package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.ubsidi.epos_2021.models.OrderStatuses;

import java.util.List;

/**
 * Created by Sumeet on 10-12-2021.
 */
@Dao
public interface OrderStatuesDao {
    @Query("SELECT * FROM `OrderStatuses` ORDER BY id ASC")
    public List<OrderStatuses> list();

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insertMultiple(List<OrderStatuses> orderStatuses);

    @Query("Delete From OrderStatuses")
    public void deleteAll();
}
