package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.ubsidi.epos_2021.models.PaymentMethod;

import java.util.List;

/**
 * Created by Amrish on 02-06-2021.
 */

@Dao
public interface PaymentMethodDao {

    @Query("SELECT * FROM PaymentMethod WHERE disabled=0 ORDER BY id ASC")
    public List<PaymentMethod> list();

    @Query("SELECT * FROM PaymentMethod WHERE id IN (:ids) AND disabled=0 ORDER BY id ASC")
    public List<PaymentMethod> list(List<String> ids);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insertMultiple(List<PaymentMethod> payment_methods);

    @Query("SELECT * FROM PaymentMethod WHERE id=:id")
    PaymentMethod view(String id);

}
