package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.ubsidi.epos_2021.models.PrepLocation;

import java.util.List;

/**
 * Created by Amrish on 22-05-2021.
 */
@Dao
public interface PrepLocationDao {
    @Query("SELECT * FROM PrepLocation ORDER BY id ASC")
    public List<PrepLocation> list();

    @Query("SELECT * FROM PrepLocation where `id`=:id")
    public PrepLocation view(String id);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insert(PrepLocation siteSetting);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insertMultiple(List<PrepLocation> siteSettings);

    @Delete
    public void deleteMultiple(List<PrepLocation> siteSettings);
}
