package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.ubsidi.epos_2021.models.ProductAddon;

import java.util.List;

/**
 * Created by Amrish on 22-05-2021.
 */
@Dao
public interface ProductAddonDao {
    @Query("SELECT * FROM ProductAddon WHERE disabled=0 ORDER BY sequence ASC")
    public List<ProductAddon> list();

    @Query("SELECT * FROM ProductAddon WHERE product_id=:productId AND disabled=0 ORDER BY sequence ASC")
    public List<ProductAddon> listByProduct(String productId);

    @Query("SELECT * FROM ProductAddon WHERE product_id=:productId AND NULLIF(parent_id, '') IS NULL AND disabled=0 ORDER BY sequence ASC")
    public List<ProductAddon> getProductParentAddon(String productId);

    @Query("SELECT contain FROM ProductAddon WHERE product_id=:productId AND parent_id=:parentId and addon_id=:addonId")
    public Boolean getContainChildAddon(String productId,String parentId,String addonId);

    @Query("SELECT * FROM ProductAddon where `id`=:id")
    public ProductAddon view(String id);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insert(ProductAddon productAddon);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insertMultiple(List<ProductAddon> productAddons);

    @Delete
    public void deleteMultiple(List<ProductAddon> productAddons);

    @Query("DELETE FROM ProductAddon")
    void deleteAll();

}
