package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Transaction;

import com.ubsidi.epos_2021.daos.relations.ProductWithProductAddons;
import com.ubsidi.epos_2021.models.Product;

import java.util.List;

/**
 * Created by Amrish on 22-05-2021.
 */
@Dao
public interface ProductDao {
    @Query("SELECT * FROM Product WHERE disabled=0 ORDER BY favourite DESC, sequence ASC")
    public List<Product> list();

    @Query("SELECT * FROM Product WHERE category_id=:categoryId AND disabled=0 ORDER BY favourite DESC, sequence ASC")
    public List<Product> listByCategory(String categoryId);

    @Query("SELECT * FROM Product WHERE category_id=:categoryId AND disabled=0 AND is_delivery=1 ORDER BY favourite DESC,sequence ASC")
    public List<Product> listDeliveryProductByCategory(String categoryId);

    @Query("SELECT * FROM Product WHERE category_id=:categoryId AND disabled=0 AND is_collection=1 ORDER BY favourite DESC,sequence ASC")
    public List<Product> listCollectionProductByCategory(String categoryId);

    @Query("SELECT * FROM Product WHERE category_id=:categoryId AND disabled=0 AND is_dinein=1 ORDER BY favourite DESC,sequence ASC")
    public List<Product> listDineinProductByCategory(String categoryId);

    //With Banquet
    @Query("SELECT * FROM Product WHERE category_id=:categoryId AND disabled=0 AND is_banquet=:banquetType ORDER BY favourite DESC, sequence ASC")
    public List<Product> listByCategory(String categoryId, int banquetType);

    @Query("SELECT * FROM Product WHERE category_id=:categoryId AND disabled=0 AND is_delivery=1 AND is_banquet=:banquetType ORDER BY favourite DESC,sequence ASC")
    public List<Product> listDeliveryProductByCategory(String categoryId, int banquetType);

    @Query("SELECT * FROM Product WHERE category_id=:categoryId AND disabled=0 AND is_collection=1 AND is_banquet=:banquetType ORDER BY favourite DESC,sequence ASC")
    public List<Product> listCollectionProductByCategory(String categoryId, int banquetType);

    @Query("SELECT * FROM Product WHERE category_id=:categoryId AND disabled=0 AND is_dinein=1 AND is_banquet=:banquetType ORDER BY favourite DESC,sequence ASC")
    public List<Product> listDineinProductByCategory(String categoryId, int banquetType);


    //All Products with order type
    @Query("SELECT * FROM Product WHERE disabled=0 AND is_delivery=1 ORDER BY favourite DESC,sequence ASC")
    public List<Product> listDeliveryProductByCategory();

    @Query("SELECT * FROM Product WHERE disabled=0 AND is_collection=1 ORDER BY favourite DESC,sequence ASC")
    public List<Product> listCollectionProductByCategory();

    @Query("SELECT * FROM Product WHERE disabled=0 AND is_dinein=1 ORDER BY favourite DESC,sequence ASC")
    public List<Product> listDineinProductByCategory();

    @Query("SELECT * FROM Product WHERE disabled=0 AND is_banquet=:banquetType ORDER BY favourite DESC, sequence ASC")
    public List<Product> listByCategory(int banquetType);

    @Query("SELECT * FROM Product WHERE disabled=0 AND is_delivery=1 AND is_banquet=:banquetType ORDER BY favourite DESC,sequence ASC")
    public List<Product> listDeliveryProductByCategory(int banquetType);

    @Query("SELECT * FROM Product WHERE disabled=0 AND is_collection=1 AND is_banquet=:banquetType ORDER BY favourite DESC,sequence ASC")
    public List<Product> listCollectionProductByCategory(int banquetType);

    @Query("SELECT * FROM Product WHERE disabled=0 AND is_dinein=1 AND is_banquet=:banquetType ORDER BY favourite DESC,sequence ASC")
    public List<Product> listDineinProductByCategory(int banquetType);

    @Query("SELECT * FROM Product WHERE disabled=0 AND is_banquet=:banquetType ORDER BY favourite DESC,sequence ASC")
    public List<Product> listBanquetProductByCategory(int banquetType);

    @Transaction
    @Query("SELECT * FROM Product WHERE category_id=:categoryId AND disabled=0 ORDER BY favourite DESC,sequence ASC")
    public List<ProductWithProductAddons> listByCategoryRelation(String categoryId);

    @Query("SELECT * FROM Product where `id`=:id")
    public Product view(String id);

    @Transaction
    @Query("SELECT * FROM Product where `id`=:id")
    public ProductWithProductAddons viewWithChild(String id);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insert(Product product);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insertMultiple(List<Product> products);

    @Delete
    public void deleteMultiple(List<Product> products);

    // delete all product
    @Query("DELETE FROM Product")
    void deleteAll();
}
