package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.ubsidi.epos_2021.models.ProductIngredient;

import java.util.List;

/**
 * Created by Amrish on 24-05-2021.
 */
@Dao
public interface ProductIngredientDao {
    @Query("SELECT * FROM ProductIngredient WHERE disabled=0 ORDER BY sequence ASC")
    public List<ProductIngredient> list();

    @Query("SELECT * FROM ProductIngredient WHERE product_id=:productId AND disabled =0")
    public List<ProductIngredient> listByProduct(String productId);

    @Query("SELECT * FROM ProductIngredient where `id`=:id")
    public ProductIngredient view(String id);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insert(ProductIngredient productIngredient);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insertMultiple(List<ProductIngredient> productIngredients);

    @Delete
    public void deleteMultiple(List<ProductIngredient> productIngredients);

    @Query("DELETE FROM ProductIngredient")
    public void deleteAll();
}
