package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.RawQuery;
import androidx.sqlite.db.SupportSQLiteQuery;

import com.ubsidi.epos_2021.models.DaoReportNameTotalValue;

import java.util.List;

@Dao
public interface ReportDao {

    @RawQuery
    int totalOrders(SupportSQLiteQuery query);

    @RawQuery
    int totalProducts(SupportSQLiteQuery query);

    @RawQuery
    float totalProductsAmount(SupportSQLiteQuery query);

    @RawQuery
    float totalDiscount(SupportSQLiteQuery query);

    @RawQuery
    float totalGratuity(SupportSQLiteQuery query);

    @RawQuery
    float totalServiceCharge(SupportSQLiteQuery query);

    @RawQuery
    int totalDiners(SupportSQLiteQuery query);

    @RawQuery
    int totalTables(SupportSQLiteQuery query);

    @RawQuery
    int totalAllottedVouchers(SupportSQLiteQuery query);

    @RawQuery
    float totalAllottedVouchersAmount(SupportSQLiteQuery query);

    @RawQuery
    List<DaoReportNameTotalValue> getOrderTypeReport(SupportSQLiteQuery query);

    @RawQuery
    List<DaoReportNameTotalValue> getOrderPaymentTypeReport(SupportSQLiteQuery query);

    @RawQuery
    List<DaoReportNameTotalValue> getOrderStatusReport(SupportSQLiteQuery query);
}
