package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Transaction;
import androidx.room.Update;

import com.ubsidi.epos_2021.daos.relations.ReservationWithCustomer;
import com.ubsidi.epos_2021.models.Reservation;

import java.util.List;

/**
 * Created by Amrish on 15-06-2021.
 */
@Dao
public interface ReservationDao {

    @Query("SELECT * FROM Reservation WHERE _id=:id")
    public Reservation view(int id);

    @Query("SELECT * FROM Reservation WHERE id=:id")
    public Reservation view(String id);

    @Query("SELECT * FROM Reservation Order By _id DESC")
    public List<Reservation> list();

    @Query("SELECT COUNT(*) FROM Reservation WHERE _customer_id=:customerId")
    int customersTotalReservation(int customerId);

    @Query("SELECT * FROM Reservation WHERE uploadable=1 Order By _id DESC")
    public List<Reservation> uploadableList();

    @Query("SELECT * FROM Reservation WHERE uploadable=1 AND online_reservation=0 Order By _id ASC LIMIT 1 ")
    public Reservation uploadableFirst();

    @Query("SELECT * FROM Reservation WHERE  date(reservation_date_time) >=:startDate AND date(reservation_date_time)<=:endDate ORDER BY _id DESC")
    List<Reservation> historyList(String startDate, String endDate);

    @Transaction
    @Query("SELECT * FROM Reservation WHERE reservation_status_id !=2 Order By reservation_date_time DESC")
    public List<ReservationWithCustomer> listWithCustomer();

    @Transaction
    @Query("SELECT * FROM Reservation WHERE  date(reservation_date_time) >=:startDate AND date(reservation_date_time)<=:endDate AND reservation_status_id !=2 ORDER BY reservation_date_time DESC")
    List<ReservationWithCustomer> historyListWithCustomer(String startDate, String endDate);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public long insert(Reservation callLogs);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insertMultiple(List<Reservation> reservations);

    @Update
    public int update(Reservation callLogs);

    @Delete
    public void delete(Reservation callLogs);

    @Query("DELETE FROM `sqlite_sequence` WHERE `name` = 'Reservation'")
    void resetReservationPrimaryKey();


    @Query("DELETE FROM `Reservation`")
    public void deleteAll();
}
