package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Update;

import com.ubsidi.epos_2021.models.DeviceInfo;

import java.util.List;

/**
 * Created by Arbaz on 16-05-2023.
 */
@Dao
public interface ResetDeviceOnDailyDao {
    @Query("SELECT * FROM DeviceInfo Where resetDate==:date")
    public DeviceInfo findByDate(String date);

    @Query("SELECT * FROM DeviceInfo Where customerPushData==:date")
    public DeviceInfo findByCustomerUploadDate(String date);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public long insert(DeviceInfo callLogs);

    @Update
    public int update(DeviceInfo callLogs);

    @Delete
    public void delete(DeviceInfo callLogs);
}
