package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.ubsidi.epos_2021.models.SiteSetting;

import java.util.List;

/**
 * Created by Amrish on 22-05-2021.
 */
@Dao
public interface SiteSettingDao {
    @Query("SELECT * FROM SiteSetting ORDER BY id ASC")
    public List<SiteSetting> list();

    @Query("SELECT * FROM SiteSetting where `key`=:key")
    public SiteSetting view(String key);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insert(SiteSetting siteSetting);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insertMultiple(List<SiteSetting> siteSettings);

    @Delete
    public void deleteMultiple(List<SiteSetting> siteSettings);
}
