package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.ubsidi.epos_2021.models.Table;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Amrish on 22-05-2021.
 */
@Dao
public interface TableDao {
    @Query("SELECT `Table`.* FROM `Table` where floor_id=:floorId AND disabled=0 ORDER BY sequence ASC")
    public List<Table> list(String floorId);

    @Query("SELECT `Table`.* FROM `Table` where floor_id=:floorId AND table_status_id=:statusId AND disabled=0 ORDER BY sequence ASC")
    public List<Table> list(String floorId, String statusId);

    @Query("SELECT `Table`.* FROM `Table` where id!=:tableId AND table_status_id!=6 AND disabled=0 ORDER BY sequence ASC")
    public List<Table> listWithoutGivenTableId(String tableId);

    @Query("SELECT `Table`.* FROM `Table` where  disabled=0 ORDER BY sequence ASC")
    public List<Table> list();

    @Query("SELECT * FROM `Table` where `id`=:id")
    public Table view(String id);

    @Query("SELECT * FROM `Table` where `merge_table_id`=:id")
    public List<Table> viewByMergedTableId(String id);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insert(Table floor);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insertMultiple(List<Table> floors);

    @Delete
    public void deleteMultiple(List<Table> floors);

    @Query("UPDATE `Table` SET table_status_id=1,merge_table_id=null")
    public void freeAllTables();

    @Query("DELETE FROM `Table`")
    public void deleteAll();
}
