package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.ubsidi.epos_2021.models.TableStatus;

import java.util.List;

/**
 * Created by Amrish on 22-05-2021.
 */
@Dao
public interface TableStatusDao {
    @Query("SELECT * FROM TableStatus ORDER BY id ASC")
    public List<TableStatus> list();

    @Query("SELECT * FROM TableStatus where `id`=:id")
    public TableStatus view(String id);

    @Query("SELECT * FROM TableStatus where `status`=:status")
    public TableStatus find(String status);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insert(TableStatus tableStatus);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insertMultiple(List<TableStatus> tableStatuses);

    @Delete
    public void deleteMultiple(List<TableStatus> tableStatuses);
}
