package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.ubsidi.epos_2021.models.User;

import java.util.List;

/**
 * Created by Amrish on 22-05-2021.
 */
@Dao
public interface UserDao {
    @Query("SELECT * FROM User WHERE disabled=0 ORDER BY id ASC")
    public List<User> list();

    @Query("SELECT * FROM User where `username`=:username")
    public User view(String username);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insert(User siteSetting);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insertMultiple(List<User> siteSettings);

    @Delete
    public void deleteMultiple(List<User> siteSettings);

    @Query("DELETE FROM User")
    public void deleteAllUser();
}
