package com.ubsidi.epos_2021.daos;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.ubsidi.epos_2021.models.Voucher;

import java.util.List;

/**
 * Created by Amrish on 22-05-2021.
 */
@Dao
public interface VoucherDao {
    @Query("SELECT * FROM `Voucher` ORDER BY created_at DESC")
    public List<Voucher> list();

    @Query("SELECT * FROM `Voucher` WHERE date(start_date) >=:startDate AND ((end_date IS NOT NULL AND date(end_date)<=:endDate) OR end_date IS NULL) ORDER BY created_at DESC")
    public List<Voucher> list(String startDate, String endDate);

    @Query("SELECT * FROM `Voucher` WHERE (date(start_date)>=:startDate AND date(start_date)<=:endDate) OR (date(end_date)>=:startDate AND date(end_date)<=:endDate) OR ( date(end_date) >=:startDate AND end_date == null) ORDER BY created_at DESC")
    public List<Voucher> listWithDate(String startDate, String endDate);

    @Query("SELECT * FROM `Voucher` where `_id`=:id")
    public Voucher view(int id);

    @Query("SELECT * FROM `Voucher` where `id`=:id")
    public Voucher view(String id);

//    @Query("SELECT * FROM `Voucher` WHERE uploadable=1 Order By _id ASC LIMIT 1 ")
//    public Voucher uploadableFirst();

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public long insert(Voucher discount);

    @Query("DELETE  FROM `Voucher` where `_id`=:id")
    public void delete(int id);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public void insertMultiple(List<Voucher> discounts);

    @Delete
    public void deleteMultiple(List<Voucher> discounts);

    @Query("DELETE FROM Voucher WHERE id NOT IN (:ids)")
    void deleteButNotThisIds(List<String> ids);

    @Query("DELETE FROM `Voucher`")
    public void deleteAll();

    @Query("SELECT * FROM Voucher WHERE voucher_code LIKE :voucherNo AND disabled=0")
    Voucher find(String voucherNo);
}
