package com.ubsidi.epos_2021.daos.relations;

import androidx.room.Embedded;
import androidx.room.Relation;

import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.OrderSplit;

import java.util.List;

/**
 * Created by Amrish on 21-05-2021.
 */
public class OrderWithItems {
    @Embedded
    public Order order;

    @Relation(parentColumn = "_id", entityColumn = "_order_id", entity = OrderItem.class)
    public List<OrderItemWithAddonsIngredients> orderItems;

    @Relation(parentColumn = "_id", entityColumn = "_order_id", entity = OrderPayment.class)
    public List<OrderPayment> orderPayments;

    @Relation(parentColumn = "_id", entityColumn = "_order_id", entity = OrderSplit.class)
    public List<OrderSplit> orderSplits;

}
