package com.ubsidi.epos_2021.fragment;

import android.content.res.Resources;
import android.graphics.Paint;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatButton;
import androidx.fragment.app.DialogFragment;

import com.ubsidi.R;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;

public class AddCommentFragment extends DialogFragment {

    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private DialogDismissListener dialogDismissListener;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    private AppCompatButton btnConfirm, btnCancel;
    private EditText etComment;
    String comment;
    private TextView tvWordCounter, tvRemove;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_add_comment, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            if (getArguments() != null)
                comment = getArguments().getString("comment");
            initViews(view);
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void initViews(View view) {
        try {
            etComment = view.findViewById(R.id.etComment);
            btnCancel = view.findViewById(R.id.btnCancel);
            btnConfirm = view.findViewById(R.id.btnConfirm);
            tvWordCounter = view.findViewById(R.id.tvWordCounter);
            tvRemove = view.findViewById(R.id.tvRemoveComment);

            tvRemove.setPaintFlags(Paint.UNDERLINE_TEXT_FLAG);
            if (!Validators.isNullOrEmpty(comment)) {
                etComment.setText(comment);
                etComment.setSelection(etComment.getText().toString().length());
                tvRemove.setVisibility(View.VISIBLE);
                btnConfirm.setText("Update");
            } else {
                tvRemove.setVisibility(View.INVISIBLE);
                btnConfirm.setText("Confirm");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {

        try {
            tvRemove.setOnClickListener(v -> etComment.setText(""));
            btnCancel.setOnClickListener(view -> {
                //getActivity().onBackPressed();
                dismiss();
            });

            btnConfirm.setOnClickListener(view -> {
                try {
                    if (btnConfirm.getText().toString().equalsIgnoreCase("Confirm")) {
                        if (Validators.isNullOrEmpty(etComment.getText().toString())) {
                            etComment.setError("Please enter comment");
                            etComment.requestFocus();
                        } else {
                            if (dialogDismissListener != null)
                                dialogDismissListener.onDialogDismiss(etComment.getText().toString());
                            //getActivity().onBackPressed();
                            dismiss();
                        }
                    } else if (btnConfirm.getText().toString().equalsIgnoreCase("Update")) {
                        if (dialogDismissListener != null)
                            dialogDismissListener.onDialogDismiss(etComment.getText().toString());
                        // getActivity().onBackPressed();
                        dismiss();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            etComment.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                }

                @Override
                public void afterTextChanged(Editable editable) {

                    try {
                        int length = etComment.length();
                        tvWordCounter.setText(length + "/300");
                        if (length > 300) {
                            tvWordCounter.setTextColor(getResources().getColor(R.color.red));
                        } else {
                            tvWordCounter.setTextColor(getResources().getColor(R.color.black));
                        }
                        if (Validators.isNullOrEmpty(etComment.getText().toString())) {
                            tvRemove.setVisibility(View.INVISIBLE);
                        } else {
                            tvRemove.setVisibility(View.VISIBLE);
                        }
                    } catch (Resources.NotFoundException e) {
                        e.printStackTrace();
                    }
                }
            });

            etComment.setOnKeyListener((textView, i, keyEvent) -> {
                if ((keyEvent.getKeyCode() == KeyEvent.KEYCODE_ENTER)) {
                    CommonFunctions.hideKeyboard(getActivity(), etComment);
                }
                return false;
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    public void onStop() {
        super.onStop();
        CommonFunctions.hideKeyboard(getActivity(), etComment);
    }
}