package com.ubsidi.epos_2021.fragment;

import android.app.Activity;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.cardview.widget.CardView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.imin.library.IminSDKManager;
import com.ubsidi.R;
import com.ubsidi.epos_2021.Links;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.MoneyTextWatcher;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.comman.bluetoothprinter.BluetoothPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinterV3Mix;
import com.ubsidi.epos_2021.comman.printer.WifiPrinter;
import com.ubsidi.epos_2021.comman.printer.ZoneRichPrinter;
import com.ubsidi.epos_2021.daos.relations.OrderWithItems;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Cashdraw;
import com.ubsidi.epos_2021.models.Discount;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.OrderSplit;
import com.ubsidi.epos_2021.models.PaymentMethod;
import com.ubsidi.epos_2021.models.Printer;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.List;
import java.util.concurrent.Callable;

public class AmountSelectionFragment extends BaseFragment {
    private Chip chipBack;
    private LinearLayout llMainLayout;
    private Float changeAmount;
    private CardView cvCheque;
    private EditText etCashAmount, etChequeNo;
    private MaterialButton btn5, btn10, btn15, btn20, btn25, btnFull;
    private TextView tvChangeAmount, txtOrderNumber;
    private LinearLayout llSubTotal, llDiscount, llGratuity, llServiceCharge, llDelivery, llCustomerInfo;
    private TextView tvGratuity, tvServiceCharge, tvDelivery, tvSubtotal, tvDiscount, tvGrandTotal, tvBalance, tvcustomer_detail, tvcustomer_contact;
    private MaterialButton btnPay;
    private TextView tvGratuityText, tvServiceChargeText, tvDiscountText;
    private Float paidAmount, orderTotal, remainingBalance;
    private LinearLayout llExpand, llGrandTotal;
    private ImageView ivExpand;
    private boolean is_full = false;

    private AlertDialog progressBarDialog;
    private PaymentMethod selectedPaymentMethod;
    private Order order;
    private float payingAmount = 0, extraAmountGratitude = 0, actualPaymentAmount = 0;
    int selectedAmount = 0;

    String order_id, order_split_id, unique_id,display_order_id;
    int _order_id, _order_split_id;

    private float cartGrandTotal = 0, cartSubTotal = 0, cartDiscount = 0, cartGratuity = 0, cartServiceCharge = 0;
    private boolean serviceChargeAutoMode = true, serviceChargeEnabled = false, serviceChargeVisible = false, discountEnabled = true, gratuityEnabled = true, autoDiscountApplied = false;
    private SiteSetting serviceChargeSetting, serviceChargeTypeSetting, serviceChargeEnableSetting, serviceChargeOptionSetting;
    private ZoneRichPrinter zoneRichPrinter;
    private SunmiPrinter sunmiPrinter;
    private WifiPrinter wifiPrinter;
    private Printer defaultPrinter;
    private SunmiPrinterV3Mix sunmiPrinterV3Mix;
    private SiteSetting cashDrawerSetting, partialPaymentMode;
    public BluetoothPrinter bluetoothPrinter;
    private boolean isFromViewCreated = false;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (getArguments() != null) {
            display_order_id = getArguments().getString("display_order_id");
            order_id = getArguments().getString("order_id");
            order_split_id = getArguments().getString("order_split_id");
            _order_id = getArguments().getInt("_order_id");
            _order_split_id = getArguments().getInt("_order_split_id");
            selectedPaymentMethod = new Gson().fromJson(getArguments().getString("payment_method"), PaymentMethod.class);
            paidAmount = getArguments().getFloat("paid_amount");
            orderTotal = getArguments().getFloat("order_total");

        }
        return inflater.inflate(R.layout.fragment_place_order_amount_selection, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (savedInstanceState != null) return;
        initViews(view);
        isFromViewCreated = true;
        fetchOffline();
        //setListeners();
    }


    private void initViews(View view) {
        zoneRichPrinter = new ZoneRichPrinter(getActivity());
        sunmiPrinter = new SunmiPrinter(getActivity());
        if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
            sunmiPrinterV3Mix = new SunmiPrinterV3Mix(requireActivity());
        }
        wifiPrinter = WifiPrinter.getInstance();
        bluetoothPrinter = new BluetoothPrinter(getActivity());
        chipBack = view.findViewById(R.id.chipBack);
        llMainLayout = view.findViewById(R.id.llAmountSelection);
        progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
        etCashAmount = view.findViewById(R.id.etCashAmount);
        cvCheque = view.findViewById(R.id.cvCheque);
        etChequeNo = view.findViewById(R.id.etChequeNo);
        btn5 = view.findViewById(R.id.btn5);
        btn10 = view.findViewById(R.id.btn10);
        btn15 = view.findViewById(R.id.btn15);
        btn20 = view.findViewById(R.id.btn20);
        btn25 = view.findViewById(R.id.btn25);
        btnFull = view.findViewById(R.id.btnFull);
        tvChangeAmount = view.findViewById(R.id.tvChangeDue);
        txtOrderNumber = view.findViewById(R.id.txtOrderNumber);

        llSubTotal = view.findViewById(R.id.ll_SubTotal);
        llDelivery = view.findViewById(R.id.ll_Delivery);
        llCustomerInfo = view.findViewById(R.id.llCustomerInfo);
        llGratuity = view.findViewById(R.id.ll_Gratuity);
        llServiceCharge = view.findViewById(R.id.ll_ServiceCharge);
        llDiscount = view.findViewById(R.id.ll_Discount);
        llGrandTotal = view.findViewById(R.id.llGrandTotal);
        llExpand = view.findViewById(R.id.llExpandable);
        ivExpand = view.findViewById(R.id.ivExpand);

        tvSubtotal = view.findViewById(R.id.tvSubtotal);
        tvDelivery = view.findViewById(R.id.tvDelivery);
        tvGratuity = view.findViewById(R.id.tvGratuity);
        tvServiceCharge = view.findViewById(R.id.tvServiceFee);
        tvDiscount = view.findViewById(R.id.tvDiscount);
        tvGrandTotal = view.findViewById(R.id.tvGrandTotal);
        tvBalance = view.findViewById(R.id.tvBalance);

        tvcustomer_detail = view.findViewById(R.id.tvcustomer_detail);
        tvcustomer_contact = view.findViewById(R.id.tvcustomer_contact);

        tvDiscountText = view.findViewById(R.id.tvDiscountText);
        tvServiceChargeText = view.findViewById(R.id.tvServiceText);
        tvGratuityText = view.findViewById(R.id.tvGratuityText);

        serviceChargeEnableSetting = myApp.findSetting("is_service_charge");
        serviceChargeSetting = myApp.findSetting("service_charge");
        serviceChargeOptionSetting = myApp.findSetting("service_charge_type_option");
        serviceChargeTypeSetting = myApp.findSetting("service_charge_type");
        cashDrawerSetting = myApp.findSetting("open_cash_drawer_after_cash_payment");
        partialPaymentMode = myApp.findSetting("partial_payment_mode");
        if (serviceChargeEnableSetting != null && (serviceChargeEnableSetting.value.equalsIgnoreCase("true") || serviceChargeEnableSetting.value.equalsIgnoreCase("1"))) {
            serviceChargeEnabled = true;
            serviceChargeVisible = true;
        }
        if (serviceChargeEnabled && serviceChargeOptionSetting != null && serviceChargeOptionSetting.value.equalsIgnoreCase("manual")) {
            serviceChargeAutoMode = false;
        }

        /* if (Links.service_charges_mode == 0) {
            if (!Links.service_charges)
                serviceChargeEnabled = false;
        }*/


        btnPay = view.findViewById(R.id.btnPay);


        etCashAmount.setSelection(etCashAmount.getText().toString().length());

        if (selectedPaymentMethod.id.equalsIgnoreCase("1")) {
            tvChangeAmount.setVisibility(View.VISIBLE);
        } else {
            tvChangeAmount.setVisibility(View.GONE);
        }

        if (selectedPaymentMethod.id.equalsIgnoreCase("3")) {
            cvCheque.setVisibility(View.VISIBLE);
        } else {
            cvCheque.setVisibility(View.GONE);
        }
        llExpand.setVisibility(View.GONE);
        if (Validators.isNullOrEmpty(display_order_id)) {
            txtOrderNumber.setText("ORDER #" + _order_id);
        } else {
            txtOrderNumber.setText("ORDER #" + display_order_id);
        }
    }

    private void updateViews() {
        cartSubTotal = order.sub_total;
        cartDiscount = order.discount;
        cartGratuity = order.gratuity;
        cartServiceCharge = order.service_charge;

        cartGrandTotal = ((cartSubTotal + cartGratuity + cartServiceCharge + order.delivery_charge) - cartDiscount);
        //     cartGrandTotal = cartSubTotal + cartGratuity - cartDiscount + cartServiceCharge + order.delivery_charge;

        tvSubtotal.setText(MyApp.currencySymbol + MyApp.df.format(cartSubTotal));
        tvGrandTotal.setText(MyApp.currencySymbol + MyApp.df.format(cartGrandTotal));

        if (order.discount > 0) {
            llDiscount.setVisibility(View.VISIBLE);
            tvDiscount.setText(MyApp.currencySymbol + MyApp.df.format(order.discount));
        } else {
            llDiscount.setVisibility(View.GONE);
        }
        if (order.gratuity > 0) {
            llGratuity.setVisibility(View.VISIBLE);
            tvGratuity.setText(MyApp.currencySymbol + MyApp.df.format(order.gratuity));
        } else {
            llGratuity.setVisibility(View.GONE);
        }
        if (order.service_charge > 0) {
            llServiceCharge.setVisibility(View.VISIBLE);
            tvServiceCharge.setText(MyApp.currencySymbol + MyApp.df.format(order.service_charge));
        } else {
            llServiceCharge.setVisibility(View.GONE);
        }
        if (order.delivery_charge > 0) {
            llDelivery.setVisibility(View.VISIBLE);
            tvDelivery.setText(MyApp.currencySymbol + MyApp.df.format(order.delivery_charge));

            Log.e("Customer", " customer_address");
            Log.e("Customer", " " + order.customer.house_no);
            Log.e("Customer", " " + order.customer.street);
            Log.e("Customer", " " + order.customer.country);
            Log.e("Customer", " " + order.customer.name);
            Log.e("Customer", " " + order.customer.mobile);

            String customer_contact = order.customer.name + " (" + order.customer.mobile + ")";
            tvcustomer_contact.setText("" + customer_contact);

            String customer_address = order.customer.house_no + " ," + order.customer.street + " ," + order.customer.country;
            tvcustomer_detail.setText("" + customer_address);

            //Log.e("Customer"," customer_address");

            llCustomerInfo.setVisibility(View.VISIBLE);
        } else {
            llDelivery.setVisibility(View.GONE);
            llCustomerInfo.setVisibility(View.GONE);
        }

        if (Float.parseFloat(MyApp.df.format(orderTotal - paidAmount)) == 0) {
            btnPay.setEnabled(false);
        }
        tvBalance.setText("Balance Remaining: " + MyApp.currencySymbol + MyApp.df.format(remainingBalance));
        if (payingAmount > 0) {
            setChangeAmount(payingAmount);
        }
        btnPay.setEnabled(selectedAmount != 0 || isValidAmount(false)); // Pay button should be enabled if selected amount is added or manual
        checkSelectedBtn(selectedAmount);
    }

    private void checkSelectedBtn(int selectedAmount) {
        if (selectedAmount == 5) {
            changeBtnColor(btn5);
        } else if (selectedAmount == 10) {
            changeBtnColor(btn10);
        } else if (selectedAmount == 15) {
            changeBtnColor(btn15);
        } else if (selectedAmount == 20) {
            changeBtnColor(btn20);
        } else if (selectedAmount == 25) {
            changeBtnColor(btn25);
        } else if (selectedAmount == 30) {
            changeBtnColor(btnFull);
        } else {

        }
    }

    String fullamount = null;

    private void setListeners() {
        if (selectedPaymentMethod.id.equalsIgnoreCase("1")) {
            //Direct Cash Payment
            if (partialPaymentMode != null && partialPaymentMode.value.equalsIgnoreCase("no")) {
                is_full = true;
                etCashAmount.setText(MyApp.df.format(orderTotal - paidAmount));
                payViaCash(selectedPaymentMethod.id, orderTotal);
            }
        } else if (selectedPaymentMethod.id.equalsIgnoreCase("cc")) {
            //Direct Card Payment
            if (partialPaymentMode != null && partialPaymentMode.value.equalsIgnoreCase("no")) {
                is_full = true;
                askForCreditCardPaymentMethod(orderTotal);
            }
        }

        chipBack.setOnClickListener(view -> getActivity().onBackPressed());
        btn5.setOnClickListener(v -> {
            is_full = false;
            changeBtnColor(v);
            selectedAmount = 5;
            checkSelectedBtn(selectedAmount);
            etCashAmount.setText(MyApp.df.format(5));
        });
        btn10.setOnClickListener(v -> {
            is_full = false;
            changeBtnColor(v);
            selectedAmount = 10;
            checkSelectedBtn(selectedAmount);
            etCashAmount.setText(MyApp.df.format(10));
        });
        btn15.setOnClickListener(v -> {
            is_full = false;
            changeBtnColor(v);
            selectedAmount = 15;
            checkSelectedBtn(selectedAmount);
            etCashAmount.setText(MyApp.df.format(15));
        });
        btn20.setOnClickListener(v -> {
            is_full = false;
            changeBtnColor(v);
            selectedAmount = 20;
            checkSelectedBtn(selectedAmount);
            etCashAmount.setText(MyApp.df.format(20));
        });
        btn25.setOnClickListener(v -> {
            is_full = false;
            changeBtnColor(v);
            selectedAmount = 25;
            checkSelectedBtn(selectedAmount);
            etCashAmount.setText(MyApp.df.format(25));
        });
        btnFull.setOnClickListener(v -> {
            is_full = true;
            changeBtnColor(v);
            selectedAmount = 30;
            checkSelectedBtn(selectedAmount);
            fullamount = MyApp.df.format(orderTotal - paidAmount);
            etCashAmount.setText(MyApp.df.format(orderTotal - paidAmount));
            btnPay.performClick();
        });

        etCashAmount.addTextChangedListener(new MoneyTextWatcher(etCashAmount));
        etCashAmount.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                payingAmount = 0;
                String amountString = etCashAmount.getText().toString().replaceAll("[£,]", "");
                if (!Validators.isNullOrEmpty(etCashAmount.getText().toString())) {
                    payingAmount = Float.parseFloat(amountString);
                    actualPaymentAmount = Float.parseFloat(amountString);
                    if (Float.compare(payingAmount, Float.parseFloat(MyApp.df.format((orderTotal - paidAmount)))) > 0) {
                        actualPaymentAmount = Float.parseFloat(MyApp.df.format((orderTotal - paidAmount)));
                        extraAmountGratitude = payingAmount - Float.parseFloat(MyApp.df.format((orderTotal - paidAmount)));
                    }
                }
                setChangeAmount(payingAmount);
                if (Validators.isNullOrEmpty(fullamount)) {
                    fullamount = "0";
                }
                if (payingAmount != 5.00 && payingAmount != 10.00 && payingAmount != 15.00 && payingAmount != 20.00 && payingAmount != 25.00 && payingAmount != Float.parseFloat(fullamount)) {
                    changeBtnColor(null);
                    selectedAmount = 0;
                    checkSelectedBtn(selectedAmount);
                } else {
                    selectedAmount = (int) payingAmount;
                    checkSelectedBtn(selectedAmount);
                }
                if (!selectedPaymentMethod.id.equalsIgnoreCase("3"))
                    btnPay.setEnabled(isValidAmount(true));
            }
        });

        etChequeNo.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                btnPay.setEnabled(!Validators.isNullOrEmpty(etChequeNo.getText().toString()) && !Validators.isNullOrEmpty(etCashAmount.getText().toString()));
            }
        });

        btnPay.setOnClickListener(v -> {
            etChequeNo.setError(null);
            etCashAmount.setError(null);
            if (isValidAmount(true)) {
                if (!Validators.isNullOrEmpty(selectedPaymentMethod.id)) {
                    if (selectedPaymentMethod.id.equalsIgnoreCase("1")) {
                        payViaCash(selectedPaymentMethod.id);
                    } else if (selectedPaymentMethod.id.equalsIgnoreCase("cc")) {
                        askForCreditCardPaymentMethod();
                    } else if (selectedPaymentMethod.id.equalsIgnoreCase("3")) {
                        if (Validators.isNullOrEmpty(etChequeNo.getText().toString())) {
                            etChequeNo.setError("Please enter cheque number");
                            etChequeNo.requestFocus();
                        } else {
                            payViaCheque(selectedPaymentMethod.id);
                        }
                    }
                }

            }

        });

        llGrandTotal.setOnClickListener(view -> {
            if (llExpand.getVisibility() == View.VISIBLE) {
                ivExpand.setRotation(90);
                llExpand.setVisibility(View.GONE);
            } else {
                ivExpand.setRotation(270);
                llExpand.setVisibility(View.VISIBLE);
            }

        });

    }

    private class UpdateOrderAsyncTask extends AsyncTask<Object, Object, Object> {
        Callable<Void> nextMethod;

        public UpdateOrderAsyncTask(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected Object doInBackground(Object... objects) {
            order.sub_total = myApp.appDatabase.orderDao().getItemSubTotal(order._id);

            cartSubTotal = order.sub_total;
            if (serviceChargeEnabled) {
                if (serviceChargeAutoMode && !order.is_auto_service_charge_remove) {
                    float serviceChargeValue = Float.parseFloat(serviceChargeSetting.value);
                    if (serviceChargeTypeSetting.value.equalsIgnoreCase("flat")) {
                        cartServiceCharge = serviceChargeValue;
                    } else {
                        if (serviceChargeValue > 0) {
                            cartServiceCharge = cartSubTotal * serviceChargeValue / 100;
                        } else {
                            cartServiceCharge = 0;
                        }
                    }
                }
            } else {
                cartServiceCharge = 0;
            }

            if (discountEnabled) {
                List<Discount> discounts = appDatabase.discountDao().eligibleDiscounts("%" + myApp.current_day + "%", "%" + order.order_type_id + "%", order.sub_total, CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"), CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"));
                if (discounts.size() > 0) {
                    Discount appliedDiscount = discounts.get(0);
                    autoDiscountApplied = false;
                    if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("flat")) {
                        if (cartSubTotal > 0) cartDiscount = appliedDiscount.discount;
                        else cartDiscount = 0;
                        autoDiscountApplied = true;
                    }
                    if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("percentage")) {
                        if (cartSubTotal > 0)
                            cartDiscount = cartSubTotal * appliedDiscount.discount / 100;
                        else cartDiscount = 0;
                        autoDiscountApplied = true;
                    }
                } else {
                    if (autoDiscountApplied) cartDiscount = 0;
                }
            }

            order.gratuity = cartGratuity;
            order.discount = cartDiscount;
            order.service_charge = cartServiceCharge;
            cartGrandTotal = ((order.sub_total + order.gratuity + order.service_charge + order.delivery_charge) - order.discount);
            // cartGrandTotal = cartSubTotal + cartGratuity - cartDiscount + cartServiceCharge + order.delivery_charge;
            order.total = cartGrandTotal;
            if (!order.order_status_id.equalsIgnoreCase("5") && !order.order_status_id.equalsIgnoreCase("10")) {
                order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
            }
            appDatabase.orderDao().update(order);
            return null;
        }

        @Override
        protected void onPostExecute(Object s) {
            super.onPostExecute(s);
            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }


    PaymentMethod moto, cardreader, manual;

    private void askForCreditCardPaymentMethod() {
        new Thread(() -> {

            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    changeFragment(new CardPaymentTypeSelectionFragment(), payingAmount, moto != null && !moto.disabled, cardreader != null && !cardreader.disabled, manual != null && !manual.disabled);
                });
            }
        }).start();
    }

    private void askForCreditCardPaymentMethod(float payingAmount) {

        Log.d("Card Payment", "moto: " + moto);
        Log.d("Card Payment", "cardreader: " + cardreader);
        Log.d("Card Payment", "manual: " + manual);

        new Thread(() -> {

            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    changeFragment(new CardPaymentTypeSelectionFragment(), payingAmount, moto != null && !moto.disabled, cardreader != null && !cardreader.disabled, manual != null && !manual.disabled);
                });
            }
        }).start();
    }

    private void payViaCheque(String paymentMethodId) {
        if (getActivity() != null) progressBarDialog.show();
        OrderPayment orderPayment = new OrderPayment();
        orderPayment.payment_method_id = paymentMethodId;
        orderPayment.updater_id = myPreferences.getLoggedInUser().id;
        orderPayment.amount = Float.parseFloat(MyApp.df.format(Float.parseFloat(etCashAmount.getText().toString().replace(",", ""))));
        orderPayment.cheque_number = etChequeNo.getText().toString();
        orderPayment.order_id = order_id;
        orderPayment.order_split_id = order_split_id;
        orderPayment._order_split_id = _order_split_id;
        orderPayment.payment_method_name = "Cheque";
        orderPayment._order_id = _order_id;
        // add unique id for find split payment
        orderPayment.unique_id = unique_id;
        new Thread(() -> {
            float paidAmount;
            if (_order_split_id > 0) {
                paidAmount = Float.parseFloat(MyApp.df.format(appDatabase.orderPaymentDao().getSplitTotalPaidAmount(_order_id, _order_split_id)));
            } else {
                paidAmount = Float.parseFloat(MyApp.df.format(appDatabase.orderPaymentDao().getTotalPaidAmount(_order_id)));
            }
            if (Float.parseFloat(MyApp.df.format(paidAmount + orderPayment.amount)) > Float.parseFloat(MyApp.df.format(orderTotal))) {
                ToastUtils.makeLongToast(getActivity(), "You cannot pay more than total");
            } else {
                appDatabase.orderPaymentDao().insert(orderPayment);
                order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                appDatabase.orderDao().update(order);
                getActivity().setResult(Activity.RESULT_OK, new Intent().putExtra("_order_split_id", _order_split_id));
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        myApp.needToPrint = true;
                        progressBarDialog.dismiss();
                        openAnimatedDialog("Payment successful");
                    });
                }
            }
        }).start();

    }

    private void payViaCash(String paymentMethodId) {
        if (getActivity() != null) progressBarDialog.show();
        OrderPayment orderPayment = new OrderPayment();
        orderPayment.payment_method_id = paymentMethodId;
        orderPayment.updater_id = myPreferences.getLoggedInUser().id;
        if (changeAmount == null) {
            changeAmount = 0F;
            orderPayment.amount = Float.parseFloat(MyApp.df.format(Float.parseFloat(etCashAmount.getText().toString().replace(",", ""))));
        } else {
            orderPayment.amount = Float.parseFloat(MyApp.df.format(Float.parseFloat(etCashAmount.getText().toString().replace(",", "")) - changeAmount));
        }
        orderPayment.order_id = order_id;
        orderPayment.order_split_id = order_split_id;
        orderPayment._order_split_id = _order_split_id;
        orderPayment.payment_method_name = "Cash";
        orderPayment._order_id = _order_id;
        // add unique id for find split payment
        orderPayment.unique_id = unique_id;
        new Thread(() -> {
            float paidAmount;
            if (_order_split_id > 0) {
                paidAmount = Float.parseFloat(MyApp.df.format(appDatabase.orderPaymentDao().getSplitTotalPaidAmount(_order_id, _order_split_id)));
            } else {
                paidAmount = Float.parseFloat(MyApp.df.format(appDatabase.orderPaymentDao().getTotalPaidAmount(_order_id)));
            }
            if (Float.parseFloat(MyApp.df.format(paidAmount + orderPayment.amount)) > Float.parseFloat(MyApp.df.format(orderTotal))) {
                ToastUtils.makeLongToast(getActivity(), "You cannot pay more than total");
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        progressBarDialog.dismiss();
                    });
                }
            } else {
                appDatabase.orderPaymentDao().insert(orderPayment);
                order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                appDatabase.orderDao().update(order);
                if (cashDrawerSetting != null && !Validators.isNullOrEmpty(cashDrawerSetting.value) && (cashDrawerSetting.value.equalsIgnoreCase("yes") || cashDrawerSetting.value.equalsIgnoreCase("1")))
                    openCashDrawer();
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        getActivity().setResult(Activity.RESULT_OK, new Intent().putExtra("_order_split_id", _order_split_id));
                        myApp.isCashDrawerOpen = true;
                        progressBarDialog.dismiss();
                        if (changeAmount > 0) {
                            openDialog(tvChangeAmount.getText().toString());
                        } else {
                            openAnimatedDialog("Payment successful");
                        }

                    });
                }
                myApp.needToPrint = true;
            }
        }).start();
    }

    private void payViaCash(String paymentMethodId, float cashAmount) {
        if (getActivity() != null) progressBarDialog.show();
        OrderPayment orderPayment = new OrderPayment();
        orderPayment.payment_method_id = paymentMethodId;
        orderPayment.updater_id = myPreferences.getLoggedInUser().id;
        orderPayment.amount = cashAmount;
        orderPayment.order_id = order_id;
        orderPayment.order_split_id = order_split_id;
        orderPayment._order_split_id = _order_split_id;
        orderPayment.payment_method_name = "Cash";
        orderPayment._order_id = _order_id;
        // add unique id for find split payment
        orderPayment.unique_id = unique_id;
        new Thread(() -> {
            /*float paidAmount;
            if (_order_split_id > 0) {
                paidAmount = Float.parseFloat(MyApp.df.format(appDatabase.orderPaymentDao().getSplitTotalPaidAmount(_order_id, _order_split_id)));
            } else {
                paidAmount = Float.parseFloat(MyApp.df.format(appDatabase.orderPaymentDao().getTotalPaidAmount(_order_id)));
            }*/
            if (Float.parseFloat(MyApp.df.format(paidAmount + orderPayment.amount)) > Float.parseFloat(MyApp.df.format(orderTotal))) {
                ToastUtils.makeLongToast(getActivity(), "You cannot pay more than total");
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        progressBarDialog.dismiss();
                    });
                }
            } else {
                appDatabase.orderPaymentDao().insert(orderPayment);
                order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                LogUtils.e("Updated_at: " + order.updated_at);
                appDatabase.orderDao().update(order);
                if (cashDrawerSetting != null && !Validators.isNullOrEmpty(cashDrawerSetting.value) && (cashDrawerSetting.value.equalsIgnoreCase("yes") || cashDrawerSetting.value.equalsIgnoreCase("1")))
                    openCashDrawer();
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        getActivity().setResult(Activity.RESULT_OK, new Intent().putExtra("_order_split_id", _order_split_id));
                        myApp.isCashDrawerOpen = true;
                        progressBarDialog.dismiss();
                        openAnimatedDialog("Payment successful");
                        /*if (changeAmount > 0) {
                            openDialog(tvChangeAmount.getText().toString());
                        } else {
                            openAnimatedDialog("Payment successful");
                        }*/

                    });
                }
                myApp.needToPrint = true;
            }
        }).start();
    }

    private void openDialog(String message) {
        ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog(message, null, 1, "Okay", null);
        confirmationDialogFragment.show(getActivity().getSupportFragmentManager(), "paybill_confirmation");
        confirmationDialogFragment.setDialogDismissListener(o -> {
            String action = (String) o;
            if (action.equalsIgnoreCase("confirm")) {
                if (getActivity() != null) {
                    getActivity().finish();
                }
            }
        });
    }

    private void openAnimatedDialog(String message) {
        AnimatedConfirmationDialogFragment confirmationDialogFragment = getInstanceAnimatedConfirmation(message, null, 1, "Okay", null);
        confirmationDialogFragment.show(getActivity().getSupportFragmentManager(), "paybill_confirmation");
        confirmationDialogFragment.setDialogDismissListener(o -> {
            String action = (String) o;
            if (action.equalsIgnoreCase("confirm")) {
                if (getActivity() != null) {
                    getActivity().finish();
                }
            }
        });
    }


    private void setChangeAmount(float payingAmount) {
        float remainingBalance = orderTotal - paidAmount;
        if (payingAmount > remainingBalance)
            changeAmount = Float.parseFloat(MyApp.df.format(payingAmount - remainingBalance));
        else changeAmount = 0f;
        if (payingAmount > remainingBalance) {
            tvChangeAmount.setText("Change due: " + MyApp.currencySymbol + MyApp.df.format(changeAmount));
        } else {
            tvChangeAmount.setText(String.format("Change due: %s0.00", MyApp.currencySymbol));
        }

    }

    private void changeBtnColor(View v) {
        btn5.setBackgroundColor(getResources().getColor(R.color.orders_card_bg_grey));
        btn5.setTextColor(getResources().getColor(R.color.reason_normal_text));

        btnFull.setBackgroundColor(getResources().getColor(R.color.orders_card_bg_grey));
        btnFull.setTextColor(getResources().getColor(R.color.reason_normal_text));

        btn10.setBackgroundColor(getResources().getColor(R.color.orders_card_bg_grey));
        btn10.setTextColor(getResources().getColor(R.color.reason_normal_text));

        btn15.setBackgroundColor(getResources().getColor(R.color.orders_card_bg_grey));
        btn15.setTextColor(getResources().getColor(R.color.reason_normal_text));

        btn20.setBackgroundColor(getResources().getColor(R.color.orders_card_bg_grey));
        btn20.setTextColor(getResources().getColor(R.color.reason_normal_text));

        btn25.setBackgroundColor(getResources().getColor(R.color.orders_card_bg_grey));
        btn25.setTextColor(getResources().getColor(R.color.reason_normal_text));

        if (v == btn5) {
            btn5.setBackgroundColor(getResources().getColor(R.color.persian_green));
            btn5.setTextColor(getResources().getColor(R.color.white));
        }
        if (v == btn10) {
            btn10.setBackgroundColor(getResources().getColor(R.color.persian_green));
            btn10.setTextColor(getResources().getColor(R.color.white));
        }
        if (v == btn15) {
            btn15.setBackgroundColor(getResources().getColor(R.color.persian_green));
            btn15.setTextColor(getResources().getColor(R.color.white));
        }
        if (v == btn20) {
            btn20.setBackgroundColor(getResources().getColor(R.color.persian_green));
            btn20.setTextColor(getResources().getColor(R.color.white));
        }
        if (v == btn25) {
            btn25.setBackgroundColor(getResources().getColor(R.color.persian_green));
            btn25.setTextColor(getResources().getColor(R.color.white));
        }
        if (v == btnFull) {
            btnFull.setBackgroundColor(getResources().getColor(R.color.persian_green));
            btnFull.setTextColor(getResources().getColor(R.color.white));
        }
    }

    private boolean isValidAmount(boolean showError) {
        float payingAmount = Validators.isNullOrEmpty(etCashAmount.getText().toString()) ? 0 : Float.parseFloat(etCashAmount.getText().toString().replace(",", ""));
        etCashAmount.setError(null);
        if (payingAmount == 0) {
            if (showError) {
                etCashAmount.setError("Amount should be greater than zero");
                etCashAmount.requestFocus();
            }
            return false;
        }
        //if (selectedPaymentMethod.id.equalsIgnoreCase("cc") || selectedPaymentMethod.id.equalsIgnoreCase("3")) {
        if (selectedPaymentMethod.id.equalsIgnoreCase("3")) {
            if (Float.compare(payingAmount, Float.parseFloat(MyApp.df.format((orderTotal - paidAmount)))) > 0) {
                if (showError) {
                    etCashAmount.setError("Amount should not greater than remaining payment");
                    etCashAmount.requestFocus();
                }
                return false;
            }
        }
        return true;
    }


    private void fetchOffline() {
        try {
            new FetchOrderOfflineAsyncTask(() -> {
                updateViews();
                return null;
            }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class FetchOrderOfflineAsyncTask extends AsyncTask<Object, Object, Object> {
        Callable<Void> nextMethod;

        public FetchOrderOfflineAsyncTask(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected Object doInBackground(Object... objects) {
            //Retrive Payment Methods
            try {
                moto = appDatabase.paymentMethodDao().view("10");
                cardreader = appDatabase.paymentMethodDao().view("9");
                manual = appDatabase.paymentMethodDao().view("2");

                OrderWithItems orderWithItems = myApp.appDatabase.orderDao().orderWithItems(_order_id);
                if (orderWithItems != null) {
                    order = orderWithItems.order;
                    if (_order_split_id > 0) {
                        OrderSplit orderSplit = appDatabase.orderSplitDao().view(_order_split_id);
                        orderTotal = orderSplit.total;
                        unique_id = orderSplit.unique_id;
                        paidAmount = appDatabase.orderPaymentDao().getSplitTotalPaidAmount(_order_id, _order_split_id);
                    } else {
                        orderTotal = order.total;
                        paidAmount = order.total_paid;
                    }
                    remainingBalance = orderTotal - paidAmount;

                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("1")) {
                        order.order_type = "Dine in";
                    }
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("2")) {
                        order.order_type = "Collection";
                    }
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("3")) {
                        order.order_type = "Delivery";
                    }
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("4")) {
                        order.order_type = "Bar";
                    }
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("5")) {
                        order.order_type = "Waiting";
                    }
                    Log.e("Order_type", " " + order.order_type);
                    if (serviceChargeVisible) {
                        SiteSetting services_charges = myApp.findSetting("service_charge_order_type");
                        List<String> split_funcation = Links.split_funcation(services_charges.value);
                        for (int i = 0; i < split_funcation.size(); i++) {
                            if (order.order_type.equalsIgnoreCase(split_funcation.get(i).toString())) {
                                serviceChargeEnabled = true;
                                break;
                            } else {
                                serviceChargeEnabled = false;
                            }
                        }
                    }

                    if (order.service_charge == 0) {
                        if (serviceChargeEnabled) {
                            if (serviceChargeAutoMode && !order.is_auto_service_charge_remove) {
                                float serviceChargeValue = Float.parseFloat(serviceChargeSetting.value);
                                if (serviceChargeTypeSetting.value.equalsIgnoreCase("flat")) {
                                    cartServiceCharge = serviceChargeValue;
                                } else {
                                    if (serviceChargeValue > 0) {
                                        cartServiceCharge = cartSubTotal * serviceChargeValue / 100;
                                    } else {
                                        cartServiceCharge = 0;
                                    }
                                }
                            }
                        } else {
                            cartServiceCharge = 0;
                        }
                    } else {
                        cartServiceCharge = order.service_charge;
                    }
                    if (order.split_type != null && order.split_type.equalsIgnoreCase("order_item")) {
                        cartServiceCharge = 0;
                        //serviceChargeEnabled = false;
                        discountEnabled = false;
                        gratuityEnabled = false;
                    }

                    order.customer = myApp.appDatabase.customerDao().view(order._customer_id);
                    if (order.customer == null) {
                        order.customer = appDatabase.customerDao().view(order.customer_id);
                    }

                }
            } catch (NumberFormatException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Object s) {
            super.onPostExecute(s);
            //if(order!=null && isFromViewCreated){
            if (order != null && isFromViewCreated) {
                isFromViewCreated = false;
                setListeners();
            }
            if (order != null) if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void changeFragment(Fragment fragment, float payingAmount, boolean is_moto, boolean is_cardreader, boolean is_manual) {
        try {
            FragmentManager manager = getActivity().getSupportFragmentManager();
            if (getArguments() != null) {
                getArguments().putFloat("paying_amount", payingAmount);
                getArguments().putFloat("actualPaymentAmount", actualPaymentAmount);
                getArguments().putFloat("extraAmountGratitude", extraAmountGratitude);
                getArguments().putBoolean("is_moto", is_moto);
                getArguments().putBoolean("is_cardreader", is_cardreader);
                getArguments().putBoolean("is_manual", is_manual);
                getArguments().putBoolean("is_full", is_full);
                fragment.setArguments(getArguments());
            }
            FragmentTransaction transaction = manager.beginTransaction();
            transaction.replace(R.id.flContainer, fragment);
            transaction.addToBackStack("can_go_back");
            transaction.commit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance(getActivity()).registerReceiver(eposOrderUpdateReceiver, new IntentFilter(Constants.EPOS_ORDER_UPDATE));
    }

    @Override
    public void onStop() {
        super.onStop();
        if (eposOrderUpdateReceiver != null)
            LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(eposOrderUpdateReceiver);
    }

    BroadcastReceiver eposOrderUpdateReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getBooleanExtra("refresh", false)) {
                    if (intent.hasExtra("_order_split_id")) {
                        _order_split_id = intent.getIntExtra("_order_split_id", 0);
                        getArguments().putInt("_order_split_id", _order_split_id);
                        if (etCashAmount.length() > 0) {
                            etCashAmount.getText().clear();
                        }
                        etCashAmount.setError(null);
                        //  etCashAmount.addTextChangedListener(new MoneyTextWatcher(etCashAmount)); Not required
                    }
                    fetchOffline();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public void updateData() {
        fetchOffline();
    }

    private void openCashDrawer() {

        try {
            defaultPrinter = myPreferences.getDefaultPrinter(false);
            Cashdraw cashdraw = new Cashdraw();
            cashdraw.user_id = myApp.myPreferences.getLoggedInUser().id;
            cashdraw.device_id = myApp.myPreferences.getRegisteredDevice().id;
            cashdraw.value = "1";
            defaultPrinter = myPreferences.getDefaultPrinter();
            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                    zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                    zoneRichPrinter.openCashDrawer();
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("sunmi") || defaultPrinter.printer_model_name.toLowerCase().contains("t2")) {
                    if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                        sunmiPrinterV3Mix.openCashDrawer();
                    } else {
                        sunmiPrinter.openCashDrawer();
                    }
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                        IminSDKManager.opencashBox();
                    } else {
                        if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                            wifiPrinter.connect(defaultPrinter.ip);
                            try {
                                Thread.sleep(100);
                                wifiPrinter.openCashDrawer(false);
                            } catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        } else {
                            try {
                                if (bluetoothPrinter != null) {
                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                    if (device != null) {
                                        Thread.sleep(100);
                                        bluetoothPrinter.openCashDrawer(false);
                                    } else {
                                        ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            } else {
                ToastUtils.makeLongToast(getActivity(), "No printer model found");
            }

            AndroidNetworking.post(ApiEndPoints.cashdraw_log).addApplicationJsonBody(cashdraw).build().getAsObject(Cashdraw.class, new ParsedRequestListener<Cashdraw>() {
                @Override
                public void onResponse(Cashdraw response) {
                }

                @Override
                public void onError(ANError anError) {
                    anError.printStackTrace();
                    if (anError.getErrorCode() == 400) {
                        ApiError apiError = anError.getErrorAsObject(ApiError.class);
                        ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                    } else {
                        anError.printStackTrace();
                        ToastUtils.makeSnackToast(getActivity(), "Something went wrong!");
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        clearPrinterVariable();
    }

    private void clearPrinterVariable() {
        if(getActivity()!=null && sunmiPrinter!=null){
            sunmiPrinter.unBindService(getActivity());
            sunmiPrinter.printBlockBill = null;
            sunmiPrinter.myApp = null;
            sunmiPrinter = null;
        }
        zoneRichPrinter.printBlockBill = null;
        zoneRichPrinter.activity = null;
        zoneRichPrinter.zonerich = null;
        zoneRichPrinter = null;
        wifiPrinter = null;
    }

    public AnimatedConfirmationDialogFragment getInstanceAnimatedConfirmation(String title, String info, int type, String positiveButton, String negativeButton) {
        AnimatedConfirmationDialogFragment rejectReasonDialog = new AnimatedConfirmationDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("title", title);
        bundle.putString("info", info);
        bundle.putString("positive_button", positiveButton);
        bundle.putString("negative_button", negativeButton);
        bundle.putInt("type", type);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }
}
