package com.ubsidi.epos_2021.fragment;

import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.ViewPager;

import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.FloorAdapter;
import com.ubsidi.epos_2021.adapters.ViewpagerTabAdapter;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.models.Floor;
import com.ubsidi.epos_2021.models.Table;

import java.util.ArrayList;

public class AssignTableDialogFragment extends DialogFragment {

    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private DialogDismissListener dialogDismissListener;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    private ViewPager vpTables;
    private TextView tvTitle;
    private ViewpagerTabAdapter viewpagerAdapter;
    private ArrayList<Floor> floors = new ArrayList<>();
    private RecyclerView rvFloors;
    private FloorAdapter floorAdapter;
    private String tableId, title;
    private boolean showOnlyFreeTables, isFromMergeTable;

    private AppDatabase appDatabase = MyApp.getInstance().appDatabase;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_assign_table_dialog, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            if (getArguments() != null) {
                tableId = getArguments().getString("table_id");
                title = getArguments().getString("title");
                showOnlyFreeTables = getArguments().getBoolean("show_only_free");
                isFromMergeTable = getArguments().getBoolean("isFromMergeTable");
            }
            initViews(view);
            setListeners();
            new FloorsAsyncTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            rvFloors = view.findViewById(R.id.rvFloors);
            vpTables = view.findViewById(R.id.vpTables);
            tvTitle = view.findViewById(R.id.tvTitle);
            floorAdapter = new FloorAdapter(floors, (position, data) -> {
                Floor selectedFloor = (Floor) data;
                vpTables.setCurrentItem(position);
                floorAdapter.selectedFloorId = selectedFloor.id;
                floorAdapter.notifyDataSetChanged();
            });

            rvFloors.setAdapter(floorAdapter);
            rvFloors.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.HORIZONTAL, false));
            viewpagerAdapter = new ViewpagerTabAdapter(getChildFragmentManager(), FragmentPagerAdapter.BEHAVIOR_RESUME_ONLY_CURRENT_FRAGMENT);
            vpTables.setAdapter(viewpagerAdapter);

            if (!Validators.isNullOrEmpty(title)) {
                tvTitle.setText(title);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            vpTables.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
                @Override
                public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

                }

                @Override
                public void onPageSelected(int position) {
                    // on page scroll change floor tables
                    Floor selectedFloor = floors.get(position);
                    floorAdapter.selectedFloorId = selectedFloor.id;
                    floorAdapter.notifyDataSetChanged();
                }

                @Override
                public void onPageScrollStateChanged(int state) {

                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class FloorsAsyncTask extends AsyncTask<String, String, String> {

        @Override
        protected String doInBackground(String... strings) {
            try {
                floors.clear();
                floors.addAll(appDatabase.floorDao().list());
            } catch (Exception e) {
                e.printStackTrace();
            }

            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                floorAdapter.selectedFloorId = floors.get(0).id;
                floorAdapter.notifyDataSetChanged();
                for (int i = 0; i < floors.size(); i++) {
                    AssignTablesFragment tablesFragment = getInstanceAssignTablesF(floors.get(i).id, tableId, showOnlyFreeTables, isFromMergeTable);
                    tablesFragment.setDialogDismissListener((data) -> {
                        if (data instanceof Table) {
                            Table table = (Table) data;
                            if (dialogDismissListener != null) {
                                dialogDismissListener.onDialogDismiss(isFromMergeTable ? new Pair(table, true) : table);
                            }
                        }
                        dismiss();
                    });
                    viewpagerAdapter.addFragment(tablesFragment, floors.get(i).name);
                }
                viewpagerAdapter.notifyDataSetChanged();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public AssignTablesFragment getInstanceAssignTablesF(String floorId, String selectedTableId, boolean showOnlyFree, boolean isFromMergeTable) {
        Bundle bundle = new Bundle();
        AssignTablesFragment fragment = new AssignTablesFragment();
        bundle.putString("floor_id", floorId);
        bundle.putString("table_id", selectedTableId);
        bundle.putBoolean("show_only_free", showOnlyFree);
        bundle.putBoolean("isFromMergeTable", isFromMergeTable);
        fragment.setArguments(bundle);
        return fragment;
    }

}