package com.ubsidi.epos_2021.fragment;

import static android.app.Activity.RESULT_OK;

import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.AssignTablesAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.models.Floor;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.Starters;
import com.ubsidi.epos_2021.models.Table;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.Constants;

import java.util.ArrayList;

public class AssignTablesFragment extends BaseFragment {
    private RecyclerView rvTables;
    private AssignTablesAdapter tablesAdapter;

    private ArrayList<Starters> starters = new ArrayList<>();
    private ArrayList<Table> tables = new ArrayList<>();
    private String floorId, tableId;
    private Floor floor;
    private SwipeRefreshLayout swipeRefreshLayout;
    private DialogDismissListener dialogDismissListener;
    private MaterialButton btnCancel, btnAccept;
    private boolean showOnlyFreeTable, isFromMergeTable;

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getArguments() != null) {
            floorId = getArguments().getString("floor_id");
            tableId = getArguments().getString("table_id");
            showOnlyFreeTable = getArguments().getBoolean("show_only_free");
            isFromMergeTable = getArguments().getBoolean("isFromMergeTable");
        }
    }

    private Table selectedTable;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_assign_tables, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            setListener();
            if (!Validators.isNullOrEmpty(tableId)) {
                tablesAdapter.selectedId = tableId;
                tablesAdapter.notifyDataSetChanged();
            }
            fetchFloorDetails();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            swipeRefreshLayout = view.findViewById(R.id.swipeRefreshLayout);
            rvTables = view.findViewById(R.id.rvItems);
            btnCancel = view.findViewById(R.id.btnCancel);
            btnAccept = view.findViewById(R.id.btnConfirm);
            tablesAdapter = new AssignTablesAdapter(tables, (position, data) -> {
                selectedTable = (Table) data;
                btnAccept.setEnabled(true);
            }, true);
            int spanCount = 4;
            if (myApp.screenWidth > 2000) {
                spanCount = 6;
            } else if (myApp.screenWidth > 1600) {
                spanCount = 5;
            }
            rvTables.setLayoutManager(new GridLayoutManager(getActivity(), spanCount));
            rvTables.setAdapter(tablesAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void setListener() {
        try {
            swipeRefreshLayout.setOnRefreshListener(() -> {
                new TablesAsyncTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            });
            btnCancel.setOnClickListener(view -> {
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss(null);
                }
            });
            btnAccept.setOnClickListener(view -> {
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss(selectedTable);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchFloorDetails() {
        try {
            if (!myApp.isConnected(getActivity())) {
                new TablesAsyncTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                return;
            }
            if ("manual".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode())) {
                new TablesAsyncTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                return;
            }
            swipeRefreshLayout.setRefreshing(true);
            AndroidNetworking.get(ApiEndPoints.floors + floorId)
                    .build()
                    .getAsObject(Floor.class, new ParsedRequestListener<Floor>() {
                        @Override
                        public void onResponse(Floor response) {
                            new TablesAsyncTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, response);

                        }

                        @Override
                        public void onError(ANError anError) {
                            new TablesAsyncTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class TablesAsyncTask extends AsyncTask<Floor, String, String> {

        @Override
        protected String doInBackground(Floor... strings) {
            try {
                if (strings.length > 0) {
                    Floor fl = strings[0];
                    if (fl != null) {
                        appDatabase.tableDao().insertMultiple(fl.tables);
                    }

                }
                floor = appDatabase.floorDao().view(floorId);
                if (isFromMergeTable) {
                    floor.tables = (ArrayList<Table>) appDatabase.tableDao().listWithoutGivenTableId(tableId);
                } else {
                    if (showOnlyFreeTable) {
                        floor.tables = (ArrayList<Table>) appDatabase.tableDao().list(floorId, "1");
                    } else {
                        floor.tables = (ArrayList<Table>) appDatabase.tableDao().list(floorId);
                    }
                }
                for (Table table : floor.tables) {
                    Order dbOrder = appDatabase.orderDao().findLastOrderOfTable(table.id);
                    if (dbOrder != null) {
                        table._last_order_id = dbOrder._id;
                    }
                    if (!Validators.isNullOrEmpty(table.table_status_id))
                        table.table_status = appDatabase.tableStatusDao().view(table.table_status_id);
                }
                tables.clear();
                tables.addAll(floor.tables);
            } catch (Exception e) {
                e.printStackTrace();
            }

            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                swipeRefreshLayout.setRefreshing(false);
                tablesAdapter.notifyDataSetChanged();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }


    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == Constants.CODE_REFRESH && resultCode == RESULT_OK) {
            new TablesAsyncTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        }
    }

}
