package com.ubsidi.epos_2021.fragment;

import android.Manifest;
import android.app.Activity;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.location.LocationManager;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.cardview.widget.CardView;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.chip.Chip;
import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.google.gson.Gson;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.Stripe;
import com.stripe.android.core.exception.StripeException;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.StripeIntent;
/*import com.stripe.exception.StripeException;
import com.stripe.model.Charge;
import com.stripe.model.PaymentMethod;*/
import com.ubsidi.BuildConfig;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.comman.bluetoothprinter.BluetoothPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinterV3Mix;
import com.ubsidi.epos_2021.comman.printer.WifiPrinter;
import com.ubsidi.epos_2021.comman.printer.ZoneRichPrinter;
import com.ubsidi.epos_2021.daos.relations.OrderWithItems;
import com.ubsidi.epos_2021.interfaces.DialogDismissDataListener;
import com.ubsidi.epos_2021.merchant.fragments.PaymentLinkFragment;
import com.ubsidi.epos_2021.merchant.fragments.StripeBluetoothCardReaderPaymentFragment;
import com.ubsidi.epos_2021.merchant.fragments.StripeInternetCardReaderPaymentFragment;
import com.ubsidi.epos_2021.models.Admin;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.models.BusinessCardReader;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.OrderSplit;
import com.ubsidi.epos_2021.models.Printer;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.concurrent.Callable;

import io.mpos.accessories.AccessoryFamily;
import io.mpos.accessories.parameters.AccessoryParameters;
import io.mpos.provider.ProviderMode;
import io.mpos.transactions.Currency;
import io.mpos.transactions.Transaction;
import io.mpos.transactions.parameters.TransactionParameters;
import io.mpos.ui.shared.MposUi;

public class CardPaymentTypeSelectionFragment extends BaseFragment {

    private Chip chipBack;
    private AlertDialog progressBarDialog;
    private CardView cvCardreader, cvMoto, cvManual, cvPaymentLink;
    private TextView tvCardreader, tvMoto, tvManual;
    private LinearLayout llExpand, llGrandTotal;
    private ImageView ivExpand;

    private LinearLayout llSubTotal, llDiscount, llGratuity, llServiceCharge, llDelivery, llMainLayout;
    private TextView tvGratuity, tvServiceCharge, tvDelivery, tvSubtotal, tvDiscount, tvGrandTotal, tvBalance;
    private MaterialButton btnPay;
    private TextView tvGratuityText, tvServiceChargeText, tvDiscountText;

    private Order order;
    String payment_method_name, order_id, order_split_id, unique_id;
    int _order_id, _order_split_id;
    float payingAmount, extraAmountGratitude = 0, actualPaymentAmount = 0;
    private boolean is_moto, is_cardreader, is_manual, is_full;
    private String paymentMethodId = null;
    private Float paidAmount, remainingBalance;

    private MposUi mposUi;
    private ZoneRichPrinter zoneRichPrinter;
    private SunmiPrinter sunmiPrinter;
    private SunmiPrinterV3Mix sunmiPrinterV3Mix;
    private WifiPrinter wifiPrinter;
    private Printer defaultPrinter;
    public BluetoothPrinter bluetoothPrinter;
    private Admin loggedInAdmin = myPreferences.getLoggedInAdmin();
    private Business selectedBusiness = loggedInAdmin.selected_business;
    private BusinessCardReader selectedCardReader;
    private SiteSetting headerAlignmentSetting;
    private int headerAlignment = 0;

    private float cartGrandTotal = 0, cartSubTotal = 0, cartDiscount = 0, cartGratuity = 0, cartServiceCharge = 0;
    private boolean serviceChargeAutoMode = true, serviceChargeEnabled = false, discountEnabled = true, gratuityEnabled = true, autoDiscountApplied = false;
    private SiteSetting serviceChargeSetting, serviceChargeTypeSetting, serviceChargeEnableSetting, serviceChargeOptionSetting;
    SiteSetting ticketHeader = myApp.findSetting("ticket_header");
    SiteSetting address = myApp.findSetting("address");
    SiteSetting footerASetting = myApp.findSetting("footer_a");
    SiteSetting footerBSetting = myApp.findSetting("footer_b");

    private String stripe_mode, stripe_private_key, stripe_public_key;
    private Stripe stripe;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (getArguments() != null) {
            payment_method_name = getArguments().getString("method_name");
            payingAmount = getArguments().getFloat("paying_amount");
            _order_id = getArguments().getInt("_order_id");
            order_id = getArguments().getString("order_id");
            order_split_id = getArguments().getString("order_split_id");
            _order_split_id = getArguments().getInt("_order_split_id");
            actualPaymentAmount = getArguments().getFloat("actualPaymentAmount");
            extraAmountGratitude = getArguments().getFloat("extraAmountGratitude");
            is_moto = getArguments().getBoolean("is_moto");
            is_manual = getArguments().getBoolean("is_manual");
            is_cardreader = getArguments().getBoolean("is_cardreader");
            paidAmount = getArguments().getFloat("paid_amount", 0);
            is_full = getArguments().getBoolean("is_full", false);
        }
        return inflater.inflate(R.layout.layout_place_order_cc_type_selection, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            if (savedInstanceState != null) return;
            initViews(view);
            setListeners();
            fetchOffline();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            chipBack = view.findViewById(R.id.chipBack);
            llMainLayout = view.findViewById(R.id.llCCTypeSelection);
            zoneRichPrinter = new ZoneRichPrinter(getActivity());
            sunmiPrinter = new SunmiPrinter(getActivity());
            if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                sunmiPrinterV3Mix = new SunmiPrinterV3Mix(requireActivity());
            }
            wifiPrinter = WifiPrinter.getInstance();
            bluetoothPrinter = new BluetoothPrinter(getActivity());
            selectedBusiness = myPreferences.getLoggedInAdmin().selected_business;
            defaultPrinter = myPreferences.getDefaultPrinter();

            progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
            cvCardreader = view.findViewById(R.id.cvCardreader);
            cvMoto = view.findViewById(R.id.cvMoto);
            cvManual = view.findViewById(R.id.cvManual);
            cvPaymentLink = view.findViewById(R.id.cvPaymentLink);
            tvCardreader = view.findViewById(R.id.tvCardreader);
            tvMoto = view.findViewById(R.id.tvMoto);
            tvManual = view.findViewById(R.id.tvManual);

            llSubTotal = view.findViewById(R.id.ll_SubTotal);
            llDelivery = view.findViewById(R.id.ll_Delivery);
            llGratuity = view.findViewById(R.id.ll_Gratuity);
            llServiceCharge = view.findViewById(R.id.ll_ServiceCharge);
            llDiscount = view.findViewById(R.id.ll_Discount);
            llGrandTotal = view.findViewById(R.id.llGrandTotal);
            llExpand = view.findViewById(R.id.llExpandable);
            ivExpand = view.findViewById(R.id.ivExpand);

            tvSubtotal = view.findViewById(R.id.tvSubtotal);
            tvDelivery = view.findViewById(R.id.tvDelivery);
            tvGratuity = view.findViewById(R.id.tvGratuity);
            tvServiceCharge = view.findViewById(R.id.tvServiceFee);
            tvDiscount = view.findViewById(R.id.tvDiscount);
            tvGrandTotal = view.findViewById(R.id.tvGrandTotal);
            tvBalance = view.findViewById(R.id.tvBalance);

            btnPay = view.findViewById(R.id.btnPay);

            tvDiscountText = view.findViewById(R.id.tvDiscountText);
            tvServiceChargeText = view.findViewById(R.id.tvServiceText);
            tvGratuityText = view.findViewById(R.id.tvGratuityText);

            serviceChargeEnableSetting = myApp.findSetting("is_service_charge");
            serviceChargeSetting = myApp.findSetting("service_charge");
            serviceChargeOptionSetting = myApp.findSetting("service_charge_type_option");
            serviceChargeTypeSetting = myApp.findSetting("service_charge_type");

            if (serviceChargeEnableSetting != null && (serviceChargeEnableSetting.value.equalsIgnoreCase("true") || serviceChargeEnableSetting.value.equalsIgnoreCase("1"))) {
                serviceChargeEnabled = true;
            }
            if (serviceChargeEnabled && serviceChargeOptionSetting != null && serviceChargeOptionSetting.value.equalsIgnoreCase("manual")) {
                serviceChargeAutoMode = false;
            }
            btnPay.setEnabled(false);

            if (is_moto) {
                if (myApp.isConnected(getActivity())) {
                    cvMoto.setVisibility(View.VISIBLE);
                } else {
                    cvMoto.setVisibility(View.GONE);
                }
            } else {
                cvMoto.setVisibility(View.GONE);
            }

            if (is_manual) {
                cvManual.setVisibility(View.VISIBLE);
            } else {
                cvManual.setVisibility(View.GONE);
            }

            if (is_cardreader) {
                if (myApp.isConnected(getActivity())) {
                    cvCardreader.setVisibility(View.VISIBLE);
                } else {
                    cvCardreader.setVisibility(View.GONE);
                }
            } else {
                cvCardreader.setVisibility(View.GONE);
            }

            headerAlignmentSetting = myApp.findSetting("ticket_header_type");
            if (headerAlignmentSetting != null && headerAlignmentSetting.value.equalsIgnoreCase("right")) {
                headerAlignment = 2;
            }
            if (headerAlignmentSetting != null && headerAlignmentSetting.value.equalsIgnoreCase("center")) {
                headerAlignment = 1;
            }
            llExpand.setVisibility(View.GONE);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateViews() {
        try {
            cartSubTotal = order.sub_total;
            cartDiscount = order.discount;
            cartGratuity = order.gratuity;
            cartServiceCharge = order.service_charge;

            cartGrandTotal = ((cartSubTotal + cartGratuity + cartServiceCharge + order.delivery_charge) - cartDiscount);
            // cartGrandTotal = cartSubTotal + cartGratuity - cartDiscount + cartServiceCharge +order.delivery_charge ;
            Log.e("cartServiceCharge_3", ":" + cartSubTotal + ":" + cartGratuity + ":" + cartDiscount + ":" + cartServiceCharge + ":" + order.delivery_charge);


            tvBalance.setText("Balance Remaining: " + MyApp.currencySymbol + MyApp.df.format(remainingBalance));
            btnPay.setText("Pay " + MyApp.currencySymbol + MyApp.df.format(payingAmount));
            tvSubtotal.setText(MyApp.currencySymbol + MyApp.df.format(cartSubTotal));
            tvGrandTotal.setText(MyApp.currencySymbol + MyApp.df.format(cartGrandTotal));

            if (is_full && _order_split_id == 0) {
                cvPaymentLink.setVisibility(View.VISIBLE);
            } else {
                cvPaymentLink.setVisibility(View.GONE);
            }

            if (order.discount > 0) {
                llDiscount.setVisibility(View.VISIBLE);
                tvDiscount.setText(MyApp.currencySymbol + MyApp.df.format(order.discount));
            } else {
                llDiscount.setVisibility(View.GONE);
            }
            if (order.gratuity > 0) {
                llGratuity.setVisibility(View.VISIBLE);
                tvGratuity.setText(MyApp.currencySymbol + MyApp.df.format(order.gratuity));
            } else {
                llGratuity.setVisibility(View.GONE);
            }
            if (order.service_charge > 0) {
                llServiceCharge.setVisibility(View.VISIBLE);
                tvServiceCharge.setText(MyApp.currencySymbol + MyApp.df.format(order.service_charge));
            } else {
                llServiceCharge.setVisibility(View.GONE);
            }
            if (order.delivery_charge > 0) {
                llDelivery.setVisibility(View.VISIBLE);
                tvDelivery.setText(MyApp.currencySymbol + MyApp.df.format(order.delivery_charge));
            } else {
                llDelivery.setVisibility(View.GONE);
            }
            if (Float.parseFloat(MyApp.df.format(remainingBalance)) == 0) {
                btnPay.setEnabled(false);
            }
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            chipBack.setOnClickListener(view -> getActivity().onBackPressed());
            cvCardreader.setOnClickListener(view -> {
                changeCvColor(view);
                paymentMethodId = "9";
                btnPay.performClick();
            });
            cvMoto.setOnClickListener(view -> {
                changeCvColor(view);
                paymentMethodId = "10";
                btnPay.performClick();
            });
            cvManual.setOnClickListener(view -> {
                changeCvColor(view);
                paymentMethodId = "2";
                btnPay.performClick();
            });
            cvPaymentLink.setOnClickListener(v -> {
                if (is_full) {
                    changeCvColor(v);
                    paymentMethodId = "11";
                    btnPay.performClick();
                } else {
                    ToastUtils.showSnackBar(getActivity(), llMainLayout, "Please pay full payment");
                }
            });
            btnPay.setOnClickListener(v -> {
                if (remainingBalance > 0) {
                    if (Validators.isNullOrEmpty(paymentMethodId)) {
                        ToastUtils.showSnackBar(getActivity(), llMainLayout, "Please select payment method");
                    } else {
                        if (paymentMethodId.equalsIgnoreCase("9")) {
                            setUpMposTerminal();
                        } else if (paymentMethodId.equalsIgnoreCase("10")) {
                            openMotoPayment();
                        } else if (paymentMethodId.equalsIgnoreCase("2")) {
                            makeManualPayment();
                        } else if (paymentMethodId.equalsIgnoreCase("11")) {
                            changeFragment(new PaymentLinkFragment());
                        }
                    }
                } else {
                    ToastUtils.showSnackBar(getActivity(), llMainLayout, "Already paid", "success");
                }
            });
            llGrandTotal.setOnClickListener(view -> {
                if (llExpand.getVisibility() == View.VISIBLE) {
                    ivExpand.setRotation(90);
                    llExpand.setVisibility(View.GONE);
                } else {
                    ivExpand.setRotation(270);
                    llExpand.setVisibility(View.VISIBLE);
                }

            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void changeCvColor(View view) {
        try {
            cvCardreader.setCardBackgroundColor(ContextCompat.getColor(getActivity(), R.color.white));
            cvMoto.setCardBackgroundColor(ContextCompat.getColor(getActivity(), R.color.white));
            cvManual.setCardBackgroundColor(ContextCompat.getColor(getActivity(), R.color.white));

            tvCardreader.setTextColor(getResources().getColor(R.color.reason_normal_text));
            tvMoto.setTextColor(getResources().getColor(R.color.reason_normal_text));
            tvManual.setTextColor(getResources().getColor(R.color.reason_normal_text));

            if (view == cvCardreader) {
                cvCardreader.setCardBackgroundColor(ContextCompat.getColor(getActivity(), R.color.persian_green));
                tvCardreader.setTextColor(getResources().getColor(R.color.white));
            }
            if (view == cvMoto) {
                cvMoto.setCardBackgroundColor(ContextCompat.getColor(getActivity(), R.color.persian_green));
                tvMoto.setTextColor(getResources().getColor(R.color.white));
            }
            if (view == cvManual) {
                cvManual.setCardBackgroundColor(ContextCompat.getColor(getActivity(), R.color.persian_green));
                tvManual.setTextColor(getResources().getColor(R.color.white));
            }

            btnPay.setEnabled(true);
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
    }


    private void openMotoPayment() {
        try {
            PaymentViaMotoDialogFragment paymentViaMotoFragment = getInstancePaymentViaMoto(payingAmount);
            paymentViaMotoFragment.show(getActivity().getSupportFragmentManager(), ",moto_payment");
            paymentViaMotoFragment.setDialogDismissListener(o -> {
                try {
                   /* if (o instanceof Charge) {
                        manageMotoResponse((Charge) o);
                    } else*/
                    if (o instanceof PaymentIntent) {
                        manageMotoResponse((PaymentIntent) o);
                    } else {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> {
                                AnimatedConfirmationDialogFragment confirmationDialogFragment = getInstanceAnimatedConfirmation("Error", "Payment declined", 2, "Okay", null);
                                confirmationDialogFragment.show(getChildFragmentManager(), "action");
                            });
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public PaymentViaMotoDialogFragment getInstancePaymentViaMoto(Float payment_amount) {
        PaymentViaMotoDialogFragment fragment = new PaymentViaMotoDialogFragment();
        Bundle b = new Bundle();
        b.putFloat("payment_amount", payment_amount);
        fragment.setArguments(b);
        return fragment;
    }

    /*private void manageMotoResponse(Charge charge) {
        try {
            String transactionId = charge.getId();
            if (getActivity() != null)
                getActivity().runOnUiThread(() -> progressBarDialog.show());
            OrderPayment orderPayment = new OrderPayment();
            orderPayment.payment_method_id = paymentMethodId;
            orderPayment.updater_id = myPreferences.getLoggedInUser().id;
            orderPayment.amount = payingAmount;
            orderPayment.txn_id = transactionId;
            orderPayment.mode = "Moto Payment";
            orderPayment.payment_method_name = "Credit Card Moto";
            orderPayment.order_id = order_id;
            orderPayment.order_split_id = order_split_id;
            orderPayment._order_split_id = _order_split_id;
            // add unique id for find split payment
            orderPayment.unique_id = unique_id;
            orderPayment._order_id = _order_id;
            if (extraAmountGratitude > 0) {
                order.gratuity = extraAmountGratitude;
                order.total = extraAmountGratitude + order.total;
            }
            new Thread(() -> {
                try {
                    appDatabase.orderPaymentDao().insert(orderPayment);
                    order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                    appDatabase.orderDao().update(order);
                    getActivity().setResult(Activity.RESULT_OK, new Intent().putExtra("_order_split_id", _order_split_id));
                    if (getActivity() != null) {
                        getActivity().runOnUiThread(() -> {
                            myApp.needToPrint = true;
                            myApp.isCashDrawerOpen = false;
                            progressBarDialog.dismiss();
                            String message = "Payment failed";
                            int statusTYpe = 2;
                            if (charge.getStatus().equalsIgnoreCase("Succeeded")) {
                                message = "Payment Approved";
                                statusTYpe = 1;
                            } else if (charge.getStatus().equalsIgnoreCase("RequiresPaymentMethod")) {
                                message = "Payment Failed";
                                statusTYpe = 2;
                            } else if (charge.getStatus().equalsIgnoreCase("Canceled")) {
                                message = "Payment Decliend";
                                statusTYpe = 2;
                            }
                            AnimatedConfirmationDialogFragment confirmationDialogFragment = getInstanceAnimatedConfirmation(message, null, statusTYpe, "Okay", null);
                            confirmationDialogFragment.setCancelable(false);
                            confirmationDialogFragment.show(getActivity().getSupportFragmentManager(), "paybill_confirmation");
                            confirmationDialogFragment.setDialogDismissListener(o -> {
                                String action = (String) o;
                                if (action.equalsIgnoreCase("confirm")) {
                                    createMotoPrint(charge);
                                }
                            });

                        });
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }*/

    private void manageMotoResponse(PaymentIntent paymentIntent) {
        try {
            String transactionId = paymentIntent.getId();
            if (getActivity() != null)
                getActivity().runOnUiThread(() -> progressBarDialog.show());
            OrderPayment orderPayment = new OrderPayment();
            orderPayment.payment_method_id = paymentMethodId;
            orderPayment.updater_id = myPreferences.getLoggedInUser().id;
            orderPayment.amount = payingAmount;
            orderPayment.txn_id = transactionId;
            orderPayment.mode = "Moto Payment";
            orderPayment.payment_method_name = "Credit Card Moto";
            orderPayment.order_id = order_id;
            orderPayment.order_split_id = order_split_id;
            orderPayment._order_split_id = _order_split_id;
            orderPayment._order_id = _order_id;
            // add unique id for find split payment
            orderPayment.unique_id = unique_id;
            if (extraAmountGratitude > 0) {
                order.gratuity = extraAmountGratitude;
                order.total = extraAmountGratitude + order.total;
            }
            new Thread(() -> {
                try {
                    appDatabase.orderPaymentDao().insert(orderPayment);
                    order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                    appDatabase.orderDao().update(order);
                    getActivity().setResult(Activity.RESULT_OK, new Intent().putExtra("_order_split_id", _order_split_id));
                    if (getActivity() != null) {
                        getActivity().runOnUiThread(() -> {
                            myApp.needToPrint = true;
                            myApp.isCashDrawerOpen = false;
                            progressBarDialog.dismiss();
                            String message = "Payment failed";
                            int statusTYpe = 2;
                            if (paymentIntent.getStatus() == null) {
                                message = "Payment Declined";
                                statusTYpe = 2;
                            } else if (paymentIntent.getStatus() == PaymentIntent.Status.Succeeded) {
                                message = "Payment Approved";
                                statusTYpe = 1;
                            } else if (paymentIntent.getStatus() == PaymentIntent.Status.RequiresPaymentMethod) {
                                message = "Payment Failed";
                            } else if (paymentIntent.getStatus() == PaymentIntent.Status.Canceled) {
                                message = "Payment Declined";
                                statusTYpe = 2;
                            } else {
                                message = "Payment Declined";
                                statusTYpe = 2;
                            }
                            AnimatedConfirmationDialogFragment confirmationDialogFragment = getInstanceAnimatedConfirmation(message, null, statusTYpe, "Okay", null);
                            confirmationDialogFragment.setCancelable(false);
                            confirmationDialogFragment.show(getChildFragmentManager(), "paybill_confirmation");
                            confirmationDialogFragment.setDialogDismissListener(o -> {
                                String action = (String) o;
                                if (action.equalsIgnoreCase("confirm")) {
                                    createMotoPrint(paymentIntent);

                                }
                            });

                        });
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*private void createMotoPrint(Charge charge) {
        try {
            print_stripe_id = charge.getId();
            print_amount = MyApp.df.format(payingAmount);

            if (charge.getPaymentMethodDetails() != null)
                print_card = charge.getPaymentMethodDetails().getCard().getBrand().toString();

            if (charge.getPaymentMethodDetails() != null && charge.getPaymentMethodDetails().getCard() != null)
                print_card_number = charge.getPaymentMethodDetails().getCard().getLast4().toString();

            print_payment_mode = "MOTO";
            if (charge.getStatus().equalsIgnoreCase("Succeeded")) {
                // Payment completed successfully
                ToastUtils.showSnackBar(getActivity(), llMainLayout, "Payment successful", "success");
                print_status = "Approved";
                myApp.startPaymentSuccessSound();
            } else if (charge.getStatus().equalsIgnoreCase("RequiresPaymentMethod")) {
                // Payment failed
                print_status = "Failed";
                myApp.startPaymentFailedSound();
            } else if (charge.getStatus().equalsIgnoreCase("Canceled")) {
                print_status = "Declined";
                myApp.startPaymentFailedSound();
            }

            title = "" + "Customer Copy" + "\n";

            SiteSetting ticketHeader = myApp.findSetting("ticket_header");
            SiteSetting address = myApp.findSetting("address");

            if (ticketHeader != null) header = ticketHeader.value;
            if (address != null) resAddress = address.value;

            amount = "£" + print_amount + "\n";

            card_____ = "Card       :" + print_card;
            account__ = "Account    :" + print_card_number;
            stripe_id = "TID        :" + print_stripe_id;
            entry_mod = "Entry Mode :" + print_payment_mode;
            status___ = "Status     :" + print_status;

            please = "Please Retain Receipt\nFor Your Record\n";
            date_final = "" + CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy hh:mm:ss a") + "\n";
            footerA = "";
            footerB = "";
            SiteSetting footerASetting = myApp.findSetting("footer_a");
            SiteSetting footerBSetting = myApp.findSetting("footer_b");

            if (footerASetting != null) footerA = footerASetting.value;

            if (footerBSetting != null) footerB = footerBSetting.value;

            main_content = card_____ + "\n" + account__ + "\n" + stripe_id + "\n" + entry_mod + "\n" + status___ + "\n";
            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                    printMotoZonrich("Merchant Copy");
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("t2") || defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                    printMotoSunmi("Merchant Copy");
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                        printIMin("Merchant Copy");
                    } else {
                        if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                            printMotoWIfi("Merchant Copy");
                        } else {
                            try {
                                if (bluetoothPrinter != null) {
                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                    if (device != null) {
                                        printMotoBT("Merchant Copy");
                                    } else {
                                        ToastUtils.makeLongToast(getActivity(), "No bluetooth device found.");
                                        goBack();
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            } else {
                ToastUtils.makeLongToast(getActivity(), "No printer model found");
                goBack();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }*/

    private void createMotoPrint(PaymentIntent paymentIntent) {

        try {
            PaymentIntent.Status paymentIntentStatus = paymentIntent.getStatus();
            print_stripe_id = paymentIntent.getId();
            print_amount = MyApp.df.format(payingAmount);

            if (paymentIntent.getPaymentMethod() != null && paymentIntent.getPaymentMethod().card != null)
                print_card = paymentIntent.getPaymentMethod().card.brand.getDisplayName();

            if (paymentIntent.getPaymentMethod() != null && paymentIntent.getPaymentMethod().card != null)
                print_card_number = paymentIntent.getPaymentMethod().card.last4;

            print_payment_mode = "MOTO";
            if (paymentIntentStatus == null) {
                print_status = "Declined";
                ToastUtils.makeToast(getActivity(), "Payment declined");
                myApp.startPaymentFailedSound();
            } else if (paymentIntentStatus == PaymentIntent.Status.Succeeded) {
                // Payment completed successfully
                ToastUtils.makeToast(getActivity(), "Payment successful");
                myApp.startPaymentSuccessSound();
                print_status = "Approved";

            } else if (paymentIntentStatus == PaymentIntent.Status.RequiresPaymentMethod) {
                // Payment failed
                print_status = "Failed";
                myApp.startPaymentFailedSound();
                ToastUtils.makeToast(getActivity(), "Card authentication failed, Please retry");
            } else if (paymentIntentStatus == StripeIntent.Status.Canceled) {
                print_status = "Declined";
                ToastUtils.makeToast(getActivity(), "Payment declined");
                myApp.startPaymentFailedSound();
            } else {
                print_status = "Declined";
                ToastUtils.makeToast(getActivity(), "Payment declined");
                myApp.startPaymentFailedSound();
            }

            title = "" + "Customer Copy" + "\n";

            SiteSetting ticketHeader = myApp.findSetting("ticket_header");
            SiteSetting address = myApp.findSetting("address");

            if (ticketHeader != null) header = ticketHeader.value;
            if (address != null) resAddress = address.value;

            amount = "£" + print_amount + "\n";

            card_____ = "Card       :" + print_card;
            account__ = "Account    :" + print_card_number;
            stripe_id = "TID        :" + print_stripe_id;
            entry_mod = "Entry Mode :" + print_payment_mode;
            status___ = "Status     :" + print_status;

            please = "Please Retain Receipt\nFor Your Record\n";
            date_final = "" + CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy hh:mm:ss a") + "\n";
            footerA = "";
            footerB = "";
            SiteSetting footerASetting = myApp.findSetting("footer_a");
            SiteSetting footerBSetting = myApp.findSetting("footer_b");

            if (footerASetting != null) footerA = footerASetting.value;

            if (footerBSetting != null) footerB = footerBSetting.value;

            main_content = card_____ + "\n" + account__ + "\n" + stripe_id + "\n" + entry_mod + "\n" + status___ + "\n";
            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                    printMotoZonrich("Merchant Copy");
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("t2") || defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                    printMotoSunmi("Merchant Copy");
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                        printIMin("Merchant Copy");
                    } else {
                        if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                            printMotoWIfi("Merchant Copy");
                        } else {
                            try {
                                if (bluetoothPrinter != null) {
                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                    if (device != null) {
                                        printMotoBT("Merchant Copy");
                                    } else {
                                        ToastUtils.makeLongToast(getActivity(), "No bluetooth device found.");
                                        goBack();
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            } else {
                ToastUtils.makeLongToast(getActivity(), "No printer model found");
                goBack();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printIMin(String title) {
        try {
            title = title + "\n";
            String finalTitle = title;
            myApp.iMinPrinterUtils.printMotoReceipt(myApp.tiffintomLogoSmall, finalTitle, header, "", "", amount, main_content, date_final, please, footerA, footerB);
            if (finalTitle.toLowerCase().contains("merchant")) {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Is Customer Copy required?", null, 0, "Confirm", "Cancel");
                confirmationDialogFragment.setCancelable(false);
                confirmationDialogFragment.show(requireActivity().getSupportFragmentManager(), "printer");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        if (((String) o).equalsIgnoreCase("confirm")) {
                            printIMin("Customer Copy");
                        }
                    }
                });

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printMotoZonrich(String title) {
        try {
            title = title + "\n";
            if (getActivity() != null) {
                String finalTitle = title;
                getActivity().runOnUiThread(() -> {
                    zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                    if (finalTitle.toLowerCase().contains("merchant")) {
                        if (selectedBusiness.auto_merchant_print != null && (selectedBusiness.auto_merchant_print.equalsIgnoreCase("true") || selectedBusiness.auto_merchant_print.equalsIgnoreCase("1"))) {
                            zoneRichPrinter.printMotoReceipt(myApp.businessLogo, finalTitle, header, headerAlignment, amount, main_content, date_final, please, footerA, footerB, myApp.myPreferences);
                            printCustomerZoneRich(finalTitle);
                        } else {
                            ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Merchant copy required?", null, 0, "Okay", "Cancel");
                            confirmationDialogFragment.show(getChildFragmentManager(), "confirm");
                            confirmationDialogFragment.setDialogDismissListener(o -> {
                                if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                                    zoneRichPrinter.printMotoReceipt(myApp.businessLogo, finalTitle, header, headerAlignment, amount, main_content, date_final, please, footerA, footerB, myApp.myPreferences);
                                    printCustomerZoneRich(finalTitle);
                                } else {
                                    printCustomerZoneRich(finalTitle);
                                }
                            });
                        }
                    } else {
                        Log.e("printMotoReceipt", "Inelse " + finalTitle);
                        zoneRichPrinter.printMotoReceipt(myApp.businessLogo, finalTitle, header, headerAlignment, amount, main_content, date_final, please, footerA, footerB, myApp.myPreferences);
                        goBack();
                    }
                });

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printCustomerZoneRich(String title) {
        if (title.toLowerCase().contains("merchant")) {
            if (selectedBusiness.auto_customer_print != null && (selectedBusiness.auto_customer_print.equalsIgnoreCase("true") || selectedBusiness.auto_customer_print.equalsIgnoreCase("1"))) {
                printMotoZonrich("Customer Copy");
            } else {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Customer copy required?", null, 0, "Okay", "Cancel");
                confirmationDialogFragment.show(getChildFragmentManager(), "confirm");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                        printMotoZonrich("Customer Copy");
                    } else {
                        Log.e("printMotoReceipt", "printCustomerZoneRich ");
                        goBack();
                    }
                });
            }
        }
    }

    public void printMotoSunmi(String title) {
        try {
            try {
                if (getActivity() != null) {

                    getActivity().runOnUiThread(() -> {
                        if (title.toLowerCase().contains("merchant")) {
                            if (selectedBusiness.auto_merchant_print != null && (selectedBusiness.auto_merchant_print.equalsIgnoreCase("true") || selectedBusiness.auto_merchant_print.equalsIgnoreCase("1"))) {
                                if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                                    sunmiPrinterV3Mix.printMotoReceipt(myApp.businessLogo, title, header, headerAlignment, amount, main_content, date_final, please, footerA, footerB, myPreferences);
                                }else {
                                    sunmiPrinter.printMotoReceipt(myApp.businessLogo, title, header, headerAlignment, amount, main_content, date_final, please, footerA, footerB, myPreferences);
                                }
                                merchantCopySunmi(title);
                            } else {
                                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Merchant copy required?", null, 0, "Okay", "Cancel");
                                confirmationDialogFragment.show(getChildFragmentManager(), "confirm");
                                confirmationDialogFragment.setDialogDismissListener(o -> {
                                    if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                                        if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                                            sunmiPrinterV3Mix.printMotoReceipt(myApp.businessLogo, title, header, headerAlignment, amount, main_content, date_final, please, footerA, footerB, myPreferences);
                                        }else {
                                            sunmiPrinter.printMotoReceipt(myApp.businessLogo, title, header, headerAlignment, amount, main_content, date_final, please, footerA, footerB, myPreferences);
                                        }
                                        merchantCopySunmi(title);
                                    } else {
                                        merchantCopySunmi(title);
                                    }
                                });
                            }
                        } else {
                            if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                                sunmiPrinterV3Mix.printMotoReceipt(myApp.businessLogo, title, header, headerAlignment, amount, main_content, date_final, please, footerA, footerB, myPreferences);
                            }else {
                                sunmiPrinter.printMotoReceipt(myApp.businessLogo, title, header, headerAlignment, amount, main_content, date_final, please, footerA, footerB, myPreferences);
                            }
                            goBack();
                        }
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void merchantCopySunmi(String title) {
        if (title.toLowerCase().contains("merchant")) {
            if (selectedBusiness.auto_customer_print != null && (selectedBusiness.auto_customer_print.equalsIgnoreCase("true") || selectedBusiness.auto_customer_print.equalsIgnoreCase("1"))) {
                printMotoSunmi("Customer Copy");
            } else {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Customer copy required?", null, 0, "Okay", "Cancel");
                confirmationDialogFragment.show(getChildFragmentManager(), "confirm");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                        printMotoSunmi("Customer Copy");
                    } else {
                        goBack();
                    }
                });
            }
        }
    }

    public void printMotoWIfi(String title) {
        try {
            wifiPrinter.connect(defaultPrinter.ip);
            CommonFunctions.functionThatDelay(100);
            wifiPrinter.printMotoReceipt(myApp.businessLogo, title, header, headerAlignment, amount, main_content, date_final, please, footerA, footerB, true, myPreferences);
            if (title.toLowerCase().contains("merchant")) {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Customer copy required?", null, 0, "Okay", "Cancel");
                confirmationDialogFragment.show(getChildFragmentManager(), "confirm");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                        printMotoWIfi("Customer Copy");
                    } else {
                        goBack();
                    }
                });
            } else {
                goBack();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printMotoBT(String title) {
        try {
            CommonFunctions.functionThatDelay(100);
            bluetoothPrinter.printMotoReceipt(myApp.businessLogo, title, header, headerAlignment, amount, main_content, date_final, please, footerA, footerB, true);
            if (title.toLowerCase().contains("merchant")) {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Customer copy required?", null, 0, "Okay", "Cancel");
                confirmationDialogFragment.show(getChildFragmentManager(), "confirm");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                        printMotoBT("Customer Copy");
                    } else {
                        goBack();
                    }
                });
            } else {
                goBack();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void makeManualPayment() {
        try {
            if (getActivity() != null)
                getActivity().runOnUiThread(() -> progressBarDialog.show());
            OrderPayment orderPayment = new OrderPayment();
            orderPayment.payment_method_id = paymentMethodId;
            orderPayment.updater_id = myPreferences.getLoggedInUser().id;
            orderPayment.amount = payingAmount;
            orderPayment.mode = "Manual Payment";
            orderPayment.payment_method_name = "Credit Card Manual";
            orderPayment.order_id = order_id;
            orderPayment.order_split_id = order_split_id;
            orderPayment._order_split_id = _order_split_id;
            orderPayment._order_id = _order_id;
            // add unique id for find split payment
            orderPayment.unique_id = unique_id;
            if (extraAmountGratitude > 0) {
                order.gratuity = extraAmountGratitude;
                order.total = extraAmountGratitude + order.total;
            }
            new Thread(() -> {
                try {
                    appDatabase.orderPaymentDao().insert(orderPayment);
                    order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                    appDatabase.orderDao().update(order);
                    getActivity().setResult(Activity.RESULT_OK, new Intent().putExtra("_order_split_id", _order_split_id));
                    if (getActivity() != null) {
                        getActivity().runOnUiThread(() -> {
                            myApp.needToPrint = true;
                            myApp.isCashDrawerOpen = false;
                            progressBarDialog.dismiss();
                            AnimatedConfirmationDialogFragment confirmationDialogFragment = getInstanceAnimatedConfirmation("Payment completed", null, 1, "Okay", null);
                            confirmationDialogFragment.setCancelable(false);
                            confirmationDialogFragment.show(getChildFragmentManager(), "paybill_confirmation");
                            confirmationDialogFragment.setDialogDismissListener(o -> {
                                if (getActivity() != null) goBack();
                            });

                        });
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeFragment(Fragment fragment) {
        try {
            FragmentManager manager = getActivity().getSupportFragmentManager();
            if (getArguments() != null) {
                fragment.setArguments(getArguments());
            }
            FragmentTransaction transaction = manager.beginTransaction();
            transaction.replace(R.id.flContainer, fragment);
            transaction.addToBackStack("can_go_back");
            transaction.commitAllowingStateLoss();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void initMpos() {
        try {
            if (selectedBusiness.stripe_mode.equalsIgnoreCase("live")) {
                mposUi = MposUi.initialize(requireContext(), ProviderMode.LIVE,
                        selectedCardReader.merchant_key, selectedCardReader.merchant_secret);
            } else {
                mposUi = MposUi.initialize(requireContext(), ProviderMode.MOCK,
                        selectedCardReader.merchant_key, selectedCardReader.merchant_secret);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setUpMposTerminal() {
        try {
            if (selectedBusiness.card_readers != null && selectedBusiness.card_readers.size() == 1) {
                selectedCardReader = selectedBusiness.card_readers.get(0);
            }

            if (selectedCardReader != null) {
                if (selectedCardReader.connectivity.toLowerCase().equalsIgnoreCase("internet") || selectedCardReader.connectivity.toLowerCase().equalsIgnoreCase("stripebluetooth") || selectedCardReader.connectivity.toLowerCase().equalsIgnoreCase("posbluetooth")) {
                    stripe_mode = selectedBusiness.stripe_mode;

                    if (!Validators.isNullOrEmpty(selectedBusiness.s_account_id) && selectedBusiness.connect_service && !Validators.isNullOrEmpty(BuildConfig.connect_stripe_public_key)) {
                        stripe_private_key = BuildConfig.connect_stripe_private_key;
                        stripe_public_key = BuildConfig.connect_stripe_public_key;
                    } else {
                        if (stripe_mode.equalsIgnoreCase("live")) {
                            stripe_private_key = selectedBusiness.stripe_private_key_live;
                            stripe_public_key = selectedBusiness.stripe_public_key_live;
                        } else {
                            stripe_private_key = selectedBusiness.stripe_private_key_test;
                            stripe_public_key = selectedBusiness.stripe_public_key_test;
                        }
                    }
                    PaymentConfiguration.init(getActivity(), stripe_public_key);
                    stripe = new Stripe(getActivity(), stripe_public_key);
                    openStripeReaders(selectedCardReader);
                } else {
                    initMpos();
                    AccessoryParameters accessoryParameters;
                    if (!Validators.isNullOrEmpty(selectedCardReader.ip)) {
                        accessoryParameters = new AccessoryParameters.Builder(AccessoryFamily.MIURA_MPI)
                                .tcp(selectedCardReader.ip, Integer.parseInt(selectedCardReader.port))
                                .build();
                    } else {
                        accessoryParameters = new AccessoryParameters.Builder(AccessoryFamily.MIURA_MPI)
                                .bluetooth()
                                .build();

                    }
                    if (mposUi != null) {
                        if (mposUi.getConfiguration() != null) {
                            mposUi.getConfiguration().setTerminalParameters(accessoryParameters);
                        }
                        if (selectedBusiness != null) {
                            String descriptor = selectedBusiness.statement_descriptor;
                            if (!Validators.isNullOrEmpty(selectedBusiness.s_account_id) && selectedBusiness.connect_service) {
                                descriptor = selectedBusiness.statement_descriptor;
                            }
                            if (!Validators.isNullOrEmpty(selectedBusiness.s_account_id) && selectedBusiness.connect_service) {
                                calculateApplicationFee();
                            } else {
                                TransactionParameters transactionParameters = new TransactionParameters.Builder()
                                        .charge(new BigDecimal("" + payingAmount), Currency.GBP)
                                        .statementDescriptor(descriptor)
                                        .subject(selectedBusiness.statement_description)
                                        .autoCapture(true)
                                        .build();

                                Intent intent = mposUi.createTransactionIntent(transactionParameters);
                                startActivityForResult(intent, Constants.PAYMENT_MPOS_CARDREADER);
                            }
                        } else {
                            ToastUtils.makeSnackToast(getActivity(), "Merchant credentials not found");
                        }
                    } else {
                        ToastUtils.makeSnackToast(getActivity(), "Something went wrong");
                    }
                }
            } else {
                SelectCardReaderDialogFragment selectCardReaderDialogFragment = new SelectCardReaderDialogFragment();
                selectCardReaderDialogFragment.show(getChildFragmentManager(), "card_readers");
                selectCardReaderDialogFragment.setCancelable(false);
                selectCardReaderDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof BusinessCardReader) {
                        selectedCardReader = (BusinessCardReader) o;
                        myPreferences.saveDefaultCardReader(selectedCardReader);
                        setUpMposTerminal();
                    }
                });
            }
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private void openStripeReaders(BusinessCardReader selectedCardReader) {
        try {
            if (selectedCardReader.s_location_id == null) {
                selectedCardReader.s_location_id = selectedBusiness.s_location_id;
            }
            if (selectedCardReader.connectivity.toLowerCase().equalsIgnoreCase("internet")) {
                //    String url = ApiEndPoints.CARD_READER_PAYMENT + "?s_location_id=" + selectedCardReader.s_location_id + "&s_terminal_id=" + selectedCardReader.s_terminal_id + "&amount=" + (totalAmount * 100) + "&business_id=" + selectedBusiness.id;
                //    startActivityForResult(new Intent(getActivity(), InternetCardReaderPaymentActivity.class).putExtra("url", url), Constants.PAYMENT_WEBVIEW_CARDREADER);
                askForPermission("internet");
            } else if (selectedCardReader.connectivity.toLowerCase().toLowerCase().equalsIgnoreCase("stripebluetooth") || selectedCardReader.connectivity.toLowerCase().toLowerCase().equalsIgnoreCase("posbluetooth")) {
                askForPermission("bluetooth");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void askForPermission(String discoverymethod) {
        try {
            final int locationPermission = ActivityCompat.checkSelfPermission(getActivity(), Manifest.permission.ACCESS_FINE_LOCATION);

           /* if (locationPermission == PackageManager.PERMISSION_GRANTED) {
                if (verifyGpsEnabled()) {
                    if (discoverymethod.equalsIgnoreCase("bluetooth")) {
                        showStripeBluetoothReaderDialog();
                    } else {
                        showStripeInternetReaderDialog();
                    }
                }
            } else {
                // If we don't have them yet, request them before doing anything else
                final String[] permissions = {Manifest.permission.ACCESS_FINE_LOCATION};
                requestPermissions(permissions, Constants.PERMISSION_CODE_LOCATION);
            }*/

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
                final int scanPermission = ActivityCompat.checkSelfPermission(getActivity(), Manifest.permission.BLUETOOTH_SCAN);
                final int connectPermission = ActivityCompat.checkSelfPermission(getActivity(), Manifest.permission.BLUETOOTH_CONNECT);
                if (locationPermission == PackageManager.PERMISSION_GRANTED && scanPermission == PackageManager.PERMISSION_GRANTED && connectPermission == PackageManager.PERMISSION_GRANTED) {
                    if (verifyGpsEnabled()) {
                        if (discoverymethod.equals("bluetooth")) {
                            showStripeBluetoothReaderDialog();
                        } else {
                            showStripeInternetReaderDialog();
                        }

                    }
                } else {
                    // If we don't have them yet, request them before doing anything else
                    final String[] permissions = {Manifest.permission.ACCESS_FINE_LOCATION, Manifest.permission.BLUETOOTH_CONNECT, Manifest.permission.BLUETOOTH_SCAN, Manifest.permission.BLUETOOTH_ADMIN};
                    requestPermissions(permissions, Constants.PERMISSION_CODE_LOCATION);
                }
            } else {
                if (locationPermission == PackageManager.PERMISSION_GRANTED) {
                    if (verifyGpsEnabled()) {
                        if (discoverymethod.equals("bluetooth")) {
                            showStripeBluetoothReaderDialog();
                        } else {
                            showStripeInternetReaderDialog();
                        }

                    }
                } else {
                    // If we don't have them yet, request them before doing anything else
                    final String[] permissions = {Manifest.permission.ACCESS_FINE_LOCATION};
                    requestPermissions(permissions, Constants.PERMISSION_CODE_LOCATION);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Receive the result of our permissions check, and initialize if we can
     */
    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        // If we receive a response to our permission check, initialize
        if (requestCode == Constants.PERMISSION_CODE_LOCATION && verifyGpsEnabled()) {
            if (selectedCardReader.connectivity.toLowerCase().equalsIgnoreCase("internet")) {
                //    String url = ApiEndPoints.CARD_READER_PAYMENT + "?s_location_id=" + selectedCardReader.s_location_id + "&s_terminal_id=" + selectedCardReader.s_terminal_id + "&amount=" + (totalAmount * 100) + "&business_id=" + selectedBusiness.id;
                //    startActivityForResult(new Intent(getActivity(), InternetCardReaderPaymentActivity.class).putExtra("url", url), Constants.PAYMENT_WEBVIEW_CARDREADER);
                showStripeInternetReaderDialog();
            } else if (selectedCardReader.connectivity.toLowerCase().toLowerCase().equalsIgnoreCase("stripebluetooth") || selectedCardReader.connectivity.toLowerCase().toLowerCase().equalsIgnoreCase("posbluetooth")) {
                showStripeBluetoothReaderDialog();
            }
        }
    }

    private void showStripeBluetoothReaderDialog() {
        try {
            StripeBluetoothCardReaderPaymentFragment stripeBluetoothCardReaderPaymentFragment = getInstanceStripeBluetoothCardR(selectedCardReader, payingAmount);
            stripeBluetoothCardReaderPaymentFragment.show(getChildFragmentManager(), "card_reader");
            stripeBluetoothCardReaderPaymentFragment.setCancelable(false);
            stripeBluetoothCardReaderPaymentFragment.setDialogDismissListener(new DialogDismissDataListener() {
                @Override
                public void onDialogDismiss(Object o, String cardName, String number) {
                    if (o instanceof com.stripe.stripeterminal.external.models.PaymentIntent) {
                        retrivePaymentIntentAndPrintWithId(((com.stripe.stripeterminal.external.models.PaymentIntent) o).getClientSecret(), cardName, number);
                    } else if (o instanceof String) {
                        myApp.startPaymentFailedSound();
                        ToastUtils.makeSnackToast(getActivity(), (String) o);
                    } else {
                        myApp.startPaymentFailedSound();
                        ToastUtils.makeSnackToast(getActivity(), "Transaction was declined, aborted, or failed");

                    }
                }

                @Override
                public void onDialogDismissPaymentFailed() {

                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public StripeBluetoothCardReaderPaymentFragment getInstanceStripeBluetoothCardR(BusinessCardReader cardReader, float amount) {
        StripeBluetoothCardReaderPaymentFragment rejectReasonDialog = new StripeBluetoothCardReaderPaymentFragment();
        Bundle bundle = new Bundle();
        bundle.putString("card_reader", new Gson().toJson(cardReader));
        bundle.putFloat("amount", amount);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    private void showStripeInternetReaderDialog() {
        try {
            StripeInternetCardReaderPaymentFragment stripeInternetCardReaderPaymentFragment = getInstanceStripeInternetCardR(selectedCardReader, payingAmount);
            stripeInternetCardReaderPaymentFragment.show(getChildFragmentManager(), "card_reader");
            stripeInternetCardReaderPaymentFragment.setCancelable(false);
            stripeInternetCardReaderPaymentFragment.setDialogDismissListener(new DialogDismissDataListener() {
                @Override
                public void onDialogDismiss(Object o, String cardName, String number) {
                    if (o instanceof com.stripe.stripeterminal.external.models.PaymentIntent) {
                        retrivePaymentIntentAndPrintWithId(((com.stripe.stripeterminal.external.models.PaymentIntent) o).getClientSecret(), cardName, number);
                    } else if (o instanceof String) {
                        myApp.startPaymentFailedSound();
                        ToastUtils.makeSnackToast(getActivity(), (String) o);
                    } else {
                        myApp.startPaymentFailedSound();
                        ToastUtils.makeSnackToast(getActivity(), "Transaction was declined, aborted, or failed");

                    }
                }

                @Override
                public void onDialogDismissPaymentFailed() {

                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public StripeInternetCardReaderPaymentFragment getInstanceStripeInternetCardR(BusinessCardReader cardReader, float amount) {
        StripeInternetCardReaderPaymentFragment rejectReasonDialog = new StripeInternetCardReaderPaymentFragment();
        Bundle bundle = new Bundle();
        bundle.putString("card_reader", new Gson().toJson(cardReader));
        bundle.putFloat("amount", amount);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }


    public boolean isGpsEnabled(Context context) {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.KITKAT) {
            String providers = Settings.Secure.getString(context.getContentResolver(),
                    Settings.Secure.LOCATION_PROVIDERS_ALLOWED);
            if (TextUtils.isEmpty(providers)) {
                return false;
            }
            return providers.contains(LocationManager.GPS_PROVIDER);
        } else {
            final int locationMode;
            try {
                locationMode = Settings.Secure.getInt(context.getContentResolver(),
                        Settings.Secure.LOCATION_MODE);
            } catch (Settings.SettingNotFoundException e) {
                e.printStackTrace();
                return false;
            }
            switch (locationMode) {

                case Settings.Secure.LOCATION_MODE_HIGH_ACCURACY:
                case Settings.Secure.LOCATION_MODE_SENSORS_ONLY:
                    return true;
                case Settings.Secure.LOCATION_MODE_BATTERY_SAVING:
                case Settings.Secure.LOCATION_MODE_OFF:
                default:
                    return false;
            }
        }
    }


    private boolean verifyGpsEnabled() {
        if (isGpsEnabled(getActivity())) {
            LogUtils.e("Returned tru, gps malyu");
            return true;
        }
        final LocationManager locationManager = (LocationManager) getActivity().getSystemService(Context.LOCATION_SERVICE);

        boolean gpsEnabled = false;
        if (locationManager == null) {
            ToastUtils.makeToast(getActivity(), "Location manager null");
        }
        try {
            gpsEnabled = locationManager != null &&
                    locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER);
        } catch (Exception exception) {
            ToastUtils.makeLongToast(getActivity(), exception.getMessage());
            exception.printStackTrace();
        }

        if (!gpsEnabled) {
            // notify user
            new AlertDialog.Builder(new ContextThemeWrapper(getActivity(), R.style.Theme_MaterialComponents_DayNight_DarkActionBar))
                    .setMessage("Please enable location services")
                    .setCancelable(false)
                    .setPositiveButton("Open location settings", (dialog, which) -> {
                        startActivity(new Intent(Settings.ACTION_LOCATION_SOURCE_SETTINGS));
                    })
                    .create()
                    .show();
        }

        return gpsEnabled;
    }

    private HashMap<String, String> generateFeeParams() {
        HashMap<String, String> params = new HashMap<>();

        params.put("amount", MyApp.df.format((payingAmount) * 100));
        params.put("currency", "GBP");
        params.put("transaction_type", !selectedBusiness.connect_service ? "merchant" : "connect");
        params.put("business_id", selectedBusiness.id);
        return params;
    }

    private void calculateApplicationFee() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    progressBarDialog.show();

                });
            }
            AndroidNetworking.post(ApiEndPoints.APPLICATION_FEE)
                    .addBodyParameter(generateFeeParams())
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> progressBarDialog.dismiss());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            try {
                                if (response.has("payment_intent_id")) {
                                    String paymentSecret = response.getString("payment_intent_id");
                                    Intent intent = mposUi.createTransactionIntent(paymentSecret);
                                    startActivityForResult(intent, Constants.PAYMENT_MPOS_CARDREADER);
                                } else if (response.has("fee")) {
                                    float fee = Float.parseFloat(response.getString("fee"));
                                    TransactionParameters transactionParameters = new TransactionParameters.Builder()
                                            .charge(new BigDecimal("" + payingAmount), Currency.GBP)
                                            .statementDescriptor(selectedBusiness.connect_service ? selectedBusiness.statement_descriptor : selectedBusiness.statement_descriptor)
                                            .applicationFee(new BigDecimal(fee))
                                            .subject(selectedBusiness.statement_description)
                                            .autoCapture(true)
                                            .build();

                                    Intent intent = mposUi.createTransactionIntent(transactionParameters);
                                    startActivityForResult(intent, Constants.PAYMENT_MPOS_CARDREADER);
                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                                ToastUtils.makeSnackToast(getActivity(), "Something went wrong!");
                            }

                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                LogUtils.e("MOTO PAYMENT ERROR");
                                LogUtils.e(anError.getErrorBody());
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> progressBarDialog.dismiss());
                                }
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                } else {
                                    ToastUtils.makeSnackToast(getActivity(), "Unknown Error");
                                }


                                if (!CommonFunctions.isConnected(getActivity()))
                                    myApp.noInternet(getActivity());
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        try {
            if (requestCode == Constants.PAYMENT_MPOS_CARDREADER) {
                boolean paymentSuccess = false;
                if (resultCode == MposUi.RESULT_CODE_APPROVED) {
                    paymentSuccess = true;
                    myApp.startPaymentSuccessSound();
                } else {
                    myApp.startPaymentFailedSound();
                }

                AnimatedConfirmationDialogFragment confirmationDialogFragment = getInstanceAnimatedConfirmation(paymentSuccess ? "Payment Approved" : "Payment Declined", null, paymentSuccess ? 1 : 2, "Okay", null);
                confirmationDialogFragment.show(getChildFragmentManager(), "paybill_confirmation");
                boolean finalPaymentSuccess = paymentSuccess;
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (finalPaymentSuccess) {
                        try {
                            Transaction transaction = MposUi.getInitializedInstance().getTransaction();
                            if (transaction != null) {
                                manageCardReaderResponse(transaction, finalPaymentSuccess);
                            } else {
                                FirebaseCrashlytics.getInstance().log("Transaction response is null: ");
                            }

                        } catch (Exception e) {
                            ToastUtils.makeLongToast(getActivity(), e.toString());
                            FirebaseCrashlytics.getInstance().log("Transaction exception: " + e.getMessage());
                            e.printStackTrace();
                        }
                    }
                });
                resetBox();
            }

            if (requestCode == Constants.PAYMENT_WEBVIEW_CARDREADER) {
                if (data != null) {

                    String status = data.getStringExtra("status");
                    if (Validators.isNullOrEmpty(status) || status.equalsIgnoreCase("0")) {
                        myApp.startPaymentFailedSound();
                        ToastUtils.makeSnackToast(getActivity(), "Transaction was declined, aborted, or failed");
                        return;
                    }

                    if (getActivity() != null) {
                        getActivity().runOnUiThread(() -> {
                            if (progressBarDialog == null)
                                progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
                            progressBarDialog.show();
                        });
                    }
                    String paymentIntentId = data.getStringExtra("payment_intent_id");
                    String client_secret = data.getStringExtra("client_secret");
                    retrivePaymentIntentAndPrint(client_secret);

                } else {

                    myApp.startPaymentFailedSound();
                    ToastUtils.makeSnackToast(getActivity(), "Transaction was declined, aborted, or failed");
                    AnimatedConfirmationDialogFragment confirmationDialogFragment = getInstanceAnimatedConfirmation("Payment Failed", "Transaction was declined, aborted, or failed", 2, "Okay", null);
                    confirmationDialogFragment.show(getChildFragmentManager(), "paybill_confirmation");
                    confirmationDialogFragment.setDialogDismissListener(o -> {

                    });
                    resetBox();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void resetBox() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {

                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void retrivePaymentIntentAndPrint(String clientSecret) {
        try {
            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                if (progressBarDialog == null) {
                    progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
                }
                progressBarDialog.show();
            });
            stripe.retrievePaymentIntent(clientSecret, new ApiResultCallback<PaymentIntent>() {
                @Override
                public void onSuccess(@NotNull PaymentIntent paymentIntent) {
                    try {
                        //com.stripe.Stripe.apiKey = stripe_private_key;
                        new Thread(() -> {
                            try {
                                //PaymentMethod paymentMethod = PaymentMethod.retrieve(paymentIntent.getPaymentMethodId());
                                PaymentMethod paymentMethod = paymentIntent.getPaymentMethod();
                                boolean paymentSuccess = paymentIntent.getStatus().toString().contains("succeeded");
                                ToastUtils.makeSnackToast(getActivity(), paymentSuccess ? "Payment Approved" : "Payment Declined");
                                if (paymentSuccess) myApp.startPaymentSuccessSound();
                                else myApp.startPaymentFailedSound();
                                if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                    manageStripeCardReaderResponse(paymentIntent, paymentMethod.card != null ? paymentMethod.card.brand.getDisplayName() : "", paymentMethod.card != null ? paymentMethod.card.last4 : "", paymentSuccess);
                                });

                            } catch (Exception e) {
                                e.printStackTrace();
                                boolean paymentSuccess = paymentIntent.getStatus().toString().contains("succeeded");
                                ToastUtils.makeSnackToast(getActivity(), paymentSuccess ? "Payment Approved" : "Payment Declined");
                                if (paymentSuccess) myApp.startPaymentSuccessSound();
                                else myApp.startPaymentFailedSound();
                                if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                    manageStripeCardReaderResponse(paymentIntent, "", "", paymentSuccess);

                                });
                            }
                            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                if (progressBarDialog == null) {
                                    progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
                                }
                                progressBarDialog.dismiss();
                            });
                        }).start();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                }

                @Override
                public void onError(@NotNull Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void retrivePaymentIntentAndPrintWithId(String clientSecret, String cardName, String number) {
        try {
            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                if (progressBarDialog == null) {
                    progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
                }
                progressBarDialog.show();
            });
            stripe.retrievePaymentIntent(clientSecret, new ApiResultCallback<PaymentIntent>() {
                @Override
                public void onSuccess(@NotNull PaymentIntent paymentIntent) {
                    try {
                        ///com.stripe.Stripe.apiKey = stripe_private_key;
                        new Thread(() -> {
                            try {
                                boolean paymentSuccess = paymentIntent.getStatus().toString().contains("succeeded");
                                ToastUtils.makeSnackToast(getActivity(), paymentSuccess ? "Payment Approved" : "Payment Declined");
                                if (paymentSuccess) myApp.startPaymentSuccessSound();
                                else myApp.startPaymentFailedSound();
                                if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                    manageStripeCardReaderResponse(paymentIntent, cardName != null ? cardName : "", number != null ? number : "", paymentSuccess);
                                });
                            } catch (Exception e) {
                                e.printStackTrace();
                                boolean paymentSuccess = paymentIntent.getStatus().toString().contains("succeeded");
                                ToastUtils.makeSnackToast(getActivity(), paymentSuccess ? "Payment Approved" : "Payment Declined");
                                if (paymentSuccess) myApp.startPaymentSuccessSound();
                                else myApp.startPaymentFailedSound();
                                if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                    manageStripeCardReaderResponse(paymentIntent, "", "", paymentSuccess);

                                });
                            }
                            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                if (progressBarDialog == null) {
                                    progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
                                }
                                progressBarDialog.dismiss();
                            });
                        }).start();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onError(@NotNull Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void manageStripeCardReaderResponse(PaymentIntent paymentIntent, String cardBrand, String cardNumber, boolean paymentSuccess) {
        try {
            if (!paymentSuccess) {
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        myApp.needToPrint = false;
                        myApp.isCashDrawerOpen = false;
                        if (progressBarDialog == null)
                            progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
                        progressBarDialog.dismiss();
                        printUsingPaymentIntent("Merchant Copy", paymentIntent, cardBrand, cardNumber, paymentSuccess);
                        return;
                    });
                }
            } else {
                getActivity().setResult(Activity.RESULT_OK, new Intent().putExtra("_order_split_id", _order_split_id));
                String transactionId = paymentIntent.getId();
                if (getActivity() != null) {
                    if (progressBarDialog == null)
                        progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
                    progressBarDialog.show();
                }
                OrderPayment orderPayment = new OrderPayment();
                orderPayment.payment_method_id = paymentMethodId;
                orderPayment.updater_id = myPreferences.getLoggedInUser().id;
                orderPayment.amount = Float.parseFloat(MyApp.df.format(payingAmount));
                orderPayment.txn_id = transactionId;
                orderPayment.mode = "Card Reader";
                orderPayment.payment_method_name = "Credit Card TT";
                orderPayment.order_id = order_id;
                orderPayment.order_split_id = order_split_id;
                orderPayment._order_split_id = _order_split_id;
                orderPayment._order_id = _order_id;
                // add unique id for find split payment
                orderPayment.unique_id = unique_id;
                if (extraAmountGratitude > 0) {
                    order.gratuity = extraAmountGratitude;
                    order.total = extraAmountGratitude + order.total;
                }
                new Thread(() -> {
                    appDatabase.orderPaymentDao().insert(orderPayment);
                    order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                    appDatabase.orderDao().update(order);
                    if (getActivity() != null) {
                        getActivity().runOnUiThread(() -> {
                            myApp.needToPrint = true;
                            myApp.isCashDrawerOpen = false;
                            progressBarDialog.dismiss();

                            AnimatedConfirmationDialogFragment confirmationDialogFragment = getInstanceAnimatedConfirmation("Payment Approved", null, 1, "Okay", null);
                            confirmationDialogFragment.show(getChildFragmentManager(), "paybill_confirmation");
                            confirmationDialogFragment.setDialogDismissListener(o -> {
                                printUsingPaymentIntent("Merchant Copy", paymentIntent, cardBrand, cardNumber, paymentSuccess);
                            });
                        });
                    }
                }).start();
            }
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    /**
     * Print for Bluetooth BBPOS Card reader & Internet Cardreader
     */
    private void printUsingPaymentIntent(String title, PaymentIntent paymentIntent, String cardBrand, String cardNumber, boolean paymentSuccess) {

        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressBarDialog.dismiss());
            }

            String payment_type = "PIN";
            if (ticketHeader != null) header = ticketHeader.value;
            if (address != null) resAddress = address.value;

            actualAmount = "£" + MyApp.df.format(payingAmount);
            grand_total = "£" + MyApp.df.format(payingAmount);

            card = "Card                    " + cardBrand;
            account = "Account      " + cardNumber;
            stripe_id = "TID  " + paymentIntent.getId();
            entry_mode = "Entry Mode         " + payment_type;
            status = "Status            " + (paymentSuccess ? "Approved" : "Declined");
            please = "Please Retain Receipt\nFor Your Record";

            date_final = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy hh:mm:ss a");

            main_content = card + "\n" + account + "\n" + stripe_id + "\n" + entry_mode + "\n" + status + "\n";

            footerA = "";
            footerB = "";

            if (footerASetting != null) {
                footerA = footerASetting.value;
            }
            if (footerBSetting != null)
                footerB = footerBSetting.value;

            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                    printCardReaderZonrich("Merchant Copy");
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("t2") || defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                    printCardReaderSunmi("Merchant Copy");
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    //   printCardReaderWifi("Merchant Copy");
                    if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                        printCardReaderIMin("Merchant Copy");
                    } else {
                        if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                            printCardReaderWifi("Merchant Copy");
                        } else {
                            try {
                                if (bluetoothPrinter != null) {
                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                    if (device != null) {
                                        printCardReaderBT("Merchant Copy");
                                    } else {
                                        ToastUtils.makeLongToast(getActivity(), "No bluetooth device found.");
                                        goBack();
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            } else {
                ToastUtils.makeLongToast(getActivity(), "No printer model found");
                goBack();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void manageCardReaderResponse(Transaction transaction, boolean paymentSuccess) {
        try {
            getActivity().setResult(Activity.RESULT_OK, new Intent().putExtra("_order_split_id", _order_split_id));
            if (!paymentSuccess) {
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        myApp.needToPrint = false;
                        myApp.isCashDrawerOpen = false;
                        if (progressBarDialog == null)
                            progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
                        progressBarDialog.dismiss();
                        createCardReaderPrint(transaction, paymentSuccess);
                        return;
                    });
                }
            } else {
                String transactionId = transaction.getIdentifier();
                if (getActivity() != null) {
                    if (progressBarDialog == null)
                        progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
                    progressBarDialog.show();
                }
                OrderPayment orderPayment = new OrderPayment();
                orderPayment.payment_method_id = paymentMethodId;
                orderPayment.updater_id = myPreferences.getLoggedInUser().id;
                orderPayment.amount = Float.parseFloat(MyApp.df.format(payingAmount));
                orderPayment.txn_id = transactionId;
                orderPayment.mode = "Card Reader";
                orderPayment.payment_method_name = "Credit Card TT";
                orderPayment.order_id = order_id;
                orderPayment.order_split_id = order_split_id;
                orderPayment._order_split_id = _order_split_id;
                // add unique id for find split payment
                orderPayment.unique_id = unique_id;
                orderPayment._order_id = _order_id;
                new Thread(() -> {
                    appDatabase.orderPaymentDao().insert(orderPayment);
                    order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                    appDatabase.orderDao().update(order);
                    if (getActivity() != null) {
                        getActivity().runOnUiThread(() -> {
                            myApp.needToPrint = true;
                            myApp.isCashDrawerOpen = false;
                            progressBarDialog.dismiss();
                            createCardReaderPrint(transaction, paymentSuccess);
                            //                    if (getActivity() != null) goBack();
                        });
                    }
                }).start();
            }
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    String title;
    String header = "", resAddress = "";
    String amount;
    String card_____;
    String account__;
    String stripe_id;
    String entry_mod;
    String status___;
    String please;
    String date_final;
    String footerA;
    String footerB;
    String main_content;
    String print_amount, print_card = "", print_card_number = "", print_stripe_id, print_payment_mode, print_status;

    String payment_type;

    String actualAmount;
    String grand_total;
    String card;
    String account;

    String entry_mode;
    String status;

    private void createCardReaderPrint(Transaction transaction, boolean paymentSuccess) {
        try {
            payment_type = "" + transaction.getPaymentDetails().getCustomerVerification().name();
            if (payment_type.equals("PIN")) {
                payment_type = "EMV";
            } else {
                payment_type = "Contactless";
            }

            if (ticketHeader != null) header = ticketHeader.value;
            if (address != null) resAddress = address.value;

            actualAmount = "£" + MyApp.df.format(payingAmount);

            grand_total = "£" + MyApp.df.format(payingAmount);

            card = "Card                    " + transaction.getPaymentDetails().getScheme().name();
            account = "Account      " + transaction.getPaymentDetails().getMaskedAccountNumber();
            stripe_id = "TID  " + transaction.getIdentifier();
            entry_mode = "Entry Mode         " + payment_type;
            status = "Status            " + (paymentSuccess ? "Approved" : "Declined");
            please = "Please Retain Receipt\nFor Your Record";

            date_final = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy hh:mm:ss a");

            main_content = card + "\n" + account + "\n" + stripe_id + "\n" + entry_mode + "\n" + status + "\n";
            footerA = "";
            footerB = "";

            if (footerASetting != null) footerA = footerASetting.value;

            if (footerBSetting != null) footerB = footerBSetting.value;

            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                    printCardReaderZonrich("Merchant Copy");
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("t2") || defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                    printCardReaderSunmi("Merchant Copy");
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {

                    // printCardReaderWifi("Merchant Copy");
                    if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                        printCardReaderIMin("Merchant Copy");
                    } else {
                        if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                            printCardReaderWifi("Merchant Copy");
                        } else {
                            try {
                                if (bluetoothPrinter != null) {
                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                    if (device != null) {
                                        printCardReaderBT("Merchant Copy");
                                    } else {
                                        ToastUtils.makeLongToast(getActivity(), "No bluetooth device found.");
                                        goBack();
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            } else {
                ToastUtils.makeLongToast(getActivity(), "No printer model found");
                goBack();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printCardReaderIMin(String title) {
        try {
            myApp.iMinPrinterUtils.printCardReaderReceipt(myApp.tiffintomLogoSmall, "", title, selectedBusiness.header_a, selectedBusiness.header_b, "", actualAmount, null, grand_total, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b);

            if (title.toLowerCase().contains("merchant")) {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Is Customer Copy required?", null, 0, "Confirm", "Cancel");
                confirmationDialogFragment.show(getChildFragmentManager(), "printer");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        if (((String) o).equalsIgnoreCase("confirm")) {
                            printCardReaderIMin("Customer Copy");
                        } else {
                            goBack();
                        }
                    } else {
                        goBack();
                    }
                });

            } else {
                goBack();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printCardReaderZonrich(String title) {
        try {
            zoneRichPrinter.connectPrinter(defaultPrinter.ip);
            if (title.toLowerCase().contains("merchant")) {
                if (selectedBusiness.auto_merchant_print != null && (selectedBusiness.auto_merchant_print.equalsIgnoreCase("true") || selectedBusiness.auto_merchant_print.equalsIgnoreCase("1"))) {
                    zoneRichPrinter.printCardReaderReceipt(myApp.businessLogo, "", title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, null, grand_total, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, myApp.myPreferences);
                    printMerchantCopy(title);
                } else {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Is Merchant Copy required?", null, 0, "Confirm", "Cancel");
                    confirmationDialogFragment.show(getChildFragmentManager(), "printer");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                zoneRichPrinter.printCardReaderReceipt(myApp.businessLogo, "", title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, null, grand_total, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, myApp.myPreferences);
                            } else {
                                goBack();
                            }
                            printMerchantCopy(title);
                        } else {
                            goBack();
                        }
                    });
                }
            } else {
                zoneRichPrinter.printCardReaderReceipt(myApp.businessLogo, "", title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, null, grand_total, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, myApp.myPreferences);
                goBack();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printMerchantCopy(String title) {
        if (title.toLowerCase().contains("merchant")) {
            if (selectedBusiness.auto_customer_print != null && (selectedBusiness.auto_customer_print.equalsIgnoreCase("true") || selectedBusiness.auto_customer_print.equalsIgnoreCase("1"))) {
                printCardReaderZonrich("Customer Copy");
            } else {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Is Customer Copy required?", null, 0, "Confirm", "Cancel");
                confirmationDialogFragment.show(getChildFragmentManager(), "printer");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        if (((String) o).equalsIgnoreCase("confirm")) {
                            printCardReaderZonrich("Customer Copy");
                        } else {
                            goBack();
                        }
                    } else {
                        goBack();
                    }
                });
            }
        } else {
            goBack();
        }
    }

    private void printCardReaderSunmi(String title) {
        try {
            if (title.toLowerCase().contains("merchant")) {
                if (selectedBusiness.auto_merchant_print != null && (selectedBusiness.auto_merchant_print.equalsIgnoreCase("true") || selectedBusiness.auto_merchant_print.equalsIgnoreCase("1"))) {
                    if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                        sunmiPrinterV3Mix.printCardReaderReceipt(myApp.businessLogo, "", title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, null, grand_total, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, myApp.myPreferences);
                    }else {
                        sunmiPrinter.printCardReaderReceipt(myApp.businessLogo, "", title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, null, grand_total, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, myApp.myPreferences);
                    }
                    printMerchantSunmiCopy(title);
                } else {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Is Merchant Copy required?", null, 0, "Confirm", "Cancel");
                    confirmationDialogFragment.show(getChildFragmentManager(), "printer");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                                    sunmiPrinterV3Mix.printCardReaderReceipt(myApp.businessLogo, "", title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, null, grand_total, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, myApp.myPreferences);
                                }else {
                                    sunmiPrinter.printCardReaderReceipt(myApp.businessLogo, "", title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, null, grand_total, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, myApp.myPreferences);
                                }
                            } else {
                                goBack();
                            }
                            printMerchantSunmiCopy(title);
                        } else {
                            goBack();
                        }
                    });
                }
            } else {
                if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                    sunmiPrinterV3Mix.printCardReaderReceipt(myApp.businessLogo, "", title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, null, grand_total, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, myApp.myPreferences);
                }else {
                    sunmiPrinter.printCardReaderReceipt(myApp.businessLogo, "", title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, null, grand_total, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, myApp.myPreferences);
                }
                goBack();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printMerchantSunmiCopy(String title) {
        if (title.toLowerCase().contains("merchant")) {
            if (selectedBusiness.auto_customer_print != null && (selectedBusiness.auto_customer_print.equalsIgnoreCase("true") || selectedBusiness.auto_customer_print.equalsIgnoreCase("1"))) {
                printCardReaderSunmi("Customer Copy");
            } else {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Is Customer Copy required?", null, 0, "Confirm", "Cancel");
                confirmationDialogFragment.show(getChildFragmentManager(), "printer");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        if (((String) o).equalsIgnoreCase("confirm")) {
                            printCardReaderSunmi("Customer Copy");
                        } else {
                            goBack();
                        }
                    } else {
                        goBack();
                    }
                });

            }
        } else {
            goBack();
        }
    }

    private void printCardReaderWifi(String title) {
        try {
            wifiPrinter.connect(defaultPrinter.ip);
            try {
                Thread.sleep(100);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            //wifiPrinter.printCardReaderReceipt(myApp.businessLogo,"", title, header, headerAlignment, actualAmount, null, grand_total, main_content, please, date_final, footerA, footerB, false, myPreferences);
            wifiPrinter.printCardReaderReceipt(myApp.businessLogo, "", title, selectedBusiness.header_a, headerAlignment, selectedBusiness.header_b, actualAmount, null, grand_total, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, false, myPreferences);

            if (title.toLowerCase().contains("merchant")) {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Is Customer Copy required?", null, 0, "Confirm", "Cancel");
                confirmationDialogFragment.show(getChildFragmentManager(), "printer");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        if (((String) o).equalsIgnoreCase("confirm")) {
                            printCardReaderWifi("Customer Copy");
                        } else {
                            goBack();
                        }
                    } else {
                        goBack();
                    }
                });
            } else {
                goBack();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printCardReaderBT(String title) {
        try {
            try {
                Thread.sleep(100);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            //bluetoothPrinter.printCardReaderReceipt(myApp.businessLogo, title, header, headerAlignment, actualAmount, null, grand_total, main_content, please, date_final, footerA, footerB, false);
            bluetoothPrinter.printCardReaderReceipt(myApp.businessLogo, title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, null, grand_total, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, false);

            if (title.toLowerCase().contains("merchant")) {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Is Customer Copy required?", null, 0, "Confirm", "Cancel");
                confirmationDialogFragment.show(getChildFragmentManager(), "printer");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        if (((String) o).equalsIgnoreCase("confirm")) {
                            printCardReaderBT("Customer Copy");
                        } else {
                            goBack();
                        }
                    } else {
                        goBack();
                    }
                });
            } else {
                goBack();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchOffline() {
        try {
            new FetchOrderOfflineAsyncTask(() -> {
                updateViews();
                return null;
            }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class FetchOrderOfflineAsyncTask extends AsyncTask<Object, Object, Object> {
        Callable<Void> nextMethod;

        public FetchOrderOfflineAsyncTask(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected Object doInBackground(Object... objects) {
            OrderWithItems orderWithItems = myApp.appDatabase.orderDao().orderWithItems(_order_id);
            if (orderWithItems != null) {
                order = orderWithItems.order;
                if (_order_split_id > 0) {
                    OrderSplit orderSplit = appDatabase.orderSplitDao().view(_order_split_id);
                    // add unique id for find split payment
                    unique_id = orderSplit.unique_id;
                    paidAmount = appDatabase.orderPaymentDao().getSplitTotalPaidAmount(_order_id, _order_split_id);
                    remainingBalance = orderSplit.total - paidAmount;
                } else {
                    paidAmount = order.total_paid;
                    remainingBalance = order.total - paidAmount;
                }
                if (order.service_charge == 0) {
                    if (serviceChargeEnabled) {
                        if (serviceChargeAutoMode && !order.is_auto_service_charge_remove) {
                            float serviceChargeValue = Float.parseFloat(serviceChargeSetting.value);
                            if (serviceChargeTypeSetting.value.equalsIgnoreCase("flat")) {
                                cartServiceCharge = serviceChargeValue;
                            } else {
                                if (serviceChargeValue > 0) {
                                    cartServiceCharge = cartSubTotal * serviceChargeValue / 100;
                                } else {
                                    cartServiceCharge = 0;
                                }
                            }
                        }
                    } else {
                        cartServiceCharge = 0;
                    }
                } else {
                    cartServiceCharge = order.service_charge;
                }
                if (order.split_type != null && order.split_type.equalsIgnoreCase("order_item")) {
                    cartServiceCharge = 0;
                    serviceChargeEnabled = false;
                    discountEnabled = false;
                    gratuityEnabled = false;
                }
            }
            return null;
        }

        @Override
        protected void onPostExecute(Object s) {
            super.onPostExecute(s);
            if (order != null)
                if (nextMethod != null) {
                    try {
                        nextMethod.call();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
        }
    }


    private void goBack() {
        if (getActivity() != null) {
            getActivity().runOnUiThread(() -> {
                Log.e("printMotoReceipt", "goBack ");
                getActivity().finish();
            });
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance(getActivity()).registerReceiver(eposOrderUpdateReceiver, new IntentFilter(Constants.EPOS_ORDER_UPDATE));
    }

    @Override
    public void onStop() {
        super.onStop();
        if (eposOrderUpdateReceiver != null)
            LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(eposOrderUpdateReceiver);
    }

    BroadcastReceiver eposOrderUpdateReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getBooleanExtra("refresh", false)) {
//                if (intent.hasExtra("_order_split_id")) {
//                    _order_split_id = intent.getIntExtra("_order_split_id", 0);
//                    getArguments().putInt("_order_split_id", _order_split_id);
//                }
                fetchOffline();
            }
        }
    };

    public AnimatedConfirmationDialogFragment getInstanceAnimatedConfirmation(String title, String info, int type, String positiveButton, String negativeButton) {
        AnimatedConfirmationDialogFragment rejectReasonDialog = new AnimatedConfirmationDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("title", title);
        bundle.putString("info", info);
        bundle.putString("positive_button", positiveButton);
        bundle.putString("negative_button", negativeButton);
        bundle.putInt("type", type);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }
}
