package com.ubsidi.epos_2021.fragment;

import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.ProductAddonAdapter;
import com.ubsidi.epos_2021.adapters.ProductAddonAdapterOldDesign;
import com.ubsidi.epos_2021.adapters.ProductIngredientsAdapter;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.MoneyTextWatcher;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.models.Addon;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;
import com.ubsidi.epos_2021.models.Product;
import com.ubsidi.epos_2021.models.ProductAddon;
import com.ubsidi.epos_2021.models.ProductIngredient;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;

import java.io.File;
import java.util.ArrayList;

/**
 * Created by Amrish on 06-05-2021.
 */
public class CartProductEditDialogFragmentOldDesign extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyRightDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.MATCH_PARENT);
        getDialog().getWindow().setGravity(Gravity.END);
    }

    private DialogDismissListener dialogDismissListener;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    private Chip chipBack;
    private LinearLayout llLoading, llInstructions, llIngredientsView, llAddonsView, llIngredientsSelect, llAddonsSelect;
    private TextView tvMessage, tvIngredientsSelect, tvAddonsSelect;
    private View vIngredientsSelect, vAddonsSelect;

    private OrderItem orderItem, originalItem;
    private String orderTypeId;

    private ImageView ivProduct;
    private TextView tvProductName, tvPrice, tvQuantityModified;
    private ImageView ivMinusModify, ivPlusModify;

    private MaterialButton btnConfirm, btnCancel;

    private RecyclerView rvProductIngredients, rvProductAddons;
    private ArrayList<ProductIngredient> productIngredients = new ArrayList<>();
    private ArrayList<ProductAddon> productAddons = new ArrayList<>();
    private ArrayList<OrderItemAddon> orderItemAddons = new ArrayList<>();
    private ArrayList<OrderItemIngredient> orderItemIngredients = new ArrayList<>();
    private ArrayList<OrderItem> toBeSavedOrderItems = new ArrayList<>();
    private ProductIngredientsAdapter productIngredientsAdapter;
    private ProductAddonAdapterOldDesign productAddonAdapter;

    private MaterialCardView cvAddSpecialInstruction;
    private EditText etSpecialInstruction, etSpecialInstructionPrice;
    private MaterialButton btnRemoveInstructions, btnConfirmInstructions;

    private Product product;
    private MyApp myApp = MyApp.getInstance();
    public AppDatabase appDatabase = myApp.appDatabase;

    private int modifiedQuantity = 1;
    private boolean addonsViewSelected = true;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_cart_product_edit_old_design, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            if (getArguments() != null) {
                orderItem = new Gson().fromJson(getArguments().getString("order_item"), OrderItem.class);
                originalItem = new Gson().fromJson(getArguments().getString("order_item"), OrderItem.class);
                orderTypeId = getArguments().getString("order_type_id");
            }
            initViews(view);
            setListeners();
            updateViews();
            new ProductDetailsAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        } catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
    }


    private void initViews(View view) {
        try {
            chipBack = view.findViewById(R.id.chipBack);

            llLoading = view.findViewById(R.id.llLoading);
            tvMessage = view.findViewById(R.id.tvMessage);

            llIngredientsSelect = view.findViewById(R.id.llIngredientsSelect);
            tvIngredientsSelect = view.findViewById(R.id.tvIngredientsSelect);
            vIngredientsSelect = view.findViewById(R.id.vIngredientsSelect);

            llAddonsSelect = view.findViewById(R.id.llAddonsSelect);
            tvAddonsSelect = view.findViewById(R.id.tvAddonsSelect);
            vAddonsSelect = view.findViewById(R.id.vAddonsSelect);

            tvProductName = view.findViewById(R.id.tvProductName);
            tvPrice = view.findViewById(R.id.tvPrice);
            ivProduct = view.findViewById(R.id.ivProduct);


            tvQuantityModified = view.findViewById(R.id.tvModifiedQuantity);
            ivPlusModify = view.findViewById(R.id.ivPlusModified);
            ivMinusModify = view.findViewById(R.id.ivMinusModified);

            etSpecialInstruction = view.findViewById(R.id.etSpecialInstruction);
            etSpecialInstructionPrice = view.findViewById(R.id.etSpecialInstructionPrice);
            cvAddSpecialInstruction = view.findViewById(R.id.cvAddSpecialInstruction);
            llInstructions = view.findViewById(R.id.llInstructions);
            btnRemoveInstructions = view.findViewById(R.id.btnRemoveInstruction);
            btnConfirmInstructions = view.findViewById(R.id.btnConfirmInstruction);

            llIngredientsView = view.findViewById(R.id.llIngredientsView);
            llAddonsView = view.findViewById(R.id.llAddonsView);

            rvProductIngredients = view.findViewById(R.id.rvProductIngredients);
            rvProductAddons = view.findViewById(R.id.rvProductAddons);

            btnCancel = view.findViewById(R.id.btnCancel);
            btnConfirm = view.findViewById(R.id.btnConfirm);


            productIngredientsAdapter = new ProductIngredientsAdapter(productIngredients, (position, data) -> {
                ProductIngredient productIngredient = (ProductIngredient) data;

            }, (position, data) -> {
                ProductIngredient productIngredient = (ProductIngredient) data;

            });
            rvProductIngredients.setLayoutManager(new GridLayoutManager(getActivity(), 3));
            rvProductIngredients.setAdapter(productIngredientsAdapter);

            productAddonAdapter = new ProductAddonAdapterOldDesign(getActivity(), productAddons, orderTypeId, (position, data) -> {

            }, (position, data) -> {
                //Sub Addon Clicked
            });
            rvProductAddons.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
            rvProductAddons.setAdapter(productAddonAdapter);

            tvMessage.setVisibility(View.GONE);
            llInstructions.setVisibility(View.GONE);
            cvAddSpecialInstruction.setVisibility(View.GONE);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void updateViews() {
        try {
            if (orderItem != null) {
                tvProductName.setText(orderItem.product_name);
                tvPrice.setText(MyApp.currencySymbol + MyApp.df.format(orderItem.price));
                etSpecialInstruction.setText(orderItem.special_instruction);
                etSpecialInstruction.setSelection(etSpecialInstruction.getText().toString().length());
                etSpecialInstructionPrice.setText(MyApp.df.format(orderItem.instruction_price));
                if (!Validators.isNullOrEmpty(etSpecialInstruction.getText().toString())) {
                    llInstructions.setVisibility(View.VISIBLE);
                    btnRemoveInstructions.setVisibility(View.VISIBLE);
                    cvAddSpecialInstruction.setVisibility(View.GONE);
                } else {
                    btnRemoveInstructions.setVisibility(View.GONE);
                    cvAddSpecialInstruction.setVisibility(View.VISIBLE);
                    llInstructions.setVisibility(View.GONE);
                }
                btnConfirmInstructions.setVisibility(View.GONE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void setListeners() {
        try {
            etSpecialInstructionPrice.addTextChangedListener(new MoneyTextWatcher(etSpecialInstructionPrice));

            llIngredientsSelect.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    try {
                        addonsViewSelected = false;
                        changeColors(llIngredientsSelect);
                        llAddonsView.setVisibility(View.GONE);
                        if (productIngredients.size() == 0) {
                            showError("There are no ingredients available for\n selected product to modify");
                            llIngredientsView.setVisibility(View.GONE);
                        } else {
                            llIngredientsView.setVisibility(View.VISIBLE);
                            llLoading.setVisibility(View.GONE);
                        }
                    } catch (Exception e) {
                    }
                }
            });

            llAddonsSelect.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    try {
                        addonsViewSelected = true;
                        changeColors(llAddonsSelect);
                        llIngredientsView.setVisibility(View.GONE);
                        if (productAddons.size() == 0) {
                            llAddonsView.setVisibility(View.GONE);
                            showError("There are no options available for\n selected product to apply");
                        } else {
                            llLoading.setVisibility(View.GONE);
                            llAddonsView.setVisibility(View.VISIBLE);
                        }
                    } catch (Exception e) {
                    }
                }
            });

            cvAddSpecialInstruction.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    try {
                        llInstructions.setVisibility(View.VISIBLE);
                        cvAddSpecialInstruction.setVisibility(View.GONE);
                        etSpecialInstruction.requestFocus();
                        etSpecialInstruction.setSelection(etSpecialInstruction.getText().toString().length());
                        if (Validators.isNullOrEmpty(orderItem.special_instruction)) {
                            btnConfirmInstructions.setVisibility(View.GONE);
                            btnRemoveInstructions.setVisibility(View.GONE);
                        } else {
                            btnRemoveInstructions.setVisibility(View.VISIBLE);
                            btnConfirmInstructions.setVisibility(View.GONE);
                        }
                    } catch (Exception e) {

                    }
                }
            });

            etSpecialInstruction.setOnKeyListener((textView, i, keyEvent) -> {
                try {
                    if ((keyEvent.getKeyCode() == KeyEvent.KEYCODE_ENTER)) {
                        CommonFunctions.hideKeyboard(getActivity(), etSpecialInstruction);
                        btnConfirmInstructions.performClick();
                    }
                } catch (Exception e) {
                }
                return false;
            });


            btnConfirmInstructions.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    try {
                        if (!Validators.isNullOrEmpty(etSpecialInstruction.getText().toString())) {
                            orderItem.special_instruction = etSpecialInstruction.getText().toString();
                            if (Validators.isNullOrEmpty(etSpecialInstructionPrice.getText().toString())) {
                                orderItem.instruction_price = 0;
                            } else {
                                orderItem.instruction_price = Float.parseFloat(etSpecialInstruction.getText().toString());
                            }
                        }
                        updateViews();
                    } catch (Exception e) {
                    }
                }
            });

            btnRemoveInstructions.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    try {
                        CommonFunctions.hideKeyboard(getActivity(), etSpecialInstruction);
                        etSpecialInstruction.setText(null);
                        etSpecialInstructionPrice.setText("0.00");
                        llInstructions.setVisibility(View.GONE);
                        cvAddSpecialInstruction.setVisibility(View.VISIBLE);
                        orderItem.special_instruction = null;
                        orderItem.instruction_price = 0;
                    } catch (Exception e) {
                    }
                }
            });

            ivPlusModify.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    try {
                        if (modifiedQuantity < orderItem.quantity) {
                            modifiedQuantity++;
                        }
                        tvQuantityModified.setText("" + modifiedQuantity);
                    } catch (Exception e) {
                    }
                }
            });

            ivMinusModify.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    try {
                        if (modifiedQuantity > 1) {
                            modifiedQuantity--;
                        }
                        tvQuantityModified.setText("" + modifiedQuantity);
                    } catch (Exception e) {
                    }
                }
            });

            btnConfirm.setOnClickListener(v -> {
                try {
                    hideKeyBoard();
                    if (validateItems()) {
                        saveOrderItem();
                    }
                } catch (Exception e) {
                }
            });

            btnCancel.setOnClickListener(v -> {
                try {
                    hideKeyBoard();
                    if (getActivity() != null) if (dialogDismissListener != null) {
                        dialogDismissListener.onDialogDismiss("dismiss");
                    }
                } catch (Exception e) {
                }
            });
            chipBack.setOnClickListener(v -> {
                hideKeyBoard();
                dismiss();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void hideKeyBoard() {
        CommonFunctions.hideKeyboard(getActivity(), etSpecialInstruction);
        CommonFunctions.hideKeyboard(getActivity(), etSpecialInstructionPrice);
    }


    private boolean validateItems() {
        // First validate addons
        try {
            boolean itemModified = true;
            if (originalItem.quantity == modifiedQuantity) {
                itemModified = false;
            }
            ArrayList<OrderItem> localSavingOrderItems = new ArrayList<>();
            if (itemModified) {
                // order update sent copy issue solved decrease quantity by modified quantity
                originalItem.sent_to_kitchen_quantity = originalItem.quantity - modifiedQuantity;
                originalItem.quantity = originalItem.quantity - modifiedQuantity;
                originalItem.sub_total = (originalItem.quantity * originalItem.price);
                originalItem.addons_price = getAddonPrice(originalItem);
                originalItem.ingredients_price = getIngredientPrice(originalItem);
                originalItem.total = originalItem.sub_total + (originalItem.addons_price * originalItem.quantity) + (originalItem.ingredients_price * originalItem.quantity) + (originalItem.instruction_price * originalItem.quantity);
                originalItem.updater_id = myApp.myPreferences.getLoggedInUser().id;
                localSavingOrderItems.add(originalItem);
            }

            int position = -1;
            ArrayList<OrderItemAddon> allSelectedAddons = new ArrayList<>();
            for (ProductAddon productAddon : productAddons) {
                position++;
                if (productAddon.selectedQuantity == 0 && productAddon.min_quantity == 0) continue;
                if (productAddon.selectedQuantity >= productAddon.min_quantity && productAddon.selectedQuantity <= productAddon.max_quantity) {
                    OrderItemAddon orderItemAddon = new OrderItemAddon();
                    orderItemAddon.addon_id = productAddon.addon.id;
                    orderItemAddon.addon_name = productAddon.addon.name;
                    orderItemAddon.price = productAddon.addon.selected_price;
                    orderItemAddon.updater_id = MyApp.getInstance().myPreferences.getLoggedInUser().id;
                    orderItemAddon.quantity = 1;
                    orderItemAddon.total = orderItemAddon.price * orderItemAddon.quantity;

                    allSelectedAddons.add(orderItemAddon);
                    allSelectedAddons.addAll(productAddon.selectedOrderItemAddon);
                } else {

                    productAddonAdapter.expandedPosition = position;
                    String message = "";
                    if (productAddon.addon != null)
                        message = "Please select " + productAddon.addon.name;
                    else message = "Please select addon";
                    productAddonAdapter.notifyDataSetChanged();
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Addon required", message, 2, "Okay", null);
                    confirmationDialogFragment.show(getChildFragmentManager(), "action");
                    return false;
                }

            }
            ArrayList<OrderItemIngredient> allSelectedIngredients = new ArrayList<>();
            for (ProductIngredient productIngredient : productIngredients) {
                if (productIngredient.quantity > 0) {
                    OrderItemIngredient oitIngredient = new OrderItemIngredient();
                    oitIngredient.product_ingredient_id = productIngredient.id;
                    oitIngredient.order_id = orderItem.order_id;
                    oitIngredient.updater_id = myApp.myPreferences.getLoggedInUser().id;
                    oitIngredient.ingredient_id = productIngredient.ingredient_id;
                    oitIngredient.ingredient_name = productIngredient.ingredient_name;
                    oitIngredient.quantity = productIngredient.quantity;
                    if (productIngredient.isAlreadyRemoved) {
                        oitIngredient.without = true;
                        oitIngredient.with = false;
                        oitIngredient.price = productIngredient.price_without;
                        oitIngredient.total = oitIngredient.price * oitIngredient.quantity;
                    } else {
                        oitIngredient.without = false;
                        oitIngredient.with = true;
                        oitIngredient.price = productIngredient.price;
                        oitIngredient.total = oitIngredient.price * oitIngredient.quantity;
                    }
                    allSelectedIngredients.add(oitIngredient);
                }

            }

            if (itemModified) {
                orderItem._id = 0;
                orderItem.id = null;
            }
            if (product != null) {
                orderItem.product_name = product.name;
                orderItem.product_id = product.id;
                if (!orderItem.misc)
                    orderItem.price = MyApp.calculatedProductPrice(orderTypeId, product);
            }
            orderItem.quantity = modifiedQuantity;
            // order update sent copy issue solved decrease quantity by modified quantity
            orderItem.sent_to_kitchen_quantity = modifiedQuantity;
            if (!Validators.isNullOrEmpty(etSpecialInstructionPrice.getText().toString())) {
                orderItem.instruction_price = Float.parseFloat(etSpecialInstructionPrice.getText().toString());
            } else {
                orderItem.instruction_price = 0;
            }
            orderItem.special_instruction = etSpecialInstruction.getText().toString();

            orderItem.sub_total = (orderItem.quantity * orderItem.price);
            orderItem.order_item_addons = allSelectedAddons;
            orderItem.addons_price = getAddonPrice(orderItem);
            orderItem.order_item_ingredients = allSelectedIngredients;
            orderItem.ingredients_price = getIngredientPrice(orderItem);
            orderItem.total = orderItem.sub_total + (orderItem.addons_price * orderItem.quantity) + (orderItem.ingredients_price * orderItem.quantity) + (orderItem.instruction_price * orderItem.quantity);
            orderItem.updater_id = myApp.myPreferences.getLoggedInUser().id;
            localSavingOrderItems.add(orderItem);

            toBeSavedOrderItems.clear();
            toBeSavedOrderItems.addAll(localSavingOrderItems);
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }

        return true;
    }

    private void saveOrderItem() {
        new SaveOrderItemAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
    }

    private class SaveOrderItemAsync extends AsyncTask<OrderItem, String, String> {

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected String doInBackground(OrderItem... orderItems) {
            try {
                for (OrderItem oit : toBeSavedOrderItems) {
                    oit.created_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                    oit._id = (int) appDatabase.orderItemDao().insert(oit);
                    appDatabase.orderItemAddonDao().deleteAll(oit._id);
                    appDatabase.orderItemIngredientDao().deleteAll(oit._id);


                    float addonTotal = 0;
                    try {
                        if (oit.order_item_addons != null) {
                            for (OrderItemAddon itemAddon : oit.order_item_addons) {
                                itemAddon._id = 0;
                                itemAddon.id = null;
                                itemAddon._order_item_id = oit._id;
                                itemAddon.total = itemAddon.quantity * itemAddon.price;
                                addonTotal = Float.valueOf(addonTotal + itemAddon.total);
                            }
                            appDatabase.orderItemAddonDao().insertAll(oit.order_item_addons);
                        }
                    } catch (Exception e) {
                    }

                    float ingredientTotal = 0;
                    if (oit.order_item_ingredients != null) {
                        for (OrderItemIngredient itemIngredient : oit.order_item_ingredients) {
                            itemIngredient._id = 0;
                            itemIngredient.id = null;
                            itemIngredient._order_item_id = oit._id;
                            itemIngredient.total = itemIngredient.quantity * itemIngredient.price;
                            ingredientTotal = ingredientTotal + itemIngredient.total;
                        }
                        appDatabase.orderItemIngredientDao().insertAll(oit.order_item_ingredients);
                    }
                }
                // update total of split group when addon add
                if (originalItem._order_split_id > 0) {
                    appDatabase.orderSplitDao().updateTotalAmount(originalItem._order_id, originalItem._order_split_id);
                }
                // Update Totals
                Order dbOrder = appDatabase.orderDao().view(originalItem._order_id);
                dbOrder.sub_total = myApp.appDatabase.orderDao().getItemSubTotal(originalItem._order_id);
                dbOrder.total = dbOrder.sub_total + dbOrder.delivery_charge + dbOrder.service_charge + dbOrder.gratuity - dbOrder.discount;
                dbOrder.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                appDatabase.orderDao().update(dbOrder);
            } catch (Exception e) {
                e.printStackTrace();
            }

            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                myApp.notifyCart(getActivity(), new Intent(Constants.EPOS_ORDER_UPDATE).putExtra("_order_id", originalItem._order_id).putExtra("result", true).putExtra("ingredients", true));
                dismiss();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }


    private void showError(String s) {
        try {
            llLoading.setVisibility(View.VISIBLE);
            tvMessage.setVisibility(View.VISIBLE);
            tvMessage.setText(s);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeColors(View v) {
        try {
            vIngredientsSelect.setBackgroundResource(R.color.light_gray);
            tvIngredientsSelect.setAlpha(0.5f);

            vAddonsSelect.setBackgroundResource(R.color.light_gray);
            tvAddonsSelect.setAlpha(0.5f);

            if (v == llIngredientsSelect) {
                vIngredientsSelect.setBackgroundResource(R.color.persian_green);
                tvIngredientsSelect.setAlpha(1f);
            }
            if (v == llAddonsSelect) {
                vAddonsSelect.setBackgroundResource(R.color.persian_green);
                tvAddonsSelect.setAlpha(1f);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ProductDetailsAsync extends AsyncTask<String, String, String> {
        private ArrayList<ProductAddon> localAddons = new ArrayList<>();
        private ArrayList<ProductIngredient> localIngredients = new ArrayList<>();

        @Override
        protected String doInBackground(String... strings) {
            try {
                if (orderItem._id > 0) {
                    orderItem = appDatabase.orderItemDao().view(orderItem._id);
                }

                try {
                    if (Validators.isNullOrEmpty(orderItem.product_id)) {
                        product = new Product();
                        product.name = orderItem.product_name;
                        product.misc = true;
                        product.delivery_price = orderItem.delivery_price;
                        product.waiting_price = orderItem.waiting_price;
                        product.web_price = orderItem.web_price;
                        product.selected_price = orderItem.price;
                        product.takeaway_price = orderItem.takeaway_price;
                    } else {
                        product = appDatabase.productDao().view(orderItem.product_id);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

                if (product == null) return null;
                localAddons.addAll(appDatabase.productAddonDao().getProductParentAddon(product.id));
                localIngredients.addAll(appDatabase.productIngredientDao().listByProduct(product.id));

                for (ProductAddon productAddon : localAddons) {
                    int selectedAddonQuantity = 0;
                    productAddon.isExpended = (productAddon.min_quantity > 0);
                    productAddon.addon = appDatabase.addonDao().view(productAddon.addon_id);
                    productAddon.addon.children = new ArrayList<>();
                    productAddon.addon.children.addAll(appDatabase.addonDao().list(productAddon.addon.id));
                    if (orderItem._id > 0) {
                        OrderItemAddon dbAddon = appDatabase.orderItemAddonDao().find(orderItem._id, productAddon.addon_id);
                        if (dbAddon != null) {
                            productAddon.addon.selected = true;
                            //                    productAddon.selectedOrderItemAddon.add(dbAddon);
                        }
                    }

                    if (productAddon.addon.children != null && productAddon.addon.children.size() > 0) {
                        for (Addon addonL1 : productAddon.addon.children) {
                            Object isContain = appDatabase.productAddonDao().getContainChildAddon(product.id,productAddon.id,addonL1.id);
                            addonL1.contain = isContain != null && (boolean) isContain;
                            if (orderItem._id > 0) {
                                OrderItemAddon dbAddonL1 = appDatabase.orderItemAddonDao().find(orderItem._id, addonL1.id);
                                if (dbAddonL1 != null) {
                                    //selectedAddonQuantity++;
                                    selectedAddonQuantity = selectedAddonQuantity + dbAddonL1.quantity;
                                    addonL1.selected = true;
                                    addonL1.quantity = dbAddonL1.quantity;
                                    productAddon.selectedOrderItemAddon.add(dbAddonL1);
                                }
                            }
                            addonL1.children = new ArrayList<>();
                            addonL1.children.addAll(appDatabase.addonDao().list(addonL1.id));
                            if (addonL1.children != null && addonL1.children.size() > 0) {
                                for (Addon addonL2 : addonL1.children) {
                                    Object isContainChild = appDatabase.productAddonDao().getContainChildAddon(product.id,productAddon.id,addonL2.id);
                                    addonL2.contain = isContainChild != null && (boolean) isContainChild;
                                    if (orderItem._id > 0) {
                                        OrderItemAddon dbAddonL2 = appDatabase.orderItemAddonDao().find(orderItem._id, addonL2.id);
                                        if (dbAddonL2 != null) {
                                            //selectedAddonQuantity++;
                                            selectedAddonQuantity = selectedAddonQuantity + addonL2.quantity;
                                            addonL1.selected = true;
                                            addonL1.quantity = addonL2.quantity;
                                            productAddon.selectedOrderItemAddon.add(dbAddonL2);
                                        }
                                    }
                                    addonL2.children = new ArrayList<>();
                                    addonL2.children.addAll(appDatabase.addonDao().list(addonL2.id));
                                }
                            }
                        }
                    }
                    productAddon.selectedQuantity = selectedAddonQuantity;
                    LogUtils.e(productAddon);
                }
                for (ProductIngredient productIngredient : localIngredients) {
                    if (orderItem._id > 0) {
                        OrderItemIngredient dbOitIngredient = appDatabase.orderItemIngredientDao().find(orderItem._id, productIngredient.id);
                        if (dbOitIngredient != null) {
                            productIngredient.isAlreadyRemoved = dbOitIngredient.without;
                            productIngredient.quantity = dbOitIngredient.quantity;
                        }
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                if (product != null) {
                    if (myApp.productImageEnabled() && !Validators.isNullOrEmpty(product.image)) {
                        ivProduct.setVisibility(View.VISIBLE);
                        Glide.with(getActivity())
                                .load(new File(getActivity().getExternalFilesDir("epos2021").getAbsolutePath()) + "/" + product.id + ".png")
                                .into(ivProduct);
                    } else {
                        ivProduct.setVisibility(View.GONE);
                    }

                    if (Validators.isNullOrEmpty(orderItem.special_instruction)) {
                        cvAddSpecialInstruction.setVisibility(View.VISIBLE);
                    } else {
                        llInstructions.setVisibility(View.VISIBLE);
                        etSpecialInstruction.setText(orderItem.special_instruction);
                        etSpecialInstructionPrice.setText(MyApp.df.format(orderItem.instruction_price));
                        cvAddSpecialInstruction.setVisibility(View.GONE);
                    }

                    productAddons.clear();
                    productAddons.addAll(localAddons);
                    productAddonAdapter.notifyDataSetChanged();

                    productIngredients.clear();
                    productIngredients.addAll(localIngredients);
                    productIngredientsAdapter.notifyDataSetChanged();

                    if (orderItem._id == 0) {
                        if (!product.auto_addon && !product.auto_modify) {
                            llIngredientsSelect.setVisibility(View.VISIBLE);
                            llAddonsSelect.setVisibility(View.GONE);
                            llIngredientsSelect.performClick();
                        } else if (product.auto_addon) {
                            llAddonsSelect.setVisibility(View.VISIBLE);
                            llAddonsSelect.performClick();
                            if (product.auto_modify) {
                                llIngredientsSelect.setVisibility(View.VISIBLE);
                            } else {
                                llIngredientsSelect.setVisibility(View.GONE);
                            }
                        } else if (productAddons.size() == 0 && productIngredients.size() == 0) {
                            llIngredientsSelect.setVisibility(View.VISIBLE);
                            llAddonsSelect.setVisibility(View.GONE);
                            llIngredientsSelect.performClick();
                        } else if (productAddons.size() > 0) {
                            llAddonsSelect.setVisibility(View.VISIBLE);
                            llAddonsSelect.performClick();
                            if (productIngredients.size() > 0) {
                                llIngredientsSelect.setVisibility(View.VISIBLE);
                            } else {
                                llIngredientsSelect.setVisibility(View.GONE);
                            }
                        } else {
                            llIngredientsSelect.setVisibility(View.VISIBLE);
                            llIngredientsSelect.performClick();
                            llAddonsSelect.setVisibility(View.GONE);
                        }
                    } else {
                        if (productAddons.size() == 0 && productIngredients.size() == 0) {
                            llIngredientsSelect.setVisibility(View.VISIBLE);
                            llAddonsSelect.setVisibility(View.GONE);
                            llIngredientsSelect.performClick();
                        } else if (productAddons.size() > 0) {
                            llAddonsSelect.setVisibility(View.VISIBLE);
                            llAddonsSelect.performClick();
                            if (productIngredients.size() > 0) {
                                llIngredientsSelect.setVisibility(View.VISIBLE);
                            } else {
                                llIngredientsSelect.setVisibility(View.GONE);
                            }
                        } else {
                            productIngredients.size();
                            llIngredientsSelect.setVisibility(View.VISIBLE);
                            llIngredientsSelect.performClick();
                            llAddonsSelect.setVisibility(View.GONE);
                        }
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }


    private float getAddonPrice(OrderItem orderItem) {
        float addonPrice = 0;
        for (OrderItemAddon orderItemAdd : orderItem.order_item_addons) {
            addonPrice = addonPrice + orderItemAdd.total;
        }
        return addonPrice;
    }

    private float getIngredientPrice(OrderItem orderItem) {
        float ingredientPrice = 0;
        for (OrderItemIngredient orderItemIngredient :
                orderItem.order_item_ingredients) {
            ingredientPrice = ingredientPrice + orderItemIngredient.total;
        }
        return ingredientPrice;
    }

}
