package com.ubsidi.epos_2021.fragment;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONArrayRequestListener;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ubsidi.R;
import com.ubsidi.epos_2021.adapters.ChatListAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.models.Chat;
import com.ubsidi.epos_2021.models.OrderHistory;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.Constants;

import org.json.JSONArray;
import org.json.JSONObject;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;


/**
 * Created by Amrish on 11-06-2021.
 */
public class ChatHomeFragment extends BaseFragment {
    LinearLayout llItem, llSearch;
    MaterialCardView cvSearch;
    ImageView ivSearch;
    Chip chipBack, chipSearchBack;
    RecyclerView rvChats;
    AppCompatEditText etSearch;
    ImageView ivCompose;
    private ArrayList<Chat> originalChats = new ArrayList<>();
    private ArrayList<Chat> searchedChats = new ArrayList<>();
    private ChatListAdapter chatListAdapter;
    private SwipeRefreshLayout swipeRefreshLayout;
    private BroadcastReceiver broadcastReceiver;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_chat_home, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initViews(view);
        setListeners();
    }

    private void initViews(View view) {
        try {
            ivCompose = view.findViewById(R.id.ivCompose);
            rvChats = view.findViewById(R.id.rvChats);
            etSearch = view.findViewById(R.id.etSearch);
            swipeRefreshLayout = view.findViewById(R.id.swipeRefreshLayout);
            llItem = view.findViewById(R.id.llItem);
            llSearch = view.findViewById(R.id.llSearch);
            cvSearch = view.findViewById(R.id.cvSearch);
            ivSearch = view.findViewById(R.id.ivSearch);
            chipBack = view.findViewById(R.id.chipBack);
            chipSearchBack = view.findViewById(R.id.chipSearchBack);
            chatListAdapter = new ChatListAdapter(searchedChats, (position, data) -> {
                Chat chat = (Chat) data;
                changeFragment(chat);
            }, (position, data) -> {
                //delete from list
                Chat chat = (Chat) data;
                // deleteFromList(chat.customer_id);
            });
            rvChats.setAdapter(chatListAdapter);
            rvChats.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteFromList(String customer_id) {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> swipeRefreshLayout.setRefreshing(true));
            }
            AndroidNetworking.delete(ApiEndPoints.order_help_list + customer_id + "/delete-user")
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        swipeRefreshLayout.setRefreshing(false);
                                    });
                                }
                                fetchData();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> swipeRefreshLayout.setRefreshing(false));
                                }
                                if (!CommonFunctions.isConnected(getActivity()))
                                    myApp.noInternet(getActivity());

                                fetchData();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeFragment(Chat chat) {
        try {
            RestaurantChatWindowFragment fragment = getInstanceRestaurantChat(chat);
            updateFragment(fragment);
            fragment.setDialogDismissListener(o -> {
                try {
                    Chat chat1 = (Chat) o;
                    updateFragment(getInstanceRestaurantChat(chat1));
                    chatListAdapter.selectedUser = chat1.customer_id;
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RestaurantChatWindowFragment getInstanceRestaurantChat(Chat chat) {
        RestaurantChatWindowFragment restaurantChatWindowFragment = new RestaurantChatWindowFragment();
        Bundle bundle = new Bundle();
        bundle.putString("chat_id", chat.id);
        bundle.putString("order_id", chat.order_id);
        bundle.putString("customer_id", chat.customer_id);
        bundle.putString("customer_name", chat.customer_name);
        bundle.putString("customer_phone", chat.phone_number);
        if (chat.user != null) {
            if (!Validators.isNullOrEmpty(chat.user.image_url))
                bundle.putString("customer_logo", chat.user.image_url);
        }

        restaurantChatWindowFragment.setArguments(bundle);
        return restaurantChatWindowFragment;
    }

    private void updateFragment(Fragment fragment) {
        try {
            FragmentManager manager = getChildFragmentManager();
            FragmentTransaction transaction = manager.beginTransaction();
            transaction.replace(R.id.nav_chat_fragment, fragment);
            transaction.addToBackStack("can_go_back");
            transaction.commit();
            getActivity().invalidateOptionsMenu();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            chipBack.setOnClickListener(v -> {
                getActivity().onBackPressed();
            });
            ivCompose.setOnClickListener(view -> {
                SelectChatCustomerDialogFragment selectChatCustomerDialogFragment = new SelectChatCustomerDialogFragment();
                selectChatCustomerDialogFragment.show(getChildFragmentManager(), "customers");
                selectChatCustomerDialogFragment.setDialogDismissListener(o -> {
                    try {
                        if (o instanceof OrderHistory) {
                            OrderHistory orderHistory = (OrderHistory) o;
                            Chat chat = new Chat();
                            chat.customer_id = orderHistory.customer_id;
                            chat.order_id = orderHistory.id;
                            chat.customer_name = orderHistory.customer_name;
                            chat.phone_number = orderHistory.phone_number;
                            changeFragment(chat);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            });
            ivSearch.setOnClickListener(v -> {
                llItem.setVisibility(View.GONE);
                llSearch.setVisibility(View.VISIBLE);
            });
            chipSearchBack.setOnClickListener(v -> {
                llSearch.setVisibility(View.GONE);
                llItem.setVisibility(View.VISIBLE);
            });
            etSearch.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void afterTextChanged(Editable editable) {
                    try {
                        searchedChats.clear();
                        searchedChats.addAll(searchChat());
                        chatListAdapter.notifyDataSetChanged();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            swipeRefreshLayout.setOnRefreshListener(this::fetchData);

            broadcastReceiver = new BroadcastReceiver() {
                public void onReceive(Context context, Intent intent) {
                    try {
                        boolean refresh = intent.getBooleanExtra("refresh", false);
                        boolean forChat = intent.getBooleanExtra("chat", false);
                        if (refresh & forChat) {
                            swipeRefreshLayout.setRefreshing(true);
                            fetchData();
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchData() {
        new Thread(this::fetchChatHistory).start();
    }

    private void fetchChatHistory() {
        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> swipeRefreshLayout.setRefreshing(true));
            }
            AndroidNetworking.get(ApiEndPoints.order_help_list)
                    .addQueryParameter("user_group", "1")
                    .addQueryParameter("restaurant_id", myApp.restaurant_id)
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsJSONArray(new JSONArrayRequestListener() {
                        @Override
                        public void onResponse(JSONArray response) {
                            Type type = new TypeToken<List<Chat>>() {
                            }.getType();
                            originalChats.clear();
                            originalChats.addAll(new Gson().fromJson(response.toString(), type));
                            for (int i = 0; i < originalChats.size(); i++) {
                                if (originalChats.get(i).user != null) {
                                    originalChats.get(i).customer_name = originalChats.get(i).user.first_name + " " + originalChats.get(i).user.last_name;
                                    originalChats.get(i).phone_number = originalChats.get(i).user.phone_number;
                                }
                            }
                            searchedChats.clear();
                            searchedChats.addAll(originalChats);

                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    swipeRefreshLayout.setRefreshing(false);
                                    chatListAdapter.notifyDataSetChanged();
                                });
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> swipeRefreshLayout.setRefreshing(false));
                            }
                            if (!CommonFunctions.isConnected(getActivity()))
                                myApp.noInternet(getActivity());
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<Chat> searchChat() {
        if (etSearch.getText().toString().isEmpty()) {
            return originalChats;
        }
        ArrayList<Chat> searchedRest = new ArrayList<>();
        for (Chat r : originalChats) {
            if (r.customer_name != null && r.customer_name.toLowerCase().contains(etSearch.getText().toString().toLowerCase())) {
                searchedRest.add(r);
            }
        }
        return searchedRest;

    }

    @Override
    public void onResume() {
        super.onResume();
        try {
            fetchData();
            if (getActivity() != null && broadcastReceiver != null) {
                LocalBroadcastManager.getInstance(getActivity()).registerReceiver(broadcastReceiver, new IntentFilter(Constants.NOTIFICATION));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onStop() {
        try {
            CommonFunctions.hideKeyboard(getActivity(), etSearch);

            if (getActivity() != null && broadcastReceiver != null)
                LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(broadcastReceiver);

        } catch (Exception e) {
            e.printStackTrace();
        }
        super.onStop();
    }
}
