package com.ubsidi.epos_2021.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.DialogFragment;

import com.google.android.material.button.MaterialButton;
import com.ubsidi.R;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.online.interfaces.DialogDismissListener;

/**
 * Created by Amrish on 11-11-2020.
 */
public class ConfirmationDialogFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private String title, info, positiveButton, negativeButton;
    private boolean reject;
    private int type; //0 neutral, 1 success,2 reject
    private MaterialButton btnConfirm, btnCancel;
    private TextView tvInfo, tvTitle;
    private DialogDismissListener dialogDismissListener;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_confirmation_fragment, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            title = getArguments().getString("title");
            info = getArguments().getString("info");
            positiveButton = getArguments().getString("positive_button");
            negativeButton = getArguments().getString("negative_button");
            type = getArguments().getInt("type");

            initViews(view);
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            btnConfirm = view.findViewById(R.id.btnConfirm);
            btnCancel = view.findViewById(R.id.btnCancel);
            tvInfo = view.findViewById(R.id.tvInfo);
            tvTitle = view.findViewById(R.id.tvTitle);

            if (Validators.isNullOrEmpty(title)) {
                tvTitle.setVisibility(View.GONE);
            } else
                tvTitle.setText(title);
            if (Validators.isNullOrEmpty(info)) {
                tvInfo.setVisibility(View.GONE);
            } else
                tvInfo.setText(info);
            if (type == 2) {
                tvTitle.setTextColor(ContextCompat.getColor(getActivity(), R.color.dialog_title_reject));
            } else if (type == 1) {
                tvTitle.setTextColor(ContextCompat.getColor(getActivity(), R.color.dialog_title_accept));
            }
            if (Validators.isNullOrEmpty(negativeButton)) {
                btnCancel.setVisibility(View.GONE);
            } else {
                btnCancel.setText(negativeButton);
            }
            if (Validators.isNullOrEmpty(positiveButton)) {
                btnConfirm.setVisibility(View.GONE);
            } else {
                btnConfirm.setText(positiveButton);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            btnConfirm.setOnClickListener(view -> {
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss("confirm");
                dismiss();
            });
            btnCancel.setOnClickListener(view -> {
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss("cancel");
                dismiss();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
