package com.ubsidi.epos_2021.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;

import com.google.android.material.button.MaterialButton;
import com.google.android.material.card.MaterialCardView;
import com.ubsidi.R;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;

/**
 * Created by Amrish on 31-05-2021.
 */
public class ConvertOrderTypeFragment extends BaseFragment {

    private MaterialButton btnCancel, btnConfirm;
    private MaterialCardView cvDelivery, cvCollection, cvDinein, cvWaiting;
    private TextView tvDelivery, tvCollection, tvDinein, tvWaiting;
    private String selectedOrderType;
    private DialogDismissListener dialogDismissListener;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_convert_order_type, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            if (getArguments() != null)
                selectedOrderType = getArguments().getString("order_type_id");
            initViews(view);
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            btnCancel = view.findViewById(R.id.btnCancel);
            btnConfirm = view.findViewById(R.id.btnConfirm);
            cvCollection = view.findViewById(R.id.cvCollection);
            cvDelivery = view.findViewById(R.id.cvDelivery);
            cvDinein = view.findViewById(R.id.cvDinein);
            cvWaiting = view.findViewById(R.id.cvWaiting);

            tvCollection = view.findViewById(R.id.tvCollection);
            tvDelivery = view.findViewById(R.id.tvDelivery);
            tvDinein = view.findViewById(R.id.tvDinein);
            tvWaiting = view.findViewById(R.id.tvWaiting);

            if (selectedOrderType.equalsIgnoreCase("1")) {
                selectCardView(cvDinein);
            }
            if (selectedOrderType.equalsIgnoreCase("2")) {
                selectCardView(cvCollection);
            }
            if (selectedOrderType.equalsIgnoreCase("3")) {
                selectCardView(cvDelivery);
            }
            if (selectedOrderType.equalsIgnoreCase("5")) {
                selectCardView(cvWaiting);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            cvWaiting.setOnClickListener(view -> {
                selectedOrderType = "5";
                selectCardView(cvWaiting);
            });
            cvDelivery.setOnClickListener(view -> {
                selectedOrderType = "3";
                selectCardView(cvDelivery);
            });
            cvDinein.setOnClickListener(view -> {
                selectedOrderType = "1";
                selectCardView(cvDinein);
            });
            cvCollection.setOnClickListener(view -> {
                selectedOrderType = "2";
                selectCardView(cvCollection);
            });
            btnCancel.setOnClickListener(view -> {
                getActivity().onBackPressed();
            });
            btnConfirm.setOnClickListener(view -> {
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss(selectedOrderType);
                }
                getActivity().onBackPressed();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void selectCardView(MaterialCardView cardView) {
        try {
            cvCollection.setCardBackgroundColor(ContextCompat.getColor(getActivity(), R.color.white));
            cvDinein.setCardBackgroundColor(ContextCompat.getColor(getActivity(), R.color.white));
            cvDelivery.setCardBackgroundColor(ContextCompat.getColor(getActivity(), R.color.white));
            cvWaiting.setCardBackgroundColor(ContextCompat.getColor(getActivity(), R.color.white));
            tvCollection.setTextColor(ContextCompat.getColor(getActivity(), R.color.black));
            tvDinein.setTextColor(ContextCompat.getColor(getActivity(), R.color.black));
            tvDelivery.setTextColor(ContextCompat.getColor(getActivity(), R.color.black));
            tvWaiting.setTextColor(ContextCompat.getColor(getActivity(), R.color.black));

            if (cardView == cvCollection) {
                cvCollection.setCardBackgroundColor(ContextCompat.getColor(getActivity(), R.color.persian_green));
                tvCollection.setTextColor(ContextCompat.getColor(getActivity(), R.color.white));
            }
            if (cardView == cvWaiting) {
                cvWaiting.setCardBackgroundColor(ContextCompat.getColor(getActivity(), R.color.persian_green));
                tvWaiting.setTextColor(ContextCompat.getColor(getActivity(), R.color.white));
            }
            if (cardView == cvDelivery) {
                cvDelivery.setCardBackgroundColor(ContextCompat.getColor(getActivity(), R.color.persian_green));
                tvDelivery.setTextColor(ContextCompat.getColor(getActivity(), R.color.white));
            }
            if (cardView == cvDinein) {
                cvDinein.setCardBackgroundColor(ContextCompat.getColor(getActivity(), R.color.persian_green));
                tvDinein.setTextColor(ContextCompat.getColor(getActivity(), R.color.white));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
