package com.ubsidi.epos_2021.fragment;

import android.os.AsyncTask;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.google.android.material.button.MaterialButton;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.ubsidi.R;
import com.ubsidi.epos_2021.adapters.CustomersAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.models.Customer;

import java.util.ArrayList;


public class CustomersFragment extends BaseFragment {
    public static CustomersFragment getInstance() {
        return new CustomersFragment();
    }

    private RecyclerView rvCustomers;
    private SwipeRefreshLayout swipeRefreshLayout;
    private EditText etSearch;
    private MaterialButton tvSearch;
    private ArrayList<Customer> customers = new ArrayList<>();
    private CustomersAdapter customersAdapter;
    private Chip chipBack;
    private ImageView ivCancel;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_customers, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            new FetchCustomersAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            tvSearch.setOnClickListener(v -> {
                new FetchCustomersAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, etSearch.getText().toString());
            });
            swipeRefreshLayout.setOnRefreshListener(() -> {
                new FetchCustomersAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, etSearch.getText().toString());
            });

            etSearch.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                }

                @Override
                public void afterTextChanged(Editable editable) {
                    if (etSearch.getText().toString().trim().isEmpty()) {
                        ivCancel.setVisibility(View.GONE);
                    } else {
                        ivCancel.setVisibility(View.VISIBLE);
                    }
                    new FetchCustomersAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, etSearch.getText().toString());
                    //CommonFunctions.hideKeyboard(getActivity(), etSearch);
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CustomerInfoDialogFragment getInstanceCustomerInfoDialog(Customer customer, boolean edit) {
        CustomerInfoDialogFragment fragment = new CustomerInfoDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("customer", new Gson().toJson(customer));
        bundle.putBoolean("edit", edit);
        fragment.setArguments(bundle);
        return fragment;
    }

    private void initViews(View view) {
        try {
            chipBack = view.findViewById(R.id.chipBack);
            ivCancel = view.findViewById(R.id.ivCancel);
            rvCustomers = view.findViewById(R.id.rvCustomers);
            etSearch = view.findViewById(R.id.etSearch);
            tvSearch = view.findViewById(R.id.btnSearch);
            swipeRefreshLayout = view.findViewById(R.id.swipeRefreshLayout);
            customersAdapter = new CustomersAdapter(customers, (position, data) -> {
                CustomerInfoDialogFragment customerInfoDialogFragment = getInstanceCustomerInfoDialog((Customer) data, true);
                customerInfoDialogFragment.show(getChildFragmentManager(), "edit");
                customerInfoDialogFragment.setDialogDismissListener(o -> {
                    try {
                        if (o instanceof Customer) {
                            Customer c = (Customer) data;
                            Customer customer = (Customer) o;
                            customer._id = c._id;
                            customer.id = c.id;
                            etSearch.setText(null);
                            new Thread(() -> {
                                appDatabase.customerDao().update(customer);
                                new FetchCustomersAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);

                            }).start();
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }, (position, data) -> {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Delete customer?", "Are you sure you want to delete customer", 2, "Confirm", "Cancel");
                confirmationDialogFragment.show(getChildFragmentManager(), "confirm");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                        checkAndDeleteCustomer((Customer) data);
                    }
                });
            });
            rvCustomers.setLayoutManager(new LinearLayoutManager(getActivity()));
            rvCustomers.setAdapter(customersAdapter);

            chipBack.setOnClickListener(view1 -> getActivity().onBackPressed());
            ivCancel.setOnClickListener(view1 -> {
                etSearch.setText("");
                CommonFunctions.hideKeyboard(getActivity(), etSearch);
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkAndDeleteCustomer(Customer customer) {
        try {
            new Thread(() -> {
                try {
                    int totalOrders = appDatabase.orderDao().customersTotalOrder(customer._id);
                    int totalReservations = appDatabase.reservationDao().customersTotalReservation(customer._id);
                    if (totalOrders == 0 && totalReservations == 0) {
                        appDatabase.customerDao().delete(customer._id);
                    } else {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> {
                                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Cannot Delete", "This customer have already orders/reservations", 2, "Okay", null);
                                confirmationDialogFragment.show(getChildFragmentManager(), "confirm");
                            });
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    class FetchCustomersAsync extends AsyncTask<String, String, String> {
        private ArrayList<Customer> customerArrayList = new ArrayList<>();

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            try {
                if (getActivity() != null) getActivity().runOnUiThread(() -> {
                    swipeRefreshLayout.setRefreshing(true);
                });
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        protected String doInBackground(String... strings) {
            try {
                customerArrayList.clear();
                if (strings.length > 0 && !Validators.isNullOrEmpty(strings[0]))
                    customerArrayList.addAll(appDatabase.customerDao().list("%" + strings[0] + "%"));
                else customerArrayList.addAll(appDatabase.customerDao().list());
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                customers.clear();
                customers.addAll(customerArrayList);
                customersAdapter.notifyDataSetChanged();
                swipeRefreshLayout.setRefreshing(false);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}
