package com.ubsidi.epos_2021.fragment;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.fragment.app.FragmentTransaction;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.ViewPager;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.activities.HomeActivity;
import com.ubsidi.epos_2021.activities.NewOrderActivity;
import com.ubsidi.epos_2021.activities.UploadOrdersActivity;
import com.ubsidi.epos_2021.adapters.FloorAdapter;
import com.ubsidi.epos_2021.adapters.ViewpagerTabAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.CallLogs;
import com.ubsidi.epos_2021.models.Floor;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.services.SingleOrderUploaderService;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.InternetUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.ArrayList;
import java.util.List;

public class DineInFragment extends BaseFragment {
    private ViewPager vpTables;
    private LinearLayout llTables;
    private TextView txtCount;
    private ConstraintLayout constRefreshTables;
    private MaterialButton btnNewOrder, btnRefreshTables, btnPushData, btnParkCalls, btnTables;
    private ImageView ivRefreshTables, ivTableArrow;
    private ViewpagerTabAdapter viewpagerAdapter;
    private ArrayList<Floor> floors = new ArrayList<>();
    private RecyclerView rvFloors;
    private FloorAdapter floorAdapter;
    AlertDialog progressDialog;
    private Chip chipBack;
    private LinearLayout llTitle;
    private boolean fromTheme2;
    private SiteSetting pushDataSetting;
    private DialogDismissListener dialogDismissListener;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_dine_in, container, false);
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getArguments() != null) {
            fromTheme2 = getArguments().getBoolean("show_title", true);
        }
    }

    BroadcastReceiver failedOrderListReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.hasExtra(Constants.FAILED_ORDER_COUNT) && intent.getIntExtra(Constants.FAILED_ORDER_COUNT, 0) > 0) {
                constRefreshTables.setVisibility(View.VISIBLE);
                btnRefreshTables.setVisibility(View.VISIBLE);
                txtCount.setVisibility(View.VISIBLE);
                btnRefreshTables.setBackgroundTintList(ContextCompat.getColorStateList(getContext(), R.color.red));
                if (intent.getIntExtra(Constants.FAILED_ORDER_COUNT, 0) > 10) {
                    txtCount.setText("" + 10 + "+");
                } else {
                    txtCount.setText("" + intent.getIntExtra(Constants.FAILED_ORDER_COUNT, 0));
                }
            } else {
                txtCount.setVisibility(View.GONE);
                btnRefreshTables.setBackgroundTintList(ContextCompat.getColorStateList(getContext(), R.color.owner_message_background));
            }
        }
    };

    @Override
    public void onResume() {
        super.onResume();
        if (getActivity() != null) {
            LocalBroadcastManager.getInstance(getActivity()).registerReceiver(failedOrderListReceiver, new IntentFilter(Constants.FAILED_ORDER_RECEIVER));
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (failedOrderListReceiver != null && getActivity() != null) {
            LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(failedOrderListReceiver);
        }
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            setListeners();
            new FloorsAsyncTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            fetchCallLogs();

            ((HomeActivity) requireActivity()).new DbSaverAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new ArrayList<>(), false);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class FloorsAsyncTask extends AsyncTask<String, String, String> {

        @Override
        protected String doInBackground(String... strings) {
            try {
                floors.clear();
                floors.addAll(appDatabase.floorDao().list());
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                progressDialog.dismiss();
                if (floors != null && floors.size() > 0) {
                    floorAdapter.selectedFloorId = floors.get(0).id;
                    floorAdapter.notifyDataSetChanged();
                    for (int i = 0; i < floors.size(); i++) {
                        viewpagerAdapter.addFragment(getInstance(floors.get(i).id, fromTheme2), floors.get(i).name);
                    }
                    viewpagerAdapter.notifyDataSetChanged();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private TablesFragment getInstance(String floorId, boolean fromTheme2) {
        Bundle bundle = new Bundle();
        TablesFragment fragment = new TablesFragment();
        bundle.putString("floor_id", floorId);
        bundle.putBoolean("from_theme2", fromTheme2);
        fragment.setArguments(bundle);
        return fragment;
    }

    private void setListeners() {
        chipBack.setOnClickListener(v -> {
            if (getActivity() != null) {
                getActivity().onBackPressed();
            }
        });

        btnNewOrder.setOnClickListener(v -> {
            createNewOrder();
        });

        vpTables.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                try {
                    // on page scroll change floor tables
                    Floor selectedFloor = floors.get(position);
                    floorAdapter.selectedFloorId = selectedFloor.id;
                    floorAdapter.notifyDataSetChanged();

                    rvFloors.scrollToPosition(position);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });

        btnRefreshTables.setOnClickListener(v -> {
            // Refresh tables data
            try {
                if (txtCount.getVisibility() == View.VISIBLE && !txtCount.getText().toString().equals("") && Integer.parseInt(txtCount.getText().toString()) > 0) {
                    if (!InternetUtils.isNetworkConnected(getActivity())) {
                        ToastUtils.makeSnackToast(getActivity(), "No internet connection");
                    } else {
                        startActivityForResult(new Intent(getActivity(), UploadOrdersActivity.class).putExtra(Constants.IS_FROM_UPLOAD_FAILED_ORDER, true), Constants.CODE_REFRESH);
                    }
                } else {
                    Fragment fragment = viewpagerAdapter.getItem(vpTables.getCurrentItem());
                    if (fragment instanceof TablesFragment) {
                        ((TablesFragment) fragment).fetchFloorDetails();
                    }
                    // Refresh all orders
                    myApp.notifyCart(getActivity(), new Intent().setAction(Constants.EPOS_ORDER_UPDATE).putExtra("result", true).putExtra("refreshAll", "update"));
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        });

        btnPushData.setOnClickListener(v -> {
            try {
                if (!InternetUtils.isNetworkConnected(getActivity())) {
                    ToastUtils.makeSnackToast(getActivity(), "No internet connection");
                } else {
                    startActivityForResult(new Intent(getActivity(), UploadOrdersActivity.class), Constants.CODE_REFRESH);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        });
        btnParkCalls.setOnClickListener(v -> {
            try {
                if (getActivity() != null) {
                    ((HomeActivity) getActivity()).getParkCalls();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        });
        llTables.setOnClickListener(view -> {
            if (ivTableArrow.getRotation() == 90) {
                ivTableArrow.setRotation(0);
                vpTables.setVisibility(View.VISIBLE);
                rvFloors.setVisibility(View.VISIBLE);
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss("Expand");
            } else {
                ivTableArrow.setRotation(90);
                vpTables.setVisibility(View.GONE);
                rvFloors.setVisibility(View.GONE);
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss("Collapse");

            }
        });
        btnTables.setOnClickListener(view -> {
            if (btnTables.getText().toString().equalsIgnoreCase("hide tables")) {
                btnTables.setText("Show Tables");
                vpTables.setVisibility(View.GONE);
                rvFloors.setVisibility(View.GONE);
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss("Collapse");

            } else {
                btnTables.setText("Hide Tables");
                vpTables.setVisibility(View.VISIBLE);
                rvFloors.setVisibility(View.VISIBLE);
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss("Expand");

            }
        });
    }

    private void fetchCallLogs() {
        try {
            AndroidNetworking.get(ApiEndPoints.calllogs)
                    .addQueryParameter("status", "parked")
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsObjectList(CallLogs.class, new ParsedRequestListener<List<CallLogs>>() {
                        @Override
                        public void onResponse(List<CallLogs> response) {
                            try {
                                Log.e("response", "" + response.toString());
                                callList.clear();
                                new CallLogAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, response);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                callList.clear();
                                new CallLogAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    //ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<CallLogs> callList = new ArrayList<>();

    private class CallLogAsync extends AsyncTask<List<CallLogs>, String, String> {

        @Override
        protected String doInBackground(List<CallLogs>... lists) {
            try {
                callList.addAll(myApp.appDatabase.calllogDao().getParkedCalls());
                for (CallLogs callLogs : callList) {
                    callLogs.customer = appDatabase.customerDao().view(callLogs.customer_id);
                }
                if (lists.length > 0) {
                    callList.addAll(lists[0]);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        if (myPreferences.getCallerIdEnableStatus()) {
                            btnParkCalls.setVisibility(View.VISIBLE);
                            Log.e("PARK CALLS api", " " + callList.size());
                            if (callList != null && callList.size() > 0) {
                                btnParkCalls.setText("Park Calls (" + callList.size() + ")");
                            } else {
                                btnParkCalls.setText("Park Calls (0)");
                            }
                        } else {
                            btnParkCalls.setVisibility(View.GONE);
                        }
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
    }

    private void createNewOrder() {
        try {
            if (getActivity() != null) {
                Fragment openedFragment = getActivity().getSupportFragmentManager().findFragmentById(R.id.nav_host_fragment);
                String orderTypeId = null;
                if (openedFragment instanceof OrdersAllFragment) {
                    orderTypeId = MyApp.openedOrderTypeId;
                    if (Validators.isNullOrEmpty(MyApp.openedOrderTypeId) || MyApp.openedOrderTypeId.equalsIgnoreCase("0") || MyApp.openedOrderTypeId.equalsIgnoreCase("6")) {
                        openOrderTypeSelectionDialog(null);
                    } else {
                        openNewOrderDialog(orderTypeId, null);
                    }
                } else {
                    openOrderTypeSelectionDialog(null);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openOrderTypeSelectionDialog(CallLogs callLogs) {
        try {
            OrderTypeSelectionDialogFragment orderTypeSelectionDialog = myApp.getInstanceOrderTypeSelection(callLogs);
            orderTypeSelectionDialog.show(getChildFragmentManager(), "order_type");
            orderTypeSelectionDialog.setDialogDismissListener(o -> {
                try {
                    if (o instanceof String) {
                        String orderTypeId = (String) o;
                        openNewOrderDialog(orderTypeId, callLogs);
                    } else if (o instanceof CallLogs) {
                        changeFragment(myApp.getInstanceNewReservation((CallLogs) o));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openNewOrderDialog(String orderTypeId, CallLogs callLogs) {
        try {
            NewOrderDialogFragment newOrderDialogFragment = myApp.getInstanceNewOrder(callLogs, orderTypeId);
            newOrderDialogFragment.show(getChildFragmentManager(), "new_order");
            newOrderDialogFragment.setDialogDismissListener(o -> {
                try {
                    if (o instanceof Order) {
                        startActivity(new Intent(getActivity(), NewOrderActivity.class).putExtra("order", new Gson().toJson(o)).putExtra("fetch_delivery_charge", ((Order) o).order_type_id.equalsIgnoreCase("3")));
                    } else if (o instanceof CallLogs) {
                        changeFragment(myApp.getInstanceNewReservation((CallLogs) o));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeFragment(Fragment fragment) {
        try {
            FragmentManager manager = getChildFragmentManager();
            FragmentTransaction transaction = manager.beginTransaction();
            transaction.replace(R.id.nav_host_fragment, fragment);
            transaction.addToBackStack("can_go_back");
            transaction.commit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            progressDialog = CommonFunctions.customProgressDialog(getActivity());
            rvFloors = view.findViewById(R.id.rvFloors);
            vpTables = view.findViewById(R.id.vpTables);
            btnNewOrder = view.findViewById(R.id.btnNewOrder);
            txtCount = view.findViewById(R.id.txtCount);
            constRefreshTables = view.findViewById(R.id.constRefreshTables);
            btnRefreshTables = view.findViewById(R.id.btnRefreshTables);
            btnPushData = view.findViewById(R.id.btnPushData);
            btnParkCalls = view.findViewById(R.id.btnParkCalls);
            ivRefreshTables = view.findViewById(R.id.ivRefreshTables);
            chipBack = view.findViewById(R.id.chipBack);
            llTitle = view.findViewById(R.id.llTitle);
            llTables = view.findViewById(R.id.llTables);
            ivTableArrow = view.findViewById(R.id.ivArrow);
            btnTables = view.findViewById(R.id.btnTables);
            pushDataSetting = myApp.findSetting("cloud_system");

            if (fromTheme2) {
                llTitle.setVisibility(View.GONE);
                btnNewOrder.setVisibility(myApp.isNewOrderVisible() ? View.VISIBLE : View.GONE);
                ivRefreshTables.setVisibility(View.GONE);
                btnRefreshTables.setVisibility(View.VISIBLE);
                constRefreshTables.setVisibility(View.VISIBLE);
                btnTables.setVisibility(View.VISIBLE);
                if (pushDataSetting != null && !Validators.isNullOrEmpty(pushDataSetting.value) && pushDataSetting.value.equalsIgnoreCase("yes")) {
                    btnPushData.setVisibility(View.VISIBLE);
                } else {
                    btnPushData.setVisibility(View.GONE);
                }
                try {
                    new Thread(() -> {
                        List<CallLogs> list = appDatabase.calllogDao().getParkedCalls();
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> {
                                if (myPreferences.getCallerIdEnableStatus()) {
                                    btnParkCalls.setVisibility(View.VISIBLE);
                                    Log.e("PARK CALLS", " " + list.size());
                                    if (list != null && list.size() > 0) {
                                        btnParkCalls.setText("Park Calls (" + list.size() + ")");
                                    } else {
                                        btnParkCalls.setText("Park Calls (0)");
                                    }
                                } else {
                                    btnParkCalls.setVisibility(View.GONE);
                                }
                            });
                        }

                    }).start();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                btnNewOrder.setVisibility(View.GONE);
                ivRefreshTables.setVisibility(View.GONE);
                llTitle.setVisibility(View.VISIBLE);
                btnRefreshTables.setVisibility(View.GONE);
                constRefreshTables.setVisibility(View.GONE);
                btnPushData.setVisibility(View.GONE);
                btnParkCalls.setVisibility(View.GONE);
                btnTables.setVisibility(View.GONE);
            }

            floorAdapter = new FloorAdapter(floors, (position, data) -> {
                Floor selectedFloor = (Floor) data;
                vpTables.setCurrentItem(position);
                floorAdapter.selectedFloorId = selectedFloor.id;
                floorAdapter.notifyDataSetChanged();
            });
            rvFloors.setAdapter(floorAdapter);
            rvFloors.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.HORIZONTAL, false));
            viewpagerAdapter = new ViewpagerTabAdapter(getChildFragmentManager(), FragmentPagerAdapter.BEHAVIOR_RESUME_ONLY_CURRENT_FRAGMENT);
            vpTables.setAdapter(viewpagerAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
