package com.ubsidi.epos_2021.fragment;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.google.android.material.button.MaterialButton;
import com.ubsidi.R;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.MoneyTextWatcher;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.daos.relations.OrderWithItems;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.utils.Constants;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.concurrent.Callable;

public class DiscountDialogFragment extends BaseFragment {

    private DialogDismissListener dialogDismissListener;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    private MaterialButton btn1, btn2, btn3, btn4, btn5, btn6, btn7, btn8, btn9, btn0, btnDot, btn30p, btn25p, btn20p, btn15p, btn10p, btn5p;
    private MaterialButton btnClear;
    private MaterialButton btnConfirm, btnCancel, btnFlat, btnPercentage;
    private EditText etAmount;
    private boolean flatAmountSelected = true;
    private float orderTotal = 10.00f;
    private Order order;
    private int _order_id;
    private String title;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_discount_dialog, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            if (getArguments() != null) {
                _order_id = getArguments().getInt("_order_id");
                title = getArguments().getString("title");

            }
            initViews(view);
            setListeners();
            fetchOffline();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            TextView tvTitle = view.findViewById(R.id.tvTitle);
            btnCancel = view.findViewById(R.id.btnCancel);
            btnConfirm = view.findViewById(R.id.btnConfirm);
            btnClear = view.findViewById(R.id.btnClear);
            btn1 = view.findViewById(R.id.btn1);
            btn2 = view.findViewById(R.id.btn2);
            btn3 = view.findViewById(R.id.btn3);
            btn4 = view.findViewById(R.id.btn4);
            btn5 = view.findViewById(R.id.btn5);
            btn6 = view.findViewById(R.id.btn6);
            btn7 = view.findViewById(R.id.btn7);
            btn8 = view.findViewById(R.id.btn8);
            btn9 = view.findViewById(R.id.btn9);
            btn0 = view.findViewById(R.id.btn0);
            btnDot = view.findViewById(R.id.btnDot);
            etAmount = view.findViewById(R.id.etAmount);
            btnPercentage = view.findViewById(R.id.btnPercentage);
            btnFlat = view.findViewById(R.id.btnFlat);

            btn30p = view.findViewById(R.id.btn30p);
            btn25p = view.findViewById(R.id.btn25p);
            btn20p = view.findViewById(R.id.btn20p);
            btn15p = view.findViewById(R.id.btn15p);
            btn10p = view.findViewById(R.id.btn10p);
            btn5p = view.findViewById(R.id.btn5p);

            btnConfirm.setEnabled(false);
            btnDot.setVisibility(View.GONE);


            if (title.equals("deliveryChargeType")) {
                tvTitle.setText("Delivery Charge");
                btn5p.setText("0.5");
                btn10p.setText("1");
                btn15p.setText("1.5");
                btn20p.setText("2");
                btn25p.setText("5");
                btn30p.setText("10");
                btnConfirm.setText("Apply Delivery Charge");

                btnPercentage.setVisibility(View.GONE);
                btnFlat.setVisibility(View.GONE);

                changeBtnColor(btnFlat);
                flatAmountSelected = true;
            } else {
                tvTitle.setText(title);
                btnConfirm.setText("Apply " + title);

                changeBtnColor(btnPercentage);
                flatAmountSelected = false;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {

        try {
            btnPercentage.setOnClickListener(v -> {
                changeBtnColor(v);
                flatAmountSelected = false;
            });

            btnFlat.setOnClickListener(v -> {
                changeBtnColor(v);
                flatAmountSelected = true;
            });


            etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount));

            etAmount.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void afterTextChanged(Editable editable) {
                    btnConfirm.setEnabled(!Validators.isNullOrEmpty(etAmount.getText().toString()) && !etAmount.getText().toString().equalsIgnoreCase("0.00"));
                }
            });
            btnCancel.setOnClickListener(view -> {
                getActivity().onBackPressed();
            });

            btnConfirm.setOnClickListener(view -> {
                float appliedAmount = Float.parseFloat(etAmount.getText().toString().replace(",", ""));

                if (!flatAmountSelected) {
                    if (orderTotal > 0)
                        appliedAmount = appliedAmount * orderTotal / 100;
                    else
                        appliedAmount = 0;
                }

                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss(appliedAmount);
                getActivity().onBackPressed();
            });

            btn1.setOnClickListener(v -> {
                etAmount.setText(etAmount.getText().toString() + "1");
            });

            btn2.setOnClickListener(v -> {
                etAmount.setText(etAmount.getText().toString() + "2");
            });

            btn3.setOnClickListener(v -> {
                etAmount.setText(etAmount.getText().toString() + "3");
            });

            btn4.setOnClickListener(v -> {
                etAmount.setText(etAmount.getText().toString() + "4");
            });

            btn5.setOnClickListener(v -> {
                etAmount.setText(etAmount.getText().toString() + "5");
            });

            btn6.setOnClickListener(v -> {
                etAmount.setText(etAmount.getText().toString() + "6");
            });

            btn7.setOnClickListener(v -> {
                etAmount.setText(etAmount.getText().toString() + "7");
            });

            btn8.setOnClickListener(v -> {
                etAmount.setText(etAmount.getText().toString() + "8");
            });

            btn9.setOnClickListener(v -> {
                etAmount.setText(etAmount.getText().toString() + "9");
            });

            btn0.setOnClickListener(v -> {
                etAmount.setText(etAmount.getText().toString() + "0");
            });

            btnDot.setOnClickListener(v -> {
                etAmount.setText(etAmount.getText().toString() + ".");
            });

            btn5p.setOnClickListener(v -> {
                //etAmount.setText("");
                //etAmount.setText("5.00");
                float appliedAmount = Float.parseFloat(etAmount.getText().toString().replace(",", ""));
                BigDecimal bigDecimal = BigDecimal.valueOf(appliedAmount).add(BigDecimal.valueOf(title.equals("deliveryChargeType") ? 0.5 : 5));
                BigDecimal bd = bigDecimal.setScale(2, RoundingMode.DOWN);
                etAmount.setText(bd.toString());
            });
            btn10p.setOnClickListener(v -> {
                float appliedAmount = Float.parseFloat(etAmount.getText().toString().replace(",", ""));
                BigDecimal bigDecimal = BigDecimal.valueOf(appliedAmount).add(BigDecimal.valueOf(title.equals("deliveryChargeType") ? 1 : 10));
                BigDecimal bd = bigDecimal.setScale(2, RoundingMode.DOWN);
                etAmount.setText(bd.toString());
               /* etAmount.setText("");
                etAmount.setText("10.00");*/
            });
            btn15p.setOnClickListener(v -> {
      /*          etAmount.setText("");
                etAmount.setText("15.00");*/
                float appliedAmount = Float.parseFloat(etAmount.getText().toString().replace(",", ""));
                BigDecimal bigDecimal = BigDecimal.valueOf(appliedAmount).add(BigDecimal.valueOf(title.equals("deliveryChargeType") ? 1.5 : 15));
                BigDecimal bd = bigDecimal.setScale(2, RoundingMode.DOWN);
                etAmount.setText(bd.toString());
            });
            btn20p.setOnClickListener(v -> {
               /* etAmount.setText("");
                etAmount.setText("20.00");*/
                float appliedAmount = Float.parseFloat(etAmount.getText().toString().replace(",", ""));
                BigDecimal bigDecimal = BigDecimal.valueOf(appliedAmount).add(BigDecimal.valueOf(title.equals("deliveryChargeType") ? 2 : 20));
                BigDecimal bd = bigDecimal.setScale(2, RoundingMode.DOWN);
                etAmount.setText(bd.toString());
            });
            btn25p.setOnClickListener(v -> {
               /* etAmount.setText("");
                etAmount.setText("25.00");*/
                float appliedAmount = Float.parseFloat(etAmount.getText().toString().replace(",", ""));
                BigDecimal bigDecimal = BigDecimal.valueOf(appliedAmount).add(BigDecimal.valueOf(title.equals("deliveryChargeType") ? 5 : 25));
                BigDecimal bd = bigDecimal.setScale(2, RoundingMode.DOWN);
                etAmount.setText(bd.toString());
            });
            btn30p.setOnClickListener(v -> {
            /*    etAmount.setText("");
                etAmount.setText("30.00");*/
                float appliedAmount = Float.parseFloat(etAmount.getText().toString().replace(",", ""));
                BigDecimal bigDecimal = BigDecimal.valueOf(appliedAmount).add(BigDecimal.valueOf(title.equals("deliveryChargeType") ? 10 : 30));
                BigDecimal bd = bigDecimal.setScale(2, RoundingMode.DOWN);
                etAmount.setText(bd.toString());
            });
            btnClear.setOnClickListener(v -> {
                if (!flatAmountSelected)
                    etAmount.setText("0.00");
                else etAmount.setText("0");
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void changeBtnColor(View v) {
        try {
            btnPercentage.setBackgroundColor(getResources().getColor(R.color.orders_card_bg_grey));
            btnPercentage.setTextColor(getResources().getColor(R.color.reason_normal_text));

            btnFlat.setBackgroundColor(getResources().getColor(R.color.orders_card_bg_grey));
            btnFlat.setTextColor(getResources().getColor(R.color.reason_normal_text));

            if (v == btnPercentage) {
                btnPercentage.setBackgroundColor(getResources().getColor(R.color.persian_green));
                btnPercentage.setTextColor(getResources().getColor(R.color.white));
            }
            if (v == btnFlat) {
                btnFlat.setBackgroundColor(getResources().getColor(R.color.persian_green));
                btnFlat.setTextColor(getResources().getColor(R.color.white));
            }
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
    }

    private void fetchOffline() {
        try {
            new FetchOrderOfflineAsyncTask(() -> {
                orderTotal = order.sub_total;
                return null;
            }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class FetchOrderOfflineAsyncTask extends AsyncTask<Object, Object, Object> {
        Callable<Void> nextMethod;

        public FetchOrderOfflineAsyncTask(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected Object doInBackground(Object... objects) {
            try {
                OrderWithItems orderWithItems = myApp.appDatabase.orderDao().orderWithItems(_order_id);
                if (orderWithItems != null) {
                    order = orderWithItems.order;
                    order.customer = appDatabase.customerDao().view(order._customer_id);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Object s) {
            super.onPostExecute(s);
            if (order != null)
                if (nextMethod != null) {
                    try {
                        nextMethod.call();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance(getActivity()).registerReceiver(eposOrderUpdateReceiver, new IntentFilter(Constants.EPOS_ORDER_UPDATE));
    }

    @Override
    public void onStop() {
        super.onStop();
        if (eposOrderUpdateReceiver != null)
            LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(eposOrderUpdateReceiver);
    }

    BroadcastReceiver eposOrderUpdateReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getBooleanExtra("refresh", false)) {
                    fetchOffline();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

}