package com.ubsidi.epos_2021.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.fragment.app.DialogFragment;

import com.google.android.material.button.MaterialButton;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.MoneyTextWatcher;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.online.interfaces.DialogDismissListener;


/**
 * Created by Amrish on 11-11-2020.
 */
public class EnterVoucherAmountDialogFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private String forWhat, title, info;
    private MaterialButton btnConfirm, btnCancel;
    private AppCompatEditText etAmount;
    private float value,voucherAmount;
    private DialogDismissListener dialogDismissListener;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_enter_voucher_amount, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            if (getArguments() != null) {
                forWhat = getArguments().getString("for_what");
                info = getArguments().getString("info");
                title = getArguments().getString("title");
                value = getArguments().getFloat("value");
                voucherAmount = getArguments().getFloat("voucherAmount");
            }
            initViews(view);
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            btnConfirm = view.findViewById(R.id.btnConfirm);
            btnCancel = view.findViewById(R.id.btnCancel);
            etAmount = view.findViewById(R.id.etAmount);
            TextView tvInfo = view.findViewById(R.id.tvInfo);
            TextView tvTitle = view.findViewById(R.id.tvTitle);
            tvInfo.setText(info);
            tvTitle.setText(title);
            etAmount.setText(MyApp.df.format(value));
            etAmount.setSelection(etAmount.getText().toString().length());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount));
            btnConfirm.setOnClickListener(view -> {
                try {
                    etAmount.setError(null);
                    if (!Validators.isNullOrEmpty(forWhat)) {
                        if (forWhat.equalsIgnoreCase("voucher_amount")) {
                            if (etAmount.getText().toString().isEmpty()) {
                                etAmount.setError("Please enter amount");
                            } else {
                                if (dialogDismissListener != null)
                                    dialogDismissListener.onDialogDismiss(etAmount.getText().toString().replace(",", ""));
                                CommonFunctions.hideKeyboard(getActivity(), etAmount);
                                dismiss();
                            }
                        }else if(forWhat.equalsIgnoreCase("minimum_order_voucher_amount")){
                            if (etAmount.getText().toString().isEmpty()) {
                                etAmount.setError("Please enter amount");
                            }else if(voucherAmount>Float.parseFloat(etAmount.getText().toString().replace(",", ""))){
                                etAmount.setError("Minimum order amount must be greater than voucher amount");
                                etAmount.requestFocus();
                            }else {
                                if (dialogDismissListener != null)
                                    dialogDismissListener.onDialogDismiss(etAmount.getText().toString().replace(",", ""));
                                CommonFunctions.hideKeyboard(getActivity(), etAmount);
                                dismiss();
                            }
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            btnCancel.setOnClickListener(view ->
            {
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss(null);
                dismiss();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
