package com.ubsidi.epos_2021.fragment;

import android.bluetooth.BluetoothDevice;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.fragment.app.DialogFragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.card.MaterialCardView;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.imin.library.IminSDKManager;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.OrderPaymentsAdapter;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.comman.bluetoothprinter.BluetoothPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinterV3Mix;
import com.ubsidi.epos_2021.comman.printer.WifiPrinter;
import com.ubsidi.epos_2021.comman.printer.ZoneRichPrinter;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.daos.relations.OrderItemWithAddonsIngredients;
import com.ubsidi.epos_2021.daos.relations.OrderWithItems;
import com.ubsidi.epos_2021.interfaces.RecyclerviewItemClickListenerWithTag;
import com.ubsidi.epos_2021.merchant.adapters.EposOrderedProductItemsAdapter;
import com.ubsidi.epos_2021.models.Admin;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.models.Discount;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.OrderSplit;
import com.ubsidi.epos_2021.models.PrepLocation;
import com.ubsidi.epos_2021.models.PrintSetting;
import com.ubsidi.epos_2021.models.PrintStructure;
import com.ubsidi.epos_2021.models.PrintStyle;
import com.ubsidi.epos_2021.models.Printer;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.Table;
import com.ubsidi.epos_2021.models.TableStatus;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.online.fragments.EnterPasswordDialogFragment;
import com.ubsidi.epos_2021.online.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.services.SingleOrderUploaderService;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class EposCompletedOrderOverviewBottomSheet extends DialogFragment {

    private int order_type = -1; // 0 dinein, 1 delivery, 2 pickup
    private RecyclerView rvPayment;
    private LinearLayout llLoading;
    private MaterialButton btnPrint, btnClose, btnCancelOrder, btnDeleteOrder;
    private DialogDismissListener dialogDismissListener;
    private LinearLayout llMainLayout;

    private TextView tvSubTotal, tvServiceCharge, tvDeliveryFee, tvDiscount, tvGratuityAmount;
    private TextView tvCustomerName, tvPhoneNo, tvAddress, tvInstructions, tvInstructionTitle;
    private MaterialCardView cvInstructions;

    private LinearLayout llDiscount, llDeliveryFee, llServiceCharge, llGratuity;
    private TextView tvOrderNumber, tvOrderPaymentStatus, tvOrderDate, tvDeliveryTime, tvMiles, tvTotal;
    private RecyclerView rvCartItems;
    private EposOrderedProductItemsAdapter productItemsAdapter;
    private OrderPaymentsAdapter paymentsAdapter;
    private ArrayList<OrderItem> orderItems = new ArrayList<>();
    private ArrayList<OrderPayment> orderPayments = new ArrayList<>();
    private int _order_id;
    private boolean printTotalInPrint = true;
    private SiteSetting buzzerSetting, ticketHeaderSetting, ticketHeaderTypeSetting, tableOrOrderIdSetting, orderDateTimeSetting, footerASetting, footerBSetting, footerOrderTypeSetting, totalVisibilitySetting, serviceChargeEnableSetting, serviceChargeOptionSetting, serviceChargeSetting, serviceChargeTypeSetting,
            paidPaymentSetting, unpaidPaymentSetting, partialPaymentSetting, cardPaymentSetting, cashPaymentSetting;
    private OrderWithItems orderWithItems;
    private Order order = new Order();
    private ArrayList<Printer> printers = new ArrayList<>();
    private boolean serviceChargeEnabled = false, serviceChargeAutoMode = true, discountEnabled = true, gratuityEnabled = true, autoDiscountApplied = false;
    private WifiPrinter wifiPrinter;
    private ZoneRichPrinter zoneRichPrinter;
    private SunmiPrinter sunmiPrinter;
    private SunmiPrinterV3Mix sunmiPrinterV3Mix;
    protected MyApp myApp = MyApp.getInstance();
    private AppDatabase appDatabase = myApp.appDatabase;
    protected AppCompatImageView ivClose;
    protected Admin loggedInAdmin = myApp.myPreferences.getLoggedInAdmin();
    protected Business selectedBusiness = loggedInAdmin.selected_business;
    protected Printer defaultPrinter;
    private Printer forceFullyDefaultPrinter;
    private int headerAlignment = 0;
    private String dateTimeModeInPrint;
    private String footerA, footerB, footerHeading;
    private LinearLayout llData;
    private float cartGrandTotal = 0, cartSubTotal = 0, cartDiscount = 0, cartServiceCharge = 0;
    public TableStatus vacantStatus = myApp.findStatus("Vacant");
    private ArrayList<Object> objects = new ArrayList<>();
    private OrderSplit selectedSplit;
    public BluetoothPrinter bluetoothPrinter;
    private HashMap<String, String> settingsMap = new HashMap<>();
    private List<PrintSetting> printSettings = myApp.myPreferences.getPrintSetting();
    private PrintStructure printStructure;
    private ArrayList<PrintStyle> listPrintStructure;

    @Override
    public int getTheme() {
        return R.style.MyBottomTopDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        getDialog().getWindow().setGravity(Gravity.BOTTOM);
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }


    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (getArguments() != null) {
            _order_id = getArguments().getInt("_order_id");
        }
        return inflater.inflate(R.layout.fragment_epos_order_overview, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            setListeners();
            if (_order_id > 0) {
                fetchOffline();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            ivClose.setOnClickListener(view -> dismiss());
            btnClose.setOnClickListener(v -> dismiss());
            btnPrint.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    createPrint("", false, true);
                }
            });
            btnCancelOrder.setOnClickListener(view -> {
                cancelOrderAction();
            });
            btnDeleteOrder.setOnClickListener(v -> {
                deleteOrderAction();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cancelOrderAction() {
        try {
            ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Cancel order", "Are you sure you want to cancel this order?", 2, "Confim", "Cancel");
            confirmationDialogFragment.show(getActivity().getSupportFragmentManager(), "cancel_order_menu");
            confirmationDialogFragment.setDialogDismissListener(o -> {
                if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {

                    try {
                        if (order.total_paid > 0) {
                            EnterPasswordDialogFragment enterPasswordDialogFragment = myApp.getInstanceEnterPassword(null, "Please enter password", "Please enter password to cancel this order");
                            enterPasswordDialogFragment.show(getActivity().getSupportFragmentManager(), "password");
                            enterPasswordDialogFragment.setDialogDismissListener(o1 -> {
                                if (o1 instanceof String) {
                                    String password = (String) o1;
                                    if (password.equalsIgnoreCase(myApp.myPreferences.getLoggedInUser().password)) {
                                        order.order_status = "Order Rejected";
                                        order.order_status_id = "10";
                                        ToastUtils.showSnackBar(getActivity(), llMainLayout, "Order rejected", "reject");
                                        new UpdateOrderAsyncTask(() -> {
                                            updateViews();
                                            uploadOrder();
                                            dismiss();
                                            return null;
                                        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                                    } else {
                                        ToastUtils.makeSnackToast(getActivity(), "Incorrect password");
                                    }
                                }
                            });
                        } else {
                            order.order_status = "Order Rejected";
                            order.order_status_id = "10";
                            ToastUtils.showSnackBar(getActivity(), llMainLayout, "Order rejected", "reject");
                            new UpdateOrderAsyncTask(() -> {
                                updateViews();
                                uploadOrder();
                                dismiss();
                                return null;
                            }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteOrderAction() {
        try {
            ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Delete order", "Are you sure you want to delete this order?", 2, "Confirm", "Cancel");
            confirmationDialogFragment.show(getActivity().getSupportFragmentManager(), "delete_order_menu");
            confirmationDialogFragment.setDialogDismissListener(o -> {
                if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                    if (order.total_paid > 0) {
                        EnterPasswordDialogFragment enterPasswordDialogFragment = myApp.getInstanceEnterPassword(null, "Please enter password", "Please enter password to cancel this order");
                        enterPasswordDialogFragment.show(getActivity().getSupportFragmentManager(), "password");
                        enterPasswordDialogFragment.setDialogDismissListener(o1 -> {
                            if (o1 instanceof String) {
                                String password = (String) o1;
                                if (password.equalsIgnoreCase(myApp.myPreferences.getLoggedInUser().password)) {
                                    if (myApp.myPreferences.getOrderSyncMode().equalsIgnoreCase("auto"))
                                        deleteOrder();

                                    order.order_status = "Order Deleted";
                                    order.order_status_id = "10";
                                    ToastUtils.showSnackBar(getActivity(), llMainLayout, "Order deleted", "delete");
                                    new UpdateOrderAsyncTask(() -> {
//                                        updateViews();
                                        myApp.notifyCart(getActivity(), new Intent().setAction(Constants.EPOS_ORDER_UPDATE).putExtra("result", true));
                                        dismiss();
                                        return null;
                                    }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                                } else {
                                    ToastUtils.makeSnackToast(getActivity(), "Incorrect password");
                                }
                            }
                        });
                    } else {
                        if (myApp.myPreferences.getOrderSyncMode().equalsIgnoreCase("auto"))
                            deleteOrder();

                        order.order_status = "Order Deleted";
                        order.order_status_id = "10";
                        ToastUtils.showSnackBar(getActivity(), llMainLayout, "Order deleted", "delete");
                        new UpdateOrderAsyncTask(() -> {
//                            updateViews();
                            myApp.notifyCart(getActivity(), new Intent().setAction(Constants.EPOS_ORDER_UPDATE).putExtra("result", true));
                            dismiss();
                            return null;
                        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteOrder() {
        try {
            AndroidNetworking.delete(ApiEndPoints.orders + order.id)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            LogUtils.e("Delete order", "response: " + response);
                        }

                        @Override
                        public void onError(ANError anError) {
                            if (anError.getErrorCode() == 400) {
                                ToastUtils.makeSnackToast(getActivity(), anError.getErrorAsObject(ApiError.class).getMessage());
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void uploadOrder() {
        try {
            if (getActivity() != null) {
                Intent intent = new Intent(getActivity(), SingleOrderUploaderService.class);
                intent.putExtra("_order_id", _order_id);
                getActivity().startService(intent);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class UpdateOrderAsyncTask extends AsyncTask<Object, Object, Object> {
        Callable<Void> nextMethod;

        public UpdateOrderAsyncTask(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected Object doInBackground(Object... objects) {
            try {
                order.sub_total = myApp.appDatabase.orderDao().getItemSubTotal(order._id);

                cartSubTotal = order.sub_total;
                if (serviceChargeEnabled) {
                    if (serviceChargeAutoMode && !order.is_auto_service_charge_remove) {
                        float serviceChargeValue = Float.parseFloat(serviceChargeSetting.value);
                        if (serviceChargeTypeSetting.value.equalsIgnoreCase("flat")) {
                            cartServiceCharge = serviceChargeValue;
                        } else {
                            if (serviceChargeValue > 0) {
                                cartServiceCharge = cartSubTotal * serviceChargeValue / 100;
                            } else {
                                cartServiceCharge = 0;
                            }
                        }
                    }
                }

                if (discountEnabled) {
                    List<Discount> discounts = appDatabase.discountDao().eligibleDiscounts("%" + myApp.current_day + "%", "%" + order.order_type_id + "%", order.sub_total, CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"), CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"));
                    if (discounts.size() > 0) {
                        Discount appliedDiscount = discounts.get(0);
                        autoDiscountApplied = false;
                        if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("flat")) {
                            if (cartSubTotal > 0)
                                cartDiscount = appliedDiscount.discount;
                            else cartDiscount = 0;
                            autoDiscountApplied = true;
                        }
                        if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("percentage")) {
                            if (cartSubTotal > 0)
                                cartDiscount = cartSubTotal * appliedDiscount.discount / 100;
                            else cartDiscount = 0;
                            autoDiscountApplied = true;
                        }
                    } else {
                        if (autoDiscountApplied) cartDiscount = 0;
                    }
                }


                order.discount = cartDiscount;
                order.service_charge = cartServiceCharge;
                cartGrandTotal = cartSubTotal + order.gratuity - cartDiscount + cartServiceCharge + order.delivery_charge;
                order.total = cartGrandTotal;
                if (!order.order_status_id.equalsIgnoreCase("5") && !order.order_status_id.equalsIgnoreCase("10")) {
                    order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                }
                appDatabase.orderDao().update(order);

                if (order.order_type_id.equalsIgnoreCase("1") && !Validators.isNullOrEmpty(order.table_id) && (order.order_status_id.equalsIgnoreCase("5") || order.order_status_id.equalsIgnoreCase("10"))) {
                    Table table = appDatabase.tableDao().view(order.table_id);
                    table.status = vacantStatus.status;
                    table.last_order_total = 0;
                    table.last_order_id = null;
                    table._last_order_id = 0;
                    table.last_order_created_at = null;
                    table.table_status_id = vacantStatus.id;
                    appDatabase.tableDao().insert(table);
                }

                if (order.order_status.equalsIgnoreCase("Order Deleted")) {
                    appDatabase.orderDao().delete(order);
                }
            } catch (NumberFormatException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Object s) {
            super.onPostExecute(s);
            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void createPrint(String title, boolean kitchenCopy, boolean goBack) {
        try {
            if (kitchenCopy) {
                print(title, true);
                return;
            }
            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                print(title, false);
            } else {
                dismiss();
                ToastUtils.makeLongToast(getActivity(), "No printer model found");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void print(String title, boolean kitchenCopy) {
        try {
            if (myApp.isCashDrawerOpen && !kitchenCopy) {
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h") || defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                        IminSDKManager.opencashBox();
                    } else {
                        if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                            zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                            zoneRichPrinter.openCashDrawer();
                        } else {
                            try {
                                if (bluetoothPrinter != null) {
                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                    if (device != null) {
                                        bluetoothPrinter.openCashDrawer();
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("t2") || defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                    if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                        sunmiPrinterV3Mix.openCashDrawer();
                    } else {
                        sunmiPrinter.openCashDrawer();
                    }
                }
                myApp.isCashDrawerOpen = false;
            }
            if (kitchenCopy) {
                new PrepLocationSenderAsync(title, () -> {
                    dismiss();
                    return null;
                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            } else {
                new OrderItemsPrintBlockAsync(null, () -> {
                    dismiss();
                    return null;
                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    class PrepLocationSenderAsync extends AsyncTask<String, String, String> {
        HashMap<PrepLocation, List<OrderItem>> prepOrderItems = new HashMap<>();
        String title;
        Callable<Void> nextMethod;

        public PrepLocationSenderAsync(String title, Callable<Void> nextMethod) {
            this.title = title;
            this.nextMethod = nextMethod;
        }

        @Override
        protected String doInBackground(String... strings) {

            try {
                ArrayList<PrepLocation> prepLocations = (ArrayList<PrepLocation>) appDatabase.prepLocationDao().list();
                for (PrepLocation prepLocation : prepLocations) {
                    List<OrderItem> miscPrepOits = new ArrayList<>();
                    List<OrderItem> prepOits = new ArrayList<>();
                    List<OrderItem> prepOitsTypePrice = new ArrayList<>();
                    List<OrderItem> allOits = new ArrayList<>();

                    /**
                     * Commenting order type wise fetching misc items, now it will get data from prep location id
                     */
                    if (order.order_type.equalsIgnoreCase("Collection")) {
                        // miscPrepOits = appDatabase.orderItemDao().orderItemsForPrepLocationsCollection(order._id, prepLocation.id);
                        prepOits = appDatabase.orderItemDao().orderItemProductForPrepLocationsCollection(order._id, prepLocation.id);
                    } else if (order.order_type.equalsIgnoreCase("Delivery")) {
                        //  miscPrepOits = appDatabase.orderItemDao().orderItemsForPrepLocationsDelivery(order._id, prepLocation.id);
                        prepOits = appDatabase.orderItemDao().orderItemProductForPrepLocationsDelivery(order._id, prepLocation.id);
                    } else if (order.order_type.equalsIgnoreCase("Waiting")) {
                        // miscPrepOits = appDatabase.orderItemDao().orderItemsForPrepLocationsBanquet(order._id, prepLocation.id);
                        prepOits = appDatabase.orderItemDao().orderItemProductForPrepLocationsBanquet(order._id, prepLocation.id);
                    } else {
                        // miscPrepOits = appDatabase.orderItemDao().orderItemsForPrepLocations(order._id, prepLocation.id);
                        prepOits = appDatabase.orderItemDao().orderItemProductForPrepLocations(order._id, prepLocation.id);
                    }
                    miscPrepOits = appDatabase.orderItemDao().orderItemsForPrepLocations(order._id, prepLocation.id);
                   /* miscPrepOits = appDatabase.orderItemDao().orderItemsForPrepLocations(order._id,prepLocation.id);
                    prepOits = appDatabase.orderItemDao().orderItemProductForPrepLocations(order._id, prepLocation.id);*/

                    if (miscPrepOits != null && miscPrepOits.size() > 0) {
                        allOits.addAll(miscPrepOits);
                    }

                    List<OrderItem> prepOitsPrice = new ArrayList<>();
                    prepOitsPrice.addAll(prepOits);

                    if (!Validators.isNullOrEmpty(order.order_type)) {
                        prepOitsTypePrice.clear();
                        for (OrderItem item : prepOits) {
                            OrderItem orderItem = new OrderItem();
                            for (OrderItem oi : prepOitsPrice) {
                                if (oi._id == item._id) {
                                    if (order.order_type.equalsIgnoreCase("collection") || order.order_type.equalsIgnoreCase("takeaway")) {
                                        oi.price = item.takeaway_price;
                                    } else if (order.order_type.equalsIgnoreCase("waiting")) {
                                        oi.price = item.waiting_price;
                                    } else if (order.order_type.equalsIgnoreCase("delivery")) {
                                        oi.price = item.delivery_price;
                                    } else {
                                        oi.price = item.price;
                                    }
                                    orderItem = oi;
                                }
                            }
                            prepOitsTypePrice.add(orderItem);
                        }
                    }

                    if (prepOitsTypePrice != null && prepOitsTypePrice.size() > 0) {
                        allOits.addAll(prepOitsTypePrice);
                    }

                    if (allOits.size() > 0) {
                        prepOrderItems.put(prepLocation, allOits);
                        for (OrderItem oit : allOits) {
                            oit.sent_to_kitchen = true;
                            appDatabase.orderItemDao().update(oit);
                        }
                    }

                    for (Map.Entry<PrepLocation, List<OrderItem>> entry : prepOrderItems.entrySet()) {
                        for (OrderItem orderItem : (ArrayList<OrderItem>) entry.getValue()) {
                            orderItem.order_item_ingredients = (ArrayList<OrderItemIngredient>) appDatabase.orderItemIngredientDao().list(orderItem._id);
                            orderItem.order_item_addons = (ArrayList<OrderItemAddon>) appDatabase.orderItemAddonDao().list(orderItem._id);
                        }
                    }

                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                int position = 0;
                for (Map.Entry<PrepLocation, List<OrderItem>> entry : prepOrderItems.entrySet()) {
                    position++;
                    PrepLocation prepLocation = entry.getKey();
                    if (printers == null) {
                        ToastUtils.makeToast(getActivity(), "Business printers are null");
                        continue;
                    }
                    Printer prepPrinter = null;
                    for (Printer pp : printers) {
                        if (prepLocation.printer_id.equalsIgnoreCase(pp.id)) {
                            prepPrinter = pp;
                        }
                    }
                    if (prepPrinter == null) {
                        ToastUtils.makeToast(getActivity(), "Preplocation printer not found,: " + prepLocation.printer_name);
                        continue;
                    }
                    if (defaultPrinter == null && forceFullyDefaultPrinter != null && prepPrinter.ip.equalsIgnoreCase(forceFullyDefaultPrinter.ip)) {
                        ToastUtils.makeToast(getActivity(), "Preplocation printer also same as default and its not connected");
                        continue;
                    }

                    Order tempOrder = new Gson().fromJson(new Gson().toJson(order), Order.class);
                    tempOrder.order_items = (ArrayList<OrderItem>) entry.getValue();
                    String printSettingName = "";
                    for (int i = 0; i < printSettings.size(); i++) {
                        if (printSettings.get(i).name.equalsIgnoreCase("Prep Ticket") || printSettings.get(i).name.equalsIgnoreCase("Custom Prep Ticket")) {
                            printSettingName = printSettings.get(i).name;
                            printStructure = printSettings.get(i).print_structure;
                            listPrintStructure = printSettings.get(i).list_print_structure;
                            break;
                        }
                    }

                    if (tempOrder.order_items.size() > 0) {
                        if (prepPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                            zoneRichPrinter.connectPrinter(prepPrinter.ip);
                            CommonFunctions.functionThatDelay(200);
                            if (printSettingName.equalsIgnoreCase("Custom Prep Ticket")) {
                                zoneRichPrinter.printOrderEposNewFoodHub(listPrintStructure, myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printStructure, printTotalInPrint, footerA, footerB, footerHeading, settingsMap, true, false, myApp.myPreferences);
                            } else {
                                zoneRichPrinter.printOrderEposNew(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printStructure, printTotalInPrint, footerA, footerB, footerHeading, settingsMap, true, false, myApp.myPreferences);
                            }
                            if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.toLowerCase().equalsIgnoreCase("yes") && prepLocation.cash_draw) {
                                zoneRichPrinter.connectPrinter(prepPrinter.ip);
                                CommonFunctions.functionThatDelay(200);
                                zoneRichPrinter.openCashDrawer();
                            }
                        } else if (prepPrinter.printer_model_name.toLowerCase().contains("t2") || prepPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                            if (printSettingName.equalsIgnoreCase("Custom Prep Ticket")) {
                                if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                                    sunmiPrinterV3Mix.printOrderEposNewFoodHub(listPrintStructure, myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printStructure, printTotalInPrint, footerA, footerB, footerHeading, settingsMap, true, false, myApp.myPreferences);
                                } else {
                                    sunmiPrinter.printOrderEposNewFoodHub(listPrintStructure, myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printStructure, printTotalInPrint, footerA, footerB, footerHeading, settingsMap, true, false, myApp.myPreferences);
                                }
                            } else {
                                if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                                    sunmiPrinterV3Mix.printOrderEposNew(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printStructure, printTotalInPrint, footerA, footerB, footerHeading, settingsMap, true, false, myApp.myPreferences);
                                } else {
                                    sunmiPrinter.printOrderEposNew(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printStructure, printTotalInPrint, footerA, footerB, footerHeading, settingsMap, true, false, myApp.myPreferences);
                                }
                            }
                            if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.toLowerCase().equalsIgnoreCase("yes") && prepLocation.cash_draw) {
                                if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                                    sunmiPrinterV3Mix.openCashDrawer();
                                } else {
                                    sunmiPrinter.openCashDrawer();
                                }
                            }
                        } else if (prepPrinter.printer_model_name.toLowerCase().contains("pos-80") || prepPrinter.printer_model_name.toLowerCase().contains("pos 80") || prepPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                            if (prepPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                                if (printSettingName.equalsIgnoreCase("Custom Prep Ticket")) {
                                    myApp.iMinPrinterUtils.printOrderEposNewFoodHub(listPrintStructure, myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, tempOrder, printStructure, printTotalInPrint, footerA, footerB, footerHeading, settingsMap, true, false);
                                } else {
                                    myApp.iMinPrinterUtils.printOrderEposNew(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printStructure, printTotalInPrint, footerA, footerB, footerHeading, settingsMap, true, false, myApp.myPreferences);
                                }
                                if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.toLowerCase().equalsIgnoreCase("yes") && prepLocation.cash_draw) {
                                    IminSDKManager.opencashBox();
                                }
                            } else {
                                if (prepPrinter.ip != null && !prepPrinter.ip.equalsIgnoreCase("")) {
                                    wifiPrinter.disconnect();
                                    CommonFunctions.functionThatDelay(200);
                                    wifiPrinter.connect(prepPrinter.ip);
                                    CommonFunctions.functionThatDelay(200);
                                    if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.toLowerCase().equalsIgnoreCase("yes") && prepLocation.cash_draw) {
                                        wifiPrinter.openCashDrawer(false);
                                    }
                                    wifiPrinter.printOrderEpos(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printTotalInPrint, footerA, footerB, footerHeading, settingsMap, true, false, myApp.myPreferences);
                                } else {
                                    try {
                                        if (bluetoothPrinter != null) {
                                            BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                            if (device != null) {
                                                CommonFunctions.functionThatDelay(200);
                                                if (buzzerSetting != null && !Validators.isNullOrEmpty(buzzerSetting.value) && buzzerSetting.value.equalsIgnoreCase("yes") && prepLocation.cash_draw) {
                                                    bluetoothPrinter.openCashDrawer(false);
                                                    CommonFunctions.functionThatDelay(200);
                                                }
                                                bluetoothPrinter.printEposOrder(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printTotalInPrint, footerA, footerB, footerHeading, true, false);
                                                CommonFunctions.functionThatDelay(200);
                                            } else {
                                                ToastUtils.makeToast(getActivity(), "No bluetooth device found.");
                                            }
                                        }
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        }
                    }
                }
                if (position >= prepOrderItems.size()) {
                    try {
                        nextMethod.call();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                myApp.isCashDrawerOpen = false;
            } catch (JsonSyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    class OrderItemsPrintBlockAsync extends AsyncTask<Integer, Integer, Integer> {
        String title;
        ArrayList<OrderItem> groupedOrderItems = new ArrayList<>();
        Callable<Void> nextMethod;

        public OrderItemsPrintBlockAsync(String title, Callable<Void> nextMethod) {
            this.title = title;
            this.nextMethod = nextMethod;
        }

        @Override
        protected Integer doInBackground(Integer... integers) {
            try {
                List<OrderItem> miscOrderItems;
                List<OrderItem> productOrderItems;
                int _split_id = 0;
                if (integers.length > 0) {
                    _split_id = integers[0];
                    miscOrderItems = appDatabase.orderItemDao().orderItemsMiscForPrint(order._id, _split_id);
                    productOrderItems = appDatabase.orderItemDao().orderItemProductForPrint(order._id, _split_id);
                } else {
                    miscOrderItems = appDatabase.orderItemDao().orderItemsMiscForPrint(order._id);
                    productOrderItems = appDatabase.orderItemDao().orderItemProductForPrint(order._id);
                }
                if (miscOrderItems != null && miscOrderItems.size() > 0) {
                    groupedOrderItems.addAll(miscOrderItems);
                }

                if (productOrderItems != null && productOrderItems.size() > 0) {
                    groupedOrderItems.addAll(productOrderItems);
                }
                if (_split_id > 0) {
                    OrderSplit orderSplit = appDatabase.orderSplitDao().view(_split_id);
                    order.total = orderSplit.total;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

            return 0;
        }

        @Override
        protected void onPostExecute(Integer integer) {
            super.onPostExecute(integer);
            try {
                Order tempOrder = new Gson().fromJson(new Gson().toJson(order), Order.class);

                tempOrder.order_items = groupedOrderItems;
                String printSettingName = "";
                for (int i = 0; i < printSettings.size(); i++) {
                    if (printSettings.get(i).name.equalsIgnoreCase("Bill") || printSettings.get(i).name.equalsIgnoreCase("Custom Bill")) {
                        printSettingName = printSettings.get(i).name;
                        printStructure = printSettings.get(i).print_structure;
                        listPrintStructure = printSettings.get(i).list_print_structure;
                        break;
                    }
                }

                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                    zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                    CommonFunctions.functionThatDelay(200);
                    if (printSettingName.equalsIgnoreCase("Custom Bill")) {
                        zoneRichPrinter.printOrderEposNewFoodHub(listPrintStructure, myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printStructure, true, footerA, footerB, footerHeading, settingsMap, false, false, myApp.myPreferences);
                    } else {
                        zoneRichPrinter.printOrderEposNew(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printStructure, true, footerA, footerB, footerHeading, settingsMap, false, false, myApp.myPreferences);
                    }
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("t2") || defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                    if (printSettingName.equalsIgnoreCase("Custom Bill")) {
                        if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                            sunmiPrinterV3Mix.printOrderEposNewFoodHub(listPrintStructure, myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printStructure, true, footerA, footerB, footerHeading, settingsMap, false, false, myApp.myPreferences);
                        } else {
                            sunmiPrinter.printOrderEposNewFoodHub(listPrintStructure, myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printStructure, true, footerA, footerB, footerHeading, settingsMap, false, false, myApp.myPreferences);
                        }
                    } else {
                        if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                            sunmiPrinterV3Mix.printOrderEposNew(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printStructure, true, footerA, footerB, footerHeading, settingsMap, false, false, myApp.myPreferences);
                        } else {
                            sunmiPrinter.printOrderEposNew(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printStructure, true, footerA, footerB, footerHeading, settingsMap, false, false, myApp.myPreferences);
                        }
                    }
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                        if (printSettingName.equalsIgnoreCase("Custom Bill")) {
                            myApp.iMinPrinterUtils.printOrderEposNewFoodHub(listPrintStructure, myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, tempOrder, printStructure, true, footerA, footerB, footerHeading, settingsMap, false, false);
                        } else {
                            myApp.iMinPrinterUtils.printOrderEposNew(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printStructure, true, footerA, footerB, footerHeading, settingsMap, false, false, myApp.myPreferences);
                        }
                    } else {
                        if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                            wifiPrinter.disconnect();
                            CommonFunctions.functionThatDelay(100);
                            wifiPrinter.connect(defaultPrinter.ip);
                            CommonFunctions.functionThatDelay(100);
                            wifiPrinter.printOrderEpos(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printTotalInPrint, footerA, footerB, footerHeading, settingsMap, false, false, myApp.myPreferences);
                        } else {
                            try {
                                if (bluetoothPrinter != null) {
                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                    if (device != null) {
                                        CommonFunctions.functionThatDelay(100);
                                        bluetoothPrinter.printEposOrder(myApp.businessLogo, title, (ticketHeaderSetting != null) ? ticketHeaderSetting.value : null, headerAlignment, tableOrOrderIdSetting != null ? tableOrOrderIdSetting.value : null, dateTimeModeInPrint, tempOrder, printTotalInPrint, footerA, footerB, footerHeading, false, false);
                                    } else {
                                        ToastUtils.makeSnackToast(getActivity(), "No bluetooth device found.");
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }

                }
                myApp.isCashDrawerOpen = false;
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } catch (JsonSyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    private void updateViews() {
        try {
            if (order != null && order.customer != null) {

                tvDeliveryTime.setVisibility(View.GONE);
                if (!Validators.isNullOrEmpty(order.order_type)) {
                    if (order.order_status_id.equalsIgnoreCase("10")) {
                        tvOrderPaymentStatus.setText("Order Rejected");
                        btnCancelOrder.setVisibility(View.GONE);
                    } else {
                        if (order.order_type.equalsIgnoreCase("Delivery")) {
                            tvOrderPaymentStatus.setText("Delivered");
                        } else if (order.order_type.equalsIgnoreCase("Collection")) {
                            tvOrderPaymentStatus.setText("Collected");
                        } else if (order.order_type.equalsIgnoreCase("Dine in")) {
                            tvOrderPaymentStatus.setText("Served");
                        } else {
                            tvOrderPaymentStatus.setText("Completed");
                        }
                    }
                }
                //tvOrderNumber.setText("Order #" + (order.id != null ? order.id : order._id));
                tvOrderNumber.setText("Order #" + (!Validators.isNullOrEmpty(order.display_order_id) ? order.display_order_id : order._id));
                tvOrderPaymentStatus.setText(order.order_status);
                if (!Validators.isNullOrEmpty(order.customer.distance)) {
                    tvMiles.setText(order.customer.distance + " Miles Away");
                } else {
                    tvMiles.setVisibility(View.INVISIBLE);
                }
                if (!Validators.isNullOrEmpty(order.customer_name)) {
                    tvCustomerName.setText("Name: " + order.customer_name);
                } else {
                    tvCustomerName.setVisibility(View.GONE);
                }

                if (!Validators.isNullOrEmpty(order.customer.mobile)) {
                    tvPhoneNo.setText("Mobile: " + order.customer.mobile);
                } else {
                    tvPhoneNo.setVisibility(View.GONE);
                }

                if (!Validators.isNullOrEmpty(order.customer.house_no) && !Validators.isNullOrEmpty(order.customer.street) && !Validators.isNullOrEmpty(order.customer.city)) {
                    tvAddress.setText("Delivery Address: " + order.customer.house_no + "," + order.customer.street + "," + order.customer.city);
                } else {
                    tvAddress.setVisibility(View.GONE);
                }

                if (!Validators.isNullOrEmpty(order.comment)) {
                    tvInstructions.setText(order.comment);
                } else {
                    tvInstructionTitle.setVisibility(View.GONE);
                    cvInstructions.setVisibility(View.GONE);
                }

                tvSubTotal.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(order.sub_total)));


                if (order.service_charge > 0) {
                    llServiceCharge.setVisibility(View.VISIBLE);
                    tvServiceCharge.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(order.service_charge)));
                } else {
                    llServiceCharge.setVisibility(View.GONE);
                }

                if (order.delivery_charge > 0) {
                    llDeliveryFee.setVisibility(View.VISIBLE);
                    tvDeliveryFee.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(order.delivery_charge)));
                } else {
                    llDeliveryFee.setVisibility(View.GONE);
                }
                if (order.discount > 0) {
                    llDiscount.setVisibility(View.VISIBLE);
                    tvDiscount.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(order.discount)));
                } else {
                    llDiscount.setVisibility(View.GONE);
                }
                if (order.gratuity > 0) {
                    llGratuity.setVisibility(View.VISIBLE);
                    tvGratuityAmount.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(order.gratuity)));
                } else {
                    llGratuity.setVisibility(View.GONE);
                }

                StringBuilder personalDetails = new StringBuilder();

                if (!Validators.isNullOrEmpty(order.created_at)) {
                    personalDetails = new StringBuilder();
                    personalDetails.append("Ordered at: ");
                    if (order.created_at.contains("Z")) {
                        personalDetails.append(CommonFunctions.formatUnknownDateTime(order.created_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, "dd MMM, hh:mm a"));
                    } else {
                        personalDetails.append(CommonFunctions.formatUnknownDateTime(order.created_at, Constants.PHP_DATE_TIME_FORMAT, "dd MMM, hh:mm a"));
                    }
                    tvOrderDate.setText(personalDetails.toString());
                    tvOrderDate.setVisibility(View.VISIBLE);
                } else {
                    tvOrderDate.setVisibility(View.GONE);
                }

                personalDetails = new StringBuilder();
                if (order_type > 0) {
                    personalDetails.append("Required by: ");
                    personalDetails.append(CommonFunctions.formatUnknownDateTime(order.delivery_date, Constants.PHP_DATE_TIME_FORMAT_ZULU, "hh:mm a"));
                } else {
                    personalDetails = new StringBuilder();
                    personalDetails.append("Served by: ");
                    personalDetails.append("ASAP");
                }
                tvDeliveryTime.setText(personalDetails.toString());

                tvTotal.setText(String.format("%s%s", MyApp.currencySymbol, MyApp.df.format(order.total)));

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            defaultPrinter = myApp.myPreferences.getDefaultPrinter();
            forceFullyDefaultPrinter = myApp.myPreferences.getDefaultPrinter(true);
            zoneRichPrinter = new ZoneRichPrinter(getActivity());
            wifiPrinter = WifiPrinter.getInstance();
            if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                sunmiPrinterV3Mix = new SunmiPrinterV3Mix(requireActivity());
            }
            sunmiPrinter = new SunmiPrinter(getActivity());
            bluetoothPrinter = new BluetoothPrinter(getActivity());
            printers = selectedBusiness.printers;
            llMainLayout = view.findViewById(R.id.llMainLayout);
            ivClose = view.findViewById(R.id.ivClose);
            llLoading = view.findViewById(R.id.llLoading);
            llData = view.findViewById(R.id.llData);
            rvPayment = view.findViewById(R.id.rvPaymentMethods);
            btnPrint = view.findViewById(R.id.btnPrint);
            btnClose = view.findViewById(R.id.btnClose);
            btnCancelOrder = view.findViewById(R.id.btnCancelOrder);
            btnDeleteOrder = view.findViewById(R.id.btnDeleteOrder);
            tvCustomerName = view.findViewById(R.id.tvCustomerName);
            tvPhoneNo = view.findViewById(R.id.tvCustomerMobile);
            tvAddress = view.findViewById(R.id.tvDeliveryAddress);
            tvInstructions = view.findViewById(R.id.tvInstructions);

            rvCartItems = view.findViewById(R.id.rvCartItems);
            tvOrderNumber = view.findViewById(R.id.tvOrderNumber);
            tvOrderPaymentStatus = view.findViewById(R.id.tvOrderPaymentStatus);
            tvOrderDate = view.findViewById(R.id.tvOrderDate);
            tvDeliveryTime = view.findViewById(R.id.tvDeliveryTime);
            tvMiles = view.findViewById(R.id.tvMiles);
            tvTotal = view.findViewById(R.id.tvTotal);

            tvSubTotal = view.findViewById(R.id.tvSubtotal);
            tvServiceCharge = view.findViewById(R.id.tvServiceFee);
            tvDeliveryFee = view.findViewById(R.id.tvDeliveryFee);
            tvDiscount = view.findViewById(R.id.tvDiscount);
            tvGratuityAmount = view.findViewById(R.id.tvGratuityAmount);
            tvInstructionTitle = view.findViewById(R.id.tvInstructionsTitle);
            cvInstructions = view.findViewById(R.id.cvInstruction);


            llDeliveryFee = view.findViewById(R.id.ll_Delivery);
            llDiscount = view.findViewById(R.id.ll_Discount);
            llServiceCharge = view.findViewById(R.id.ll_ServiceCharge);
            llGratuity = view.findViewById(R.id.ll_Gratuity);

            buzzerSetting = myApp.findSetting("open_cash_drawer_after_send_to_kitchen");
            ticketHeaderTypeSetting = myApp.findSetting("ticket_header_type");
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("right")) {
                headerAlignment = 2;
            }
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("center")) {
                headerAlignment = 1;
            }
            ticketHeaderSetting = myApp.findSetting("ticket_header");
            tableOrOrderIdSetting = myApp.findSetting("use_table_number_or_order_number");
            orderDateTimeSetting = myApp.findSetting("date_time_in_receipt_printing");

            if (orderDateTimeSetting != null) {
                dateTimeModeInPrint = orderDateTimeSetting.value;
            }
            footerASetting = myApp.findSetting("footer_a");
            footerBSetting = myApp.findSetting("footer_b");

            if (footerASetting != null) {
                footerA = footerASetting.value;
            }
            if (footerBSetting != null) {
                footerB = footerBSetting.value;
            }
            if (order != null) {
                if (!Validators.isNullOrEmpty(order.order_type_id) && order.order_type_id.equalsIgnoreCase("2")) {
                    footerOrderTypeSetting = myApp.findSetting("footer_takeaway");
                } else if (!Validators.isNullOrEmpty(order.order_type_id) && order.order_type_id.equalsIgnoreCase("3")) {
                    footerOrderTypeSetting = myApp.findSetting("footer_delivery");
                } else if (!Validators.isNullOrEmpty(order.order_type_id) && order.order_type_id.equalsIgnoreCase("5")) {
                    footerOrderTypeSetting = myApp.findSetting("footer_waiting");
                } else {
                    if (!Validators.isNullOrEmpty(order.order_type_id) && order.order_type_id.equalsIgnoreCase("1")) {
                        footerOrderTypeSetting = myApp.findSetting("footer_dinein");
                    }
                }
            }
            if (footerOrderTypeSetting != null) {
                footerHeading = footerOrderTypeSetting.value;
            }
            paidPaymentSetting = myApp.findSetting("paid_payment_title");
            unpaidPaymentSetting = myApp.findSetting("unpaid_payment_title");
            partialPaymentSetting = myApp.findSetting("partial_payment_title");
            cardPaymentSetting = myApp.findSetting("card_payment_type");
            cashPaymentSetting = myApp.findSetting("cash_payment_type");

            settingsMap.put("paid_payment_title", paidPaymentSetting.value);
            settingsMap.put("unpaid_payment_title", unpaidPaymentSetting.value);
            settingsMap.put("partial_payment_title", partialPaymentSetting.value);
            settingsMap.put("card_payment_type", cardPaymentSetting.value);
            settingsMap.put("cash_payment_type", cashPaymentSetting.value);

            totalVisibilitySetting = myApp.findSetting("kitchen_total_visible");
            if (totalVisibilitySetting != null && (totalVisibilitySetting.value.equalsIgnoreCase("no") || totalVisibilitySetting.value.equalsIgnoreCase("false") || totalVisibilitySetting.value.equalsIgnoreCase("0"))) {
                printTotalInPrint = false;
            }
            serviceChargeEnableSetting = myApp.findSetting("is_service_charge");
            serviceChargeSetting = myApp.findSetting("service_charge");
            serviceChargeOptionSetting = myApp.findSetting("service_charge_type_option");
            serviceChargeTypeSetting = myApp.findSetting("service_charge_type");

            if (serviceChargeEnableSetting != null && (serviceChargeEnableSetting.value.equalsIgnoreCase("true") || serviceChargeEnableSetting.value.equalsIgnoreCase("1"))) {
                serviceChargeEnabled = true;
            }
            if (serviceChargeEnabled && serviceChargeOptionSetting != null && serviceChargeOptionSetting.value.equalsIgnoreCase("manual")) {
                serviceChargeAutoMode = false;
            }

            if (MyApp.userPermission != null && MyApp.userPermission.cancel_order.actions.list) {
                if (MyApp.userPermission.cancel_order_after_payment.actions.list)
                    btnCancelOrder.setVisibility(View.VISIBLE);
                else
                    btnCancelOrder.setVisibility(View.GONE);
            } else {
                btnCancelOrder.setVisibility(View.GONE);
            }

            if (MyApp.userPermission != null && MyApp.userPermission.delete_order.actions.list) {
                if (MyApp.userPermission.cancel_order_after_payment.actions.list)
                    btnDeleteOrder.setVisibility(View.VISIBLE);
                else
                    btnDeleteOrder.setVisibility(View.GONE);
            } else {
                btnDeleteOrder.setVisibility(View.GONE);
            }

            rvCartItems.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
            productItemsAdapter = new EposOrderedProductItemsAdapter(objects, true, new RecyclerviewItemClickListenerWithTag() {
                @Override
                public void onItemClick(int position, String tag, Object data) {
                    OrderSplit split = (OrderSplit) data;
                    if (split.selected) {
                        selectedSplit = split;
                    } else {
                        selectedSplit = null;
                    }
                    new FetchOrderOfflineAsyncTask(() -> {
                        productItemsAdapter.notifyDataSetChanged();
                        return null;
                    }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                }
            });
            rvCartItems.setNestedScrollingEnabled(false);
            rvCartItems.setAdapter(productItemsAdapter);


            paymentsAdapter = new OrderPaymentsAdapter(orderPayments, true);
            rvPayment.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
            rvPayment.setNestedScrollingEnabled(false);
            rvPayment.setAdapter(paymentsAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchOffline() {
        try {
            new FetchOrderOfflineAsyncTask(() -> {
                try {
                    updateViews();
                    productItemsAdapter.notifyDataSetChanged();
                    paymentsAdapter.notifyDataSetChanged();
                } catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class FetchOrderOfflineAsyncTask extends AsyncTask<Object, Object, Object> {
        Callable<Void> nextMethod;

        public FetchOrderOfflineAsyncTask(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected Object doInBackground(Object... object) {
            try {
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        llLoading.setVisibility(View.VISIBLE);
                        llData.setVisibility(View.INVISIBLE);
                    });
                }

                orderWithItems = myApp.appDatabase.orderDao().orderWithItems(_order_id);
                if (orderWithItems != null) {
                    order = orderWithItems.order;
                    order.total_paid = myApp.appDatabase.orderPaymentDao().getTotalPaidAmount(_order_id);
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("1")) {
                        order.order_type = "Dine in";
                    }
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("2")) {
                        order.order_type = "Collection";
                    }
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("3")) {
                        order.order_type = "Delivery";
                    }
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("4")) {
                        order.order_type = "Bar";
                    }
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("5")) {
                        order.order_type = "Waiting";
                    }

                    if (!Validators.isNullOrEmpty(order.table_id))
                        order.table_number = appDatabase.tableDao().view(order.table_id).number;
                    order.order_payments = (ArrayList<OrderPayment>) orderWithItems.orderPayments;
                    orderPayments.clear();
                    orderPayments.addAll(order.order_payments);

                    order.order_splits = (ArrayList<OrderSplit>) orderWithItems.orderSplits;

                    order.order_items = new ArrayList<>();
                    orderItems.clear();
                    HashMap<OrderSplit, List<OrderItem>> orderItemsWithSplitId = new HashMap<>();
                    try {
                        for (OrderItemWithAddonsIngredients item : orderWithItems.orderItems) {
                            OrderItem orderItem = item.orderItem;
                            orderItem.order_item_addons = (ArrayList<OrderItemAddon>) item.orderItemAddons;
                            orderItem.order_item_ingredients = (ArrayList<OrderItemIngredient>) item.orderItemIngredients;
                            order.order_items.add(orderItem);
                            if (orderItem._order_split_id == 0) {
                                orderItems.add(orderItem);
                            } else {
                                OrderSplit split = new OrderSplit();
                                split._id = orderItem._order_split_id;
                                List<OrderItem> splitOrderItems = new ArrayList<>();
                                if (selectedSplit != null && split._id == selectedSplit._id) {
                                    if (orderItemsWithSplitId.containsKey(split)) {
                                        splitOrderItems = orderItemsWithSplitId.get(split);
                                    }
                                    splitOrderItems.add(orderItem);
                                }
                                orderItemsWithSplitId.put(split, splitOrderItems);
                            }
                        }
                        Collections.reverse(orderItems);
                        if (!Validators.isNullOrEmpty(order.split_type) && order.split_type.equalsIgnoreCase("order_item")) {
                            //We will show none splitted items first.
                            objects.clear();
                            objects.addAll(orderItems);

                            for (Map.Entry<OrderSplit, List<OrderItem>> entry : orderItemsWithSplitId.entrySet()) {

                                OrderSplit split = appDatabase.orderSplitDao().view(entry.getKey()._id);
                                if (selectedSplit != null && split._id == selectedSplit._id) {
                                    split.selected = true;
                                }
                                LogUtils.e("ONREFRESH : SPLIT: " + new Gson().toJson(split));
                                objects.add(split);
                                objects.addAll(entry.getValue());
                            }
                        } else {
                            objects.clear();
                            objects.addAll(orderItems);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    cartDiscount = order.discount;
                    cartServiceCharge = order.service_charge;
                    order.customer = myApp.appDatabase.customerDao().view(order._customer_id);
                    if (order.customer == null) {
                        order.customer = myApp.appDatabase.customerDao().view(order.customer_id);
                    }

                    order.total = order.sub_total + order.gratuity - order.discount + order.service_charge + order.delivery_charge;
                    ;
                    myApp.setOrderItems(orderItems);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Object s) {
            super.onPostExecute(s);
            try {
                if (order != null) {
                    if (nextMethod != null) {
                        try {
                            nextMethod.call();
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    llLoading.setVisibility(View.GONE);
                                    llData.setVisibility(View.VISIBLE);
                                });
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    if (getActivity() != null) {
                        getActivity().runOnUiThread(() -> {
                            llLoading.setVisibility(View.INVISIBLE);
                            llData.setVisibility(View.INVISIBLE);
                        });
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

}
