package com.ubsidi.epos_2021.fragment;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.FragmentTransaction;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.Priority;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.checkbox.MaterialCheckBox;
import com.google.gson.Gson;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.activities.NewOrderActivity;
import com.ubsidi.epos_2021.adapters.EposOrdersAdapter;
import com.ubsidi.epos_2021.adapters.EposOrdersAdapterTheme2;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.models.Header;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.OrderSplit;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.services.SingleOrderUploaderService;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.InternetUtils;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class EposOrdersFragment extends BaseFragment {
    private EposOrdersAdapter eposOrdersAdapter;
    private EposOrdersAdapterTheme2 eposOrdersAdapterTheme2;
    SiteSetting homeTheme = myApp.findSetting("home_theme");

    private final ArrayList<Object> objects = new ArrayList<>();
    private final ArrayList<Integer> selectedOrderIds = new ArrayList<>();
    private String orderTypeId;
    private TextView tvErrorMessage;
    private SwipeRefreshLayout swipeRefreshLayout;
    private DbSaverAsync dbSaverAsync;
    private LinearLayout llOrderHistory, llArchivedOrders;
    private MaterialCardView cvArchiveAction;
    private TextView tvSelectedOrders;
    private MaterialButton btnCancel, btnConfirm;
    private boolean isArchived = false, isFromNotification = false;
    private TextView tvSelect;
    private AlertDialog progressDialog;
    private boolean refreshOnResume = true;
    private RecyclerView rvOrders;
    private boolean fromTheme2;
    private TextView tvAction;
    private MaterialCheckBox cbSelectAll;
    public boolean showCompletedOrders = true;
    public boolean showPaidOrders = false;
    private boolean isAllSelected = false;
    private boolean orderCompleteAuto;
    int failedOrderCount = 0;

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getArguments() != null) {
            orderTypeId = getArguments().getString("order_type_id");
            fromTheme2 = getArguments().getBoolean("from_theme2", false);
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_orders, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            dbSaverAsync = new DbSaverAsync();
            setListener();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            SiteSetting orderCompleteMode = myApp.findSetting("order_complete_mode");
            if (orderCompleteMode != null && !Validators.isNullOrEmpty(orderCompleteMode.value) && (orderCompleteMode.value.toLowerCase().equalsIgnoreCase("auto") || orderCompleteMode.value.toLowerCase().equalsIgnoreCase("1") || orderCompleteMode.value.toLowerCase().equalsIgnoreCase("yes"))) {
                orderCompleteAuto = true;
            }
            progressDialog = CommonFunctions.customProgressDialog(getActivity());
            swipeRefreshLayout = view.findViewById(R.id.swipeRefreshLayout);
            tvErrorMessage = view.findViewById(R.id.tvErrorMessage);
            llOrderHistory = view.findViewById(R.id.llOrderHistoryOrders);
            llArchivedOrders = view.findViewById(R.id.llArchivedOrders);
            tvSelect = view.findViewById(R.id.tvSelect);
            cvArchiveAction = view.findViewById(R.id.cvArchiveAction);
            tvSelectedOrders = view.findViewById(R.id.tvSelectedOrders);
            btnConfirm = view.findViewById(R.id.btnConfirm);
            btnCancel = view.findViewById(R.id.btnCancel);
            rvOrders = view.findViewById(R.id.rvItems);
            tvAction = view.findViewById(R.id.tvMarkServed);
            cbSelectAll = view.findViewById(R.id.cbSelectAll);

            tvAction.setVisibility(View.GONE);
            cvArchiveAction.setVisibility(View.GONE);

            SiteSetting showCompletedOrdersSiteSetting = myApp.findSetting("show_completed_orders");
            showCompletedOrders = showCompletedOrdersSiteSetting != null && showCompletedOrdersSiteSetting.value != null && (showCompletedOrdersSiteSetting.value.equalsIgnoreCase("true") || showCompletedOrdersSiteSetting.value.equalsIgnoreCase("1"));

            if (homeTheme != null && !Validators.isNullOrEmpty(homeTheme.value) && homeTheme.value.equalsIgnoreCase("theme3")) {
                eposOrdersAdapter = new EposOrdersAdapter(objects, fromTheme2, isAllSelected, (position, data) -> {
                    if (eposOrdersAdapter.showCheck) {
                        try {
                            if (data != null) {
                                if (data instanceof Order)
                                    orderSelectionHandle(position, (Order) data);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        if (((Order) data).order_status_id.equalsIgnoreCase("5") || ((Order) data).order_status_id.equalsIgnoreCase("10")) {
                            EposCompletedOrderOverviewBottomSheet eposCompletedOrderOverviewBottomSheet = getInstanceEposCompletedOrderOverview(((Order) data)._id);
                            eposCompletedOrderOverviewBottomSheet.show(getChildFragmentManager(), "view");
                        } else
                            startActivityForResult(new Intent(getActivity(), NewOrderActivity.class)
                                            .putExtra("order", new Gson().toJson(data))
                                    , Constants.CODE_REFRESH);
                    }
                }, (position, data) -> {
                    if (data instanceof Order) {
                        try {
                            if (((Order) data).order_status_id.equalsIgnoreCase("5") || ((Order) data).order_status_id.equalsIgnoreCase("10")) {
                                EposCompletedOrderOverviewBottomSheet eposCompletedOrderOverviewBottomSheet = getInstanceEposCompletedOrderOverview(((Order) data)._id);
                                eposCompletedOrderOverviewBottomSheet.show(getChildFragmentManager(), "view");
                            } else {
                                handleAction(position, data);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }, (position, tag, data) -> {
                    //homelistener
                    String action = tag;
                    Order order = (Order) data;
                    Log.e("Order_id", "" + order.id + " " + order._id);

                    if (action.equalsIgnoreCase("complete_order")) {
                        try {
                            order.order_status_id = "5";
                            order.order_status = "Order Completed";
                            order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                            new Thread(() -> {
                                appDatabase.orderDao().update(order);
                            }).start();
                            eposOrdersAdapter.notifyItemChanged(position);
                            Intent intent = new Intent(getActivity(), SingleOrderUploaderService.class);
                            intent.putExtra("_order_id", order._id);
                            getActivity().startService(intent);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        //Show snackbar if require
                    } else if (action.equalsIgnoreCase("pay_order")) {
                        startActivityForResult(new Intent(getActivity(), NewOrderActivity.class).putExtra("order", new Gson().toJson(data)).putExtra("destination", "pay_bill"), Constants.CODE_REFRESH);
                    } else if (action.equalsIgnoreCase("ready_to_action")) {
                        try {
                            Log.e("Order", "" + order.id);
                            if (String.valueOf(order.id) == null || String.valueOf(order.id).isEmpty()) {
                            } else {
                                SendNotificationToUser(String.valueOf(order.id));
                            }

                            order.order_status_id = "6";
                            order.order_status = "Order In Transit";
                            order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                            new Thread(() -> {
                                appDatabase.orderDao().update(order);
                            }).start();
                            eposOrdersAdapter.notifyItemChanged(position);
                            Intent intent = new Intent(getActivity(), SingleOrderUploaderService.class);
                            intent.putExtra("_order_id", order._id);
                            getActivity().startService(intent);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        //Show snackbar if require
                    } else {
                        LogUtils.e("actions::" + action);
                    }
                });
            } else {
                eposOrdersAdapterTheme2 = new EposOrdersAdapterTheme2(objects, fromTheme2, isAllSelected, (position, data) -> {
                    if (eposOrdersAdapterTheme2.showCheck) {
                        try {
                            if (data != null) {
                                if (data instanceof Order)
                                    orderSelectionHandle(position, (Order) data);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        if (((Order) data).order_status_id.equalsIgnoreCase("5") || ((Order) data).order_status_id.equalsIgnoreCase("10")) {
                            EposCompletedOrderOverviewBottomSheet eposCompletedOrderOverviewBottomSheet = getInstanceEposCompletedOrderOverview(((Order) data)._id);
                            eposCompletedOrderOverviewBottomSheet.show(getChildFragmentManager(), "view");
                        } else
                            startActivityForResult(new Intent(getActivity(), NewOrderActivity.class)
                                            .putExtra("order", new Gson().toJson(data))
                                    , Constants.CODE_REFRESH);
                    }
                }, (position, data) -> {
                    if (data instanceof Order) {
                        try {
                            if (((Order) data).order_status_id.equalsIgnoreCase("5") || ((Order) data).order_status_id.equalsIgnoreCase("10")) {
                                EposCompletedOrderOverviewBottomSheet eposCompletedOrderOverviewBottomSheet = getInstanceEposCompletedOrderOverview(((Order) data)._id);
                                eposCompletedOrderOverviewBottomSheet.show(getChildFragmentManager(), "view");
                            } else {
                                handleAction(position, data);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }, (position, tag, data) -> {
                    //homelistener
                    String action = tag;
                    Order order = (Order) data;
                    Log.e("Order_id", "" + order.id + " " + order._id);

                    if (action.equalsIgnoreCase("complete_order")) {
                        try {
                            order.order_status_id = "5";
                            order.order_status = "Order Completed";
                            order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                            new Thread(() -> {
                                appDatabase.orderDao().update(order);
                            }).start();
                            eposOrdersAdapterTheme2.notifyItemChanged(position);
                            Intent intent = new Intent(getActivity(), SingleOrderUploaderService.class);
                            intent.putExtra("_order_id", order._id);
                            getActivity().startService(intent);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        //Show snackbar if require
                    } else if (action.equalsIgnoreCase("pay_order")) {
                        startActivityForResult(new Intent(getActivity(), NewOrderActivity.class).putExtra("order", new Gson().toJson(data)).putExtra("destination", "pay_bill"), Constants.CODE_REFRESH);
                    } else if (action.equalsIgnoreCase("ready_to_action")) {
                        try {
                            Log.e("Order", "" + order.id);
                            if (String.valueOf(order.id) == null || String.valueOf(order.id).isEmpty()) {
                            } else {
                                SendNotificationToUser(String.valueOf(order.id));
                            }

                            order.order_status_id = "6";
                            order.order_status = "Order In Transit";
                            order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                            new Thread(() -> {
                                appDatabase.orderDao().update(order);
                            }).start();
                            eposOrdersAdapterTheme2.notifyItemChanged(position);
                            Intent intent = new Intent(getActivity(), SingleOrderUploaderService.class);
                            intent.putExtra("_order_id", order._id);
                            getActivity().startService(intent);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        //Show snackbar if require
                    } else {
                        LogUtils.e("actions::" + action);
                    }
                });
            }

            int spanCount = getActivity().getResources().getInteger(R.integer.epos_orders_span);
            if (homeTheme != null && !Validators.isNullOrEmpty(homeTheme.value) && homeTheme.value.equalsIgnoreCase("theme3")) {
                if (myApp.screenWidth > 1900) {
                    spanCount = 5;
                } else if (myApp.screenWidth > 1200) {
                    spanCount = 4;
                }
            }
            GridLayoutManager gridLayoutManager = new GridLayoutManager(getActivity(), spanCount);
            int finalSpanCount = spanCount;
            gridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup() {
                @Override
                public int getSpanSize(int position) {
                    if (objects.size() > 0 && objects.get(position) instanceof Order) {
                        return 1;
                    } else {
                        return finalSpanCount;
                    }
                }
            });
            rvOrders.setLayoutManager(gridLayoutManager);
            if (homeTheme != null && !Validators.isNullOrEmpty(homeTheme.value) && homeTheme.value.equalsIgnoreCase("theme3")) {
                rvOrders.setAdapter(eposOrdersAdapter);
            } else {
                rvOrders.setAdapter(eposOrdersAdapterTheme2);
            }
            if (fromTheme2) {
                llOrderHistory.setVisibility(View.GONE);
                llArchivedOrders.setVisibility(View.GONE);
            } else {
                if (MyApp.userPermission != null && MyApp.userPermission.order_history.actions.list) {
                    llOrderHistory.setVisibility(View.VISIBLE);
                } else {
                    llOrderHistory.setVisibility(View.GONE);
                }
                if (MyApp.userPermission != null && MyApp.userPermission.archive_order.actions.list) {
                    llArchivedOrders.setVisibility(View.VISIBLE);
                } else {
                    llArchivedOrders.setVisibility(View.GONE);
                }
            }

            setActionText();
            if (orderCompleteAuto) {
                tvAction.setVisibility(View.GONE);
                tvSelect.setVisibility(View.GONE);
            }
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
    }


    private void SendNotificationToUser(String order_id) {
        try {
            LogUtils.e("Send notification to user");
            Log.e("Url", "" + ApiEndPoints.orders + order_id + ApiEndPoints.READ_TO_COLLECT);
            AndroidNetworking.post(ApiEndPoints.orders + order_id + ApiEndPoints.READ_TO_COLLECT)
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            Log.e("Response", "Error : " + response);
                        }

                        @Override
                        public void onError(ANError anError) {
                            Log.e("Response", "Error : " + anError.getMessage());
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void setActionText() {
        try {
            if (orderTypeId.equalsIgnoreCase("3")) {
                tvAction.setText("Mark as delivered");
                btnConfirm.setText("Mark as delivered");
            } else if (orderTypeId.equalsIgnoreCase("2")) {
                tvAction.setText("Mark as collected");
                btnConfirm.setText("Mark as collected");
            } else if (orderTypeId.equalsIgnoreCase("1")) {
                tvAction.setText("Mark as served");
                btnConfirm.setText("Mark as served");
            } else if (orderTypeId.equalsIgnoreCase("5")) {
                tvAction.setText("Mark as collected");
                btnConfirm.setText("Mark as collected");
            } else {
                tvAction.setText("Mark as Completed");
                btnConfirm.setText("Mark as Completed");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showSelectAll(boolean showBtn) {
        try {
            if (fromTheme2 && showBtn) {
                cbSelectAll.setVisibility(View.VISIBLE);
            } else {
                cbSelectAll.setVisibility(View.GONE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void orderSelectionHandle(int position, Order order) {
        try {
            if (order.selected) {
                if (!selectedOrderIds.contains(order._id)) {
                    selectedOrderIds.add(order._id);
                }
            } else {
                int index = selectedOrderIds.indexOf(order._id);
                if (index != -1)
                    selectedOrderIds.remove(index);
            }
            if (selectedOrderIds.size() > 0) {
                tvSelectedOrders.setText(selectedOrderIds.size() + " orders selected");
                if (fromTheme2) {
                    tvAction.setVisibility(View.VISIBLE);
                    cvArchiveAction.setVisibility(View.GONE);
                } else {
                    cvArchiveAction.setVisibility(View.VISIBLE);
                    tvAction.setVisibility(View.GONE);
                }
            } else {
                cvArchiveAction.setVisibility(View.GONE);
                tvAction.setVisibility(View.GONE);
            }
            try {
                rvOrders.post(() -> {
                    if (homeTheme != null && !Validators.isNullOrEmpty(homeTheme.value) && homeTheme.value.equalsIgnoreCase("theme3")) {
                        eposOrdersAdapter.notifyDataSetChanged();
                    } else {
                        eposOrdersAdapterTheme2.notifyDataSetChanged();
                    }
                });
            } catch (Exception e) {
                e.printStackTrace();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleAction(int position, Object data) {
        try {
            Order order = (Order) data;
            Log.e("Order_id", "" + order.order_type_id);

            if (MyApp.df.format(order.total).equalsIgnoreCase(MyApp.df.format(order.total_paid)) || order.total_paid >= order.total) {
                order.order_status_id = "5";
                order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                new Thread(() -> {
                    appDatabase.orderDao().update(order);
                }).start();
                if (homeTheme != null && !Validators.isNullOrEmpty(homeTheme.value) && homeTheme.value.equalsIgnoreCase("theme3")) {
                    eposOrdersAdapter.notifyItemChanged(position);
                }else {
                    eposOrdersAdapterTheme2.notifyItemChanged(position);
                }
                Intent intent = new Intent(getActivity(), SingleOrderUploaderService.class);
                intent.putExtra("_order_id", order._id);
                getActivity().startService(intent);
            } else {
                startActivityForResult(new Intent(getActivity(), NewOrderActivity.class).putExtra("order", new Gson().toJson(data)).putExtra("destination", "pay_bill"), Constants.CODE_REFRESH);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListener() {

        try {
            rvOrders.addOnScrollListener(new RecyclerView.OnScrollListener() {
                @Override
                public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                    int topRowVerticalPosition =
                            (recyclerView == null || recyclerView.getChildCount() == 0) ? 0 : recyclerView.getChildAt(0).getTop();
                    swipeRefreshLayout.setEnabled(topRowVerticalPosition >= 0);

                }
            });
            swipeRefreshLayout.setOnRefreshListener(this::fetchOrders);
            llOrderHistory.setOnClickListener(view -> {
                try {
                    FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
                    ft.replace(R.id.nav_host_fragment, getInstanceEposOrdersHistory(orderTypeId, false), "all_orders");
                    ft.addToBackStack("let_go_back");
                    ft.commit();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            llArchivedOrders.setOnClickListener(view -> {
                try {
                    FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
                    ft.replace(R.id.nav_host_fragment, getInstanceEposOrdersHistory(orderTypeId, true), "all_archived_orders");
                    ft.addToBackStack("let_go_back");
                    ft.commit();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            tvSelect.setOnClickListener(view -> {
                try {
                    isAllSelected = false;
                    if (homeTheme != null && !Validators.isNullOrEmpty(homeTheme.value) && homeTheme.value.equalsIgnoreCase("theme3")) {
                        eposOrdersAdapter.showCheck = !eposOrdersAdapter.showCheck;
                        try {
                            eposOrdersAdapter.notifyDataSetChanged();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (eposOrdersAdapter.showCheck) {
                            showSelectAll(true);
                            tvSelect.setText("Cancel");
                        } else {
                            showSelectAll(false);
                            tvSelect.setText("Select");
                            cbSelectAll.setChecked(false);
                            unSelectAll();
                        }
                    }else {
                        eposOrdersAdapterTheme2.showCheck = !eposOrdersAdapterTheme2.showCheck;
                        try {
                            eposOrdersAdapterTheme2.notifyDataSetChanged();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (eposOrdersAdapterTheme2.showCheck) {
                            showSelectAll(true);
                            tvSelect.setText("Cancel");
                        } else {
                            showSelectAll(false);
                            tvSelect.setText("Select");
                            cbSelectAll.setChecked(false);
                            unSelectAll();
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            tvAction.setOnClickListener(v -> {
                LogUtils.e("selectedOrderIds size: " + selectedOrderIds.size());
                bulkCompleteOrder();
            });
            btnCancel.setOnClickListener(view -> {
                tvSelect.performClick();
            });
            btnConfirm.setOnClickListener(view -> {
                //            performArchiveUnArchive();
                bulkCompleteOrder();
            });

            cbSelectAll.setOnCheckedChangeListener((buttonView, isChecked) -> {
                selectAllOrders(isChecked);
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EposOrdersHistoryFragment getInstanceEposOrdersHistory(String typeId, boolean isArchived) {
        Bundle bundle = new Bundle();
        EposOrdersHistoryFragment fragment = new EposOrdersHistoryFragment();
        bundle.putString("order_type_id", typeId);
        bundle.putBoolean("is_archived", isArchived);
        fragment.setArguments(bundle);
        return fragment;
    }

    private void selectAllOrders(boolean isSelected) {
        try {
            selectedOrderIds.clear();
            for (Object object : objects) {
                if (object instanceof Order) {
                    Order order = (Order) object;
                    if (isSelected) {
                        order.selected = CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1 && (!order.order_status_id.equalsIgnoreCase("5") && !order.order_status_id.equalsIgnoreCase("10"));
                        if (order.selected) {
                            selectedOrderIds.add(order._id);
                        } else {
                            int index = selectedOrderIds.indexOf(order._id);
                            if (index != -1)
                                selectedOrderIds.remove(index);
                        }
                    } else {
                        order.selected = false;
                    }
                }
            }
            if (selectedOrderIds.size() > 0) {
                tvAction.setVisibility(View.VISIBLE);
            } else {
                tvAction.setVisibility(View.GONE);
            }
            if (homeTheme != null && !Validators.isNullOrEmpty(homeTheme.value) && homeTheme.value.equalsIgnoreCase("theme3")) {
                eposOrdersAdapter.notifyDataSetChanged();
            }else {
                eposOrdersAdapterTheme2.notifyDataSetChanged();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void bulkCompleteOrder() {
        try {
            if (getActivity() != null && orderUpdateReceiver != null) {
                LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(orderUpdateReceiver);
            }
            OrdersBulkActionPerformDialogFragment ordersBulkActionPerformDialogFragment = getInstanceOrdersBulkAction(tvAction.getText().toString(), "complete_orders", selectedOrderIds);
            ordersBulkActionPerformDialogFragment.show(getChildFragmentManager(), "upload");
            ordersBulkActionPerformDialogFragment.setDialogDismissListener(o -> {
                fetchOrders();
                if (getActivity() != null && orderUpdateReceiver != null)
                    LocalBroadcastManager.getInstance(getActivity()).registerReceiver(orderUpdateReceiver, new IntentFilter(
                            Constants.EPOS_ORDER_UPDATE));
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void performArchiveUnArchive() {
        if (MyApp.userPermission != null && MyApp.userPermission.archive_order.actions.list) {
            new Thread(() -> {
                appDatabase.orderDao().archiveStatus(selectedOrderIds, !isArchived);
                List<String> onlineIds = appDatabase.orderDao().onlineIds(selectedOrderIds);
                if (myApp.isConnected(getActivity()) && "auto".equalsIgnoreCase(myPreferences.getOrderSyncMode())) {
                    uploadArchiveStatus(onlineIds);
                } else {
                    if (getActivity() != null) getActivity().runOnUiThread(() -> fetchOrders());
                }
            }).start();
        } else {
            tvSelect.setVisibility(View.GONE);
        }
    }

    private void uploadArchiveStatus(List<String> onlineIds) {
        try {
            if (getActivity() != null) getActivity().runOnUiThread(() -> progressDialog.show());
            String url = ApiEndPoints.archive_orders;
            if (isArchived) {
                url = ApiEndPoints.unarchive_orders;
            }
            AndroidNetworking.post(url)
                    .addBodyParameter("ids", new Gson().toJson(onlineIds))
                    .build()
                    .getAsObject(Object.class, new ParsedRequestListener() {
                        @Override
                        public void onResponse(Object response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        progressDialog.dismiss();
                                        fetchOrders();
                                    });
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (getActivity() != null)
                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                anError.printStackTrace();
                                if (anError.getErrorCode() == 400) {
                                    ToastUtils.makeSnackToast(getActivity(), anError.getErrorAsObject(ApiError.class).getMessage());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void unSelectAll() {
        try {
            for (Object object : objects) {
                if (object instanceof Order) {
                    ((Order) object).selected = false;
                }
            }
            selectedOrderIds.clear();
            tvSelectedOrders.setText("0 orders selected");
            cvArchiveAction.setVisibility(View.GONE);
            tvAction.setVisibility(View.GONE);
            try {
                if (homeTheme != null && !Validators.isNullOrEmpty(homeTheme.value) && homeTheme.value.equalsIgnoreCase("theme3")) {
                    eposOrdersAdapter.notifyDataSetChanged();
                }else {
                    eposOrdersAdapterTheme2.notifyDataSetChanged();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchByOrderId(String orderId) {
        try {
            if (getActivity() != null && myApp.isConnected(getActivity()) && "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode())) {
                // display data from local while api calling is running
               /* dbSaverAsync = new DbSaverAsync();
                dbSaverAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new ArrayList<>(), false);*/
                // fetch online order
                fetchOrdersById(orderId);
            } else {
                dbSaverAsync = new DbSaverAsync();
                dbSaverAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new ArrayList<>(), false);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchOrders() {
        try {
            if (getActivity() != null && myApp.isConnected(getActivity()) && "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode())) {
                // display data from local while api calling is running
                dbSaverAsync = new DbSaverAsync();
                dbSaverAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new ArrayList<>(), false);
                // fetch online order
                fetchOnlineOrders();
            } else {
                dbSaverAsync = new DbSaverAsync();
                dbSaverAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new ArrayList<>(), false);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HashMap<String, String> getOrdersParameters(Order latestOrder, Calendar calendar) {
        HashMap<String, String> params = new HashMap<>();
        Calendar fromCalendar = Calendar.getInstance();
        fromCalendar.add(Calendar.DATE, -1);
        Calendar toCalendar = Calendar.getInstance();

        String updated_at = (latestOrder != null && latestOrder.updated_at != null) ? CommonFunctions.formatUnknownDateTime(latestOrder.updated_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, Constants.PHP_DATE_TIME_FORMAT) : CommonFunctions.convertMsToDesiredFormat(calendar.getTimeInMillis(), Constants.PHP_DATE_TIME_FORMAT);
        Date updatedDate = CommonFunctions.convertToDate(updated_at, Constants.PHP_DATE_TIME_FORMAT);
        Calendar updatedAtCalendar = Calendar.getInstance();
        updatedAtCalendar.setTime(updatedDate);
        updatedAtCalendar.add(Calendar.HOUR_OF_DAY, -4);
        updated_at = CommonFunctions.formatMiliToDesireFormat(updatedAtCalendar.getTimeInMillis(), Constants.PHP_DATE_TIME_FORMAT);

        LogUtils.e("Fetching after updated " + updated_at);
        params.put("archived", isArchived ? "1" : "0");
        params.put("nopaginate", "1");
//        params.put("screen", "dashboard");
        params.put("from_date", CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd"));
        params.put("from_updated_at", updated_at);
        params.put("to_date", CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd"));
        if (!Validators.isNullOrEmpty(orderTypeId) && !orderTypeId.equalsIgnoreCase("0")) {
            params.put("order_type_id", orderTypeId);
        }
        return params;
    }

    private void fetchOrdersById(String orderId) {

        try {
            tvErrorMessage.setVisibility(View.GONE);
            swipeRefreshLayout.setVisibility(View.VISIBLE);
            swipeRefreshLayout.setRefreshing(true);
            new Thread(() -> {
                AndroidNetworking.get(ApiEndPoints.orders + orderId)
                        .setPriority(Priority.IMMEDIATE)
                        .build()
                        .getAsObject(Order.class, new ParsedRequestListener<Order>() {
                            @Override
                            public void onResponse(Order response) {
                                try {
                                    LogUtils.e("EposOrdersFragment", "API CALL response avyo " + response);
                                    List<Order> orderList = new ArrayList<>();
                                    orderList.add(response);
                                    dbSaverAsync = new DbSaverAsync();
                                    dbSaverAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, orderList);
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }

                            @Override
                            public void onError(ANError anError) {
                                try {
                                    anError.printStackTrace();
                                    boolean shouldDelete = false;
                                    if (anError.getErrorCode() == 400) shouldDelete = true;
                                    if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                        swipeRefreshLayout.setRefreshing(false);
                                    });

                                    dbSaverAsync = new DbSaverAsync();
                                    dbSaverAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new ArrayList<>(), shouldDelete);
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }

                            }
                        });
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void fetchOnlineOrders() {

        try {
            tvErrorMessage.setVisibility(View.GONE);
            swipeRefreshLayout.setVisibility(View.VISIBLE);
            swipeRefreshLayout.setRefreshing(true);
            LogUtils.e("ORDERS", "API CALL");
            Calendar calendar = Calendar.getInstance();
            calendar.add(Calendar.DATE, -2);
            new Thread(() -> {
                Order latestOrder;
                if (Validators.isNullOrEmpty(orderTypeId)) {
                    latestOrder = appDatabase.orderDao().lastUpdatedOrder();
                } else {
                    latestOrder = appDatabase.orderDao().lastUpdatedOrder(orderTypeId);
                }
                if (latestOrder != null)
                    LogUtils.e("Latest Order: " + latestOrder._id + " &ID:" + latestOrder.id + " &updated_at:" + latestOrder.updated_at + " & created_at:" + latestOrder.created_at);
                AndroidNetworking.get(ApiEndPoints.orders + "latest")
                        .setPriority(Priority.IMMEDIATE)
                        .setTag("fetchOnlineOrdersEposOrder111")
                        .addQueryParameter(getOrdersParameters(latestOrder, calendar))
                        .build()
                        .getAsObjectList(Order.class, new ParsedRequestListener<List<Order>>() {
                            @Override
                            public void onResponse(List<Order> response) {
                                try {
                                    LogUtils.e("ORDERS", "API CALL response avyo " + response.size());
                                    Collections.reverse(response);
                                    dbSaverAsync = new DbSaverAsync();
                                    dbSaverAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, response);
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }

                            @Override
                            public void onError(ANError anError) {
                                try {
                                    anError.printStackTrace();
                                    boolean shouldDelete = false;
                                    if (anError.getErrorCode() == 400) shouldDelete = true;
                                    if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                        swipeRefreshLayout.setRefreshing(false);
                                    });

                                    dbSaverAsync = new DbSaverAsync();
                                    dbSaverAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new ArrayList<>(), shouldDelete);
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }

                            }
                        });
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private class DeleteOrderAsync extends AsyncTask<Object, Void, String> {

        @Override
        protected String doInBackground(Object... objects) {
            try {
                Thread.currentThread().setPriority(Thread.MAX_PRIORITY);
                if (objects[0] instanceof String) {
                    // list all online orders that are not in local DB
                    ArrayList<String> allOrderIds = new ArrayList<>();
                    allOrderIds.add(objects[0].toString());
                    ArrayList<Order> localOrdersWithOnlineID = new ArrayList<>();
                    localOrdersWithOnlineID = (ArrayList<Order>) appDatabase.orderDao().listWithOnlineIds(allOrderIds);
                    for (Order onlineOrder : localOrdersWithOnlineID) {
                        appDatabase.orderPaymentDao().deleteAll(onlineOrder._id);
                        appDatabase.orderSplitDao().deleteAll(onlineOrder._id);
                        appDatabase.orderItemAddonDao().deleteAll(onlineOrder._id);
                        appDatabase.orderItemIngredientDao().deleteAll(onlineOrder._id);
                        appDatabase.orderDao().delete(onlineOrder);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            swipeRefreshLayout.setRefreshing(false);
            dbSaverAsync = new DbSaverAsync();
            dbSaverAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new ArrayList<>(), false);
        }
    }

    public void refreshOrder() {
        dbSaverAsync = new DbSaverAsync();
        dbSaverAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new ArrayList<>(), false);
    }

    private class DbSaverAsync extends AsyncTask<Object, Void, String> {
        private ArrayList<Object> localObjects = new ArrayList<>();

        @Override
        protected void onPreExecute() {
            LogUtils.e("ORDERS", "PRE EXECUTE");
            if (homeTheme != null && !Validators.isNullOrEmpty(homeTheme.value) && homeTheme.value.equalsIgnoreCase("theme3")) {
                if (eposOrdersAdapter.showCheck)
                    tvSelect.performClick();
            }else {
                if (eposOrdersAdapterTheme2.showCheck)
                    tvSelect.performClick();
            }
            super.onPreExecute();
        }

        @Override
        protected String doInBackground(Object... lists) {
            try {
                LogUtils.e("ORDERS", "IN background start");
                Thread.currentThread().setPriority(Thread.MAX_PRIORITY);
                int count = 0;
                if (lists[0] instanceof ArrayList<?>) {
                    ArrayList<Order> parameterOrders = (ArrayList<Order>) lists[0];
                    ArrayList<String> allOrderIds = new ArrayList<>();
                    ArrayList<Order> newOnlineOrders = new ArrayList<>();
                    for (Order o : parameterOrders) {
                        allOrderIds.add(o.id);
                    }

                    // list all online orders that are not in local DB
                    ArrayList<Order> localOrdersWithOnlineID = new ArrayList<>();
                    localOrdersWithOnlineID = (ArrayList<Order>) appDatabase.orderDao().listWithOnlineIds(allOrderIds);
                    List<String> shouldNotDeleteThisIds;
                    for (Order onlineOrder : parameterOrders) {
                        boolean found = false;
                        for (Order dbOrder : localOrdersWithOnlineID) {
                            if (onlineOrder.id.equalsIgnoreCase(dbOrder.id) || onlineOrder.unique_id.equalsIgnoreCase(dbOrder.unique_id)) {
                                found = true;
                                break;
                            }
                        }
                        if (!found) {
                            newOnlineOrders.add(onlineOrder);
                        }
                    }
                    // list all orders that are already in local DB
                    for (Order dbOrder : localOrdersWithOnlineID) {
                        Order matchedOnlineOrder = null;
                        for (Order onlineOrder : parameterOrders) {
                            if (onlineOrder.id.equalsIgnoreCase(dbOrder.id)) {
                                matchedOnlineOrder = onlineOrder;
                                break;
                            }
                        }
                        if (matchedOnlineOrder != null) {
                            if (!dbOrder.is_uploaded_on_server) {
                                count = count + 1;
                                LogUtils.e("Order is not updated on server");
                            } else {
                                if (dbOrder.updated_at != null &&
                                        dbOrder.updated_at.toLowerCase().equalsIgnoreCase(matchedOnlineOrder.updated_at.toLowerCase()) &&
                                        dbOrder.total == matchedOnlineOrder.total &&
                                        dbOrder.total_paid == matchedOnlineOrder.total_paid
                                ) {
                                    LogUtils.e("Continuing... second");
                                    continue;
                                } else {
                                    Customer dbCustomer = appDatabase.customerDao().view(matchedOnlineOrder.customer_id);
                                    int _customer_id;
                                    if (dbCustomer == null) {
                                        dbCustomer = matchedOnlineOrder.customer;
                                        _customer_id = (int) appDatabase.customerDao().insert(matchedOnlineOrder.customer);
                                    } else {
                                        _customer_id = dbCustomer._id;
                                        dbCustomer = matchedOnlineOrder.customer;
                                        dbCustomer._id = _customer_id;
                                        appDatabase.customerDao().update(dbCustomer);
                                        _customer_id = dbCustomer._id;
                                    }
                                    matchedOnlineOrder._customer_id = _customer_id;
                                    matchedOnlineOrder.customer._id = _customer_id;

                                    int _order_id;
                                    matchedOnlineOrder.customer_name = dbCustomer.name;
                                    if (dbOrder == null) {
                                        _order_id = (int) appDatabase.orderDao().insert(matchedOnlineOrder);
                                        matchedOnlineOrder._id = _order_id;
                                    } else {
                                        matchedOnlineOrder._id = dbOrder._id;
                                        _order_id = dbOrder._id;
                                        // if local order status is not paid then update the order
                                        if (!dbOrder.order_status_id.equalsIgnoreCase("5") || matchedOnlineOrder.order_status_id.equalsIgnoreCase("10")) {
                                            // if local item is not updated on server
                                            if (dbOrder.sub_total > matchedOnlineOrder.sub_total && matchedOnlineOrder.order_items != null && !matchedOnlineOrder.order_items.isEmpty()) {
                                                dbOrder.is_uploaded_on_server = true;
                                                appDatabase.orderDao().update(dbOrder);
                                            } else {
                                                matchedOnlineOrder.is_uploaded_on_server = true;
                                                appDatabase.orderDao().update(matchedOnlineOrder);
                                            }
                                        }
                                    }


                                    shouldNotDeleteThisIds = new ArrayList<>();
                                    if (matchedOnlineOrder.order_splits != null) {
                                        for (OrderSplit split : matchedOnlineOrder.order_splits) {
                                            shouldNotDeleteThisIds.add(split.id);
                                            split._order_id = _order_id;
                                            OrderSplit dbSplit = appDatabase.orderSplitDao().view(split.id);
                                            if (dbSplit == null) {
                                                split._id = (int) appDatabase.orderSplitDao().insert(split);
                                            } else {
                                                split._id = dbSplit._id;
                                                appDatabase.orderSplitDao().update(split);
                                            }
                                        }
                                    }
                                    appDatabase.orderSplitDao().deleteOtherIdsButNotThis(_order_id, shouldNotDeleteThisIds);

                                    shouldNotDeleteThisIds = new ArrayList<>();
                                    if (matchedOnlineOrder.order_payments != null) {
                                        for (OrderPayment payment : matchedOnlineOrder.order_payments) {
                                            shouldNotDeleteThisIds.add(payment.id);
                                            payment._order_id = _order_id;
                                            OrderPayment dbPayment = appDatabase.orderPaymentDao().view(payment.id);
                                            if (dbPayment == null) {
                                                payment._id = (int) appDatabase.orderPaymentDao().insert(payment);
                                            } else {
                                                payment._id = dbPayment._id;

                                            }
                                            if (!Validators.isNullOrEmpty(payment.order_split_id)) {
                                                OrderSplit dbOrderSplit = appDatabase.orderSplitDao().view(payment.order_split_id);
                                                if (dbOrderSplit != null)
                                                    payment._order_split_id = dbOrderSplit._id;
                                            }
                                            appDatabase.orderPaymentDao().insert(payment);
                                        }
                                    }

                                    appDatabase.orderPaymentDao().deleteOtherIdsButNotThis(_order_id, shouldNotDeleteThisIds);
                                    if (matchedOnlineOrder.order_items != null) {
                                        //commenting because of the mismatch price issues
                                        //appDatabase.orderItemDao().deleteAll(_order_id);
                                        appDatabase.orderItemDao().deleteAll(_order_id);


                                        for (OrderItem orderItem : matchedOnlineOrder.order_items) {

                                            orderItem._order_id = _order_id;
                                            OrderItem dbOrderItem = myApp.appDatabase.orderItemDao().view(orderItem.id);
                                            if (!Validators.isNullOrEmpty(orderItem.order_split_id)) {
                                                OrderSplit orderSplit = appDatabase.orderSplitDao().view(orderItem.order_split_id);
                                                if (orderSplit != null)
                                                    orderItem._order_split_id = orderSplit._id;
                                            }

                                            int _order_item_id = 0;
                                            if (dbOrderItem == null) {
                                                try {
                                                    _order_item_id = (int) appDatabase.orderItemDao().insert(orderItem);
                                                    orderItem._id = _order_item_id;
                                                } catch (Exception e) {

                                                }
                                            } else {
                                                _order_item_id = dbOrderItem._id;
                                                orderItem._id = _order_item_id;
                                                // if local item is not updated on server
                                                if (dbOrderItem.quantity > orderItem.quantity) {
                                                    appDatabase.orderItemDao().update(dbOrderItem);
                                                } else {
                                                    appDatabase.orderItemDao().update(orderItem);
                                                }
                                            }

                                            float addonTotal = 0;
                                            shouldNotDeleteThisIds = new ArrayList<>();
                                            if (orderItem.order_item_addons != null) {
                                                for (OrderItemAddon itemAddon : orderItem.order_item_addons) {
                                                    shouldNotDeleteThisIds.add(itemAddon.id);
                                                    itemAddon._order_item_id = _order_item_id;
                                                    itemAddon.total = itemAddon.quantity * itemAddon.price;
                                                    addonTotal = addonTotal + itemAddon.total;
                                                    OrderItemAddon dbAddon = appDatabase.orderItemAddonDao().view(itemAddon.id);
                                                    if (dbAddon == null) {
                                                        itemAddon._id = (int) appDatabase.orderItemAddonDao().insert(itemAddon);
                                                    } else {
                                                        itemAddon._id = dbAddon._id;
                                                        appDatabase.orderItemAddonDao().update(itemAddon);
                                                    }
                                                }
                                            }
                                            appDatabase.orderItemAddonDao().deleteOtherIdsButNotThis(_order_item_id, shouldNotDeleteThisIds);

                                            float ingredientTotal = 0;
                                            if (orderItem.order_item_ingredients != null) {
                                                appDatabase.orderItemIngredientDao().deleteAll(_order_item_id);
                                                for (OrderItemIngredient itemIngredient : orderItem.order_item_ingredients) {
                                                    itemIngredient._order_item_id = _order_item_id;
                                                    itemIngredient.total = itemIngredient.quantity * itemIngredient.price;
                                                    ingredientTotal = ingredientTotal + itemIngredient.total;
                                                    OrderItemIngredient dbAddon = appDatabase.orderItemIngredientDao().view(itemIngredient.id);
                                                    if (dbAddon == null) {
                                                        itemIngredient._id = (int) appDatabase.orderItemIngredientDao().insert(itemIngredient);
                                                    } else {
                                                        itemIngredient._id = dbAddon._id;
                                                        appDatabase.orderItemIngredientDao().update(itemIngredient);
                                                    }
                                                }
                                            }

                                            if (dbOrderItem != null && dbOrderItem.quantity > orderItem.quantity) {
                                                ingredientTotal = ingredientTotal * dbOrderItem.quantity;
                                                addonTotal = addonTotal * dbOrderItem.quantity;
                                            } else {
                                                ingredientTotal = ingredientTotal * orderItem.quantity;
                                                addonTotal = addonTotal * orderItem.quantity;
                                            }
                                            myApp.appDatabase.orderItemDao().updateOrderItemTotal(_order_item_id, addonTotal, ingredientTotal);
                                        }

                                    } else {
                                        // delete all item from local if item is deleted from any device
                                        appDatabase.orderItemDao().deleteAll(_order_id);
                                    }
                                }
                            }
                        }
                    }
                    for (int j = 0; j < newOnlineOrders.size(); j++) {
                        Order order = newOnlineOrders.get(j);
                        order.is_uploaded_on_server = true;
                        if (isCancelled()) break;
                        Order dbOrder = appDatabase.orderDao().view(order.id);
                        if (dbOrder == null) {
                            // if local order is not updated check with local unique id in order to prevent duplicate order issue
                            dbOrder = appDatabase.orderDao().viewByUniqueId(order.unique_id);
                        }
                        if (dbOrder != null && dbOrder.updated_at != null &&
                                dbOrder.updated_at.toLowerCase().equalsIgnoreCase(order.updated_at.toLowerCase()) &&
                                dbOrder.total == order.total &&
                                dbOrder.total_paid == order.total_paid
                        ) {
                            LogUtils.e("Continuing...");
                            continue;
                        }
                        Customer dbCustomer = appDatabase.customerDao().view(order.customer_id);
                        int _customer_id;
                        if (dbCustomer == null) {
                            dbCustomer = order.customer;
                            _customer_id = (int) appDatabase.customerDao().insert(order.customer);
                        } else {
                            _customer_id = dbCustomer._id;
                            dbCustomer = order.customer;
                            dbCustomer._id = _customer_id;
                            appDatabase.customerDao().update(dbCustomer);
                            _customer_id = dbCustomer._id;
                        }
                        order._customer_id = _customer_id;
                        order.customer._id = _customer_id;

                        int _order_id;
                        order.customer_name = dbCustomer.name;
                        if (dbOrder == null) {
                            _order_id = (int) appDatabase.orderDao().insert(order);
                            order._id = _order_id;
                        } else {
                            order._id = dbOrder._id;
                            _order_id = dbOrder._id;
                            // if local order status is not paid then update the order
                            if (!dbOrder.order_status_id.equalsIgnoreCase("5") || order.order_status_id.equalsIgnoreCase("10")) {
                                appDatabase.orderDao().update(order);
                            }
                        }


                        shouldNotDeleteThisIds = new ArrayList<>();
                        if (order.order_splits != null) {
                            for (OrderSplit split : order.order_splits) {
                                shouldNotDeleteThisIds.add(split.id);
                                split._order_id = _order_id;
                                OrderSplit dbSplit = appDatabase.orderSplitDao().view(split.id);
                                if (dbSplit == null) {
                                    split._id = (int) appDatabase.orderSplitDao().insert(split);
                                } else {
                                    split._id = dbSplit._id;
                                    appDatabase.orderSplitDao().update(split);
                                }
                            }
                        }
                        appDatabase.orderSplitDao().deleteOtherIdsButNotThis(_order_id, shouldNotDeleteThisIds);

                        shouldNotDeleteThisIds = new ArrayList<>();
                        if (order.order_payments != null) {
                            for (OrderPayment payment : order.order_payments) {
                                shouldNotDeleteThisIds.add(payment.id);
                                payment._order_id = _order_id;
                                OrderPayment dbPayment = appDatabase.orderPaymentDao().view(payment.id);
                                if (dbPayment == null) {
                                    payment._id = (int) appDatabase.orderPaymentDao().insert(payment);
                                } else {
                                    payment._id = dbPayment._id;

                                }
                                if (!Validators.isNullOrEmpty(payment.order_split_id)) {
                                    OrderSplit dbOrderSplit = appDatabase.orderSplitDao().view(payment.order_split_id);
                                    if (dbOrderSplit != null)
                                        payment._order_split_id = dbOrderSplit._id;
                                }
                                appDatabase.orderPaymentDao().insert(payment);
                            }
                        }

                        appDatabase.orderPaymentDao().deleteOtherIdsButNotThis(_order_id, shouldNotDeleteThisIds);

                        if (order.order_items != null) {
                            appDatabase.orderItemDao().deleteAll(_order_id);
                            for (OrderItem orderItem : order.order_items) {
                                orderItem._order_id = _order_id;
                                OrderItem dbOrderItem = myApp.appDatabase.orderItemDao().view(orderItem.id);

                                if (!Validators.isNullOrEmpty(orderItem.order_split_id)) {
                                    OrderSplit orderSplit = appDatabase.orderSplitDao().view(orderItem.order_split_id);
                                    if (orderSplit != null)
                                        orderItem._order_split_id = orderSplit._id;
                                }

                                int _order_item_id = 0;
                                if (dbOrderItem == null) {
                                    try {
                                        _order_item_id = (int) appDatabase.orderItemDao().insert(orderItem);
                                        orderItem._id = _order_item_id;
                                    } catch (Exception e) {

                                    }
                                } else {
                                    _order_item_id = dbOrderItem._id;
                                    orderItem._id = _order_item_id;
                                    appDatabase.orderItemDao().update(orderItem);
                                }

                                float addonTotal = 0;
                                shouldNotDeleteThisIds = new ArrayList<>();
                                if (orderItem.order_item_addons != null) {
                                    for (OrderItemAddon itemAddon : orderItem.order_item_addons) {
                                        shouldNotDeleteThisIds.add(itemAddon.id);
                                        itemAddon._order_item_id = _order_item_id;
                                        itemAddon.total = itemAddon.quantity * itemAddon.price;
                                        addonTotal = addonTotal + itemAddon.total;
                                        OrderItemAddon dbAddon = appDatabase.orderItemAddonDao().view(itemAddon.id);
                                        if (dbAddon == null) {
                                            itemAddon._id = (int) appDatabase.orderItemAddonDao().insert(itemAddon);
                                        } else {
                                            itemAddon._id = dbAddon._id;
                                            appDatabase.orderItemAddonDao().update(itemAddon);
                                        }
                                    }
                                }
                                appDatabase.orderItemAddonDao().deleteOtherIdsButNotThis(_order_item_id, shouldNotDeleteThisIds);

                                float ingredientTotal = 0;
                                if (orderItem.order_item_ingredients != null) {
                                    appDatabase.orderItemIngredientDao().deleteAll(_order_item_id);
                                    for (OrderItemIngredient itemIngredient : orderItem.order_item_ingredients) {
                                        itemIngredient._order_item_id = _order_item_id;
                                        itemIngredient.total = itemIngredient.quantity * itemIngredient.price;
                                        ingredientTotal = ingredientTotal + itemIngredient.total;
                                        OrderItemIngredient dbAddon = appDatabase.orderItemIngredientDao().view(itemIngredient.id);
                                        if (dbAddon == null) {
                                            itemIngredient._id = (int) appDatabase.orderItemIngredientDao().insert(itemIngredient);
                                        } else {
                                            itemIngredient._id = dbAddon._id;
                                            appDatabase.orderItemIngredientDao().update(itemIngredient);
                                        }
                                    }
                                }

                                ingredientTotal = ingredientTotal * orderItem.quantity;
                                addonTotal = addonTotal * orderItem.quantity;
                                myApp.appDatabase.orderItemDao().updateOrderItemTotal(_order_item_id, addonTotal, ingredientTotal);
                            }
                        } else {

                        }
                    }

                    Log.e("localOrdersWithOnlineID", "localOrdersWithOnlineID " + localOrdersWithOnlineID.size() + " newOnlineOrders " + newOnlineOrders.size()
                            + " parameterOrders " + parameterOrders.size());
                    if (isCancelled()) return null;

                }
                /*// if failed order count is 0 then send brodcast to dineline fragment for display count
                if (count > 0 && "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode())) {
                    Intent intent = new Intent(Constants.FAILED_ORDER_RECEIVER);
                    intent.putExtra(Constants.FAILED_ORDER_COUNT, count);
                    LocalBroadcastManager.getInstance(getActivity()).sendBroadcast(intent);
                }*/
                if (isCancelled()) return null;
                localObjects.clear();
                String startDateString = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.DATE_FORMAT);
                String endDateString = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.DATE_FORMAT);
                List<String> completedStatusIds = new ArrayList<>();
                List<String> pendingStatusIds = new ArrayList<>();
                pendingStatusIds.add("1");
                pendingStatusIds.add("2");
                pendingStatusIds.add("3");
                pendingStatusIds.add("4");
                pendingStatusIds.add("6");
                pendingStatusIds.add("7");
                if (showPaidOrders) {
                    completedStatusIds.add("5");
                    completedStatusIds.add("10");
                    pendingStatusIds = new ArrayList<>();
                }
                if (showCompletedOrders) {
                    completedStatusIds.add("5");
                    completedStatusIds.add("10");
                }

                if (Validators.isNullOrEmpty(orderTypeId) || orderTypeId.equalsIgnoreCase("0")) {
                    SiteSetting collectionSetting = myApp.findSetting("is_collection");
                    SiteSetting waitingSetting = myApp.findSetting("is_waiting");
                    SiteSetting deliverySetting = myApp.findSetting("is_delivery");
                    ArrayList<Order> collectionOrders = new ArrayList<>();
                    ArrayList<Order> deliveryOrders = new ArrayList<>();
                    ArrayList<Order> waitingOrders = new ArrayList<>();
                    if (collectionSetting != null && (collectionSetting.value.equals("true") || collectionSetting.value.equals("1")) && (MyApp.userPermission != null && MyApp.userPermission.collection.actions.list)) {
                        if (completedStatusIds.size() > 0) {
                            collectionOrders = (ArrayList<Order>) myApp.appDatabase.orderDao().allPendingOrders("2", startDateString, pendingStatusIds, completedStatusIds, isArchived);
                        } else {
                            collectionOrders = (ArrayList<Order>) myApp.appDatabase.orderDao().allPendingOrders("2", pendingStatusIds, isArchived);
                        }
                    }
                    if (deliverySetting != null && (deliverySetting.value.equals("true") || deliverySetting.value.equals("1")) && (MyApp.userPermission != null && MyApp.userPermission.delivery.actions.list)) {
                        if (completedStatusIds.size() > 0) {
                            deliveryOrders = (ArrayList<Order>) myApp.appDatabase.orderDao().allPendingOrders("3", startDateString, pendingStatusIds, completedStatusIds, isArchived);
                        } else {
                            deliveryOrders = (ArrayList<Order>) myApp.appDatabase.orderDao().allPendingOrders("3", pendingStatusIds, isArchived);
                            if (deliveryOrders != null) {
                                for (int i = 0; i < deliveryOrders.size(); i++) {
                                    Order order = deliveryOrders.get(i);
                                    order.customer = myApp.appDatabase.customerDao().view(order._customer_id);
                                }
                            }
                        }

                    }
                    if (waitingSetting != null && (waitingSetting.value.equals("true") || waitingSetting.value.equals("1")) && (MyApp.userPermission != null && MyApp.userPermission.waiting.actions.list)) {
                        if (completedStatusIds.size() > 0) {
                            waitingOrders = (ArrayList<Order>) myApp.appDatabase.orderDao().allPendingOrders("5", startDateString, pendingStatusIds, completedStatusIds, isArchived);
                        } else {
                            waitingOrders = (ArrayList<Order>) myApp.appDatabase.orderDao().allPendingOrders("5", pendingStatusIds, isArchived);
                        }
                    }
                    if (collectionOrders != null && collectionOrders.size() > 0) {
                        localObjects.add(new Header(String.format("Collection Orders (%d)", collectionOrders.size()), -1));
                        localObjects.addAll(collectionOrders);
                    }
                    if (deliveryOrders != null && deliveryOrders.size() > 0) {
                        localObjects.add(new Header(String.format("Delivery Orders (%d)", deliveryOrders.size()), -2));
                        localObjects.addAll(deliveryOrders);
                    }
                    if (waitingOrders != null && waitingOrders.size() > 0) {
                        localObjects.add(new Header(String.format("Waiting Orders (%d)", waitingOrders.size()), -3));
                        localObjects.addAll(waitingOrders);
                    }
                } else {

                    ArrayList<Order> inProgressOrders = (ArrayList<Order>) myApp.appDatabase.orderDao().inprogress(orderTypeId, pendingStatusIds, isArchived);
                    if (inProgressOrders != null && inProgressOrders.size() > 0) {
                        localObjects.add(new Header(String.format("Orders in progress (%d)", inProgressOrders.size()), -1));
                        if (orderTypeId != null && orderTypeId.equalsIgnoreCase("3")) {
                            for (int i = 0; i < inProgressOrders.size(); i++) {
                                Order order = inProgressOrders.get(i);
                                order.customer = myApp.appDatabase.customerDao().view(order._customer_id);
                            }
                        }
                        localObjects.addAll(inProgressOrders);
                    }
                    if (completedStatusIds.size() > 0) {
                        ArrayList<Order> completedOrders = (ArrayList<Order>) myApp.appDatabase.orderDao().completed(orderTypeId, CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), "yyyy-MM-dd"), completedStatusIds, isArchived);
                        if (completedOrders != null && completedOrders.size() > 0) {
                            if (orderTypeId != null && orderTypeId.equalsIgnoreCase("3")) {
                                for (int i = 0; i < completedOrders.size(); i++) {
                                    Order order = completedOrders.get(i);
                                    order.customer = myApp.appDatabase.customerDao().view(order._customer_id);
                                }
                            }
                            localObjects.add(new Header(String.format("Recently completed (%d)", completedOrders.size()), -2));
                            localObjects.addAll(completedOrders);
                        }
                    }
                }
                /*// if failed order count is 0 then send brodcast to dineline fragment for display count
                if (count == 0 && "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode())) {
                    int failedOrderCount = myApp.appDatabase.orderDao().failedOrder();
                    Log.e("failedOrderCount", "failedOrderCount " + failedOrderCount);
                    Intent intent = new Intent(Constants.FAILED_ORDER_RECEIVER);
                    intent.putExtra(Constants.FAILED_ORDER_COUNT, failedOrderCount);
                    LocalBroadcastManager.getInstance(getActivity()).sendBroadcast(intent);
                }*/
                failedOrderCount = myApp.appDatabase.orderDao().failedOrder();
                LogUtils.e("ORDERS", "IN background finish");
            } catch (Exception e) {
                e.printStackTrace();
            }
            return "Executed";
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                LogUtils.e("ORDERS", "Post Execute");
                refreshOnResume = true;
                myApp.shallWeRefreshOrders = true;
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        swipeRefreshLayout.setRefreshing(false);
                        swipeRefreshLayout.setVisibility(View.VISIBLE);
                        objects.clear();
                        objects.addAll(localObjects);

                        if (MyApp.userPermission != null && MyApp.userPermission.archive_order.actions.list) {
                            tvSelect.setVisibility(View.VISIBLE);
                            if (orderCompleteAuto)
                                tvSelect.setVisibility(View.GONE);
                        } else {
                            tvSelect.setVisibility(View.GONE);
                        }

                        if (localObjects.size() == 0) {
                            tvErrorMessage.setVisibility(View.VISIBLE);
                            tvSelect.setVisibility(View.GONE);
                            tvErrorMessage.setText("No orders found!");
                        } else {
                            tvErrorMessage.setVisibility(View.GONE);
                        }

                        try {
                            rvOrders.post(() -> {
                                if (homeTheme != null && !Validators.isNullOrEmpty(homeTheme.value) && homeTheme.value.equalsIgnoreCase("theme3")) {
                                    if (eposOrdersAdapter != null) {
                                        eposOrdersAdapter.notifyDataSetChanged();
                                    }
                                }else {
                                    if (eposOrdersAdapterTheme2 != null) {
                                        eposOrdersAdapterTheme2.notifyDataSetChanged();
                                    }
                                }
                            });
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                    });

                    if (isFromNotification) {
                        isFromNotification = false;
                        Intent intent = new Intent(Constants.EPOS_ORDER_COUNT_UPDATE);
                        LocalBroadcastManager.getInstance(getActivity()).sendBroadcast(intent);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        protected void onCancelled() {
            super.onCancelled();
            try {
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        swipeRefreshLayout.setRefreshing(false);
                        try {
                            rvOrders.post(() -> {
                                if (homeTheme != null && !Validators.isNullOrEmpty(homeTheme.value) && homeTheme.value.equalsIgnoreCase("theme3")) {
                                    eposOrdersAdapter.notifyDataSetChanged();
                                }else {
                                    eposOrdersAdapterTheme2.notifyDataSetChanged();
                                }
                            });
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (objects.size() == 0) {
                            tvErrorMessage.setVisibility(View.VISIBLE);
                            tvSelect.setVisibility(View.GONE);
                            tvErrorMessage.setText("No orders found!");
                        } else {
                            tvErrorMessage.setVisibility(View.GONE);
                            if (MyApp.userPermission != null && !fromTheme2 && MyApp.userPermission.archive_order.actions.list) {
                                tvSelect.setVisibility(View.VISIBLE);
                            }
                        }
                        if (fromTheme2 && orderCompleteAuto) {
                            tvSelect.setVisibility(View.GONE);
                        }
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    BroadcastReceiver orderUpdateReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getBooleanExtra("result", false)) {
                    if (intent.hasExtra("refreshAll")) {
                        fetchOrders();
                    } else {
                        if (myApp.shallWeRefreshOrders) {
                            if (!swipeRefreshLayout.isRefreshing()) {
                                swipeRefreshLayout.setRefreshing(true);
                            }
                            fetchOrders();
                        } else {
                            myApp.shallWeRefreshOrders = true;
                        }
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    BroadcastReceiver orderTypeClickListener = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.hasExtra("order_type_id")) {
                    if (orderTypeId.equalsIgnoreCase(intent.getStringExtra("order_type_id"))) {
                        int visiblePosition = ((GridLayoutManager) rvOrders.getLayoutManager()).findFirstVisibleItemPosition();
                        if (visiblePosition > 6) {
                            rvOrders.smoothScrollToPosition(0);
                        }
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    BroadcastReceiver newOrderReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getBooleanExtra("refresh", false)) {
                    // String toastMessage = "PUSH REceived.";
                    LogUtils.e("shallWeRefreshOrders?" + myApp.shallWeRefreshOrders + "");

                    if (myApp.shallWeRefreshOrders) {
                        if (intent.hasExtra("notification_section") && intent.getStringExtra("notification_section").equalsIgnoreCase("tables")) {
                        }
                        // if notification section for delete order
                        else if (intent.hasExtra("notification_section") && intent.getStringExtra("notification_section").equalsIgnoreCase("order_delete")
                                && intent.hasExtra("order_id")) {
                            myApp.shallWeRefreshOrders = false;
                            if (!swipeRefreshLayout.isRefreshing()) {
                                swipeRefreshLayout.setRefreshing(true);
                            }
                            isFromNotification = true;
                            DeleteOrderAsync deleteOrderAsync = new DeleteOrderAsync();
                            deleteOrderAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, intent.getStringExtra("order_id"), false);
                        } else {
                            isFromNotification = true;
                            LogUtils.e("Already not refreshing");
                            myApp.shallWeRefreshOrders = false;
                            if (!swipeRefreshLayout.isRefreshing()) {
                                swipeRefreshLayout.setRefreshing(true);
                            }
                            if (intent.hasExtra("order_id") && !Validators.isNullOrEmpty(intent.getStringExtra("order_id"))) {
                                fetchByOrderId(intent.getStringExtra("order_id"));
                            } else {
                                fetchOrders();
                            }
                        }

                    } else {
                        /*dbSaverAsync = new DbSaverAsync();
                        dbSaverAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new ArrayList<>(), false);*/
                        LogUtils.e("Already refreshing");
                        myApp.shallWeRefreshOrders = false;
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        refreshOnResume = false;

    }

    @Override
    public void onStop() {
        super.onStop();
        try {
            if (dbSaverAsync != null) {
                dbSaverAsync.cancel(true);
            }
            AndroidNetworking.cancel("fetchOnlineOrdersEposOrder111");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    // book table/order receiver
    BroadcastReceiver bookTableSuccessReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            // refersh data from the database
            if (intent.getBooleanExtra(Constants.IS_FROM_ERROR, false)) {
                refreshList();
                //ToastUtils.makeSnackToast(HomeActivity.this, intent.getStringExtra(Constants.SUCCESS_MESSAGE));
            }
        }
    };

    // delete table/order receiver
    BroadcastReceiver deleteTableOrderSuccessReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            // refersh data from the database only if fragment is added and activity is not null
            if (isAdded() && getActivity() != null) {
                refreshList();
            }
        }
    };

    // below method used to refresh list
    private void refreshList() {
        dbSaverAsync = new DbSaverAsync();
        dbSaverAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new ArrayList<>());
    }

    @Override
    public void onResume() {
        super.onResume();
        try {
            Log.e("Is Auto", " " + "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode()));
            Log.e("Is Internet", " " + InternetUtils.isNetworkConnected(getActivity()));
            if ("manual".equalsIgnoreCase(myPreferences.getOrderSyncMode()) || (refreshOnResume && myApp.shallWeRefreshOrders)) {
                try {
                    swipeRefreshLayout.setRefreshing(true);
                    fetchOrders();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (!myApp.isConnected(getActivity()) && refreshOnResume && "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode())) {
                try {
                    // When Internet is not available in Auto mode
                    swipeRefreshLayout.setRefreshing(true);
                    fetchOrders();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (myApp.isFromDeleteOrder) {
                // delete order refresh list
                myApp.isFromDeleteOrder = false;
                refreshList();
            }
            registerBroadcast();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    public void onPause() {
        super.onPause();
        try {
            unregisterBroadcast();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        if (homeTheme != null && !Validators.isNullOrEmpty(homeTheme.value) && homeTheme.value.equalsIgnoreCase("theme3")) {
            if (eposOrdersAdapter != null) {
                eposOrdersAdapter.orders = null;
                if (eposOrdersAdapter.handler != null) {
                    eposOrdersAdapter.tmr.cancel();
                    eposOrdersAdapter.tmr = null;
                    eposOrdersAdapter.handler.removeCallbacks(eposOrdersAdapter.updateTime);
                    eposOrdersAdapter.handler.removeCallbacks(null);
                    eposOrdersAdapter.handler = null;
                }
                eposOrdersAdapter.lstHolders = null;
                eposOrdersAdapter.lstHomeHolders = null;
                eposOrdersAdapter.homeActionListener = null;
                eposOrdersAdapter.itemClickListener = null;
                eposOrdersAdapter.actionListener = null;
                eposOrdersAdapter = null;
            }
        }else {
            if (eposOrdersAdapterTheme2 != null) {
                eposOrdersAdapterTheme2.orders = null;
                if (eposOrdersAdapterTheme2.handler != null) {
                    eposOrdersAdapterTheme2.tmr.cancel();
                    eposOrdersAdapterTheme2.tmr = null;
                    eposOrdersAdapterTheme2.handler.removeCallbacks(eposOrdersAdapterTheme2.updateTime);
                    eposOrdersAdapterTheme2.handler.removeCallbacks(null);
                    eposOrdersAdapterTheme2.handler = null;
                }
                eposOrdersAdapterTheme2.lstHolders = null;
                eposOrdersAdapterTheme2.lstHomeHolders = null;
                eposOrdersAdapterTheme2.homeActionListener = null;
                eposOrdersAdapterTheme2.itemClickListener = null;
                eposOrdersAdapterTheme2.actionListener = null;
                eposOrdersAdapterTheme2 = null;
            }
        }
    }

    private void unregisterBroadcast() {
        // dis connecting in onDestroy because delete from database is quickly and before onResume called delete broadcast is sended to all the reciver
        if (getActivity() != null && deleteTableOrderSuccessReceiver != null) {
            LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(deleteTableOrderSuccessReceiver);
        }
        LogUtils.e("On Pause:EposOrdersFragment");
        if (getActivity() != null && orderUpdateReceiver != null) {
            LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(orderUpdateReceiver);
        }
        if (getActivity() != null && newOrderReceiver != null) {
            LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(newOrderReceiver);
        }
        if (getActivity() != null && orderTypeClickListener != null) {
            LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(orderTypeClickListener);
        }
        if (getActivity() != null && bookTableSuccessReceiver != null) {
            LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(bookTableSuccessReceiver);
        }
    }

    private void registerBroadcast() {
        // register order success receiver
        if (getActivity() != null) {
            LocalBroadcastManager.getInstance(getActivity()).registerReceiver(bookTableSuccessReceiver, new IntentFilter(Constants.BOOK_TABLE_SUCCESS));
            LocalBroadcastManager.getInstance(getActivity()).registerReceiver(deleteTableOrderSuccessReceiver, new IntentFilter(Constants.DELETE_ORDER_SUCCESS));
        }
        if (getActivity() != null && orderUpdateReceiver != null)
            LocalBroadcastManager.getInstance(getActivity()).registerReceiver(orderUpdateReceiver, new IntentFilter(
                    Constants.EPOS_ORDER_UPDATE));
        if (getActivity() != null && newOrderReceiver != null) {
            LocalBroadcastManager.getInstance(getActivity()).registerReceiver(newOrderReceiver, new IntentFilter(Constants.EPOS_NEW_ORDER));
        }
        if (getActivity() != null && orderTypeClickListener != null) {
            LocalBroadcastManager.getInstance(getActivity()).registerReceiver(orderTypeClickListener, new IntentFilter(Constants.EPOS_ORDER_TYPE_CLICK));
        }
    }

    public EposCompletedOrderOverviewBottomSheet getInstanceEposCompletedOrderOverview(int orderId) {
        EposCompletedOrderOverviewBottomSheet overviewBottomSheet = new EposCompletedOrderOverviewBottomSheet();
        Bundle bundle = new Bundle();
        bundle.putInt("_order_id", orderId);
        overviewBottomSheet.setArguments(bundle);
        return overviewBottomSheet;
    }

    public OrdersBulkActionPerformDialogFragment getInstanceOrdersBulkAction(String title, String action, ArrayList<Integer> orderIds) {
        OrdersBulkActionPerformDialogFragment dialogFragment = new OrdersBulkActionPerformDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("title", title);
        bundle.putString("action", action);
        bundle.putIntegerArrayList("orderIds", orderIds);
        dialogFragment.setArguments(bundle);
        return dialogFragment;
    }
}
