package com.ubsidi.epos_2021.fragment;

import static android.app.Activity.RESULT_OK;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.AppCompatSpinner;
import androidx.cardview.widget.CardView;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.button.MaterialButtonToggleGroup;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.activities.NewOrderActivity;
import com.ubsidi.epos_2021.adapters.EposOrdersAdapter;
import com.ubsidi.epos_2021.adapters.TableWiseFilterAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.models.Header;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.OrderSplit;
import com.ubsidi.epos_2021.models.Table;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.online.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.services.SingleOrderUploaderService;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.ToastUtils;
import com.wdullaer.materialdatetimepicker.date.DatePickerDialog;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EposOrdersHistoryFragment extends BaseFragment {
    private EposOrdersAdapter eposOrdersAdapter;

    private final ArrayList<Object> orders = new ArrayList<>();
    private final ArrayList<Object> objects = new ArrayList<>();
    private SwipeRefreshLayout swipeRefreshLayout;
    private OrderHistoryAsync orderHistoryAsync;

    private Date fromDate, toDate;
    private Calendar today;
    private boolean isCustomDate;
    private String dateFilter = "Today";
    private LinearLayout llFromDate, llToDate;
    private TextView tvFromDate, tvToDate, tvAllOrders;
    private RecyclerView rvTables;
    private Chip ivBack;
    private MaterialButton btnToday, btnThisWeek, btnThisMonth, btnCustom;
    private MaterialButtonToggleGroup btnGroup;
    private CardView cvCustom;
    private boolean isArchived;
    private ImageView ivSearch;
    int fromYear, fromMonth, fromDay, toYear, toMonth, toDay;
    Calendar c = Calendar.getInstance();
    int year = c.get(Calendar.YEAR);
    int month = c.get(Calendar.MONTH);
    int day = 1;
    private final ArrayList<Integer> selectedOrderIds = new ArrayList<>();
    private MaterialCardView cvArchiveAction;
    private TextView tvSelectedOrders, tvSelect, tvErrorMessage;
    private MaterialButton btnCancel, btnConfirm;
    private DatePickerDialog fromPicker, toPicker;
    private TextView tvTitle;
    public boolean showCheck = false;
    private Calendar fromCalender = Calendar.getInstance();
    private Calendar toCalender = Calendar.getInstance();
    private String fromDateString, toDateString;

    private int filterType = 0; //0 today, 1=week,2=month,3= custom
    private EditText etSearch;
    private MaterialButton tvSearch;
    private boolean fetchingOrders = true;
    private AlertDialog progressDialog;

    private LinearLayout llToday, llThisWeek, llThisMonth, llCustom;
    private TextView tvToday, tvThisWeek, tvThisMonth, tvCustom;
    private View vToday, vThisWeek, vThisMonth, vCustom;
    private AppCompatSpinner spTableFilter;
    private TableWiseFilterAdapter tableWiseFilterAdapter;
    private boolean isFromTableFilter = false;

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getArguments() != null) {
            isArchived = getArguments().getBoolean("is_archived");
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_epos_orders_history, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            orderHistoryAsync = new OrderHistoryAsync();
            setListener();
            getToday();
            getAllTables();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getAllTables() {
        new Thread(() -> {
            List<Table> tableList = appDatabase.tableDao().list();
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    if (tableList != null && !tableList.isEmpty()) {
                        Table table = new Table();
                        table.id = "-1";
                        table.number = "Select Table";
                        tableList.add(0, table);
                        tableWiseFilterAdapter = new TableWiseFilterAdapter(requireContext(), android.R.layout.simple_list_item_1, tableList);
                        spTableFilter.setAdapter(tableWiseFilterAdapter);
                        spTableFilter.setVisibility(View.VISIBLE);
                        spTableFilter.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
                            @Override
                            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                                Table table = tableWiseFilterAdapter.getItem(position);
                                if (table != null) {
                                    if (table.id.equals("-1")) {
                                        fetchOrders("");
                                    } else {
                                        isFromTableFilter = true;
                                        fetchOrders(table.id);
                                    }
                                    CommonFunctions.hideKeyboard(getActivity(), etSearch);
                                }
                            }

                            @Override
                            public void onNothingSelected(AdapterView<?> parent) {

                            }
                        });
                    }
                });
            }
        }).start();
    }

    private void initViews(View view) {
        try {
            progressDialog = CommonFunctions.customProgressDialog(getActivity());
            today = Calendar.getInstance();
            fromDate = today.getTime();
            toDate = today.getTime();

            fromMonth = today.get(Calendar.MONTH);
            fromDay = today.get(Calendar.DAY_OF_MONTH);
            fromYear = today.get(Calendar.YEAR);

            toMonth = today.get(Calendar.MONTH);
            toDay = today.get(Calendar.DAY_OF_MONTH);
            toYear = today.get(Calendar.YEAR);

            tvAllOrders = view.findViewById(R.id.tvAllOrders);
            llFromDate = view.findViewById(R.id.llFromDate);
            llToDate = view.findViewById(R.id.llToDate);
            tvFromDate = view.findViewById(R.id.tvFromDate);
            tvToDate = view.findViewById(R.id.tvToDate);
            ivBack = view.findViewById(R.id.chipBack);


            etSearch = view.findViewById(R.id.etSearch);
            tvSearch = view.findViewById(R.id.btnSearch);
            btnToday = view.findViewById(R.id.btnToday);
            btnThisWeek = view.findViewById(R.id.btnThisWeek);
            btnThisMonth = view.findViewById(R.id.btnThisMonth);
            btnCustom = view.findViewById(R.id.btnCustom);
            btnGroup = view.findViewById(R.id.btnGroup);
            cvCustom = view.findViewById(R.id.cvCustom);
            ivSearch = view.findViewById(R.id.ivSearch);
            tvTitle = view.findViewById(R.id.tvCurrentScreen);
            lastCheckedId = btnToday.getId();
            cvCustom.setVisibility(View.GONE);
            swipeRefreshLayout = view.findViewById(R.id.swipeRefreshLayout);
            rvTables = view.findViewById(R.id.rvItems);

            tvSelect = view.findViewById(R.id.tvSelect);
            tvErrorMessage = view.findViewById(R.id.tvErrorMessage);
            cvArchiveAction = view.findViewById(R.id.cvArchiveAction);
            tvSelectedOrders = view.findViewById(R.id.tvSelectedOrders);
            btnConfirm = view.findViewById(R.id.btnConfirm);
            btnCancel = view.findViewById(R.id.btnCancel);
            tvSelect.setVisibility(View.GONE);
            cvArchiveAction.setVisibility(View.GONE);
            tvSearch.setVisibility(View.VISIBLE);

            llToday = view.findViewById(R.id.llToday);
            llThisWeek = view.findViewById(R.id.llThisWeek);
            llThisMonth = view.findViewById(R.id.llThisMonth);
            llCustom = view.findViewById(R.id.llCustom);

            tvToday = view.findViewById(R.id.tvToday);
            tvThisWeek = view.findViewById(R.id.tvThisWeek);
            tvThisMonth = view.findViewById(R.id.tvThisMonth);
            tvCustom = view.findViewById(R.id.tvCustom);

            vToday = view.findViewById(R.id.vToday);
            vThisWeek = view.findViewById(R.id.vThisWeek);
            vThisMonth = view.findViewById(R.id.vThisMonth);
            vCustom = view.findViewById(R.id.vCustom);
            spTableFilter = view.findViewById(R.id.spTableFilter);
            chekedBtn(llToday);
            if (isArchived) {
                btnConfirm.setText("Unarchive");
                tvTitle.setText("> Archived orders");
            }

            eposOrdersAdapter = new EposOrdersAdapter(objects, true, (position, data) -> {
                try {
                    Order order = (Order) data;
                    if (eposOrdersAdapter.showCheck) {
                        orderSelectionHandle(order);
                    } else {
                        if (!Validators.isNullOrEmpty(order.table_id) && "auto".equalsIgnoreCase(myPreferences.getOrderSyncMode())) {
                            progressDialog.show();
                            TableByIdAsync tableByIdAsync = new TableByIdAsync(order.table_id, order);
                            tableByIdAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                        } else {
                            if (order.order_status_id.equalsIgnoreCase("5") || order.order_status_id.equalsIgnoreCase("10")) {
                                openOverViewBottomSheet(order._id);
                            } else {
                                startActivityForResult(new Intent(getActivity(), NewOrderActivity.class).putExtra("order", new Gson().toJson(data)), Constants.CODE_REFRESH);
                            }
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }, (position, data) -> {
                handleAction(position, data);
            });
            int spanCount = getResources().getInteger(R.integer.epos_orders_span);

            GridLayoutManager gridLayoutManager = new GridLayoutManager(getActivity(), spanCount);
            gridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup() {
                @Override
                public int getSpanSize(int position) {
                    if (objects.size() > 0 && (objects.size() - 1 >= position) && objects.get(position) instanceof Order) {
                        return 1;
                    } else {
                        return spanCount;
                    }
                }
            });
            rvTables.setLayoutManager(gridLayoutManager);
            rvTables.setAdapter(eposOrdersAdapter);
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
    }

    private void openOverViewBottomSheet(int order_id) {
        try {
            EposCompletedOrderOverviewBottomSheet overviewBottomSheet = getInstance(order_id);
            overviewBottomSheet.show(getChildFragmentManager(), "order_detils");
            overviewBottomSheet.setDialogDismissListener(o -> {
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EposCompletedOrderOverviewBottomSheet getInstance(int orderId) {
        EposCompletedOrderOverviewBottomSheet overviewBottomSheet = new EposCompletedOrderOverviewBottomSheet();
        Bundle bundle = new Bundle();
        bundle.putInt("_order_id", orderId);
        overviewBottomSheet.setArguments(bundle);
        return overviewBottomSheet;
    }

    private void orderSelectionHandle(Order order) {
        try {
            if (order.selected) {
                if (!selectedOrderIds.contains(order._id)) {
                    selectedOrderIds.add(order._id);
                }
            } else {
                int index = selectedOrderIds.indexOf(order._id);
                if (index != -1)
                    selectedOrderIds.remove(index);
            }
            if (selectedOrderIds.size() > 0) {
                tvSelectedOrders.setText(selectedOrderIds.size() + " orders selected");
                cvArchiveAction.setVisibility(View.VISIBLE);
            } else {
                cvArchiveAction.setVisibility(View.GONE);
            }
            eposOrdersAdapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleAction(int position, Object data) {
        try {
            Order order = (Order) data;

            if (MyApp.df.format(order.total).equalsIgnoreCase(MyApp.df.format(order.total_paid))) {
                order.order_status_id = "5";
                order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                new Thread(() -> {
                    changeTableStatus(order, "1", "Free");
                    appDatabase.orderDao().update(order);
                }).start();
                Intent intent = new Intent(getActivity(), SingleOrderUploaderService.class);
                intent.putExtra("_order_id", order._id);
                getActivity().startService(intent);
            } else {
                startActivityForResult(new Intent(getActivity(), NewOrderActivity.class).putExtra("order", new Gson().toJson(data)).putExtra("destination", "pay_bill"), Constants.CODE_REFRESH);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeTableStatus(Order order, String table_status_id, String status) {
        try {
            if (!order.order_type_id.equals("1")) {
                return;
            }

            new Thread(() -> {
                try {
                    Table table = appDatabase.tableDao().view(order.table_id);

                    if (CommonFunctions.orderPaymentStatus(order.total, order.total_paid) == 1 && !order.order_status_id.equalsIgnoreCase("5")) {
                        table.table_status_id = "4";
                        table.status = "Order Taken";
                    } else {
                        table.table_status_id = table_status_id;
                        table.status = status;
                    }
                    table.updater_id = myPreferences.getLoggedInUser().id;
                    appDatabase.tableDao().insert(table);
                    AndroidNetworking.post(ApiEndPoints.tables + table.id)
                            .addApplicationJsonBody(table)
                            .build()
                            .getAsObject(Table.class, new ParsedRequestListener() {
                                @Override
                                public void onResponse(Object response) {

                                }

                                @Override
                                public void onError(ANError anError) {

                                }
                            });
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    int lastCheckedId = 0;
    boolean moveNext = false;

    private void setListener() {
        try {
            ivBack.setOnClickListener(v -> getActivity().onBackPressed());
            tvAllOrders.setOnClickListener(v -> getActivity().onBackPressed());
            swipeRefreshLayout.setOnRefreshListener(this::fetchOrders);


            llToday.setOnClickListener(v -> {
                cvCustom.setVisibility(View.GONE);
                filterType = 0;
                chekedBtn(llToday);
                getToday();
            });
            llThisWeek.setOnClickListener(v -> {
                cvCustom.setVisibility(View.GONE);
                filterType = 1;
                chekedBtn(llThisWeek);
                getWeek();
            });
            llThisMonth.setOnClickListener(v -> {
                cvCustom.setVisibility(View.GONE);
                filterType = 2;
                chekedBtn(llThisMonth);
                getCurrentMonth();
            });
            llCustom.setOnClickListener(v -> {
                cvCustom.setVisibility(View.VISIBLE);
                chekedBtn(llCustom);
            });
            tvSelect.setOnClickListener(view -> {
                eposOrdersAdapter.showCheck = !eposOrdersAdapter.showCheck;
                eposOrdersAdapter.notifyDataSetChanged();
                if (eposOrdersAdapter.showCheck) {
                    tvSelect.setText("Cancel");
                } else {
                    tvSelect.setText("Select");
                    unSelectAll();
                }
            });
            btnCancel.setOnClickListener(view -> {
                tvSelect.performClick();
            });
            btnConfirm.setOnClickListener(view -> {
                performArchiveUnArchive();
            });
            ivSearch.setOnClickListener(view -> {
                if (!etSearch.getText().toString().isEmpty()) {
                    etSearch.setText("");
                    tvSearch.performClick();
                }
            });
            llFromDate.setOnClickListener(view -> {
                DatePickerDialog datePickerDialog = DatePickerDialog.newInstance((DatePickerDialog.OnDateSetListener) (view1, y, m, d) -> {
                    fromDay = d;
                    fromMonth = m;
                    fromYear = y;
                    fromDateString = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                    fromCalender.set(y, m, d, 0, 0, 0);
                    fromDate = fromCalender.getTime();
                    tvFromDate.setText("From: " + CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd/MM/yyyy"));
                    tvToDate.setText("To: " + CommonFunctions.formatUnknownDateTime(toDateString, "yyyy-MM-dd", "dd/MM/yyyy"));

                    filterType = 3;
                    fetchOrders();
                }, fromCalender.get(Calendar.YEAR), fromCalender.get(Calendar.MONTH), fromCalender.get(Calendar.DAY_OF_MONTH));

                datePickerDialog.setThemeDark(false);
                datePickerDialog.showYearPickerFirst(false);
                datePickerDialog.show(getActivity().getFragmentManager(), "FromPickerDialog");

                if (!Validators.isNullOrEmpty(toDateString)) {
                    datePickerDialog.setMaxDate(toCalender);
                }
            });

            llToDate.setOnClickListener(view -> {
                DatePickerDialog datePickerDialog = DatePickerDialog.newInstance((view12, y, m, d) -> {
                    toDay = d;
                    toMonth = m;
                    toYear = y;
                    toDateString = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                    toCalender.set(y, m, d, 23, 59, 59);
                    toDate = toCalender.getTime();
                    tvFromDate.setText("From: " + CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd/MM/yyyy"));
                    tvToDate.setText("To: " + CommonFunctions.formatUnknownDateTime(toDateString, "yyyy-MM-dd", "dd/MM/yyyy"));

                    filterType = 3;
                    fetchOrders();
                }, toCalender.get(Calendar.YEAR), toCalender.get(Calendar.MONTH), toCalender.get(Calendar.DAY_OF_MONTH));
                datePickerDialog.setThemeDark(false);
                datePickerDialog.showYearPickerFirst(false);
                datePickerDialog.show(getActivity().getFragmentManager(), "ToPickerDialog");

                if (!Validators.isNullOrEmpty(fromDateString)) {
                    datePickerDialog.setMinDate(fromCalender);
                }
            });

            tvSearch.setOnClickListener(view -> {
                fetchOrders(etSearch.getText().toString());
            });
            etSearch.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence s, int start, int count, int after) {

                }

                @Override
                public void onTextChanged(CharSequence s, int start, int before, int count) {

                }

                @Override
                public void afterTextChanged(Editable s) {
                    if (etSearch.getText().toString().length() == 0 && !swipeRefreshLayout.isRefreshing()) {
                        //Show clear icon instead of search icon
                        ivSearch.setImageResource(R.drawable.ic_baseline_search_24);
                    } else {
                        ivSearch.setImageResource(R.drawable.ic_baseline_close_24);
                    }
                }
            });
            etSearch.setOnEditorActionListener((v, actionId, event) -> {
                if (actionId == EditorInfo.IME_ACTION_SEARCH) {
                    fetchOrders(etSearch.getText().toString().trim());
                    CommonFunctions.hideKeyboard(getActivity(), etSearch);
                    return true;
                }
                return false;
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void performArchiveUnArchive() {
        try {
            if (MyApp.userPermission != null && MyApp.userPermission.archive_order.actions.list) {
                new Thread(() -> {
                    appDatabase.orderDao().archiveStatus(selectedOrderIds, !isArchived);
                    List<String> onlineIds = appDatabase.orderDao().onlineIds(selectedOrderIds);
                    if (myApp.isConnected(getActivity()) && "auto".equalsIgnoreCase(myPreferences.getOrderSyncMode())) {
                        uploadArchiveStatus(onlineIds);
                    } else {
                        if (getActivity() != null) getActivity().runOnUiThread(() -> fetchOrders());
                    }
                }).start();

            } else {
                tvSelect.setVisibility(View.GONE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void uploadArchiveStatus(List<String> onlineIds) {
        try {
            if (getActivity() != null) getActivity().runOnUiThread(() -> progressDialog.show());
            String url = ApiEndPoints.archive_orders;
            if (isArchived) {
                url = ApiEndPoints.unarchive_orders;
            }
            AndroidNetworking.post(url)
                    .addBodyParameter("ids", new Gson().toJson(onlineIds))
                    .build()
                    .getAsObject(Object.class, new ParsedRequestListener() {
                        @Override
                        public void onResponse(Object response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        progressDialog.dismiss();
                                        fetchOrders();
                                    });
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (getActivity() != null)
                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                anError.printStackTrace();
                                if (anError.getErrorCode() == 400) {
                                    ToastUtils.makeSnackToast(getActivity(), anError.getErrorAsObject(ApiError.class).getMessage());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void unSelectAll() {
        try {
            for (Object object : objects) {
                if (object instanceof Order) {
                    ((Order) object).selected = false;
                }
            }
            selectedOrderIds.clear();
            tvSelectedOrders.setText("0 orders selected");
            cvArchiveAction.setVisibility(View.GONE);
            eposOrdersAdapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void chekedBtn(View v) {
        try {
            vToday.setBackgroundResource(R.color.light_gray);
            tvToday.setAlpha(0.5f);

            vThisWeek.setBackgroundResource(R.color.light_gray);
            tvThisWeek.setAlpha(0.5f);

            vThisMonth.setBackgroundResource(R.color.light_gray);
            tvThisMonth.setAlpha(0.5f);

            vCustom.setBackgroundResource(R.color.light_gray);
            tvCustom.setAlpha(0.5f);

            if (v == llToday) {
                vToday.setBackgroundResource(R.color.persian_green);
                tvToday.setAlpha(1f);
            }
            if (v == llThisWeek) {
                vThisWeek.setBackgroundResource(R.color.persian_green);
                tvThisWeek.setAlpha(1f);
            }
            if (v == llThisMonth) {
                vThisMonth.setBackgroundResource(R.color.persian_green);
                tvThisMonth.setAlpha(1f);
            }
            if (v == llCustom) {
                vCustom.setBackgroundResource(R.color.persian_green);
                tvCustom.setAlpha(1f);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void customClick() {
        if ((!Validators.isNullOrEmpty(fromDateString)) && (Validators.isNullOrEmpty(toDateString))) {
            llToDate.performClick();
        } else {
            moveNext = true;
            llFromDate.performClick();
        }
    }

    private void getCurrentMonth() {
        try {
            c.set(year, month, day);
            fromDate = c.getTime();

            int numOfDaysInMonth = c.getActualMaximum(Calendar.DAY_OF_MONTH);
            c.add(Calendar.DAY_OF_MONTH, numOfDaysInMonth - 1);

            toDate = c.getTime();

            fromDateString = CommonFunctions.formatMiliToDesireFormat(fromDate.getTime(), "yyyy-MM-dd");
            toDateString = CommonFunctions.formatMiliToDesireFormat(toDate.getTime(), "yyyy-MM-dd");
            tvFromDate.setText("From: " + CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd/MM/yyyy"));
            tvToDate.setText("To: " + CommonFunctions.formatUnknownDateTime(toDateString, "yyyy-MM-dd", "dd/MM/yyyy"));

            fetchingOrders = true;
            etSearch.setText("");
            fetchOrders();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getWeek() {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setFirstDayOfWeek(Calendar.MONDAY);
            cal.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
            fromDate = cal.getTime();

            cal.add(Calendar.DATE, 6);
            toDate = cal.getTime();

            fromDateString = CommonFunctions.formatMiliToDesireFormat(fromDate.getTime(), "yyyy-MM-dd");
            toDateString = CommonFunctions.formatMiliToDesireFormat(toDate.getTime(), "yyyy-MM-dd");
            tvFromDate.setText("From: " + CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd/MM/yyyy"));
            tvToDate.setText("To: " + CommonFunctions.formatUnknownDateTime(toDateString, "yyyy-MM-dd", "dd/MM/yyyy"));

            fetchingOrders = true;
            etSearch.setText("");


            fetchOrders();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getToday() {
        try {
            fromDateString = CommonFunctions.formatMiliToDesireFormat(System.currentTimeMillis(), "yyyy-MM-dd");
            toDateString = CommonFunctions.formatMiliToDesireFormat(System.currentTimeMillis(), "yyyy-MM-dd");
            fromDate = new Date();
            toDate = fromDate;
            fetchingOrders = true;
            etSearch.setText("");
            tvFromDate.setText("From: " + CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd/MM/yyyy"));
            tvToDate.setText("To: " + CommonFunctions.formatUnknownDateTime(toDateString, "yyyy-MM-dd", "dd/MM/yyyy"));

            fetchOrders();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchOrders() {
        try {
            if (getActivity() != null && myApp.isConnected(getActivity()) && "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode())) {
                fetchOnlineOrders();
            } else {
                orderHistoryAsync = new OrderHistoryAsync();
                orderHistoryAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchOrders(String query) {
        try {
            orderHistoryAsync = new OrderHistoryAsync();
            orderHistoryAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, query);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchOnlineOrders() {
        try {
            swipeRefreshLayout.setVisibility(View.VISIBLE);
            orders.clear();
            try {
                eposOrdersAdapter.notifyDataSetChanged();
            } catch (Exception e) {
                e.printStackTrace();
            }
            swipeRefreshLayout.setRefreshing(true);
            AndroidNetworking.get(ApiEndPoints.orders)
                    .setTag("fetchOnlineOrdersEposOrderHistory")
                    .addQueryParameter("archived", isArchived ? "1" : "0")
                    .addQueryParameter("nopaginate", "1")
                    .addQueryParameter("from_date", fromDateString)
                    .addQueryParameter("to_date", toDateString)
                    .build()
                    .getAsObjectList(Order.class, new ParsedRequestListener<List<Order>>() {
                        @Override
                        public void onResponse(List<Order> response) {
                            try {
                                Collections.reverse(response);
                                orderHistoryAsync = new OrderHistoryAsync();
                                orderHistoryAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, response);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                boolean shouldDelete = false;
                                if (anError.getErrorCode() == 400) shouldDelete = true;
                                swipeRefreshLayout.setRefreshing(false);
                                orderHistoryAsync = new OrderHistoryAsync();
                                orderHistoryAsync.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private class OrderHistoryAsync extends AsyncTask<Object, String, String> {
        private ArrayList<Object> localObjects = new ArrayList<>();

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            try {
                if (eposOrdersAdapter.showCheck)
                    tvSelect.performClick();
                fetchingOrders = true;
                swipeRefreshLayout.setRefreshing(true);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        protected String doInBackground(Object... lists) {
            try {
                String query = null;
                if (lists.length > 0) {
                    if (lists[0] instanceof String) {
                        query = (String) lists[0];
                    }
                    if (lists[0] instanceof ArrayList<?>) {
                        ArrayList<Order> localOrders = (ArrayList<Order>) lists[0];
                        Iterator<Order> iterator = localOrders.iterator();
                        List<String> shouldNotDeleteThisIds;

                        while (iterator.hasNext()) {
                            Order order = iterator.next();
                            if (isCancelled()) break;
                            Order dbOrder = appDatabase.orderDao().view(order.id);
                            if (dbOrder == null) {
                                // if local order is not updated check with local unique id in order to prevent duplicate order issue
                                dbOrder = appDatabase.orderDao().viewByUniqueId(order.unique_id);
                            }
                            Customer dbCustomer = appDatabase.customerDao().view(order.customer_id);
                            int _customer_id;
                            if (dbCustomer == null) {
                                dbCustomer = order.customer;
                                _customer_id = (int) appDatabase.customerDao().insert(order.customer);
                            } else {
                                _customer_id = dbCustomer._id;
                                dbCustomer = order.customer;
                                dbCustomer._id = _customer_id;
                                appDatabase.customerDao().update(dbCustomer);
                                _customer_id = dbCustomer._id;
                            }
                            order._customer_id = _customer_id;
                            order.customer._id = _customer_id;

                            int _order_id;
                            order.customer_name = dbCustomer.name;
                            // if uploaded true for order history order
                            order.is_uploaded_on_server = true;
                            if (dbOrder == null) {
                                _order_id = (int) appDatabase.orderDao().insert(order);
                                order._id = _order_id;
                            } else {
                                order._id = dbOrder._id;
                                _order_id = dbOrder._id;
                                // if local order status is not paid then update the order
                                if (!dbOrder.order_status_id.equalsIgnoreCase("5") || order.order_status_id.equalsIgnoreCase("10")) {
                                    appDatabase.orderDao().update(order);
                                }
                            }


                            shouldNotDeleteThisIds = new ArrayList<>();
                            if (order.order_splits != null) {
                                for (OrderSplit split : order.order_splits) {
                                    shouldNotDeleteThisIds.add(split.id);
                                    split._order_id = _order_id;
                                    OrderSplit dbSplit = appDatabase.orderSplitDao().view(split.id);
                                    if (dbSplit == null) {
                                        split._id = (int) appDatabase.orderSplitDao().insert(split);
                                    } else {
                                        split._id = dbSplit._id;
                                        appDatabase.orderSplitDao().update(split);
                                    }
                                }
                            }
                            appDatabase.orderSplitDao().deleteOtherIdsButNotThis(_order_id, shouldNotDeleteThisIds);

                            shouldNotDeleteThisIds = new ArrayList<>();
                            if (order.order_payments != null) {
                                for (OrderPayment payment : order.order_payments) {
                                    shouldNotDeleteThisIds.add(payment.id);
                                    payment._order_id = _order_id;
                                    OrderPayment dbPayment = appDatabase.orderPaymentDao().view(payment.id);
                                    if (dbPayment == null) {
                                        payment._id = (int) appDatabase.orderPaymentDao().insert(payment);
                                    } else {
                                        payment._id = dbPayment._id;

                                    }
                                    if (!Validators.isNullOrEmpty(payment.order_split_id)) {
                                        OrderSplit dbOrderSplit = appDatabase.orderSplitDao().view(payment.order_split_id);
                                        if (dbOrderSplit != null)
                                            payment._order_split_id = dbOrderSplit._id;
                                    }
                                    appDatabase.orderPaymentDao().insert(payment);
                                }
                            }

                            appDatabase.orderPaymentDao().deleteOtherIdsButNotThis(_order_id, shouldNotDeleteThisIds);

                            if (order.order_items != null) {
                                for (OrderItem orderItem : order.order_items) {
                                    orderItem._order_id = _order_id;
                                    OrderItem dbOrderItem = myApp.appDatabase.orderItemDao().view(orderItem.id);

                                    if (!Validators.isNullOrEmpty(orderItem.order_split_id)) {
                                        OrderSplit orderSplit = appDatabase.orderSplitDao().view(orderItem.order_split_id);
                                        if (orderSplit != null)
                                            orderItem._order_split_id = orderSplit._id;
                                    }

                                    int _order_item_id = 0;
                                    if (dbOrderItem == null) {
                                        try {
                                            _order_item_id = (int) appDatabase.orderItemDao().insert(orderItem);
                                            orderItem._id = _order_item_id;
                                        } catch (Exception e) {

                                        }
                                    } else {
                                        _order_item_id = dbOrderItem._id;
                                        orderItem._id = _order_item_id;
                                        appDatabase.orderItemDao().update(orderItem);
                                    }

                                    float addonTotal = 0;
                                    shouldNotDeleteThisIds = new ArrayList<>();
                                    if (orderItem.order_item_addons != null) {
                                        for (OrderItemAddon itemAddon : orderItem.order_item_addons) {
                                            shouldNotDeleteThisIds.add(itemAddon.id);
                                            itemAddon._order_item_id = _order_item_id;
                                            itemAddon.total = itemAddon.quantity * itemAddon.price;
                                            addonTotal = addonTotal + itemAddon.total;
                                            OrderItemAddon dbAddon = appDatabase.orderItemAddonDao().view(itemAddon.id);
                                            if (dbAddon == null) {
                                                itemAddon._id = (int) appDatabase.orderItemAddonDao().insert(itemAddon);
                                            } else {
                                                itemAddon._id = dbAddon._id;
                                                appDatabase.orderItemAddonDao().update(itemAddon);
                                            }
                                        }
                                    }
                                    appDatabase.orderItemAddonDao().deleteOtherIdsButNotThis(_order_item_id, shouldNotDeleteThisIds);

                                    float ingredientTotal = 0;
                                    if (orderItem.order_item_ingredients != null) {
                                        appDatabase.orderItemIngredientDao().deleteAll(_order_item_id);
                                        for (OrderItemIngredient itemIngredient : orderItem.order_item_ingredients) {
                                            itemIngredient._order_item_id = _order_item_id;
                                            itemIngredient.total = itemIngredient.quantity * itemIngredient.price;
                                            ingredientTotal = ingredientTotal + itemIngredient.total;
                                            OrderItemIngredient dbAddon = appDatabase.orderItemIngredientDao().view(itemIngredient.id);
                                            if (dbAddon == null) {
                                                itemIngredient._id = (int) appDatabase.orderItemIngredientDao().insert(itemIngredient);
                                            } else {
                                                itemIngredient._id = dbAddon._id;
                                                appDatabase.orderItemIngredientDao().update(itemIngredient);
                                            }
                                        }
                                    }

                                    ingredientTotal = ingredientTotal * orderItem.quantity;
                                    addonTotal = addonTotal * orderItem.quantity;
                                    myApp.appDatabase.orderItemDao().updateOrderItemTotal(_order_item_id, addonTotal, ingredientTotal);
                                }
                            }
                        }
                    }
                }

                if (isCancelled()) return null;
                LinkedHashMap<String, String> dateRanges = new LinkedHashMap<>();
                if (filterType == 0) {
                    dateRanges.put(CommonFunctions.convertMsToDesiredFormat(fromDate.getTime(), "yyyy-MM-dd"), CommonFunctions.convertMsToDesiredFormat(fromDate.getTime(), "yyyy-MM-dd"));
                } else if (filterType == 1) {
                    for (Date date : getDatesRangeJava7(fromDate, toDate, 1)) {
                        dateRanges.put(CommonFunctions.convertMsToDesiredFormat(date.getTime(), "yyyy-MM-dd"), CommonFunctions.convertMsToDesiredFormat(date.getTime(), "yyyy-MM-dd"));
                    }
                } else if (filterType == 2) {
                    for (Date date : getDatesRangeJava7(fromDate, toDate, 7)) {
                        Calendar calStart = Calendar.getInstance();
                        calStart.setTime(date);
                        calStart.add(Calendar.DAY_OF_WEEK, 6);
                        dateRanges.put(CommonFunctions.convertMsToDesiredFormat(date.getTime(), "yyyy-MM-dd"), CommonFunctions.convertMsToDesiredFormat(calStart.getTime().getTime(), "yyyy-MM-dd"));
                    }
                } else if (filterType == 3) {
                    for (Date date : getDatesRangeJava7(fromDate, toDate, 1)) {
                        dateRanges.put(CommonFunctions.convertMsToDesiredFormat(date.getTime(), "yyyy-MM-dd"), CommonFunctions.convertMsToDesiredFormat(date.getTime(), "yyyy-MM-dd"));
                    }
                }
                localObjects.clear();
                List<String> statusIds = new ArrayList<>();
                statusIds.add("1");
                statusIds.add("2");
                statusIds.add("3");
                statusIds.add("4");
                statusIds.add("7");
                statusIds.add("5");
                statusIds.add("6");
                statusIds.add("9");
                statusIds.add("10");
                int count = 1;
                for (Map.Entry<String, String> entry : dateRanges.entrySet()) {
                    String startDate = entry.getKey();
                    String endDate = entry.getValue();
                    ArrayList<Order> rangeOrders = new ArrayList<>();
                    if (Validators.isNullOrEmpty(query)) {
                        rangeOrders = (ArrayList<Order>) myApp.appDatabase.orderDao().historyListWithoutDelivery(startDate, endDate, statusIds, isArchived);

                        // store delivery order
                        ArrayList<Order> deliveryOrder = new ArrayList<>();
                        deliveryOrder = (ArrayList<Order>) myApp.appDatabase.orderDao().historyListWithDelivery(startDate, endDate, statusIds, isArchived);
                        if (deliveryOrder != null) {
                            for (int i = 0; i < deliveryOrder.size(); i++) {
                                Order order = deliveryOrder.get(i);
                                order.customer = myApp.appDatabase.customerDao().view(order._customer_id);
                            }
                        } else {
                            deliveryOrder = new ArrayList<>();
                        }
                        rangeOrders.addAll(deliveryOrder);
                    } else {
                        if (isFromTableFilter) {
                            isFromTableFilter = false;
                            rangeOrders = (ArrayList<Order>) myApp.appDatabase.orderDao().historyListFilterTableWise(startDate, endDate, statusIds, query, isArchived);
                        } else {
                            boolean isSearchMobileNumber = false;
                            try {
                                isSearchMobileNumber = true;
                                query = "%" + Integer.parseInt(query.trim())+ "%";
                            } catch (Exception e) {
                                isSearchMobileNumber = false;
                                query = "%" + query.trim() + "%";
                            }
                            if(isSearchMobileNumber){
                                rangeOrders = (ArrayList<Order>) myApp.appDatabase.orderDao().historyListCustomer(startDate, endDate, statusIds, query, isArchived);
                            }else {
                                rangeOrders = (ArrayList<Order>) myApp.appDatabase.orderDao().historyList(startDate, endDate, statusIds, query, isArchived);
                            }
                        }
                    }
                    if (rangeOrders != null && rangeOrders.size() > 0) {
                        if (startDate.equalsIgnoreCase(endDate)) {
                            localObjects.add(new Header(CommonFunctions.formatUnknownDateTime(startDate, "yyyy-MM-dd", "dd MMM yyyy"), -1 * count));
                        } else {
                            localObjects.add(new Header(CommonFunctions.formatUnknownDateTime(startDate, "yyyy-MM-dd", "dd MMM") + " - " + CommonFunctions.formatUnknownDateTime(endDate, "yyyy-MM-dd", "dd MMM yyyy"), -1 * count));
                        }
                        count++;
                        localObjects.addAll(rangeOrders);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return "Executed";
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                fetchingOrders = false;
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        objects.clear();
                        objects.addAll(localObjects);
                        swipeRefreshLayout.setRefreshing(false);
                        swipeRefreshLayout.setVisibility(View.VISIBLE);
                        eposOrdersAdapter.notifyDataSetChanged();
                        if (objects != null) {
                            if (objects.isEmpty()) {
                                tvErrorMessage.setVisibility(View.VISIBLE);
                                rvTables.setVisibility(View.GONE);
                            } else {
                                tvErrorMessage.setVisibility(View.GONE);
                                rvTables.setVisibility(View.VISIBLE);
                            }
                        }
                        if (MyApp.userPermission != null && MyApp.userPermission.archive_order.actions.list) {
                            tvSelect.setVisibility(View.VISIBLE);
                        } else {
                            tvSelect.setVisibility(View.GONE);
                        }
                        if (objects.size() == 0) {
                            tvSelect.setVisibility(View.GONE);
                        }
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        protected void onCancelled() {
            super.onCancelled();
            try {
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        swipeRefreshLayout.setRefreshing(false);
                        eposOrdersAdapter.notifyDataSetChanged();
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class TableByIdAsync extends AsyncTask<Object, String, String> {
        String tableId;
        Order order;
        boolean isLocked = false;
        String number = "";

        TableByIdAsync(String tableId, Order order) {
            this.tableId = tableId;
            this.order = order;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected String doInBackground(Object... lists) {
            Table table = appDatabase.tableDao().view(tableId);
            isLocked = table.locked;
            number = table.number;
            return "Executed";
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        if (isLocked) {
                            ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Busy", number + " is Busy right now", 2, "Okay", null);
                            confirmationDialogFragment.show(getChildFragmentManager(), "confirm");
                        } else {
                            if (order.order_status_id.equalsIgnoreCase("5") || order.order_status_id.equalsIgnoreCase("10")) {
                                openOverViewBottomSheet(order._id);
                            } else {
                                startActivityForResult(new Intent(getActivity(), NewOrderActivity.class).putExtra("order", new Gson().toJson(order)), Constants.CODE_REFRESH);
                            }
                        }
                        progressDialog.dismiss();
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        protected void onCancelled() {
            super.onCancelled();
            try {
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        progressDialog.dismiss();
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<Date> getDatesRangeJava7(Date startDate, Date endDate, int interval) {
        List<Date> datesInRange = new ArrayList<>();
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(startDate);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(endDate);

        while (!startCalendar.after(endCalendar)) {
            Date result = startCalendar.getTime();
            datesInRange.add(result);
            startCalendar.add(Calendar.DATE, interval);
        }
        Collections.reverse(datesInRange);
        return datesInRange;
    }


    BroadcastReceiver orderUpdateReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getBooleanExtra("result", false) && myApp.shallWeRefreshOrders) {
                    swipeRefreshLayout.setRefreshing(true);
                    fetchOrders();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == Constants.CODE_REFRESH && resultCode == RESULT_OK) {
//            fetchOrders();
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        try {
            if (orderHistoryAsync != null) {
                orderHistoryAsync.cancel(true);
            }
            AndroidNetworking.cancel("fetchOnlineOrdersEposOrderHistory");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if (getActivity() != null && orderUpdateReceiver != null)
            LocalBroadcastManager.getInstance(getActivity()).registerReceiver(orderUpdateReceiver, new IntentFilter(
                    Constants.EPOS_ORDER_UPDATE));
    }

    @Override
    public void onPause() {
        super.onPause();
        if (getActivity() != null && orderUpdateReceiver != null) {
            LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(orderUpdateReceiver);
        }
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        if (eposOrdersAdapter != null) {
            eposOrdersAdapter.orders = null;
            if (eposOrdersAdapter.handler != null) {
                eposOrdersAdapter.tmr.cancel();
                eposOrdersAdapter.tmr = null;
                eposOrdersAdapter.handler.removeCallbacks(eposOrdersAdapter.updateTime);
                eposOrdersAdapter.handler.removeCallbacks(null);
                eposOrdersAdapter.handler = null;
            }
            eposOrdersAdapter.lstHolders = null;
            eposOrdersAdapter.lstHomeHolders = null;
            eposOrdersAdapter.homeActionListener = null;
            eposOrdersAdapter.itemClickListener = null;
            eposOrdersAdapter.actionListener = null;
            eposOrdersAdapter = null;
        }

    }
}
