package com.ubsidi.epos_2021.fragment;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatSpinner;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.ANRequest;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.button.MaterialButtonToggleGroup;
import com.google.android.material.card.MaterialCardView;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.activities.NewOrderActivity;
import com.ubsidi.epos_2021.adapters.FullReportAdapter;
import com.ubsidi.epos_2021.adapters.SelectedUserAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.comman.bluetoothprinter.BluetoothPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinterV3Mix;
import com.ubsidi.epos_2021.comman.printer.WifiPrinter;
import com.ubsidi.epos_2021.comman.printer.ZoneRichPrinter;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.DaoReportNameTotalValue;
import com.ubsidi.epos_2021.models.FullReport;
import com.ubsidi.epos_2021.models.OrderExternalPayment;
import com.ubsidi.epos_2021.models.Printer;
import com.ubsidi.epos_2021.models.ReportOrderPaymentMethod;
import com.ubsidi.epos_2021.models.ReportOrderStatus;
import com.ubsidi.epos_2021.models.ReportOrderType;
import com.ubsidi.epos_2021.models.ReportTextModel;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.User;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.ToastUtils;
import com.wdullaer.materialdatetimepicker.date.DatePickerDialog;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class FullReportFragment extends BaseFragment {
    private SiteSetting webOrderSetting;
    private Chip chipBack;
    private LinearLayout llToDate, llFromDate;
    private String fromDateString, toDateString;
    private Calendar today = Calendar.getInstance();
    int fromYear, fromMonth, fromDay, toYear, toMonth, toDay;
    private Calendar fromCalender = Calendar.getInstance();
    private Calendar toCalender = Calendar.getInstance();
    private Date fromDate, toDate;
    private TextView tvFromDate, tvToDate;
    private MaterialButton btnToday, btnThisWeek, btnThisMonth, btnCustom;
    private MaterialButtonToggleGroup btnGroup;
    private MaterialCardView cvCustom;
    private RecyclerView rvReports;
    private MaterialButton btnBack, btnPrint;
    private ArrayList<Object> reports = new ArrayList<>();
    private ArrayList<Object> onlineReports = new ArrayList<>();
    private FullReportAdapter reportAdapter;
    private LinearLayout llProgress, llData;
    private TextView tvSelectedDate;

    private Date startDate, endDate;
    Calendar c = Calendar.getInstance();
    int year = c.get(Calendar.YEAR);
    int month = c.get(Calendar.MONTH);
    int day = 1;
    private DatePickerDialog fromPicker, toPicker;
    int selectedButton = 0;
    private ZoneRichPrinter zoneRichPrinter;
    private SunmiPrinter sunmiPrinter;
    private SunmiPrinterV3Mix sunmiPrinterV3Mix;
    private WifiPrinter wifiPrinter;
    public BluetoothPrinter bluetoothPrinter;
    private SiteSetting ticketHeaderSetting, ticketHeaderTypeSetting, footerASetting, footerBSetting;
    private int headerAlignment = 0;
    Printer defaultPrinter;
    private TextView tvTitle;
    private LinearLayout llUsers;
    private AppCompatSpinner spinnerUsers;
    private boolean isUserReport = false, isOnlineReport, isArchived;
    private ArrayList<User> users = new ArrayList<>();
    private SelectedUserAdapter userArrayAdapter;
    private User selectedUser;

    private String title;

    private LinearLayout llToday, llThisWeek, llThisMonth, llCustom;
    private TextView tvToday, tvThisWeek, tvThisMonth, tvCustom;
    private View vToday, vThisWeek, vThisMonth, vCustom;
    public ArrayList<ReportOrderPaymentMethod> order_payment_wise;
    private String transaction_value = "",external_payments="";
    private FullReport fullReport;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_full_report, container, false);
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        try {
            if (getArguments() != null) {
                isUserReport = getArguments().getBoolean("user_report", false);
                isOnlineReport = getArguments().getBoolean("online_report", false);
                isArchived = getArguments().getBoolean("is_archived", false);
                title = getArguments().getString("title");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onViewCreated(@NonNull @NotNull View view, @Nullable @org.jetbrains.annotations.Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            if (MyApp.userPermission != null) {
                setListeners();
                if (isUserReport) {
                    llUsers.setVisibility(View.VISIBLE);
                    tvTitle.setText("Selected User Report");
                    fetchUsers();
                } else {
                    llUsers.setVisibility(View.GONE);
                    getToday();
                }
                if (!Validators.isNullOrEmpty(title))
                    tvTitle.setText(title);
            } else {
                ToastUtils.makeSnackToast(getActivity(), "No permissions found!");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchUsers() {
        try {
            new Thread(() -> {
                try {
                    users.clear();
                    users.addAll(appDatabase.userDao().list());
                    if (users.size() > 0)
                        selectedUser = users.get(0);
                    if (getActivity() != null) {
                        getActivity().runOnUiThread(() -> {
                            userArrayAdapter.notifyDataSetChanged();
                            getToday();
                        });
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            webOrderSetting = myApp.findSetting("is_weborder");
            loadSettings();
            zoneRichPrinter = new ZoneRichPrinter(getActivity());
            sunmiPrinter = new SunmiPrinter(getActivity());
            if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                sunmiPrinterV3Mix = new SunmiPrinterV3Mix(requireActivity());
            }
            defaultPrinter = myPreferences.getDefaultPrinter();
            zoneRichPrinter = myApp.connectZonerich(zoneRichPrinter, defaultPrinter);
            wifiPrinter = WifiPrinter.getInstance();
            bluetoothPrinter = new BluetoothPrinter(getActivity());
            tvTitle = view.findViewById(R.id.tvTitle);
            llUsers = view.findViewById(R.id.llUsers);
            spinnerUsers = view.findViewById(R.id.spinnerUsers);
            userArrayAdapter = new SelectedUserAdapter(getActivity(), android.R.layout.simple_list_item_1, users);
            spinnerUsers.setAdapter(userArrayAdapter);

            chipBack = view.findViewById(R.id.chipBack);
            btnToday = view.findViewById(R.id.btnToday);
            btnThisWeek = view.findViewById(R.id.btnThisWeek);
            btnThisMonth = view.findViewById(R.id.btnThisMonth);
            btnCustom = view.findViewById(R.id.btnCustom);
            btnGroup = view.findViewById(R.id.btnGroup);

            cvCustom = view.findViewById(R.id.cvCustom);
            rvReports = view.findViewById(R.id.rvReports);
            btnBack = view.findViewById(R.id.btnBack);
            btnPrint = view.findViewById(R.id.btnPrint);
            llToDate = view.findViewById(R.id.llToDate);
            llFromDate = view.findViewById(R.id.llFromDate);
            tvToDate = view.findViewById(R.id.tvToDate);
            tvFromDate = view.findViewById(R.id.tvFromDate);
            llProgress = view.findViewById(R.id.llProgress);
            llData = view.findViewById(R.id.llData);
            tvSelectedDate = view.findViewById(R.id.tvSelectedDate);

            llToday = view.findViewById(R.id.llToday);
            llThisWeek = view.findViewById(R.id.llThisWeek);
            llThisMonth = view.findViewById(R.id.llThisMonth);
            llCustom = view.findViewById(R.id.llCustom);

            tvToday = view.findViewById(R.id.tvToday);
            tvThisWeek = view.findViewById(R.id.tvThisWeek);
            tvThisMonth = view.findViewById(R.id.tvThisMonth);
            tvCustom = view.findViewById(R.id.tvCustom);

            vToday = view.findViewById(R.id.vToday);
            vThisWeek = view.findViewById(R.id.vThisWeek);
            vThisMonth = view.findViewById(R.id.vThisMonth);
            vCustom = view.findViewById(R.id.vCustom);

            chekedBtn(llToday);
            cvCustom.setVisibility(View.GONE);
            reportAdapter = new FullReportAdapter(reports, (position, data) -> {

            });
            rvReports.setLayoutManager(new WrapContentLinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
            rvReports.setItemAnimator(null);
            rvReports.setAdapter(reportAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public class WrapContentLinearLayoutManager extends LinearLayoutManager {
        public WrapContentLinearLayoutManager(Context context, int orientation, boolean reverseLayout) {
            super(context, orientation, reverseLayout);
        }

        @Override
        public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
            try {
                super.onLayoutChildren(recycler, state);
            } catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadSettings() {
        try {
            ticketHeaderTypeSetting = myApp.findSetting("ticket_header_type");
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("right")) {
                headerAlignment = 2;
            }
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("center")) {
                headerAlignment = 1;
            }
            ticketHeaderSetting = myApp.findSetting("ticket_header");

            footerASetting = myApp.findSetting("footer_a");
            footerBSetting = myApp.findSetting("footer_b");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void setListeners() {
        try {
            chipBack.setOnClickListener(v -> getActivity().onBackPressed());
            llToday.setOnClickListener(v -> {
                selectedButton = llToday.getId();
                cvCustom.setVisibility(View.GONE);
                chekedBtn(llToday);
                getToday();
            });
            llThisWeek.setOnClickListener(v -> {
                selectedButton = llThisWeek.getId();
                cvCustom.setVisibility(View.GONE);
                chekedBtn(llThisWeek);
                getWeek();
            });
            llThisMonth.setOnClickListener(v -> {
                selectedButton = llThisMonth.getId();
                cvCustom.setVisibility(View.GONE);
                chekedBtn(llThisMonth);
                getCurrentMonth();
            });
            llCustom.setOnClickListener(v -> {
                selectedButton = llCustom.getId();
                cvCustom.setVisibility(View.VISIBLE);
                chekedBtn(llCustom);
            });

            llFromDate.setOnClickListener(view -> {
                try {
                    DatePickerDialog datePickerDialog = DatePickerDialog.newInstance((view1, y, m, d) -> {
                        fromDay = d;
                        fromMonth = m;
                        fromYear = y;
                        fromDateString = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                        fromCalender.set(y, m, d);
                        tvFromDate.setText(CommonFunctions.formatMiliToDesireFormat(fromCalender.getTimeInMillis(), "dd/MM/yyyy"));
                        setDateText();
                        fetchReport();
                    }, fromCalender.get(Calendar.YEAR), fromCalender.get(Calendar.MONTH), fromCalender.get(Calendar.DAY_OF_MONTH));
                    datePickerDialog.setThemeDark(false);
                    datePickerDialog.showYearPickerFirst(false);
                    datePickerDialog.show(getActivity().getFragmentManager(), "FromPickerDialog");
                    if (!Validators.isNullOrEmpty(toDateString)) {
                        datePickerDialog.setMaxDate(toCalender);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });

            llToDate.setOnClickListener(view -> {
                try {
                    DatePickerDialog datePickerDialog = DatePickerDialog.newInstance((view12, y, m, d) -> {
                        toDay = d;
                        toMonth = m;
                        toYear = y;
                        toDateString = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                        toCalender.set(y, m, d);
                        tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalender.getTimeInMillis(), "dd/MM/yyyy"));
                        setDateText();
                        fetchReport();
                    }, toCalender.get(Calendar.YEAR), toCalender.get(Calendar.MONTH), toCalender.get(Calendar.DAY_OF_MONTH));
                    datePickerDialog.setThemeDark(false);
                    datePickerDialog.showYearPickerFirst(false);
                    datePickerDialog.show(getActivity().getFragmentManager(), "ToPickerDialog");
                    if (!Validators.isNullOrEmpty(fromDateString)) {
                        datePickerDialog.setMinDate(fromCalender);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

            });
            btnBack.setOnClickListener(view -> {
                getActivity().onBackPressed();
            });
            btnPrint.setOnClickListener(view -> {
                createPrint();
            });
            spinnerUsers.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
                @Override
                public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                    try {
                        if (users.size() - 1 >= i) {
                            selectedUser = users.get(i);
                            fetchReport();
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onNothingSelected(AdapterView<?> adapterView) {

                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void chekedBtn(View v) {
        try {
            vToday.setBackgroundResource(R.color.light_gray);
            tvToday.setAlpha(0.5f);

            vThisWeek.setBackgroundResource(R.color.light_gray);
            tvThisWeek.setAlpha(0.5f);

            vThisMonth.setBackgroundResource(R.color.light_gray);
            tvThisMonth.setAlpha(0.5f);

            vCustom.setBackgroundResource(R.color.light_gray);
            tvCustom.setAlpha(0.5f);

            if (v == llToday) {
                vToday.setBackgroundResource(R.color.persian_green);
                tvToday.setAlpha(1f);
            }
            if (v == llThisWeek) {
                vThisWeek.setBackgroundResource(R.color.persian_green);
                tvThisWeek.setAlpha(1f);
            }
            if (v == llThisMonth) {
                vThisMonth.setBackgroundResource(R.color.persian_green);
                tvThisMonth.setAlpha(1f);
            }
            if (v == llCustom) {
                vCustom.setBackgroundResource(R.color.persian_green);
                tvCustom.setAlpha(1f);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setDateText() {
        try {
            if (fromDateString.equalsIgnoreCase(toDateString)) {
                tvSelectedDate.setText(CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd MMM yyyy"));
            } else {
                tvSelectedDate.setText(CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd MMM yyyy") + " to " + CommonFunctions.formatUnknownDateTime(toDateString, "yyyy-MM-dd", "dd MMM yyyy"));
            }

            tvFromDate.setText("From: " + CommonFunctions.formatUnknownDateTime(fromDateString, "yyyy-MM-dd", "dd/MM/yyyy"));
            tvToDate.setText("To: " + CommonFunctions.formatUnknownDateTime(toDateString, "yyyy-MM-dd", "dd/MM/yyyy"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getCurrentMonth() {
        try {
            c.set(year, month, day);
            startDate = c.getTime();


            int numOfDaysInMonth = c.getActualMaximum(Calendar.DAY_OF_MONTH);
            c.add(Calendar.DAY_OF_MONTH, numOfDaysInMonth - 1);

            endDate = c.getTime();

            fromDateString = CommonFunctions.formatMiliToDesireFormat(startDate.getTime(), "yyyy-MM-dd");
            toDateString = CommonFunctions.formatMiliToDesireFormat(endDate.getTime(), "yyyy-MM-dd");

            setDateText();

            fetchReport();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getWeek() {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setFirstDayOfWeek(Calendar.MONDAY);
            cal.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
            startDate = cal.getTime();

            cal.add(Calendar.DATE, 6);
            endDate = cal.getTime();

            fromDateString = CommonFunctions.formatMiliToDesireFormat(startDate.getTime(), "yyyy-MM-dd");
            toDateString = CommonFunctions.formatMiliToDesireFormat(endDate.getTime(), "yyyy-MM-dd");

            setDateText();
            fetchReport();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getToday() {
        try {
            fromDateString = CommonFunctions.formatMiliToDesireFormat(System.currentTimeMillis(), "yyyy-MM-dd");
            toDateString = CommonFunctions.formatMiliToDesireFormat(System.currentTimeMillis(), "yyyy-MM-dd");

            setDateText();
            fetchReport();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ReportAsync extends AsyncTask<String, String, String> {

        @Override
        protected String doInBackground(String... strings) {
            try {
                StringBuffer stringTotalOrdersQuery = new StringBuffer();
                StringBuffer stringTotalProductSaleQuery = new StringBuffer();
                StringBuffer stringTotalProductSaleAmountQuery = new StringBuffer();
                StringBuffer stringTotalDiscountQuery = new StringBuffer();
                StringBuffer stringTotalGratuityQuery = new StringBuffer();
                StringBuffer stringTotalServiceChargeQuery = new StringBuffer();
                StringBuffer stringTotalDeliveryChargeQuery = new StringBuffer();
                StringBuffer stringTotalDinersQuery = new StringBuffer();
                StringBuffer stringTotalTablesQuery = new StringBuffer();
                StringBuffer stringOrderTypeQuery = new StringBuffer();
                StringBuffer stringPaymentTypeQuery = new StringBuffer();
                StringBuffer stringOrderStatusQuery = new StringBuffer();
                StringBuffer stringRejectQuery = new StringBuffer();

                ArrayList<String> totalOrdersParams = new ArrayList<>();
                ArrayList<String> totalProductsSaleParams = new ArrayList<>();
                ArrayList<String> totalProductsSaleAmountParams = new ArrayList<>();
                ArrayList<String> totalDiscountsParams = new ArrayList<>();
                ArrayList<String> totalGratuityParams = new ArrayList<>();
                ArrayList<String> totalServiceChargeParams = new ArrayList<>();
                ArrayList<String> totalDeliveryChargeParams = new ArrayList<>();
                ArrayList<String> totalDinersParams = new ArrayList<>();
                ArrayList<String> totalTablesParams = new ArrayList<>();
                ArrayList<String> orderTypeParams = new ArrayList<>();
                ArrayList<String> paymentTypeParams = new ArrayList<>();
                ArrayList<String> orderStatusParams = new ArrayList<>();
                ArrayList<String> orderRejectParams = new ArrayList<>();

                stringTotalOrdersQuery.append("SELECT COUNT(*) from 'Order' WHERE date(created_at) >= ?  AND date(created_at) <= ?");
                stringOrderStatusQuery.append("SELECT COUNT(*) as total, SUM(total) as value, order_status as name from 'Order' WHERE date(created_at) >= ?  AND date(created_at) <= ? ");
                stringOrderTypeQuery.append("SELECT COUNT(*) as total, SUM(total) as value, order_type as name from 'Order' WHERE date(created_at) >= ?  AND date(created_at) <= ? AND order_status_id!=10");
                stringPaymentTypeQuery.append("SELECT COUNT(*) as total, SUM(amount) as value, payment_method_name as name from OrderPayment LEFT JOIN 'Order' ON 'Order'._id = OrderPayment._order_id  WHERE date('Order'.created_at) >= ?  AND date('Order'.created_at) <= ? AND order_status_id!=10");
                stringRejectQuery.append("SELECT COUNT(*) as total, SUM(amount) as value, payment_method_name as name from OrderPayment LEFT JOIN 'Order' ON 'Order'._id = OrderPayment._order_id  WHERE date('Order'.created_at) >= ?  AND date('Order'.created_at) <= ? AND 'Order'.order_status_id = 10 ");
                stringTotalDinersQuery.append("SELECT SUM(no_guest) from 'Order' WHERE date(created_at) >= ?  AND date(created_at) <= ? AND order_type_id = 1 AND order_status_id!=10");
                stringTotalTablesQuery.append("SELECT COUNT(*) from 'Order' WHERE date(created_at) >= ?  AND date(created_at) <= ? AND order_type_id = 1 AND order_status_id!=10");
                stringTotalDiscountQuery.append("SELECT SUM(discount) from 'Order' WHERE date(created_at) >= ?  AND date(created_at) <= ? AND order_status_id!=10");
                stringTotalGratuityQuery.append("SELECT SUM(gratuity) from 'Order' WHERE date(created_at) >= ?  AND date(created_at) <= ? AND order_status_id!=10");
                stringTotalServiceChargeQuery.append("SELECT SUM(service_charge) from 'Order' WHERE date(created_at) >= ?  AND date(created_at) <= ? AND order_status_id!=10");
                stringTotalDeliveryChargeQuery.append("SELECT SUM(delivery_charge) from 'Order' WHERE date(created_at) >= ?  AND date(created_at) <= ? AND order_status_id!=10");
                stringTotalProductSaleQuery.append("SELECT COUNT(*) from OrderItem LEFT JOIN 'Order' ON 'Order'._id = OrderItem._order_id WHERE date('Order'.created_at) >= ?  AND date('Order'.created_at) <= ? AND order_status_id!=10 AND is_delete=0");
                stringTotalProductSaleAmountQuery.append("SELECT SUM(OrderItem.total) from OrderItem LEFT JOIN 'Order' ON 'Order'._id = OrderItem._order_id WHERE date('Order'.created_at) >= ?  AND date('Order'.created_at) <= ? AND order_status_id!=10 AND is_delete=0");

                totalOrdersParams.add(fromDateString);
                totalOrdersParams.add(toDateString);

                orderStatusParams.add(fromDateString);
                orderStatusParams.add(toDateString);

                orderTypeParams.add(fromDateString);
                orderTypeParams.add(toDateString);

                totalProductsSaleParams.add(fromDateString);
                totalProductsSaleParams.add(toDateString);

                totalProductsSaleAmountParams.add(fromDateString);
                totalProductsSaleAmountParams.add(toDateString);

                totalDiscountsParams.add(fromDateString);
                totalDiscountsParams.add(toDateString);

                totalGratuityParams.add(fromDateString);
                totalGratuityParams.add(toDateString);

                totalServiceChargeParams.add(fromDateString);
                totalServiceChargeParams.add(toDateString);

                totalDeliveryChargeParams.add(fromDateString);
                totalDeliveryChargeParams.add(toDateString);

                totalDinersParams.add(fromDateString);
                totalDinersParams.add(toDateString);

                totalTablesParams.add(fromDateString);
                totalTablesParams.add(toDateString);

                paymentTypeParams.add(fromDateString);
                paymentTypeParams.add(toDateString);

                orderRejectParams.add(fromDateString);
                orderRejectParams.add(toDateString);

                if (isUserReport && selectedUser != null) {
                    stringTotalOrdersQuery.append(" AND updater_id = ?");
                    stringOrderTypeQuery.append(" AND updater_id = ?");
                    stringOrderStatusQuery.append(" AND updater_id = ?");
                    stringTotalDiscountQuery.append(" AND updater_id = ?");
                    stringTotalDinersQuery.append(" AND updater_id = ?");
                    stringTotalTablesQuery.append(" AND updater_id = ?");
                    stringTotalGratuityQuery.append(" AND updater_id = ?");
                    stringTotalServiceChargeQuery.append(" AND updater_id = ?");
                    stringTotalDeliveryChargeQuery.append(" AND updater_id = ?");
                    stringTotalProductSaleQuery.append(" AND OrderItem.updater_id = ?");
                    stringTotalProductSaleAmountQuery.append(" AND OrderItem.updater_id = ?");
                    stringPaymentTypeQuery.append(" AND OrderPayment.updater_id = ?");
                    stringRejectQuery.append(" AND OrderPayment.updater_id = ?");

                    totalTablesParams.add(selectedUser.id);
                    orderTypeParams.add(selectedUser.id);
                    orderStatusParams.add(selectedUser.id);
                    totalDinersParams.add(selectedUser.id);
                    totalOrdersParams.add(selectedUser.id);
                    totalDiscountsParams.add(selectedUser.id);
                    totalGratuityParams.add(selectedUser.id);
                    totalServiceChargeParams.add(selectedUser.id);
                    totalDeliveryChargeParams.add(selectedUser.id);
                    totalProductsSaleParams.add(selectedUser.id);
                    totalProductsSaleAmountParams.add(selectedUser.id);
                    paymentTypeParams.add(selectedUser.id);
                    orderRejectParams.add(selectedUser.id);
                } else {
                    stringTotalOrdersQuery.append(" AND 'Order'.is_archived = ?");
                    stringOrderTypeQuery.append(" AND 'Order'.is_archived = ?");
                    stringOrderStatusQuery.append(" AND 'Order'.is_archived = ?");
                    stringTotalDiscountQuery.append(" AND 'Order'.is_archived = ?");
                    stringTotalDinersQuery.append(" AND 'Order'.is_archived = ?");
                    stringTotalTablesQuery.append(" AND 'Order'.is_archived = ?");
                    stringTotalGratuityQuery.append(" AND 'Order'.is_archived = ?");
                    stringTotalServiceChargeQuery.append(" AND 'Order'.is_archived = ?");
                    stringTotalDeliveryChargeQuery.append(" AND 'Order'.is_archived = ?");
                    stringTotalProductSaleQuery.append(" AND 'Order'.is_archived = ?");
                    stringTotalProductSaleAmountQuery.append(" AND 'Order'.is_archived = ?");
                    stringPaymentTypeQuery.append(" AND 'Order'.is_archived = ?");
                    stringRejectQuery.append(" AND 'Order'.is_archived = ?");


                    totalTablesParams.add(isArchived ? "1" : "0");
                    orderTypeParams.add(isArchived ? "1" : "0");
                    orderStatusParams.add(isArchived ? "1" : "0");
                    totalDinersParams.add(isArchived ? "1" : "0");
                    totalOrdersParams.add(isArchived ? "1" : "0");
                    totalDiscountsParams.add(isArchived ? "1" : "0");
                    totalGratuityParams.add(isArchived ? "1" : "0");
                    totalServiceChargeParams.add(isArchived ? "1" : "0");
                    totalDeliveryChargeParams.add(isArchived ? "1" : "0");
                    totalProductsSaleParams.add(isArchived ? "1" : "0");
                    totalProductsSaleAmountParams.add(isArchived ? "1" : "0");
                    paymentTypeParams.add(isArchived ? "1" : "0");
                    orderRejectParams.add(isArchived ? "1" : "0");
                }

                stringOrderStatusQuery.append(" Group By 'Order'.order_status_id");
                stringOrderTypeQuery.append(" Group By 'Order'.order_type_id");
                stringPaymentTypeQuery.append(" Group By OrderPayment.payment_method_id");
                stringRejectQuery.append(" Group By OrderPayment.payment_method_id");

                SupportSQLiteQuery totalOrdersQuery = new SimpleSQLiteQuery(stringTotalOrdersQuery.toString(), totalOrdersParams.toArray());
                SupportSQLiteQuery totalProductsSaleQuery = new SimpleSQLiteQuery(stringTotalProductSaleQuery.toString(), totalProductsSaleParams.toArray());
                SupportSQLiteQuery totalProductsSaleAmountQuery = new SimpleSQLiteQuery(stringTotalProductSaleAmountQuery.toString(), totalProductsSaleAmountParams.toArray());
                SupportSQLiteQuery totalDiscountQuery = new SimpleSQLiteQuery(stringTotalDiscountQuery.toString(), totalDiscountsParams.toArray());
                SupportSQLiteQuery totalGratuityQuery = new SimpleSQLiteQuery(stringTotalGratuityQuery.toString(), totalGratuityParams.toArray());
                SupportSQLiteQuery totalServiceChargeQuery = new SimpleSQLiteQuery(stringTotalServiceChargeQuery.toString(), totalServiceChargeParams.toArray());
                SupportSQLiteQuery totalDeliveryChargeQuery = new SimpleSQLiteQuery(stringTotalDeliveryChargeQuery.toString(), totalDeliveryChargeParams.toArray());
                SupportSQLiteQuery totalDinersQuery = new SimpleSQLiteQuery(stringTotalDinersQuery.toString(), totalDinersParams.toArray());
                SupportSQLiteQuery totalTablesQuery = new SimpleSQLiteQuery(stringTotalTablesQuery.toString(), totalTablesParams.toArray());
                SupportSQLiteQuery orderStatusQuery = new SimpleSQLiteQuery(stringOrderStatusQuery.toString(), orderStatusParams.toArray());
                SupportSQLiteQuery orderTypeQuery = new SimpleSQLiteQuery(stringOrderTypeQuery.toString(), orderTypeParams.toArray());
                SupportSQLiteQuery paymentTypeQuery = new SimpleSQLiteQuery(stringPaymentTypeQuery.toString(), paymentTypeParams.toArray());
                SupportSQLiteQuery rejectQuery = new SimpleSQLiteQuery(stringRejectQuery.toString(), orderRejectParams.toArray());

                int totalOrders = appDatabase.reportDao().totalOrders(totalOrdersQuery);
                int totalProducts = appDatabase.reportDao().totalProducts(totalProductsSaleQuery);
                float totalProductSaleAmount = appDatabase.reportDao().totalProductsAmount(totalProductsSaleAmountQuery);
                float totalDiscounts = appDatabase.reportDao().totalDiscount(totalDiscountQuery);
                float totalGratuity = appDatabase.reportDao().totalGratuity(totalGratuityQuery);
                float totalServiceCharge = appDatabase.reportDao().totalServiceCharge(totalServiceChargeQuery);
                float totalDeliveryCharge = appDatabase.reportDao().totalServiceCharge(totalDeliveryChargeQuery);
                int totalDiners = appDatabase.reportDao().totalDiners(totalDinersQuery);
                int totalTables = appDatabase.reportDao().totalTables(totalTablesQuery);
                List<DaoReportNameTotalValue> orderStatus = appDatabase.reportDao().getOrderStatusReport(orderStatusQuery);
                List<DaoReportNameTotalValue> orderTypes = appDatabase.reportDao().getOrderStatusReport(orderTypeQuery);
                List<DaoReportNameTotalValue> orderPayments = appDatabase.reportDao().getOrderStatusReport(paymentTypeQuery);
                List<DaoReportNameTotalValue> reject = appDatabase.reportDao().getOrderStatusReport(rejectQuery);

                reports.clear();
                if(fullReport!=null && ("auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode()))){
                    if (MyApp.userPermission.order_count.actions.list)
                        reports.add(new ReportTextModel("Total Orders", fullReport.order_count, ""));
                    //reports.add(new ReportTextModel("Total Orders", response.order_count, false));
                    if (MyApp.userPermission.orders_total_product.actions.list && MyApp.userPermission.orders_amount_product.actions.list) {
                        reports.add(new ReportTextModel("Product Sale", fullReport.orders_total_product, MyApp.df.format(fullReport.orders_amount_product)));
                    }
                    if (MyApp.userPermission.total_discount.actions.list)
                        reports.add(new ReportTextModel("Total Discounts", "", MyApp.df.format(fullReport.total_discount)));
                    if (MyApp.userPermission.total_no_guest.actions.list)
                        reports.add(new ReportTextModel("Total Dinners", fullReport.total_no_guest, ""));
                    if (MyApp.userPermission.total_no_table.actions.list)
                        reports.add(new ReportTextModel("Total Tables", fullReport.total_no_table, ""));

                    if (fullReport.allocated_voucher != 0 && fullReport.allocated_voucher_value != 0) {
                        reports.add(new ReportTextModel("Total Voucher", String.valueOf(fullReport.allocated_voucher), MyApp.df.format(fullReport.allocated_voucher_value)));
                    }
                    if (!Validators.isNullOrEmpty(fullReport.total_gratuity)) {
                        reports.add(new ReportTextModel("Total gratuity", "", fullReport.total_gratuity));
                    }
                    if (!Validators.isNullOrEmpty(fullReport.total_service_charge)) {
                        reports.add(new ReportTextModel("Total service charge", "", String.valueOf(fullReport.total_service_charge)));
                    }
                    if (totalDeliveryCharge > 0) {
                        reports.add(new ReportTextModel("Total delivery charge", "", MyApp.df.format(totalDeliveryCharge)));
                    }
                    if (onlineReports != null && (!Validators.isNullOrEmpty(myApp.restaurant_id) && webOrderSetting != null && (webOrderSetting.value.equalsIgnoreCase("true") || webOrderSetting.value.equalsIgnoreCase("1")))) {
                        reports.addAll(onlineReports);
                    }
                    if (fullReport.order_type_wise != null && fullReport.order_type_wise.size() > 0 && MyApp.userPermission.order_type_wise.actions.list) {
                        reports.add(new ReportTextModel("Order type", "", true));
                        for (ReportOrderType something : fullReport.order_type_wise) {
                            reports.add(new ReportTextModel("" + something.type + "", String.valueOf(something.count), MyApp.df.format(something.total)));
                        }
                    }
                    if (fullReport.order_status_wise != null && fullReport.order_status_wise.size() > 0 && MyApp.userPermission.order_status_wise.actions.list) {
                        reports.add(new ReportTextModel("Order status", "", true));
                        for (ReportOrderStatus something : fullReport.order_status_wise) {
                            reports.add(new ReportTextModel("" + something.status, String.valueOf(something.count), MyApp.df.format(something.total)));
                        }
                    }
                    /*if (fullReport.order_payment_wise != null && fullReport.order_payment_wise.size() > 0 && MyApp.userPermission.order_payment_wise.actions.list) {
                        reports.add(new ReportTextModel("Order payment", "", true));
                        for (ReportOrderPaymentMethod something : fullReport.order_payment_wise) {
                            reports.add(new ReportTextModel("" + something.name + "Payment", String.valueOf(something.count), MyApp.df.format(something.total)));
                        }
                    }*/
                }
                else {
                    if (MyApp.userPermission.order_count.actions.list)
                        reports.add(new ReportTextModel("Total Orders", String.valueOf(totalOrders), ""));
                    if (MyApp.userPermission.orders_total_product.actions.list && MyApp.userPermission.orders_amount_product.actions.list) {
                        reports.add(new ReportTextModel("Product Sale", String.valueOf(totalProducts), MyApp.df.format(totalProductSaleAmount)));
                    }
                    if (MyApp.userPermission.total_discount.actions.list)
                        reports.add(new ReportTextModel("Total Discounts", "", MyApp.df.format(totalDiscounts)));
                    if (MyApp.userPermission.total_no_guest.actions.list)
                        reports.add(new ReportTextModel("Total Dinners", String.valueOf(totalDiners), ""));
                    if (MyApp.userPermission.total_no_table.actions.list)
                        reports.add(new ReportTextModel("Total Tables", String.valueOf(totalTables), ""));


                    if (totalGratuity > 0) {
                        reports.add(new ReportTextModel("Total gratuity", "", MyApp.df.format(totalGratuity)));
                    }
                    if (totalServiceCharge > 0) {
                        reports.add(new ReportTextModel("Total service charge", "", MyApp.df.format(totalServiceCharge)));
                    }
                    if (totalDeliveryCharge > 0) {
                        reports.add(new ReportTextModel("Total delivery charge", "", MyApp.df.format(totalDeliveryCharge)));
                    }
                    if (onlineReports != null && (!Validators.isNullOrEmpty(myApp.restaurant_id) && webOrderSetting != null && (webOrderSetting.value.equalsIgnoreCase("true") || webOrderSetting.value.equalsIgnoreCase("1")))) {
                        reports.addAll(onlineReports);
                    }
                    if (orderTypes != null && orderTypes.size() > 0 && MyApp.userPermission.order_type_wise.actions.list) {
                        reports.add(new ReportTextModel("Order type", "", true));
                        for (DaoReportNameTotalValue something : orderTypes) {
                            Log.e("DaoReportNameTotalValue", "DaoReportNameTotalValue " + something.total + " value " + something.value);
                            reports.add(new ReportTextModel("" + something.name, String.valueOf(something.total), MyApp.df.format(Float.parseFloat(something.value))));
                       /* reports.add(new ReportTextModel("Total " + something.name + " orders", String.valueOf(something.total), false));
                        reports.add(new ReportTextModel("Value " + something.name + " orders", MyApp.currencySymbol + MyApp.df.format(Float.parseFloat(something.value)), false));*/
                        }
                    }

                    if (orderStatus != null && orderStatus.size() > 0 && MyApp.userPermission.order_type_wise.actions.list) {
                        reports.add(new ReportTextModel("Order Status", "", true));
                        for (DaoReportNameTotalValue something : orderStatus) {
                            Log.d("Full Report Status", "name: " + something.name + " , " + "value: " + something.value);
                            reports.add(new ReportTextModel("" + something.name, String.valueOf(something.total), MyApp.df.format(Float.parseFloat(something.value))));

                       /* reports.add(new ReportTextModel("Total " + something.name + " orders", String.valueOf(something.total), false));
                        reports.add(new ReportTextModel("Value " + something.name + " orders", MyApp.currencySymbol + MyApp.df.format(Float.parseFloat(something.value)), false));*/
                        }
                    }
                }
                float cashTotal = 0, cardTotal = 0, externalMoto = 0, externalCR = 0,cardManaul =0;
                int cashTotalCount = 0,cardManaulTotalCount =0;
                int cardTotalCount = 0, externalMotoCount = 0, externalCRCount = 0;
                if (orderPayments != null && orderPayments.size() > 0 && MyApp.userPermission.order_type_wise.actions.list) {
                    if (("auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode())) && order_payment_wise != null) {
                        if (order_payment_wise.size() > 0 && MyApp.userPermission.order_payment_wise.actions.list) {
                            reports.add(new ReportTextModel("Payment Type", "", true));
                            for (ReportOrderPaymentMethod something : order_payment_wise) {
                                //reports.add(new ReportTextModel("" + something.name, String.valueOf(something.total), MyApp.df.format(Float.parseFloat(something.value))));
                                if (something.name.toLowerCase().contains("cash")) {
                                    cashTotal = (cashTotal + something.total);
                                    cashTotalCount = cashTotalCount + something.count;
                                }
                                if (something.name.toLowerCase().contains("card") || something.name.toLowerCase().contains("link")) {
                                    Log.e("transaction_value","namenamenamename "+something.total+" name "+something.name);
                                    if(something.name.equalsIgnoreCase("Credit Card Manual")){
                                        cardManaul = cardManaul+something.total;
                                        cardManaulTotalCount = cardManaulTotalCount + something.count;
                                    }else {
                                        cardTotal = (cardTotal + something.total);
                                        cardTotalCount = cardTotalCount + something.count;
                                    }
                                }
                                reports.add(new ReportTextModel("" + something.name + "", String.valueOf(something.count), MyApp.df.format(something.total), false, true));
                                Log.e("somethingsomething", "ReportTextModel " + cashTotalCount + " cardTotalCount " + cardTotalCount + " cardTotal " + cardTotal);
                            }
                        }
                    } else {
                        reports.add(new ReportTextModel("Payment Type", "", true));
                        for (DaoReportNameTotalValue something : orderPayments) {
                            Log.d("Full Report Payment", "name: " + something.name + " , " + "value: " + something.value);
//                        reports.add(new ReportTextModel("Total " + something.name + " orders", String.valueOf(something.total), false));
//                        reports.add(new ReportTextModel("Value " + something.name + " orders", MyApp.currencySymbol + MyApp.df.format(Float.parseFloat(something.value)), false));
                            reports.add(new ReportTextModel("" + something.name, String.valueOf(something.total), MyApp.df.format(Float.parseFloat(something.value))));
                            if (something.name.toLowerCase().contains("cash")) {
                                if (!Validators.isNullOrEmpty(something.total)) {
                                    cashTotalCount = cashTotalCount + Integer.parseInt(something.total);
                                }
                                cashTotal = cashTotal + Float.parseFloat(something.value);
                            }
                            if (something.name.toLowerCase().contains("card") || something.name.toLowerCase().contains("link")) {
                                if(something.name.equalsIgnoreCase("Credit Card Manual")){
                                    if (!Validators.isNullOrEmpty(something.total)) {
                                        cardManaulTotalCount = cardManaulTotalCount + Integer.parseInt(something.total);
                                    }
                                    cardManaul = cardManaul + Float.parseFloat(something.value);
                                }else {
                                    if (!Validators.isNullOrEmpty(something.total)) {
                                        cardTotalCount = cardTotalCount + Integer.parseInt(something.total);
                                    }
                                    cardTotal = cardTotal + Float.parseFloat(something.value);
                                }
                            }
                        }
                        for (DaoReportNameTotalValue something : reject) {
                            Log.d("Reject", "name: " + something.name + " , " + "value: " + something.value);
                            if (something.name.toLowerCase().contains("cash")) {
                                if (!Validators.isNullOrEmpty(something.total)) {
                                    //cashTotalCount = cashTotalCount + Integer.parseInt(something.total);
                                }
                                //cashTotal = cashTotal - Float.parseFloat(something.value);
                            }
                            if (something.name.toLowerCase().contains("card") || something.name.toLowerCase().contains("link")) {
                                if (!Validators.isNullOrEmpty(something.total)) {
                                    //cardTotalCount = cardTotalCount + Integer.parseInt(something.total);
                                }
                                //cardTotal = cardTotal - Float.parseFloat(something.value);
                            }
                        }
                        List<OrderExternalPayment> orderExternalPaymentList = appDatabase.orderExternalPaymentDao().list();
                        if (orderExternalPaymentList != null && !orderExternalPaymentList.isEmpty()) {
                            reports.add(new ReportTextModel("External Payments", "", true));
                            for (OrderExternalPayment orderExternalPayment : orderExternalPaymentList) {
                                if (orderExternalPayment.payment_method_id.equalsIgnoreCase(Constants.EXTERNAL_CARD_READER_PAYMENT) && orderExternalPayment.payment_status.equalsIgnoreCase(Constants.APPROVED)) {
                                    externalCR = externalCR + orderExternalPayment.amount;
                                } else if (orderExternalPayment.payment_method_id.equalsIgnoreCase(Constants.EXTERNAL_MOTO_PAYMENT) && orderExternalPayment.payment_status.equalsIgnoreCase(Constants.APPROVED)) {
                                    externalMoto = externalMoto + orderExternalPayment.amount;
                                }
                            }
                        }
                    }
                    if (externalCR > 0) {
                        reports.add(new ReportTextModel("" + "External CARD", "", MyApp.df.format(externalCR)));
                    }
                    if (externalMoto > 0) {
                        reports.add(new ReportTextModel("" + "External MOTO", "", MyApp.df.format(externalMoto)));
                    }
                    reports.add(new ReportTextModel("Grand Total", "", true));
                    if (externalCR + externalMoto > 0) {
                        reports.add(new ReportTextModel("Total External", "", MyApp.df.format(externalCR + externalMoto)));
                    }
                    //reports.add(new ReportTextModel("Total Link", "" + linkTotalCount, MyApp.df.format(linkTotal)));
                    reports.add(new ReportTextModel("Total Card", "" + cardTotalCount, MyApp.df.format(cardTotal)));
                    reports.add(new ReportTextModel("Total Cash", "" + cashTotalCount, MyApp.df.format(cashTotal)));
                    if (("auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode()))){
                        reports.add(new ReportTextModel("Total Card Manual", "" + cardManaulTotalCount, MyApp.df.format(cardManaul)));
                        float total =0,grandTotal =0;
                        /*if(!Validators.isNullOrEmpty(transaction_value)){
                            grandTotal =  Float.parseFloat(transaction_value);
                            Log.e("transaction_value","transaction_value "+transaction_value);
                            total = Float.parseFloat(transaction_value) - cardTotal ;
                        }*/
                        if(!Validators.isNullOrEmpty(external_payments)){
                            grandTotal= cardTotal;
                            grandTotal =  grandTotal + Float.parseFloat(external_payments);
                            Log.e("external_payments","external_payments "+external_payments);
                            total = Float.parseFloat(external_payments)  ;
                        }
                        if(total>0){
                            reports.add(new ReportTextModel("Total External", "", MyApp.df.format(total)));
                        }
                        if(grandTotal>0){
                            reports.add(new ReportTextModel("Total", (cashTotalCount + cardTotalCount +cardManaulTotalCount) + "", MyApp.df.format(grandTotal + cashTotal+cardManaul + externalMoto + externalCR)));
                        }else {
                            reports.add(new ReportTextModel("Total", (cashTotalCount + cardTotalCount +cardManaulTotalCount) + "", MyApp.df.format(cardTotal+cardManaul + cashTotal + externalMoto + externalCR)));
                        }
                    }else {
                        reports.add(new ReportTextModel("Total Card Manual", "" + cardManaulTotalCount, MyApp.df.format(cardManaul)));
                        reports.add(new ReportTextModel("Total", (cashTotalCount + cardTotalCount + cardManaulTotalCount) + "", MyApp.df.format(cardTotal +cardManaul+ cashTotal + externalMoto + externalCR)));
                    }
                }
            } catch (NumberFormatException e) {
                e.printStackTrace();
            }

            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                llProgress.setVisibility(View.GONE);
                llData.setVisibility(View.VISIBLE);
                if (getActivity() != null) {
                    rvReports.post(() -> {
                        rvReports.stopScroll();
                        reportAdapter.notifyDataSetChanged();
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void fetchReport() {
        try {
            if (!isOnlineReport) {
                new ReportAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                //return;
            }
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    llProgress.setVisibility(View.VISIBLE);
                    llData.setVisibility(View.GONE);
                });
            }
            String url = ApiEndPoints.full_report;
            if (isOnlineReport) {
                url = ApiEndPoints.online_report;
            }

            if (("auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode()) || isOnlineReport) && myApp.isConnected(requireContext())) {
                btnPrint.setEnabled(false);
                transaction_value="";
                external_payments="";
                fullReport = null;
                ANRequest.GetRequestBuilder requestBuilder = AndroidNetworking.get(url)
                        .addQueryParameter("shift_status", "both")
                        .addQueryParameter("from_date", fromDateString)
                        .addQueryParameter("restaurant_id", myApp.restaurant_id)
                        .addQueryParameter("to_date", toDateString);
                if (isUserReport && selectedUser != null) {
                    requestBuilder.addQueryParameter("user_id", selectedUser.id);
                }
                requestBuilder.addQueryParameter("archived", isArchived ? "1" : "0");
                requestBuilder.build()
                        .getAsObject(FullReport.class, new ParsedRequestListener<FullReport>() {
                            @Override
                            public void onResponse(FullReport response) {
                                try {
                                    if (getActivity() != null) {
                                        getActivity().runOnUiThread(() -> {
                                            llProgress.setVisibility(View.GONE);
                                            llData.setVisibility(View.VISIBLE);
                                        });
                                    }

                                    if (isOnlineReport) {
                                        reports.clear();
                                        if (MyApp.userPermission.online_order_count.actions.list) {
                                            reports.add(new ReportTextModel("Orders", response.online_order_count, ""));
                                            if (response.android_online_order_count != null && !response.android_online_order_count.isEmpty()) {
                                                reports.add(new ReportTextModel("Android ", "" + response.android_online_order_count.get(0).count, MyApp.df.format(response.android_online_order_count.get(0).total)));
                                            }
                                            if (response.web_online_order_count != null && !response.web_online_order_count.isEmpty()) {
                                                reports.add(new ReportTextModel("Web", "" + response.web_online_order_count.get(0).count, MyApp.df.format(response.web_online_order_count.get(0).total)));
                                            }
                                            if (response.ios_online_order_count != null && !response.ios_online_order_count.isEmpty()) {
                                                reports.add(new ReportTextModel("IOS ", "" + response.ios_online_order_count.get(0).count, MyApp.df.format(response.ios_online_order_count.get(0).total)));
                                            }
                                        }

                                        if (MyApp.userPermission.online_reservation_count.actions.list)
                                            reports.add(new ReportTextModel("Reservations", response.online_reservation_count, ""));

                                        if (MyApp.userPermission.online_order_total_business.actions.list)
                                            reports.add(new ReportTextModel("Order Businesses", response.online_order_total_business, ""));

                                        if (MyApp.userPermission.online_order_calculated_commission.actions.list)
                                            reports.add(new ReportTextModel("Order Commission", "", response.online_order_calculated_commission));

                                        if (response.online_order_type != null && response.online_order_type.size() > 0 && MyApp.userPermission.online_order_type.actions.list) {
                                            reports.add(new ReportTextModel("Order type", "", true));
                                            for (ReportOrderType something : response.online_order_type) {
                                                reports.add(new ReportTextModel("" + something.order_type, String.valueOf(something.count), MyApp.df.format(something.total)));
                                            }
                                        }

                                        if (response.online_order_payment != null && response.online_order_payment.size() > 0 && MyApp.userPermission.online_order_payment.actions.list) {
                                            reports.add(new ReportTextModel("Payment type", "", true));
                                            for (ReportOrderPaymentMethod something : response.online_order_payment) {
                                                reports.add(new ReportTextModel("" + something.payment_method, String.valueOf(something.count), MyApp.df.format(something.total)));
                                            }
                                        }
                                    } else {
                                        fullReport = response;
                                        transaction_value = response.transaction_value;
                                        external_payments = response.external_payments;
                                        if (("auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode()))) {
                                            order_payment_wise = response.order_payment_wise;
                                        }
                                        onlineReports.clear();
                                        if (MyApp.userPermission.online_order_count.actions.list) {
                                            onlineReports.add(new ReportTextModel("Online orders", "", true));
                                            if (response.android_online_order_count != null && !response.android_online_order_count.isEmpty()) {
                                                onlineReports.add(new ReportTextModel("Android ", "" + response.android_online_order_count.get(0).count, MyApp.df.format(response.android_online_order_count.get(0).total)));
                                            }
                                            if (response.web_online_order_count != null && !response.web_online_order_count.isEmpty()) {
                                                onlineReports.add(new ReportTextModel("Web", "" + response.web_online_order_count.get(0).count, MyApp.df.format(response.web_online_order_count.get(0).total)));
                                            }
                                            if (response.ios_online_order_count != null && !response.ios_online_order_count.isEmpty()) {
                                                onlineReports.add(new ReportTextModel("IOS ", "" + response.ios_online_order_count.get(0).count, MyApp.df.format(response.ios_online_order_count.get(0).total)));
                                            }
                                        }
                                        new ReportAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                                    }
                                    if (getActivity() != null) {
                                        getActivity().runOnUiThread(() -> {
                                            btnPrint.setEnabled(true);
                                        });
                                    }
                                    if (getActivity() != null)
                                        if (isOnlineReport) {
                                            rvReports.post(() -> {
                                                rvReports.stopScroll();
                                                reportAdapter.notifyDataSetChanged();
                                                btnPrint.setVisibility(View.VISIBLE);
                                            });
                                        }
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }

                            @Override
                            public void onError(ANError anError) {
                                try {
                                    if (!isOnlineReport) {
                                        new ReportAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                                    }
                                    if (getActivity() != null) {
                                        getActivity().runOnUiThread(() -> {
                                            btnPrint.setEnabled(true);
                                        });
                                    }
                                    if (getActivity() != null) {
                                        if (isOnlineReport) {
                                            getActivity().runOnUiThread(() -> {
                                                llProgress.setVisibility(View.GONE);
                                                llData.setVisibility(View.GONE);
                                            });
                                        }
                                    }

                                    if (anError.getErrorCode() == 400) {
                                        ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                        ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                        if (isOnlineReport) {
                                            if (getActivity() != null) {
                                                getActivity().runOnUiThread(() -> {
                                                    btnPrint.setVisibility(View.GONE);
                                                });
                                            }
                                        }
                                    }
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createPrint() {
        try {
            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                String title = "Full report";
                if (isUserReport) {
                    title = "User report";
                }
                if (isOnlineReport) {
                    title = "Online order report";
                }
                String time = CommonFunctions.formatMiliToDesireFormat(System.currentTimeMillis(),"hh:mm:ss");
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                    zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                    //zoneRichPrinter.printFullReport(myApp.businessLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, title, tvSelectedDate.getText().toString(), selectedUser != null ? selectedUser.username : null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "",myApp.myPreferences);
                    zoneRichPrinter.printFoodHubFullReport(myApp.businessLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, title, tvSelectedDate.getText().toString()+" "+time, selectedUser != null ? selectedUser.username : null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myApp.myPreferences);
                    getActivity().onBackPressed();
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("sunmi") || defaultPrinter.printer_model_name.toLowerCase().contains("t2")) {
                    //sunmiPrinter.printFullReport(myApp.businessLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, title, tvSelectedDate.getText().toString(), selectedUser != null ? selectedUser.username : null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "",myPreferences);
                    if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                        sunmiPrinterV3Mix.printFoodHubFullReport(myApp.businessLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, title, tvSelectedDate.getText().toString()+" "+time, selectedUser != null ? selectedUser.username : null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                    }else {
                        sunmiPrinter.printFoodHubFullReport(myApp.businessLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, title, tvSelectedDate.getText().toString()+" "+time, selectedUser != null ? selectedUser.username : null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                    }
                    getActivity().onBackPressed();
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if(defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")){
                        myApp.iMinPrinterUtils.printFoodHubFullReport(myApp.businessLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, title, tvSelectedDate.getText().toString()+" "+time, selectedUser != null ? selectedUser.username : null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                    }else {
                        if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                            wifiPrinter.connect(defaultPrinter.ip);
                            CommonFunctions.functionThatDelay(200);
                            wifiPrinter.printFullReport(myApp.businessLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, title, tvSelectedDate.getText().toString()+" "+time, selectedUser != null ? selectedUser.username : null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                            getActivity().onBackPressed();
                        } else {
                            try {
                                if (bluetoothPrinter != null) {
                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                    if (device != null) {
                                        CommonFunctions.functionThatDelay(100);
                                        bluetoothPrinter.printFullReport(myApp.businessLogo, ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, title, tvSelectedDate.getText().toString()+" "+time, selectedUser != null ? selectedUser.username : null, reports, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "");
                                        getActivity().onBackPressed();
                                    } else {
                                        ToastUtils.makeSnackToast(getActivity(), "No bluetooth device found.");
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            } else {
                ToastUtils.makeSnackToast(getActivity(), "No printer model found");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}