package com.ubsidi.epos_2021.fragment;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.Paint;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.common.Priority;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.activities.HomeActivity;
import com.ubsidi.epos_2021.activities.NewOrderActivity;
import com.ubsidi.epos_2021.adapters.HomeCategoriesAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.CallLogs;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;
import com.ubsidi.epos_2021.models.OrderPayment;
import com.ubsidi.epos_2021.models.OrderSplit;
import com.ubsidi.epos_2021.models.RecyclerMenuItem;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.online.models.Counts;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class HomeFragment extends BaseFragment {

    private MaterialButton btnNewOrder;
    private MaterialButton btnParkCalls;
    private HomeCategoriesAdapter itemAdapter;
    private ArrayList<RecyclerMenuItem> items = new ArrayList<>();

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_home, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        try {
            initViews(view);
            setUpItems();
            setListeners();
            setParkCalls();
            fetchCallLogs();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setParkCalls() {
        try {
            new Thread(() -> {
                List<CallLogs> list = appDatabase.calllogDao().getParkedCalls();
                if (myPreferences.getCallerIdEnableStatus()) {
                    btnParkCalls.setVisibility(View.VISIBLE);
                    if (list != null && list.size() > 0) {
                        btnParkCalls.setText("Park Calls (" + list.size() + ")");
                    } else {
                        btnParkCalls.setText("Park Calls (0)");
                    }
                } else {
                    btnParkCalls.setVisibility(View.GONE);
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchCallLogs() {
        try {
            AndroidNetworking.get(ApiEndPoints.calllogs)
                    .addQueryParameter("status", "parked")
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsObjectList(CallLogs.class, new ParsedRequestListener<List<CallLogs>>() {
                        @Override
                        public void onResponse(List<CallLogs> response) {
                            try {
                                android.util.Log.e("response", "" + response.toString());
                                callList.clear();
                                new CallLogAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, response);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                callList.clear();
                                new CallLogAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<CallLogs> callList = new ArrayList<>();

    private class CallLogAsync extends AsyncTask<List<CallLogs>, String, String> {

        @Override
        protected String doInBackground(List<CallLogs>... lists) {
            try {
                callList.addAll(myApp.appDatabase.calllogDao().getParkedCalls());
                for (CallLogs callLogs : callList) {
                    callLogs.customer = appDatabase.customerDao().view(callLogs.customer_id);
                }
                if (lists.length > 0) {
                    callList.addAll(lists[0]);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        if (myPreferences.getCallerIdEnableStatus()) {
                            btnParkCalls.setVisibility(View.VISIBLE);
                            Log.e("PARK CALLS api", " " + callList.size());
                            if (callList != null && callList.size() > 0) {
                                btnParkCalls.setText("Park Calls (" + callList.size() + ")");
                            } else {
                                btnParkCalls.setText("Park Calls (0)");
                            }
                        } else {
                            btnParkCalls.setVisibility(View.GONE);
                        }
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }
    }

    private void setListeners() {
        try {
            btnNewOrder.setOnClickListener(v -> {
                try {
                    OrderTypeSelectionDialogFragment orderTypeSelectionDialog = new OrderTypeSelectionDialogFragment();
                    orderTypeSelectionDialog.show(getActivity().getSupportFragmentManager(), "order_type");
                    orderTypeSelectionDialog.setDialogDismissListener(o -> {
                        String orderTypeId = o.toString();
                        openNewOrderDialog(orderTypeId);
                    });
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            btnParkCalls.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    try {
                        if (getActivity() != null) {
                            ((HomeActivity) getActivity()).getParkCalls();
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openNewOrderDialog(String orderTypeId) {
        try {
            NewOrderDialogFragment newOrderDialogFragment = getInstanceNewOrder(orderTypeId);
            newOrderDialogFragment.show(getActivity().getSupportFragmentManager(), "new_order");
            newOrderDialogFragment.setDialogDismissListener(o -> {
                try {
                    if (o instanceof Order) {
                        startActivity(new Intent(getActivity(), NewOrderActivity.class)
                                .putExtra("order", new Gson().toJson(o))
                                .putExtra("fetch_delivery_charge", ((Order) o).order_type_id.equalsIgnoreCase("3")));
                    } else if (o instanceof CallLogs) {
                        changeFragment(myApp.getInstanceNewReservation((CallLogs) o));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public NewOrderDialogFragment getInstanceNewOrder(String orderTypeId) {
        NewOrderDialogFragment fragment = new NewOrderDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("order_type_id", orderTypeId);
        fragment.setArguments(bundle);
        return fragment;
    }

    private void setUpItems() {
        try {
            //1 = Dine In, 2= Collection, 3 = Delivery, 4 = Bar, 5= Waiting, 6 Web Order
            SiteSetting collectionSetting = myApp.findSetting("is_collection");
            SiteSetting waitingSetting = myApp.findSetting("is_waiting");
            SiteSetting deliverySetting = myApp.findSetting("is_delivery");
            SiteSetting dineinSetting = myApp.findSetting("is_dinein");
            SiteSetting webOrderSetting = myApp.findSetting("is_weborder");
            SiteSetting reservationSetting = myApp.findSetting("is_reservation");
            items.clear();

            RecyclerMenuItem homeItems = new RecyclerMenuItem();
            if (waitingSetting != null && (waitingSetting.value.equals("true") || waitingSetting.value.equals("1")) && (MyApp.userPermission != null && MyApp.userPermission.waiting.actions.list)) {
                homeItems.id = "5";
                homeItems.title = "Waiting";
                items.add(homeItems);
            }
            if (collectionSetting != null && (collectionSetting.value.equals("true") || collectionSetting.value.equals("1")) && (MyApp.userPermission != null && MyApp.userPermission.collection.actions.list)) {
                homeItems = new RecyclerMenuItem();
                homeItems.id = "2";
                homeItems.title = "Collection";
                items.add(homeItems);
            }
            if (deliverySetting != null && (deliverySetting.value.equals("true") || deliverySetting.value.equals("1")) && (MyApp.userPermission != null && MyApp.userPermission.delivery.actions.list)) {
                homeItems = new RecyclerMenuItem();
                homeItems.id = "3";
                homeItems.title = "Delivery";
                items.add(homeItems);
            }
            if (!Validators.isNullOrEmpty(myApp.restaurant_id) && webOrderSetting != null && (webOrderSetting.value.equalsIgnoreCase("true") || webOrderSetting.value.equalsIgnoreCase("1")) && (MyApp.userPermission != null && MyApp.userPermission.web_orders.actions.list)) {
                homeItems = new RecyclerMenuItem();
                homeItems.id = "6";
                homeItems.title = "Online orders";
                items.add(homeItems);
            }

            if (dineinSetting != null && (dineinSetting.value.equals("true") || dineinSetting.value.equals("1")) && (MyApp.userPermission != null && MyApp.userPermission.dinein.actions.list)) {
                homeItems = new RecyclerMenuItem();
                homeItems.id = "1";
                homeItems.title = "Tables";
                items.add(homeItems);
            }

            if (MyApp.userPermission != null && MyApp.userPermission.order_history.actions.list) {
                homeItems = new RecyclerMenuItem();
                homeItems.id = "9";
                homeItems.title = "Order history";
                items.add(homeItems);
            }
            if (reservationSetting != null && (reservationSetting.value.equals("true") || reservationSetting.value.equals("1")) && (MyApp.userPermission != null && MyApp.userPermission.reservation.actions.list)) {
                homeItems = new RecyclerMenuItem();
                homeItems.id = "7";
                homeItems.title = "Reservation";
                items.add(homeItems);
            }
            if (MyApp.userPermission != null && MyApp.userPermission.vouchers.actions.list) {
                homeItems = new RecyclerMenuItem();
                homeItems.id = "8";
                homeItems.title = "Voucher";
                items.add(homeItems);
            }

            itemAdapter.notifyDataSetChanged();
            fetchEposOrdersCount();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            RecyclerView rvItems = view.findViewById(R.id.rvItems);
            btnNewOrder = view.findViewById(R.id.btnNewOrder);
            TextView tvEdit = view.findViewById(R.id.tvEdit);
            btnParkCalls = view.findViewById(R.id.btnParkCalls);
            tvEdit.setPaintFlags(Paint.UNDERLINE_TEXT_FLAG);

            itemAdapter = new HomeCategoriesAdapter(items, (position, data) -> {
                try {
                    RecyclerMenuItem categories = (RecyclerMenuItem) data;

                    if (categories.id.equalsIgnoreCase("2") || categories.id.equalsIgnoreCase("3") || categories.id.equalsIgnoreCase("5") || categories.id.equalsIgnoreCase("6")) {
                        LocalBroadcastManager.getInstance(getActivity()).sendBroadcast(new Intent("order_fragment_change").putExtra("order_type", categories.id).putExtra("destination", "active_orders"));
                    }
                    if (categories.title.equalsIgnoreCase("Tables")) {
                        LocalBroadcastManager.getInstance(getActivity()).sendBroadcast(new Intent("order_fragment_change").putExtra("destination", "tables"));
                        changeFragment(new DineInFragment());
                    }
                    if (categories.title.equalsIgnoreCase("Order history")) {
                        LocalBroadcastManager.getInstance(getActivity()).sendBroadcast(new Intent("order_fragment_change").putExtra("destination", "order_history"));
                        changeFragment(getInstanceEposOrdersHistory(null, false));
                    }
                    if (categories.title.equalsIgnoreCase("Reservation")) {
                        LocalBroadcastManager.getInstance(getActivity()).sendBroadcast(new Intent("order_fragment_change").putExtra("destination", "reservation_history"));
                        changeFragment(new ReservationListFragment());
                    }
                    if (categories.title.equalsIgnoreCase("Voucher")) {
                        LocalBroadcastManager.getInstance(getActivity()).sendBroadcast(new Intent("order_fragment_change").putExtra("destination", "voucher_history"));
                        changeFragment(new VoucherHistoryFragment());
                    }
                    if (categories.title.equalsIgnoreCase("Notifications")) {

                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            rvItems.setLayoutManager(new GridLayoutManager(getActivity(), getActivity().getResources().getInteger(R.integer.home_menu_span)));
            rvItems.setAdapter(itemAdapter);
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }

    }

    public EposOrdersHistoryFragment getInstanceEposOrdersHistory(String typeId, boolean isArchived) {
        Bundle bundle = new Bundle();
        EposOrdersHistoryFragment fragment = new EposOrdersHistoryFragment();
        bundle.putString("order_type_id", typeId);
        bundle.putBoolean("is_archived", isArchived);
        fragment.setArguments(bundle);
        return fragment;
    }

    BroadcastReceiver eposOrderUpdateReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                fetchEposOrdersCount();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    BroadcastReceiver onlineOrdersNotificationReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getBooleanExtra("refresh", false)) {
                    Counts allCounts = new Gson().fromJson(intent.getStringExtra("counts"), Counts.class);
                    setOnlineOrderCounts(allCounts);
                }
            } catch (JsonSyntaxException e) {
                e.printStackTrace();
            }
        }
    };
    BroadcastReceiver newOrderReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getBooleanExtra("refresh", false)) {

                    LogUtils.e("shallWeRefreshOrders?" + myApp.shallWeRefreshOrders + "");
                    if (myApp.shallWeRefreshOrders) {
                        if (intent.hasExtra("notification_section") && intent.getStringExtra("notification_section").equalsIgnoreCase("tables")) {

                        } else {
                            if (intent.hasExtra("order_id") && !Validators.isNullOrEmpty(intent.getStringExtra("order_id"))) {
                                fetchByOrderId(intent.getStringExtra("order_id"));
                            } else {
                                fetchOrders();
                            }
                        }

                    } else {
                        LogUtils.e("Already refreshing");
                        myApp.shallWeRefreshOrders = false;
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private void fetchByOrderId(String orderId) {
        if (getActivity() != null && myApp.isConnected(getActivity()) && "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode())) {
            fetchOrdersById(orderId);
        }
    }

    private void fetchOrders() {
        try {
            if (getActivity() != null && myApp.isConnected(getActivity()) && "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode())) {
                fetchOnlineOrders();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HashMap<String, String> getOrdersParameters(Order latestOrder, Calendar calendar) {
        HashMap<String, String> params = new HashMap<>();
        Calendar fromCalendar = Calendar.getInstance();
        fromCalendar.add(Calendar.DATE, -1);
        Calendar toCalendar = Calendar.getInstance();

        String updated_at = (latestOrder != null && latestOrder.updated_at != null) ? CommonFunctions.formatUnknownDateTime(latestOrder.updated_at, Constants.PHP_DATE_TIME_FORMAT_ZULU, Constants.PHP_DATE_TIME_FORMAT) : CommonFunctions.convertMsToDesiredFormat(calendar.getTimeInMillis(), Constants.PHP_DATE_TIME_FORMAT);
        Date updatedDate = CommonFunctions.convertToDate(updated_at, Constants.PHP_DATE_TIME_FORMAT);
        Calendar updatedAtCalendar = Calendar.getInstance();
        updatedAtCalendar.setTime(updatedDate);
        updatedAtCalendar.add(Calendar.HOUR_OF_DAY, -4);
        updated_at = CommonFunctions.formatMiliToDesireFormat(updatedAtCalendar.getTimeInMillis(), Constants.PHP_DATE_TIME_FORMAT);

        LogUtils.e("Fetching after updated " + updated_at);
        params.put("archived", "0");
        params.put("nopaginate", "1");
//        params.put("screen", "dashboard");
        params.put("from_date", CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd"));
        params.put("from_updated_at", updated_at);
        params.put("to_date", CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd"));
        return params;
    }

    private void fetchOrdersById(String orderId) {

        try {
            myApp.shallWeRefreshOrders = false;
            new Thread(() -> {
                AndroidNetworking.get(ApiEndPoints.orders + orderId)
                        .setPriority(Priority.IMMEDIATE)
                        .build()
                        .getAsObject(Order.class, new ParsedRequestListener<Order>() {
                            @Override
                            public void onResponse(Order response) {
                                try {
                                    LogUtils.e("ORDERS", "API CALL response avyo " + response);
                                    List<Order> orderList = new ArrayList<>();
                                    orderList.add(response);
                                    Collections.reverse(orderList);
                                    new DbSaverAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, orderList);
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }

                            @Override
                            public void onError(ANError anError) {
                                try {
                                    anError.printStackTrace();
                                    fetchEposOrdersCount();
                                    myApp.shallWeRefreshOrders = true;
                                    boolean shouldDelete = false;
                                    if (anError.getErrorCode() == 400) shouldDelete = true;
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void fetchOnlineOrders() {

        try {
            myApp.shallWeRefreshOrders = false;
            Calendar calendar = Calendar.getInstance();
            calendar.add(Calendar.DATE, -2);
            new Thread(() -> {
                Order latestOrder;
                latestOrder = appDatabase.orderDao().lastUpdatedOrder();
                AndroidNetworking.get(ApiEndPoints.orders + "latest")
                        .setPriority(Priority.IMMEDIATE)
                        .addQueryParameter(getOrdersParameters(latestOrder, calendar))
                        .build()
                        .getAsObjectList(Order.class, new ParsedRequestListener<List<Order>>() {
                            @Override
                            public void onResponse(List<Order> response) {
                                try {
                                    LogUtils.e("ORDERS", "API CALL response avyo " + response.size());
                                    Collections.reverse(response);
                                    new DbSaverAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, response);
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }

                            @Override
                            public void onError(ANError anError) {
                                try {
                                    anError.printStackTrace();
                                    fetchEposOrdersCount();
                                    myApp.shallWeRefreshOrders = true;
                                    boolean shouldDelete = false;
                                    if (anError.getErrorCode() == 400) shouldDelete = true;
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private class DbSaverAsync extends AsyncTask<Object, Void, String> {
        private ArrayList<Object> localObjects = new ArrayList<>();

        @Override
        protected void onPreExecute() {
            LogUtils.e("ORDERS", "PRE EXECUTE");
            super.onPreExecute();
        }

        @Override
        protected String doInBackground(Object... lists) {
            try {
                LogUtils.e("ORDERS", "IN background start");
                Thread.currentThread().setPriority(Thread.MAX_PRIORITY);
                if (lists[0] instanceof ArrayList<?>) {
                    ArrayList<Order> parameterOrders = (ArrayList<Order>) lists[0];
                    ArrayList<String> allOrderIds = new ArrayList<>();
                    ArrayList<Order> newOnlineOrders = new ArrayList<>();
                    for (Order o : parameterOrders) {
                        allOrderIds.add(o.id);
                    }

                    // list all online orders that are not in local DB
                    ArrayList<Order> localOrdersWithOnlineID = new ArrayList<>();
                    localOrdersWithOnlineID = (ArrayList<Order>) appDatabase.orderDao().listWithOnlineIds(allOrderIds);
                    List<String> shouldNotDeleteThisIds;
                    for (Order onlineOrder : parameterOrders) {
                        boolean found = false;
                        for (Order dbOrder : localOrdersWithOnlineID) {
                            if (onlineOrder.id.equalsIgnoreCase(dbOrder.id)) {
                                found = true;
                                break;
                            }
                        }
                        if (!found) {
                            newOnlineOrders.add(onlineOrder);
                        }
                    }
                    // list all orders that are already in local DB
                    for (Order dbOrder : localOrdersWithOnlineID) {
                        Order matchedOnlineOrder = null;
                        for (Order onlineOrder : parameterOrders) {
                            if (onlineOrder.id.equalsIgnoreCase(dbOrder.id)) {
                                matchedOnlineOrder = onlineOrder;
                                break;
                            }
                        }
                        if (matchedOnlineOrder != null) {
                            if (dbOrder.updated_at != null &&
                                    dbOrder.updated_at.toLowerCase().equalsIgnoreCase(matchedOnlineOrder.updated_at.toLowerCase()) &&
                                    dbOrder.total == matchedOnlineOrder.total &&
                                    dbOrder.total_paid == matchedOnlineOrder.total_paid
                            ) {
                                LogUtils.e("Continuing... second");
                                continue;
                            } else {
                                Customer dbCustomer = appDatabase.customerDao().view(matchedOnlineOrder.customer_id);
                                int _customer_id;
                                if (dbCustomer == null) {
                                    dbCustomer = matchedOnlineOrder.customer;
                                    _customer_id = (int) appDatabase.customerDao().insert(matchedOnlineOrder.customer);
                                } else {
                                    _customer_id = dbCustomer._id;
                                    dbCustomer = matchedOnlineOrder.customer;
                                    dbCustomer._id = _customer_id;
                                    appDatabase.customerDao().update(dbCustomer);
                                    _customer_id = dbCustomer._id;
                                }
                                matchedOnlineOrder._customer_id = _customer_id;
                                matchedOnlineOrder.customer._id = _customer_id;

                                int _order_id;
                                matchedOnlineOrder.customer_name = dbCustomer.name;
                                if (dbOrder == null) {
                                    _order_id = (int) appDatabase.orderDao().insert(matchedOnlineOrder);
                                    matchedOnlineOrder._id = _order_id;
                                } else {
                                    matchedOnlineOrder._id = dbOrder._id;
                                    _order_id = dbOrder._id;
                                    //appDatabase.orderDao().update(matchedOnlineOrder);
                                    // if local order status is not paid then update the order
                                    if (!dbOrder.order_status_id.equalsIgnoreCase("5") || matchedOnlineOrder.order_status_id.equalsIgnoreCase("10")) {
                                        // if local item is not updated on server
                                        if (dbOrder.sub_total > matchedOnlineOrder.sub_total) {
                                            dbOrder.is_uploaded_on_server = true;
                                            appDatabase.orderDao().update(dbOrder);
                                        } else {
                                            matchedOnlineOrder.is_uploaded_on_server = true;
                                            appDatabase.orderDao().update(matchedOnlineOrder);
                                        }
                                    }
                                }


                                shouldNotDeleteThisIds = new ArrayList<>();
                                if (matchedOnlineOrder.order_splits != null) {
                                    for (OrderSplit split : matchedOnlineOrder.order_splits) {
                                        shouldNotDeleteThisIds.add(split.id);
                                        split._order_id = _order_id;
                                        OrderSplit dbSplit = appDatabase.orderSplitDao().view(split.id);
                                        if (dbSplit == null) {
                                            split._id = (int) appDatabase.orderSplitDao().insert(split);
                                        } else {
                                            split._id = dbSplit._id;
                                            appDatabase.orderSplitDao().update(split);
                                        }
                                    }
                                }
                                appDatabase.orderSplitDao().deleteOtherIdsButNotThis(_order_id, shouldNotDeleteThisIds);

                                shouldNotDeleteThisIds = new ArrayList<>();
                                if (matchedOnlineOrder.order_payments != null) {
                                    for (OrderPayment payment : matchedOnlineOrder.order_payments) {
                                        shouldNotDeleteThisIds.add(payment.id);
                                        payment._order_id = _order_id;
                                        OrderPayment dbPayment = appDatabase.orderPaymentDao().view(payment.id);
                                        if (dbPayment == null) {
                                            payment._id = (int) appDatabase.orderPaymentDao().insert(payment);
                                        } else {
                                            payment._id = dbPayment._id;

                                        }
                                        if (!Validators.isNullOrEmpty(payment.order_split_id)) {
                                            OrderSplit dbOrderSplit = appDatabase.orderSplitDao().view(payment.order_split_id);
                                            if (dbOrderSplit != null)
                                                payment._order_split_id = dbOrderSplit._id;
                                        }
                                        appDatabase.orderPaymentDao().insert(payment);
                                    }
                                }

                                appDatabase.orderPaymentDao().deleteOtherIdsButNotThis(_order_id, shouldNotDeleteThisIds);

                                if (matchedOnlineOrder.order_items != null) {
                                    //commenting because of the mismatch price issues
                                    //appDatabase.orderItemDao().deleteAll(_order_id);
                                    for (OrderItem orderItem : matchedOnlineOrder.order_items) {
                                        orderItem._order_id = _order_id;
                                        OrderItem dbOrderItem = myApp.appDatabase.orderItemDao().view(orderItem.id);

                                        if (!Validators.isNullOrEmpty(orderItem.order_split_id)) {
                                            OrderSplit orderSplit = appDatabase.orderSplitDao().view(orderItem.order_split_id);
                                            if (orderSplit != null)
                                                orderItem._order_split_id = orderSplit._id;
                                        }

                                        int _order_item_id = 0;
                                        if (dbOrderItem == null) {
                                            try {
                                                _order_item_id = (int) appDatabase.orderItemDao().insert(orderItem);
                                                orderItem._id = _order_item_id;
                                            } catch (Exception e) {

                                            }
                                        } else {
                                            _order_item_id = dbOrderItem._id;
                                            orderItem._id = _order_item_id;
                                            //appDatabase.orderItemDao().update(orderItem);
                                            // if local item is not updated on server
                                            if (dbOrderItem.quantity > orderItem.quantity) {
                                                appDatabase.orderItemDao().update(dbOrderItem);
                                            } else {
                                                appDatabase.orderItemDao().update(orderItem);
                                            }
                                        }

                                        float addonTotal = 0;
                                        shouldNotDeleteThisIds = new ArrayList<>();
                                        if (orderItem.order_item_addons != null) {
                                            for (OrderItemAddon itemAddon : orderItem.order_item_addons) {
                                                shouldNotDeleteThisIds.add(itemAddon.id);
                                                itemAddon._order_item_id = _order_item_id;
                                                itemAddon.total = itemAddon.quantity * itemAddon.price;
                                                addonTotal = addonTotal + itemAddon.total;
                                                OrderItemAddon dbAddon = appDatabase.orderItemAddonDao().view(itemAddon.id);
                                                if (dbAddon == null) {
                                                    itemAddon._id = (int) appDatabase.orderItemAddonDao().insert(itemAddon);
                                                } else {
                                                    itemAddon._id = dbAddon._id;
                                                    appDatabase.orderItemAddonDao().update(itemAddon);
                                                }
                                            }
                                        }
                                        appDatabase.orderItemAddonDao().deleteOtherIdsButNotThis(_order_item_id, shouldNotDeleteThisIds);

                                        float ingredientTotal = 0;
                                        if (orderItem.order_item_ingredients != null) {
                                            appDatabase.orderItemIngredientDao().deleteAll(_order_item_id);
                                            for (OrderItemIngredient itemIngredient : orderItem.order_item_ingredients) {
                                                itemIngredient._order_item_id = _order_item_id;
                                                itemIngredient.total = itemIngredient.quantity * itemIngredient.price;
                                                ingredientTotal = ingredientTotal + itemIngredient.total;
                                                OrderItemIngredient dbAddon = appDatabase.orderItemIngredientDao().view(itemIngredient.id);
                                                if (dbAddon == null) {
                                                    itemIngredient._id = (int) appDatabase.orderItemIngredientDao().insert(itemIngredient);
                                                } else {
                                                    itemIngredient._id = dbAddon._id;
                                                    appDatabase.orderItemIngredientDao().update(itemIngredient);
                                                }
                                            }
                                        }

                                        /*ingredientTotal = ingredientTotal * orderItem.quantity;
                                        addonTotal = addonTotal * orderItem.quantity;*/

                                        // when local item is not updated on api so need to use item from database
                                        if (dbOrderItem != null && dbOrderItem.quantity > orderItem.quantity) {
                                            ingredientTotal = ingredientTotal * dbOrderItem.quantity;
                                            addonTotal = addonTotal * dbOrderItem.quantity;
                                        } else {
                                            ingredientTotal = ingredientTotal * orderItem.quantity;
                                            addonTotal = addonTotal * orderItem.quantity;
                                        }
                                        myApp.appDatabase.orderItemDao().updateOrderItemTotal(_order_item_id, addonTotal, ingredientTotal);
                                    }
                                }
                            }
                        }
                    }

                    Iterator<Order> iterator = newOnlineOrders.iterator();

                    while (iterator.hasNext()) {
                        Order order = iterator.next();
                        if (isCancelled()) break;
                        Order dbOrder = appDatabase.orderDao().view(order.id);
                        if (dbOrder == null) {
                            // if local order is not updated check with local unique id in order to prevent duplicate order issue
                            dbOrder = appDatabase.orderDao().viewByUniqueId(order.unique_id);
                        }
                        if (dbOrder != null && dbOrder.updated_at != null &&
                                dbOrder.updated_at.toLowerCase().equalsIgnoreCase(order.updated_at.toLowerCase()) &&
                                dbOrder.total == order.total &&
                                dbOrder.total_paid == order.total_paid
                        ) {
                            LogUtils.e("Continuing...");
                            continue;
                        }
                        Customer dbCustomer = appDatabase.customerDao().view(order.customer_id);
                        int _customer_id;
                        if (dbCustomer == null) {
                            dbCustomer = order.customer;
                            _customer_id = (int) appDatabase.customerDao().insert(order.customer);
                        } else {
                            _customer_id = dbCustomer._id;
                            dbCustomer = order.customer;
                            dbCustomer._id = _customer_id;
                            appDatabase.customerDao().update(dbCustomer);
                            _customer_id = dbCustomer._id;
                        }
                        order._customer_id = _customer_id;
                        order.customer._id = _customer_id;

                        int _order_id;
                        order.customer_name = dbCustomer.name;
                        order.is_uploaded_on_server = true;
                        if (dbOrder == null) {
                            _order_id = (int) appDatabase.orderDao().insert(order);
                            order._id = _order_id;
                        } else {
                            order._id = dbOrder._id;
                            _order_id = dbOrder._id;
                            // if local order status is not paid then update the order
                            if (!dbOrder.order_status_id.equalsIgnoreCase("5") || order.order_status_id.equalsIgnoreCase("10")) {
                                appDatabase.orderDao().update(order);
                            }
                        }


                        shouldNotDeleteThisIds = new ArrayList<>();
                        if (order.order_splits != null) {
                            for (OrderSplit split : order.order_splits) {
                                shouldNotDeleteThisIds.add(split.id);
                                split._order_id = _order_id;
                                OrderSplit dbSplit = appDatabase.orderSplitDao().view(split.id);
                                if (dbSplit == null) {
                                    split._id = (int) appDatabase.orderSplitDao().insert(split);
                                } else {
                                    split._id = dbSplit._id;
                                    appDatabase.orderSplitDao().update(split);
                                }
                            }
                        }
                        appDatabase.orderSplitDao().deleteOtherIdsButNotThis(_order_id, shouldNotDeleteThisIds);

                        shouldNotDeleteThisIds = new ArrayList<>();
                        if (order.order_payments != null) {
                            for (OrderPayment payment : order.order_payments) {
                                shouldNotDeleteThisIds.add(payment.id);
                                payment._order_id = _order_id;
                                OrderPayment dbPayment = appDatabase.orderPaymentDao().view(payment.id);
                                if (dbPayment == null) {
                                    payment._id = (int) appDatabase.orderPaymentDao().insert(payment);
                                } else {
                                    payment._id = dbPayment._id;

                                }
                                if (!Validators.isNullOrEmpty(payment.order_split_id)) {
                                    OrderSplit dbOrderSplit = appDatabase.orderSplitDao().view(payment.order_split_id);
                                    if (dbOrderSplit != null)
                                        payment._order_split_id = dbOrderSplit._id;
                                }
                                appDatabase.orderPaymentDao().insert(payment);
                            }
                        }

                        appDatabase.orderPaymentDao().deleteOtherIdsButNotThis(_order_id, shouldNotDeleteThisIds);

                        if (order.order_items != null) {
                            appDatabase.orderItemDao().deleteAll(_order_id);
                            for (OrderItem orderItem : order.order_items) {
                                orderItem._order_id = _order_id;
                                OrderItem dbOrderItem = myApp.appDatabase.orderItemDao().view(orderItem.id);

                                if (!Validators.isNullOrEmpty(orderItem.order_split_id)) {
                                    OrderSplit orderSplit = appDatabase.orderSplitDao().view(orderItem.order_split_id);
                                    if (orderSplit != null)
                                        orderItem._order_split_id = orderSplit._id;
                                }

                                int _order_item_id = 0;
                                if (dbOrderItem == null) {
                                    try {
                                        _order_item_id = (int) appDatabase.orderItemDao().insert(orderItem);
                                        orderItem._id = _order_item_id;
                                    } catch (Exception e) {

                                    }
                                } else {
                                    _order_item_id = dbOrderItem._id;
                                    orderItem._id = _order_item_id;
                                    appDatabase.orderItemDao().update(orderItem);
                                }

                                float addonTotal = 0;
                                shouldNotDeleteThisIds = new ArrayList<>();
                                if (orderItem.order_item_addons != null) {
                                    for (OrderItemAddon itemAddon : orderItem.order_item_addons) {
                                        shouldNotDeleteThisIds.add(itemAddon.id);
                                        itemAddon._order_item_id = _order_item_id;
                                        itemAddon.total = itemAddon.quantity * itemAddon.price;
                                        addonTotal = addonTotal + itemAddon.total;
                                        OrderItemAddon dbAddon = appDatabase.orderItemAddonDao().view(itemAddon.id);
                                        if (dbAddon == null) {
                                            itemAddon._id = (int) appDatabase.orderItemAddonDao().insert(itemAddon);
                                        } else {
                                            itemAddon._id = dbAddon._id;
                                            appDatabase.orderItemAddonDao().update(itemAddon);
                                        }
                                    }
                                }
                                appDatabase.orderItemAddonDao().deleteOtherIdsButNotThis(_order_item_id, shouldNotDeleteThisIds);

                                float ingredientTotal = 0;
                                if (orderItem.order_item_ingredients != null) {
                                    appDatabase.orderItemIngredientDao().deleteAll(_order_item_id);
                                    for (OrderItemIngredient itemIngredient : orderItem.order_item_ingredients) {
                                        itemIngredient._order_item_id = _order_item_id;
                                        itemIngredient.total = itemIngredient.quantity * itemIngredient.price;
                                        ingredientTotal = ingredientTotal + itemIngredient.total;
                                        OrderItemIngredient dbAddon = appDatabase.orderItemIngredientDao().view(itemIngredient.id);
                                        if (dbAddon == null) {
                                            itemIngredient._id = (int) appDatabase.orderItemIngredientDao().insert(itemIngredient);
                                        } else {
                                            itemIngredient._id = dbAddon._id;
                                            appDatabase.orderItemIngredientDao().update(itemIngredient);
                                        }
                                    }
                                }

                                ingredientTotal = ingredientTotal * orderItem.quantity;
                                addonTotal = addonTotal * orderItem.quantity;
                                myApp.appDatabase.orderItemDao().updateOrderItemTotal(_order_item_id, addonTotal, ingredientTotal);
                            }
                        } else {
                            // delete all item from local if item is deleted from any device
                            appDatabase.orderItemDao().deleteAll(_order_id);
                        }
                    }
                    if (isCancelled()) return null;

                }
                if (isCancelled()) return null;
            } catch (Exception e) {
                e.printStackTrace();
            }


            LogUtils.e("ORDERS", "IN background finish");
            return "Executed";
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                LogUtils.e("ORDERS", "Post Execute");
                myApp.shallWeRefreshOrders = true;
                if (getActivity() != null) {
                    getActivity().runOnUiThread(HomeFragment.this::fetchEposOrdersCount);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        protected void onCancelled() {
            super.onCancelled();
        }
    }

    private void fetchEposOrdersCount() {
        try {
            new Thread(() -> {
                try {
                    for (RecyclerMenuItem orderType : items) {
                        if (!orderType.id.equalsIgnoreCase("0") && !orderType.id.equalsIgnoreCase("6")) {
                            orderType.count = appDatabase.orderDao().activeOrdersCount(orderType.id);
                        } else if (orderType.id.equalsIgnoreCase("0")) {
                            orderType.count = appDatabase.orderDao().activeOrdersCount();
                        }
                    }
                    if (getActivity() != null) {
                        try {
                            getActivity().runOnUiThread(() -> {
                                itemAdapter.notifyDataSetChanged();
                            });
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setOnlineOrderCounts(Counts allCounts) {
        try {
            if (allCounts == null) return;
            for (RecyclerMenuItem menuItem : items) {
                if (menuItem.id.equalsIgnoreCase("6")) {
                    menuItem.count = allCounts.pending_orders;
                }
            }

            itemAdapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        try {
            if (getActivity() != null) {
                LocalBroadcastManager.getInstance(getActivity()).registerReceiver(onlineOrdersNotificationReceiver, new IntentFilter(Constants.NOTIFICATION));
                LocalBroadcastManager.getInstance(getActivity()).registerReceiver(newOrderReceiver, new IntentFilter(Constants.EPOS_NEW_ORDER));
                LocalBroadcastManager.getInstance(getActivity()).registerReceiver(eposOrderUpdateReceiver, new IntentFilter(Constants.EPOS_ORDER_UPDATE));
                if (itemAdapter != null) {
                    myApp.stopOrderSound();
                    setOnlineOrderCounts(null);
                }
            }
            myApp.shallWeRefreshOrders = true;
            myApp.isReservationOpen = false;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        try {
            myApp.shallWeRefreshOrders = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (onlineOrdersNotificationReceiver != null && getActivity() != null) {
            LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(onlineOrdersNotificationReceiver);
        }
        if (getActivity() != null && eposOrderUpdateReceiver != null) {
            LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(eposOrderUpdateReceiver);
        }
        if (getActivity() != null && newOrderReceiver != null) {
            LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(newOrderReceiver);
        }
    }

    private void changeFragment(Fragment fragment) {
        try {
            FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
            ft.replace(getId(), fragment);
            ft.addToBackStack("can_go_back");
            ft.commit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
