package com.ubsidi.epos_2021.fragment;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.gson.Gson;
import com.ubsidi.R;
import com.ubsidi.epos_2021.activities.NewOrderActivity;
import com.ubsidi.epos_2021.adapters.CategoryAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.daos.relations.CategoryWithChildren;
import com.ubsidi.epos_2021.models.Category;
import com.ubsidi.epos_2021.utils.LogUtils;

import java.util.ArrayList;

public class MainCategoryFragment extends BaseFragment {

    private RecyclerView rvCategory;
    private CategoryAdapter categoryAdapter;

    private ArrayList<Category> filteredItems = new ArrayList<>();
    private ArrayList<Category> categories = new ArrayList<>();
    String orderType;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_main_category, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        initViews(view);
        new Thread(this::fetchCategories).start();
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getArguments() != null) {
            orderType = getArguments().getString("order_type");
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance(getActivity()).registerReceiver(searchReceiver, new IntentFilter("search_receiver"));
    }

    private void initViews(View view) {
        try {
            rvCategory = view.findViewById(R.id.rvCategories);

            categoryAdapter = new CategoryAdapter(filteredItems, (position, data) -> {
                Category selectedCategory = (Category) data;
                //send brodcast
                LocalBroadcastManager.getInstance(getActivity()).sendBroadcast(new Intent("search_receiver").putExtra("category_data", new Gson().toJson(selectedCategory)));

                try {
                    if (getActivity() != null) {
                        ((NewOrderActivity) getActivity()).clearEditText();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

            });
            rvCategory.setLayoutManager(new GridLayoutManager(getActivity(), 2, LinearLayoutManager.VERTICAL, false));
            rvCategory.setAdapter(categoryAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    BroadcastReceiver searchReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            String searchedItem = intent.getStringExtra("searched_item");

        }
    };


    private void fetchCategories() {
        try {
            LogUtils.d("order type::" + orderType);
            categories.clear();
            categories.addAll(myApp.categories);
//            filteredItems.clear();
//            filteredItems.addAll(categories);
            if (!Validators.isNullOrEmpty(orderType)) {
                ArrayList<Category> tempCategories = new ArrayList<>();
                filteredItems.clear();
                if (orderType.equalsIgnoreCase("2")) {
                    ArrayList<CategoryWithChildren> categoryWithChildren = (ArrayList<CategoryWithChildren>) appDatabase.categoryDao().collectionCategory(true);
                    for (CategoryWithChildren c : categoryWithChildren) {
                        Category category = c.category;
                        category.children = (ArrayList<Category>) c.children;
                        ArrayList<Category> childs = new ArrayList<>();
                        for (Category childCategory : category.children) {
                            if (!childCategory.disabled) {
                                childs.add(childCategory);
                            }
                        }
                        category.children = childs;
                        tempCategories.add(category);
                    }
                    filteredItems.addAll(tempCategories);
                } else if (orderType.equalsIgnoreCase("3")) {
                    ArrayList<CategoryWithChildren> categoryWithChildren = (ArrayList<CategoryWithChildren>) appDatabase.categoryDao().deliveryCategory(true);
                    for (CategoryWithChildren c : categoryWithChildren) {
                        Category category = c.category;
                        category.children = (ArrayList<Category>) c.children;
                        ArrayList<Category> childs = new ArrayList<>();
                        for (Category childCategory : category.children) {
                            if (!childCategory.disabled) {
                                childs.add(childCategory);
                            }
                        }
                        category.children = childs;
                        tempCategories.add(category);
                    }
                    filteredItems.addAll(tempCategories);
                } else if (orderType.equalsIgnoreCase("1")) {
                    ArrayList<CategoryWithChildren> categoryWithChildren = (ArrayList<CategoryWithChildren>) appDatabase.categoryDao().dineInCategory(true);
                    for (CategoryWithChildren c : categoryWithChildren) {
                        Category category = c.category;
                        category.children = (ArrayList<Category>) c.children;
                        ArrayList<Category> childs = new ArrayList<>();
                        for (Category childCategory : category.children) {
                            if (!childCategory.disabled) {
                                childs.add(childCategory);
                            }
                        }
                        category.children = childs;
                        tempCategories.add(category);
                    }
                    filteredItems.addAll(tempCategories);
                } else if (orderType.equalsIgnoreCase("5")) {
                    ArrayList<CategoryWithChildren> categoryWithChildren = (ArrayList<CategoryWithChildren>) appDatabase.categoryDao().waitingCategory(true);
                    for (CategoryWithChildren c : categoryWithChildren) {
                        Category category = c.category;
                        category.children = (ArrayList<Category>) c.children;
                        ArrayList<Category> childs = new ArrayList<>();
                        for (Category childCategory : category.children) {
                            if (!childCategory.disabled) {
                                childs.add(childCategory);
                            }
                        }
                        category.children = childs;
                        tempCategories.add(category);
                    }
                    filteredItems.addAll(tempCategories);
                }
            } else {
                filteredItems.clear();
                filteredItems.addAll(categories);
            }
            // Set first floor item selected;
            if (categories.size() > 0) {
                categoryAdapter.selectedCategoryId = categories.get(0).id;
                Category selectedCategory = categories.get(0);
                //send brodcast
                LocalBroadcastManager.getInstance(getActivity()).sendBroadcast(new Intent("search_receiver").putExtra("category_data", new Gson().toJson(selectedCategory)));
            }
            categoryAdapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(searchReceiver);
    }
}
