package com.ubsidi.epos_2021.fragment;


import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.ubsidi.R;
import com.ubsidi.epos_2021.adapters.MerchantStatementAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.merchant.activities.WebviewActivity;
import com.ubsidi.epos_2021.models.MerchantStatement;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.online.interfaces.RecyclerViewItemClickListener;
import com.wdullaer.materialdatetimepicker.date.DatePickerDialog;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/**
 * Created by Amrish on 23-06-2021.
 */
public class MerchantStatementFragment extends BaseFragment {
    private ArrayList<Object> objects = new ArrayList<>();
    private MerchantStatementAdapter merchantStatementAdapter;
    private ArrayList<MerchantStatement> statements = new ArrayList<>();
    private SwipeRefreshLayout swipeRefreshLayout;
    private Calendar fromCalendar = Calendar.getInstance();
    private Calendar toCalendar = Calendar.getInstance();
    private String fromDateString, toDateString;

    private TextView tvToDate, tvFromDate;
    private RelativeLayout llFromDate, llToDate;
    int fromYear, fromMonth, fromDay, toYear, toMonth, toDay;


    @Nullable
    @Override
    public View onCreateView(@NonNull @NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_merchant_statements, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            fetchStatements();
            setListeners();
            updateViews();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            tvToDate = view.findViewById(R.id.tvToDate);
            tvFromDate = view.findViewById(R.id.tvFromDate);
            llToDate = view.findViewById(R.id.llToDate);
            llFromDate = view.findViewById(R.id.llFromDate);
            RecyclerView rvStatements = view.findViewById(R.id.rvStatements);
            swipeRefreshLayout = view.findViewById(R.id.swipeRefreshLayout);
            rvStatements.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));
            merchantStatementAdapter = new MerchantStatementAdapter(objects, new RecyclerViewItemClickListener() {
                @Override
                public void onItemClick(int position, Object data) {
                    //view click
                    try {
                        MerchantStatement statement = (MerchantStatement) data;
                        String pathUrl = ApiEndPoints.merchant_statements + "/" + statement.id + "/download";

                        Intent i = new Intent(getActivity(), WebviewActivity.class);
                        i.putExtra("pdfUrl", pathUrl);
                        startActivity(i);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, (position, data) -> {
                //download click
                try {
                    MerchantStatement statement = (MerchantStatement) data;
                    String pathUrl = ApiEndPoints.merchant_statements + "/" + statement.id + "/download";
                    Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(pathUrl));
                    startActivity(browserIntent);
                } catch (Exception e) {
                    e.printStackTrace();
                }

            });
            rvStatements.setAdapter(merchantStatementAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void updateViews() {
        try {
            fromCalendar.add(Calendar.DATE, -30);

            fromDateString = CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "yyyy-MM-dd");
            toDateString = CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "yyyy-MM-dd");

            tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
            tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void setListeners() {
        try {
            swipeRefreshLayout.setOnRefreshListener(this::fetchStatements);
            llFromDate.setOnClickListener(view -> {
                try {
                    DatePickerDialog datePickerDialog = DatePickerDialog.newInstance((view1, y, m, d) -> {
                        fromDay = d;
                        fromMonth = m;
                        fromYear = y;
                        fromDateString = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                        fromCalendar.set(y, m, d);
                        tvFromDate.setText("From: " + CommonFunctions.formatMiliToDesireFormat(fromCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                        fetchStatements();
                    }, fromCalendar.get(Calendar.YEAR), fromCalendar.get(Calendar.MONTH), fromCalendar.get(Calendar.DAY_OF_MONTH));
                    datePickerDialog.setThemeDark(false);
                    datePickerDialog.showYearPickerFirst(false);
                    datePickerDialog.show(getActivity().getFragmentManager(), "FromPickerDialog");
                    if (!Validators.isNullOrEmpty(toDateString)) {
                        datePickerDialog.setMaxDate(toCalendar);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });

            llToDate.setOnClickListener(view -> {
                try {
                    DatePickerDialog datePickerDialog = DatePickerDialog.newInstance((view12, y, m, d) -> {
                        toDay = d;
                        toMonth = m;
                        toYear = y;
                        toDateString = y + "-" + String.format("%02d", (m + 1)) + "-" + String.format("%02d", d);
                        toCalendar.set(y, m, d);
                        tvToDate.setText("To: " + CommonFunctions.formatMiliToDesireFormat(toCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                        fetchStatements();
                    }, toCalendar.get(Calendar.YEAR), toCalendar.get(Calendar.MONTH), toCalendar.get(Calendar.DAY_OF_MONTH));
                    datePickerDialog.setThemeDark(false);
                    datePickerDialog.showYearPickerFirst(false);
                    datePickerDialog.show(getActivity().getFragmentManager(), "ToPickerDialog");
                    if (!Validators.isNullOrEmpty(fromDateString)) {
                        datePickerDialog.setMinDate(fromCalendar);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void fetchStatements() {
        try {
            swipeRefreshLayout.setRefreshing(true);
            AndroidNetworking.get(ApiEndPoints.merchant_statements)
                    .addQueryParameter("nopaginate", "1")
                    .addQueryParameter("from_date", fromDateString)
                    .addQueryParameter("to_date", toDateString)
                    .build()
                    .getAsObjectList(MerchantStatement.class, new ParsedRequestListener<List<MerchantStatement>>() {
                        @Override
                        public void onResponse(List<MerchantStatement> response) {
                            try {
                                swipeRefreshLayout.setRefreshing(false);
                                statements.clear();
                                statements.addAll(response);
                                objects.clear();
                                objects.addAll(statements);
                                merchantStatementAdapter.notifyDataSetChanged();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                swipeRefreshLayout.setRefreshing(false);
                                if (anError.getErrorCode() == 400) {
                                    statements.clear();
                                    objects.clear();
                                    merchantStatementAdapter.notifyDataSetChanged();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
