package com.ubsidi.epos_2021.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.DialogFragment;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.gson.Gson;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Table;
import com.ubsidi.epos_2021.models.TableStatus;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.online.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.utils.LogUtils;

/**
 * Created by Amrish on 11-11-2020.
 */
public class MergeInfoDialogFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private String title, info, positiveButton, negativeButton, tableId;
    private boolean reject;
    private int type; //0 neutral, 1 success,2 reject
    private MaterialButton btnConfirm, btnCancel;
    private TextView tvInfo, tvTitle;
    public TableStatus vacantStatus = MyApp.getInstance().findStatus("Vacant");
    private DialogDismissListener dialogDismissListener;
    private ProgressBar progress_merge_info;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_merge_info_fragment, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            title = getArguments().getString("title");
            info = getArguments().getString("info");
            positiveButton = getArguments().getString("positive_button");
            negativeButton = getArguments().getString("negative_button");
            tableId = getArguments().getString("tableId");
            type = getArguments().getInt("type");

            initViews(view);
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            btnConfirm = view.findViewById(R.id.btnConfirm);
            btnCancel = view.findViewById(R.id.btnCancel);
            tvInfo = view.findViewById(R.id.tvInfo);
            tvTitle = view.findViewById(R.id.tvTitle);
            progress_merge_info = view.findViewById(R.id.progress_merge_info);

            if (Validators.isNullOrEmpty(title)) {
                tvTitle.setVisibility(View.GONE);
            } else
                tvTitle.setText(title);
            if (Validators.isNullOrEmpty(info)) {
                tvInfo.setVisibility(View.GONE);
            } else
                tvInfo.setText(info);
            if (type == 2) {
                tvTitle.setTextColor(ContextCompat.getColor(getActivity(), R.color.dialog_title_reject));
            } else if (type == 1) {
                tvTitle.setTextColor(ContextCompat.getColor(getActivity(), R.color.dialog_title_accept));
            }
            if (Validators.isNullOrEmpty(negativeButton)) {
                btnCancel.setVisibility(View.GONE);
            } else {
                btnCancel.setText(negativeButton);
            }
            if (Validators.isNullOrEmpty(positiveButton)) {
                btnConfirm.setVisibility(View.GONE);
            } else {
                btnConfirm.setText(positiveButton);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            btnConfirm.setOnClickListener(view -> {
                progress_merge_info.setVisibility(View.VISIBLE);
                freeOldTable(tableId);
            });
            btnCancel.setOnClickListener(view -> {
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss("cancel");
                dismiss();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void freeOldTable(String oldTableId) {
        LogUtils.e("TABLE::Freeing old table start");
        try {
            new Thread(() -> {
                Table table = MyApp.getInstance().appDatabase.tableDao().view(oldTableId);
                table.locked = false;
                table.table_status_id = vacantStatus.id;
                table.status = vacantStatus.status;
                table.last_order_id = null;
                table._last_order_id = 0;
                table.last_order_created_at = null;
                table.merge_table_id = null;
                table.updater_id = MyApp.getInstance().myPreferences.getLoggedInUser().id;
                MyApp.getInstance().appDatabase.tableDao().insert(table);
                AndroidNetworking.post(ApiEndPoints.tables + table.id)
                        .addApplicationJsonBody(table)
                        .build()
                        .getAsObject(Table.class, new ParsedRequestListener() {
                            @Override
                            public void onResponse(Object response) {
                                LogUtils.e("TABLE FREEING STATUS CHANGED BEFORE RESPONSE:" + new Gson().toJson(table));
                                requireActivity().runOnUiThread(() -> {
                                    progress_merge_info.setVisibility(View.GONE);
                                });
                                if (dialogDismissListener != null)
                                    dialogDismissListener.onDialogDismiss("confirm");
                                dismiss();
                            }

                            @Override
                            public void onError(ANError anError) {
                                requireActivity().runOnUiThread(() -> {
                                    progress_merge_info.setVisibility(View.GONE);
                                });
                                if (anError.getErrorCode() == 400) {
                                    LogUtils.e("TABLE FREEING OLD TABLE ERROR IN TABLE STATUS CHANGE: ", anError.getErrorAsObject(ApiError.class).getMessage());
                                }
                            }
                        });
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
