package com.ubsidi.epos_2021.fragment;

import android.os.AsyncTask;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.AppCompatSpinner;

import com.google.android.material.button.MaterialButton;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.PrepLocationAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.MoneyTextWatcher;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.PrepLocation;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.ArrayList;


public class MiscItemFragment extends BaseFragment {


    private DialogDismissListener dialogDismissListener;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    private OrderItem orderItem = new OrderItem();
    private ImageView ivPlus, ivMinus;
    private TextView tvQuantity;
    private MaterialButton btnConfirm, btnCancel;
    private EditText etProductName, etMiscAmount;
    private AppCompatSpinner spPrepLocation;
    private AlertDialog progressBarDialog;
    private PrepLocationAdapter prepLocationAdapter;
    private ArrayList<PrepLocation> prepLocationList = new ArrayList<>();
    private PrepLocation selectedPrepLocation;
    int quantity = 1;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_misc_item, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            new PrepLocationAsyncTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {

        try {
            progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
            btnCancel = view.findViewById(R.id.btnCancel);
            btnConfirm = view.findViewById(R.id.btnConfirm);
            ivPlus = view.findViewById(R.id.ivPlus);
            ivMinus = view.findViewById(R.id.ivMinus);
            tvQuantity = view.findViewById(R.id.tvQuantity);
            spPrepLocation = view.findViewById(R.id.spPrepLocation);
            etMiscAmount = view.findViewById(R.id.etMiscAmount);
            etProductName = view.findViewById(R.id.etProductName);
            tvQuantity.setText(String.valueOf(orderItem.quantity));

            etMiscAmount.setText("0.00");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateView() {
        try {
            prepLocationAdapter = new PrepLocationAdapter(getActivity(), android.R.layout.simple_list_item_1, prepLocationList);
            spPrepLocation.setAdapter(prepLocationAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {

        try {
            spPrepLocation.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
                @Override
                public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                    selectedPrepLocation = prepLocationAdapter.getItem(position);

                }

                @Override
                public void onNothingSelected(AdapterView<?> parent) {

                }
            });

            btnCancel.setOnClickListener(v -> {
                getActivity().onBackPressed();
            });

            btnConfirm.setOnClickListener(v -> {
                try {
                    CommonFunctions.hideKeyboard(getActivity(), etMiscAmount);
                    if (isValid()) {
                        float miscAmount = Float.parseFloat(etMiscAmount.getText().toString().replace(",", ""));
                        orderItem.product_name = etProductName.getText().toString();
                        orderItem.price = miscAmount;
                        orderItem.takeaway_price = miscAmount;
                        orderItem.waiting_price = miscAmount;
                        orderItem.delivery_price = miscAmount;
                        orderItem.web_price = miscAmount;
                        orderItem.updater_id = MyApp.getInstance().myPreferences.getLoggedInUser().id;
                        if (selectedPrepLocation != null)
                            orderItem.preparation_location_id = selectedPrepLocation.id;
                        orderItem.sub_total = orderItem.quantity * orderItem.price;
                        orderItem.total = orderItem.sub_total;
                        orderItem.misc = true;
                        if (dialogDismissListener != null)
                            dialogDismissListener.onDialogDismiss(orderItem);
                        getActivity().onBackPressed();
                    }
                } catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            });

            ivPlus.setOnClickListener(view -> {
                orderItem.quantity++;
                tvQuantity.setText("" + orderItem.quantity);
            });

            ivMinus.setOnClickListener(view -> {
                try {
                    if (orderItem.quantity > 1) {
                        orderItem.quantity--;
                        tvQuantity.setText("" + orderItem.quantity);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            etMiscAmount.addTextChangedListener(new MoneyTextWatcher(etMiscAmount));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isValid() {
        if (Validators.isNullOrEmpty(etProductName.getText().toString())) {
            ToastUtils.makeToast(getActivity(), "Please enter Product name");
            return false;
        }
        if (Validators.isNullOrEmpty(etMiscAmount.getText().toString())) {
            ToastUtils.makeToast(getActivity(), "Please enter Amount");
            return false;
        }
        return true;
    }

    private class PrepLocationAsyncTask extends AsyncTask<String, String, String> {
        @Override
        protected String doInBackground(String... strings) {
            try {
                prepLocationList.clear();
                prepLocationList.addAll(MyApp.getInstance().appDatabase.prepLocationDao().list());
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            try {
                progressBarDialog.dismiss();
                super.onPostExecute(s);
                if (prepLocationList.size() > 0)
                    selectedPrepLocation = prepLocationList.get(0);
                updateView();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

}