package com.ubsidi.epos_2021.fragment;

import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.DialogFragment;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.chip.Chip;
import com.google.android.material.textfield.MaterialAutoCompleteTextView;
import com.google.gson.Gson;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.CustomerAutoSuggestAdapter;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderType;
import com.ubsidi.epos_2021.models.Table;
import com.ubsidi.epos_2021.models.TableStatus;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.ArrayList;
import java.util.List;


public class NewDineinOrderDialogFragment extends DialogFragment {
    Order order = new Order();

    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private DialogDismissListener dialogDismissListener;

    protected void manageIntents() {
        if (getArguments() != null) {
            table = new Gson().fromJson(getArguments().getString("table"), Table.class);
        }
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    private Chip chipBack;
    private MaterialButton btnConfirm;
    private MaterialAutoCompleteTextView etName;
    private EditText etMobile, etEmail;
    private ArrayList<Customer> customers = new ArrayList<>();
    private CustomerAutoSuggestAdapter customerAutoSuggestAdapter;
    private Customer selectedCustomer;
    private Table table;
    private LinearLayout llMainLayout, llLoading;
    private ImageView ivSecDecrease, ivSecIncrease;
    private EditText tvModifyQty;
    private AlertDialog progressBarDialog;
    private OrderType selectedOrderType;
    private AppDatabase appDatabase;
    private MyApp myApp = MyApp.getInstance();
    public TableStatus vacantStatus = myApp.findStatus("Vacant");
    public TableStatus takingOrderStatus = myApp.findStatus("Taking Order");

    private CheckBox signupForNewsletter;


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_new_dinein_order_dialog, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            appDatabase = MyApp.getInstance().appDatabase;
            manageIntents();
            initViews(view);
            setListeners();
            fetchCustomers();

            setUpOrderTypes();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
            btnConfirm = view.findViewById(R.id.btnConfirm);
            btnConfirm.setEnabled(true);
            etName = view.findViewById(R.id.etName);
            etMobile = view.findViewById(R.id.etMobile);
            etEmail = view.findViewById(R.id.etEmail);
            TextView tvTableNo = view.findViewById(R.id.tvTableNo);
            tvModifyQty = view.findViewById(R.id.tvModifyQty);
            tvModifyQty.requestFocus();
            ivSecIncrease = view.findViewById(R.id.ivSecIncrease);
            ivSecDecrease = view.findViewById(R.id.ivSecDecrease);
            llMainLayout = view.findViewById(R.id.llMainLayout);
            llLoading = view.findViewById(R.id.llLoading);
            chipBack = view.findViewById(R.id.chipBack);
            tvModifyQty.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

                }

                @Override
                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                    if(!Validators.isNullOrEmpty(tvModifyQty.getText().toString())){
                        guestCount = Integer.parseInt(tvModifyQty.getText().toString());
                    }
                }

                @Override
                public void afterTextChanged(Editable editable) {

                }
            });
            signupForNewsletter = view.findViewById(R.id.signupForNewsletter);

            getOfflineCustomer();

            tvTableNo.setText("Table No: " + table.number);
            etName.setThreshold(3);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getOfflineCustomer() {
        new Thread(() -> {
            try {
                if (!customers.isEmpty()) {
                    customers.clear();
                }
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        customers.addAll(appDatabase.customerDao().listNoNull());
                        LogUtils.e("Dinein getOfflineCustomer " + customers.size());
                        customerAutoSuggestAdapter = new CustomerAutoSuggestAdapter(getActivity(), customers);
                        etName.setAdapter(customerAutoSuggestAdapter);
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    int guestCount = 1;

    private void setListeners() {
        try {
            chipBack.setOnClickListener(view -> {
                dismissAllowingStateLoss();
            });

            btnConfirm.setOnClickListener(view -> {
                if (isValid()) {
                    btnConfirm.setEnabled(false);
                    createOrderOffline();
                }

            });

            etName.setOnItemClickListener((adapterView, view, i, l) -> {
                try {
                    int indext = customers.indexOf(adapterView.getItemAtPosition(i));
                    if (indext != -1) {
                        selectedCustomer = customers.get(indext);
                        etName.setText(selectedCustomer.name);
                        etMobile.setText(selectedCustomer.mobile);
                        etEmail.setText(selectedCustomer.email);
                        new Thread(() -> {
                            if (selectedCustomer._id == 0 && !Validators.isNullOrEmpty(selectedCustomer.id)) {
                                selectedCustomer._id = (int) appDatabase.customerDao().insert(selectedCustomer);
                            }
                        }).start();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

            });

            ivSecIncrease.setOnClickListener(view -> {
                guestCount++;
                tvModifyQty.setText("" + guestCount);
                tvModifyQty.setSelection(tvModifyQty.getText().length());
            });

            ivSecDecrease.setOnClickListener(view -> {
                if (guestCount > 1) {
                    guestCount--;
                    tvModifyQty.setText("" + guestCount);
                    tvModifyQty.setSelection(tvModifyQty.getText().length());
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isValid() {


        return true;
    }

    Customer customer;


    private void setUpOrderTypes() {

        llLoading.setVisibility(View.GONE);
        llMainLayout.setVisibility(View.VISIBLE);

        selectedOrderType = new OrderType("1", "Dine in");
    }

    private void fetchCustomers() {
        new CustomersDbOperations().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, customers);
        /*if (MyApp.getInstance().isConnected(getActivity()) && "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode())) {
            fetchOnlineCustomers();
            //new CustomersDbOperations().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, customers);
        } else {
            new CustomersDbOperations().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, customers);
        }*/
    }

    private void fetchOnlineCustomers() {
        AndroidNetworking.get(ApiEndPoints.customers)
                .addQueryParameter("nopaginate", "1")
                .build()
                .getAsObjectList(Customer.class, new ParsedRequestListener<List<Customer>>() {
                    @Override
                    public void onResponse(List<Customer> response) {
                        // customerAutoSuggestAdapter.updateData(response);
                        new CustomersDbOperations().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (ArrayList<Customer>) response);
                    }

                    @Override
                    public void onError(ANError anError) {
                        if (anError.getErrorCode() == 400) {
                            ApiError apiError = anError.getErrorAsObject(ApiError.class);
                            ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                        }
                        new CustomersDbOperations().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, customers);
                    }
                });

    }

    private void createOrderOffline() {
        try {
            new Thread(() -> {
                try {
                    Customer customer;
                    if (selectedCustomer != null) {
                        customer = selectedCustomer;
                    } else {
                        customer = new Customer();
                    }

                    //1->true , 0->false
                    if (signupForNewsletter.isChecked())
                        customer.news_letter = true;
                    else
                        customer.news_letter = false;

                    //Add By SP
                    if (myApp.myPreferences.getRemoteDeviceEnableStatus()) {
                        order.print_id = 1;
                    } else {
                        order.print_id = 0;
                    }
                    //Toast.makeText(getActivity(), "print_id:"+order.print_id, Toast.LENGTH_SHORT).show();

                    customer.name = etName.getText().toString();
                    customer.mobile = etMobile.getText().toString();
                    customer.email = etEmail.getText().toString();

                    order.customer_id = customer.id;
                    order.table_id = table.id;
                    order.table_number = table.number;
                    order.no_guest = String.valueOf(guestCount);
                    order.customer = customer;
                    order.customer_name = customer.name;
                    order.updater_id = MyApp.getInstance().myPreferences.getLoggedInUser().id;
                    order.order_status_id = "1";
                    order.order_status = "Taking Order";
                    order.order_type_id = selectedOrderType.id;
                    order.order_items = new ArrayList<>();
                    order.device_id = MyApp.getInstance().myPreferences.getRegisteredDevice().id;
                    order.created_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                    order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                    order.delivery_date = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                    // Update Customer
                    selectedCustomer = customer;
                    if (selectedCustomer._id == 0)
                        selectedCustomer._id = (int) appDatabase.customerDao().insert(selectedCustomer);
                    else {
                        appDatabase.customerDao().insert(selectedCustomer);
                    }
                    order._customer_id = selectedCustomer._id;
                    order.customer_name = selectedCustomer.name;
                    long tsLong = System.currentTimeMillis() / 1000;
                    order.unique_id = tsLong + MyApp.getInstance().myPreferences.getBusinessId() + MyApp.getInstance().myPreferences.getRegisteredDevice().id;
                    // Save Order
                    order._id = (int) MyApp.getInstance().appDatabase.orderDao().insert(order);
                    table._last_order_id = order._id;
                    table.last_order_id = null;
                    table.table_status_id = takingOrderStatus.id;
                    table.status = takingOrderStatus.status;
                    appDatabase.tableDao().insert(table);
                    // change display order id
                    String userPrefix = myApp.myPreferences.getLoggedInUser().preffix;
                    if(!Validators.isNullOrEmpty(userPrefix)){
                        String prefix = userPrefix+order._id;
                        order.display_order_id = prefix;
                        myApp.appDatabase.orderDao().updateDisplayOrderId(order._id,prefix);
                    }
                    if (MyApp.getInstance().isConnected(getActivity()) && "auto".equalsIgnoreCase(MyApp.getInstance().myPreferences.getOrderSyncMode())) {
                        createOrderOnline(order);
                    } else {
                        changeTableStatus(order, takingOrderStatus.id, takingOrderStatus.status);
                        dialogDismissListener.onDialogDismiss(order);
                        dismissAllowingStateLoss();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createOrderOnline(Order order) {

        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    progressBarDialog.show();
                });
            }
            myApp.shallWeRefreshOrders = false;
            AndroidNetworking.post(ApiEndPoints.orders)
                    .addApplicationJsonBody(order)
                    .addQueryParameter("print", myApp.myPreferences.getRemoteDeviceEnableStatus() ? "1" : "")
                    .build()
                    .getAsObject(Order.class, new ParsedRequestListener<Order>() {
                        @Override
                        public void onResponse(Order response) {
                            try {
                                //response.unique_id = order.unique_id;
                                response.customer._id = selectedCustomer._id;
                                response._id = order._id;
                                response._customer_id = selectedCustomer._id;
                                new Thread(() -> {
                                    // Update Customer
                                    changeTableStatus(order, takingOrderStatus.id, takingOrderStatus.status);
                                }).start();
                                Intent intent = new Intent();
                                intent.putExtra(Constants.SUCCESS_MESSAGE, "Added successfully");
                                LocalBroadcastManager.getInstance(getActivity()).sendBroadcast(intent);
                                // send success msg brodcast
                                new UpdateOrderWithOnline(response).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                sendBrodCast("\n[ID=> " + order._id + "]  " + anError.getErrorAsObject(ApiError.class).getMessage(), true);
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        progressBarDialog.dismiss();
                                        changeTableStatus(order, takingOrderStatus.id, takingOrderStatus.status);
                                        dialogDismissListener.onDialogDismiss(order);
                                        dismissAllowingStateLoss();
                                    });
                                }
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void sendBrodCast(String msg, Boolean isFromError) {
        // display order taken success message start
        Intent intent = new Intent(Constants.BOOK_TABLE_SUCCESS);
        intent.putExtra(Constants.SUCCESS_MESSAGE, msg);
        intent.putExtra(Constants.IS_FROM_ERROR, isFromError);
        //intent.putExtra(Constants._ORDER_ID, _order_id);
        LocalBroadcastManager.getInstance(getActivity()).sendBroadcast(intent);
        // display order taken success message end
    }

    private void changeTableStatus(Order order, String table_status_id, String status) {
        try {
            if (!order.order_type_id.equals("1")) {
                return;
            }

            new Thread(() -> {
                try {
                    Table table = appDatabase.tableDao().view(order.table_id);
                    // locked table only on auto mode no need to lock on manual mode as fetching table lock issue when anything accidentally happen like crash
                    table.locked = "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode());
                    table.table_status_id = table_status_id;
                    table.status = status;

                    appDatabase.tableDao().insert(table);
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class CustomersDbOperations extends AsyncTask<ArrayList<Customer>, Void, String> {

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected String doInBackground(ArrayList<Customer>... lists) {
            try {
                for (Customer customer : lists[0]) {
                    Customer dbCustomer = appDatabase.customerDao().view(customer.id);
                    if (dbCustomer == null) {
                        appDatabase.customerDao().insert(customer);
                    } else {
                        appDatabase.customerDao().update(customer);
                    }
                }
                if (getActivity() != null)
                    getActivity().runOnUiThread(() -> {
                        customers.clear();
                        customers.addAll(appDatabase.customerDao().listNoNull());
                    });
            } catch (Exception e) {
                e.printStackTrace();
            }

            return "Executed";
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        progressBarDialog.dismiss();
                        customerAutoSuggestAdapter.updateData(customers);
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class UpdateOrderWithOnline extends AsyncTask<String, String, String> {
        Order onlineorder;

        public UpdateOrderWithOnline(Order onlineorder) {
            this.onlineorder = onlineorder;
        }

        @Override
        protected String doInBackground(String... strings) {
            appDatabase.customerDao().update(onlineorder.customer);
            Order dbOrder = appDatabase.orderDao().view(order._id);
            // check record from the database if null insert else update
            if (dbOrder == null) {
                appDatabase.orderDao().insert(onlineorder);
            } else {
                appDatabase.orderDao().update(onlineorder);
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                myApp.shallWeRefreshOrders = true;
                dialogDismissListener.onDialogDismiss(onlineorder);
                dismissAllowingStateLoss();
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        progressBarDialog.dismiss();
                    });
                }
                // sendBrodCast("Order Taken Successfully", false);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    // changed by SP
    private void printFunction() {

    }
}