package com.ubsidi.epos_2021.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

import com.ubsidi.R;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;

public class NewHomeFragment extends BaseFragment {

    private LinearLayout llTable, llOrder;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_new_home, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        initViews(view);
    }

    private void initViews(View view) {
        llTable = view.findViewById(R.id.llTable);
        llOrder = view.findViewById(R.id.llOrderNewHome);

        try {
            llOrder.setVisibility(myApp.isNewOrderVisible() ? View.VISIBLE : View.GONE);
            FragmentManager manager = getChildFragmentManager();
            FragmentTransaction transaction = manager.beginTransaction();
            DineInFragment dineInFragment = getInstanceDineIn(true);
            dineInFragment.setDialogDismissListener(o -> {
                String data = (String) o;
                try {
                    if (data.equalsIgnoreCase("Expand")) {
                        ViewGroup.LayoutParams tableParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT, 1f);
                        llTable.setLayoutParams(tableParams);
                        ViewGroup.LayoutParams orderParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT, 1f);
                        llOrder.setLayoutParams(orderParams);
                    } else {
                        ViewGroup.LayoutParams params = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT, 0f);
                        llTable.setLayoutParams(params);
                        ViewGroup.LayoutParams orderParams = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT, 1f);
                        llOrder.setLayoutParams(orderParams);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            transaction.replace(R.id.flTable, dineInFragment);
            transaction.replace(R.id.flOrders, getInstanceOrdersAll(true));
            transaction.commit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OrdersAllFragment getInstanceOrdersAll(boolean fromTheme2) {
        OrdersAllFragment ordersAllFragment = new OrdersAllFragment();
        Bundle bundle = new Bundle();
        bundle.putBoolean("from_theme2", fromTheme2);
        ordersAllFragment.setArguments(bundle);
        return ordersAllFragment;
    }

    public DineInFragment getInstanceDineIn(boolean fromTheme2) {
        DineInFragment dineInFragment = new DineInFragment();
        Bundle bundle = new Bundle();
        bundle.putBoolean("show_title", fromTheme2);
        dineInFragment.setArguments(bundle);
        return dineInFragment;
    }

    @Override
    public void onResume() {
        super.onResume();
        myApp.isReservationOpen = false;
    }
}
