package com.ubsidi.epos_2021.fragment;

import android.location.Location;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.EditorInfo;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.DialogFragment;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.chip.Chip;
import com.google.android.material.textfield.MaterialAutoCompleteTextView;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.CustomerAutoSuggestAdapter;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.daos.AppDatabase;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.CallLogs;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderType;
import com.ubsidi.epos_2021.models.Postcode;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Amrish on 05-05-2021.
 */
public class NewOrderDialogFragment extends DialogFragment {
    private DialogDismissListener dialogDismissListener;
    private SiteSetting findlatitude, findLongitude, lookupSetting;
    private String orderTypeId;
    private MaterialButton btnConfirm, btnCancel;
    private TextView btnSearch;
    private RadioGroup rgOrderType;
    private RadioButton rbWaiting, rbCollection, rbDelivery, rbBar, rbReservation;
    private OrderType selectedOrderType;
    private LinearLayout llDeliveryFields;
    private AlertDialog progressBarDialog;
    private EditText etPostcode, etMobile, etEmail, etHouseNo, etStreet, etCity;
    private MaterialAutoCompleteTextView etName;
    private TextView tvTitle, tvDistance;
    private Chip chipBack;
    private Postcode searchedPostcode;
    private final ArrayList<Customer> customers = new ArrayList<>();
    private CustomerAutoSuggestAdapter customerAutoSuggestAdapter;
    private Customer selectedCustomer;
    private AppDatabase appDatabase;
    private final MyApp myApp = MyApp.getInstance();
    private String number, name;
    private LinearLayout llSecond;
    private float distance;
    private CallLogs callLogs;
    private CheckBox signupForNewsletter;

    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        if (getDialog() != null && getDialog().getWindow() != null) {
            Window window = getDialog().getWindow();
            window.setLayout(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        }
    }

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_new_order, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        // adjust plan when keyboard open for any field like edittext, checking null before adjust pan to prevent nullPointerException
        if (getDialog() != null && getDialog().getWindow() != null) {
            getDialog().getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_PAN);
        }
        super.onViewCreated(view, savedInstanceState);
        try {
            appDatabase = MyApp.getInstance().appDatabase;
            findLongitude = myApp.findSetting("address_longitude");
            findlatitude = myApp.findSetting("address_latitude");
            lookupSetting = myApp.findSetting("postcode_lookup_visible");
            if (getArguments() != null) {
                number = getArguments().getString("number");
                name = getArguments().getString("name");
                orderTypeId = getArguments().getString("order_type_id");
                callLogs = new Gson().fromJson(getArguments().getString("calllogs"), CallLogs.class);
                if (callLogs != null && callLogs.customer != null) {
                    selectedCustomer = callLogs.customer;
                }
            }

            initViews(view);
            updateView();
            setListeners();
            fetchCustomers();

            setUpOrderTypes();
        } catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
    }

    private void updateView() {
        try {
            if (selectedCustomer != null) {
                etName.setText(selectedCustomer.name);
                etMobile.setText(selectedCustomer.mobile);
                etEmail.setText(selectedCustomer.email);
                etPostcode.setText(selectedCustomer.postcode);
                etHouseNo.setText(selectedCustomer.house_no);
                etStreet.setText(selectedCustomer.street);
                etCity.setText(selectedCustomer.city);

                if (!Validators.isNullOrEmpty(selectedCustomer.distance)) {
                    distance = Float.parseFloat(selectedCustomer.distance);
                    tvDistance.setText("Distance: " + distance + " miles");
                } else {
                    tvDistance.setVisibility(View.GONE);
                }

                if (callLogs != null && callLogs.customer != null) {
                    CommonFunctions.hideKeyboard(getActivity(), etName);
                    etName.clearFocus();
                }
            }

            if (number != null) {
                etMobile.setText(number);
            }
            if (name != null) {
                etName.setText(name);
            }
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            //1 = Dine In, 2= Collection, 3 = Delivery, 4 = Bar, 5= Waiting, 6 Web Order
            rbCollection.setOnCheckedChangeListener((compoundButton, checked) -> {
                try {
                    if (checked) {
                        rbDelivery.setChecked(false);
                        rbWaiting.setChecked(false);
                        selectedOrderType = new OrderType("2", "Collection");
                        etMobile.setImeOptions(EditorInfo.IME_ACTION_DONE);
                        etEmail.setVisibility(View.GONE);
                        etMobile.setVisibility(View.VISIBLE);
                        llSecond.setVisibility(View.GONE);
                        llDeliveryFields.setVisibility(View.GONE);
                        tvDistance.setVisibility(View.GONE);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            rbWaiting.setOnCheckedChangeListener((compoundButton, checked) -> {
                try {
                    if (checked) {
                        rbCollection.setChecked(false);
                        rbDelivery.setChecked(false);
                        selectedOrderType = new OrderType("5", "Waiting");
                        etMobile.setImeOptions(EditorInfo.IME_ACTION_DONE);
                        etEmail.setVisibility(View.GONE);
                        etMobile.setVisibility(View.GONE);
                        llSecond.setVisibility(View.GONE);
                        llDeliveryFields.setVisibility(View.GONE);
                        tvDistance.setVisibility(View.GONE);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            rbDelivery.setOnCheckedChangeListener((compoundButton, checked) -> {
                try {
                    if (checked) {
                        rbCollection.setChecked(false);
                        rbWaiting.setChecked(false);
                        selectedOrderType = new OrderType("3", "Delivery");
                        etMobile.setImeOptions(EditorInfo.IME_ACTION_NEXT);
                        etEmail.setVisibility(View.GONE);
                        etMobile.setVisibility(View.VISIBLE);
                        llSecond.setVisibility(View.VISIBLE);
                        llDeliveryFields.setVisibility(View.VISIBLE);
                        tvDistance.setVisibility(View.GONE);

                        if (lookupSetting != null && lookupSetting.value.equalsIgnoreCase("yes")) {
                            btnSearch.setVisibility(View.VISIBLE);
                        } else {
                            btnSearch.setVisibility(View.GONE);
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            rbBar.setOnCheckedChangeListener((compoundButton, checked) -> {
                try {
                    if (checked) {
                        rbCollection.setChecked(false);
                        rbWaiting.setChecked(false);
                        selectedOrderType = new OrderType("4", "Bar");
                        etMobile.setImeOptions(EditorInfo.IME_ACTION_GO);
                        etEmail.setVisibility(View.GONE);
                        llSecond.setVisibility(View.GONE);
                        llDeliveryFields.setVisibility(View.GONE);
                        tvDistance.setVisibility(View.GONE);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            rbReservation.setOnCheckedChangeListener((compoundButton, checked) -> {
                try {
                    if (checked) {
                        if (dialogDismissListener != null) {
                            dialogDismissListener.onDialogDismiss(callLogs);
                            dismiss();
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            btnCancel.setOnClickListener(view -> {
                dismiss();
            });
            btnConfirm.setOnClickListener(view -> {
                try {
                    if (isValid()) {
                        btnConfirm.setEnabled(false);
                        createOrderOffline();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            btnSearch.setOnClickListener(view -> {
                try {
                    if (Validators.isNullOrEmpty(etPostcode.getText().toString())) {
                        etPostcode.setError("Please enter postcode");
                        etPostcode.requestFocus();
                    } else {
                        searchPostcode(etPostcode.getText().toString());
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            etName.setOnItemClickListener((adapterView, view, i, l) -> {
                try {
                    int indext = customers.indexOf(adapterView.getItemAtPosition(i));
                    if (indext != -1) {
                        selectedCustomer = customers.get(indext);
                        displayCustomerDetails(false);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

            });
            etName.setThreshold(3);

            chipBack.setOnClickListener(view -> {
                dismiss();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void displayCustomerDetails(boolean isRemoveFocus) {
        try {
            if (selectedCustomer != null) {

                try {
                    etName.setText(selectedCustomer.name);
                    etName.setSelection(etName.getText().toString().length());
                    etMobile.setText(selectedCustomer.mobile);
                    etMobile.setSelection(etMobile.getText().toString().length());
                    etEmail.setText(selectedCustomer.email);
                    etEmail.setSelection(etEmail.getText().toString().length());
                    etPostcode.setText(selectedCustomer.postcode);
                    etPostcode.setSelection(etPostcode.getText().toString().length());
                    etStreet.setText(selectedCustomer.street);
                    etStreet.setSelection(etStreet.getText().toString().length());
                    etCity.setText(selectedCustomer.city);
                    etCity.setSelection(etCity.getText().toString().length());
                    etHouseNo.setText(selectedCustomer.house_no);
                    etHouseNo.setSelection(etHouseNo.getText().toString().length());
                    if (!Validators.isNullOrEmpty(selectedCustomer.distance)) {
                        distance = Float.parseFloat(selectedCustomer.distance);
                        if (orderTypeId != null && orderTypeId.equalsIgnoreCase("3")) {
                            tvDistance.setVisibility(View.VISIBLE);
                        }
                        tvDistance.setText(distance + " Miles Away");
                    } else {
                        tvDistance.setVisibility(View.GONE);
                    }
                    new Thread(() -> {
                        try {
                            if (selectedCustomer._id == 0 && !Validators.isNullOrEmpty(selectedCustomer.id)) {
                                selectedCustomer._id = (int) appDatabase.customerDao().insert(selectedCustomer);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }).start();

                    if (isRemoveFocus) {
                        CommonFunctions.hideKeyboard(getActivity(), etName);
                        etName.clearFocus();
                        LogUtils.e("Clear focus");
                    }
                } catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private void hideKeyBoard() {

    }

    private boolean isValid() {
        try {
            if (selectedOrderType == null) {
                ToastUtils.makeLongToast(getActivity(), "No order type selected");
                return false;
            }

            if (selectedOrderType.id.equalsIgnoreCase("3")) {
                if (Validators.isNullOrEmpty(etName.getText().toString())) {
                    etName.setError("Please enter customer name");
                    etName.requestFocus();
                    return false;
                }

                if (Validators.isNullOrEmpty(etMobile.getText().toString())) {
                    etMobile.setError("Please enter mobile number");
                    etMobile.requestFocus();
                    return false;
                }
                if (Validators.isNullOrEmpty(etPostcode.getText().toString())) {
                    etPostcode.setError("Please lookup postcode");
                    etPostcode.requestFocus();
                    return false;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void initViews(View view) {
        try {
            progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
            btnCancel = view.findViewById(R.id.btnCancel);
            btnConfirm = view.findViewById(R.id.btnConfirm);
            tvTitle = view.findViewById(R.id.tvTitle);

            rgOrderType = view.findViewById(R.id.rgOrderType);
            rbDelivery = view.findViewById(R.id.rbDelivery);
            rbCollection = view.findViewById(R.id.rbCollection);
            rbWaiting = view.findViewById(R.id.rbWaiting);
            rbBar = view.findViewById(R.id.rbBar);
            rbReservation = view.findViewById(R.id.rbReservation);
            etEmail = view.findViewById(R.id.etEmail);
            etMobile = view.findViewById(R.id.etPhone);
            etName = view.findViewById(R.id.etName);
            etPostcode = view.findViewById(R.id.etPostcode);
            etHouseNo = view.findViewById(R.id.etHouse);
            etCity = view.findViewById(R.id.etTown);
            etStreet = view.findViewById(R.id.etStreet);
            llDeliveryFields = view.findViewById(R.id.llDeliveryFields1);
            btnSearch = view.findViewById(R.id.btnSearch);
            llSecond = view.findViewById(R.id.llSecond);
            chipBack = view.findViewById(R.id.chipBack);
            tvDistance = view.findViewById(R.id.tvDistance);

            signupForNewsletter = view.findViewById(R.id.signupForNewsletter);
            btnConfirm.setEnabled(true);
            getOfflineCustomer();

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setUpOrderTypes() {
        //1 = Dine In, 2= Collection, 3 = Delivery, 4 = Bar, 5= Waiting, 6 Web Order
        try {
            rbBar.setVisibility(View.GONE);

            SiteSetting collectionSetting = myApp.findSetting("is_collection");
            SiteSetting deliverySetting = myApp.findSetting("is_delivery");
            SiteSetting reservationSetting = myApp.findSetting("is_reservation");
            if (collectionSetting != null && (collectionSetting.value.equals("false") || collectionSetting.value.equals("0")) && (MyApp.userPermission != null && MyApp.userPermission.collection.actions.list)) {
                rbCollection.setVisibility(View.GONE);
            }
            if (deliverySetting != null && (deliverySetting.value.equals("false") || deliverySetting.value.equals("0")) && (MyApp.userPermission != null && MyApp.userPermission.delivery.actions.list)) {
                rbDelivery.setVisibility(View.GONE);
            }
            if (collectionSetting != null && (collectionSetting.value.equals("false") || collectionSetting.value.equals("0")) && (MyApp.userPermission != null && MyApp.userPermission.waiting.actions.list)) {
                rbWaiting.setVisibility(View.GONE);
            }


            if (callLogs != null && reservationSetting != null && (reservationSetting.value.equals("true") || reservationSetting.value.equals("1")) && MyApp.userPermission != null && MyApp.userPermission.reservation.actions.list) {
                rbReservation.setVisibility(View.VISIBLE);
            }

            if (rbCollection.getVisibility() == View.VISIBLE) {
                rbCollection.setChecked(true);
            } else if (rbDelivery.getVisibility() == View.VISIBLE) {
                rbDelivery.setChecked(true);
            } else if (rbWaiting.getVisibility() == View.VISIBLE) {
                rbWaiting.setChecked(true);
            } else if (rbBar.getVisibility() == View.VISIBLE) {
                rbBar.setChecked(true);
            }
            if (!Validators.isNullOrEmpty(orderTypeId)) {
                rgOrderType.setVisibility(View.GONE);
                if (orderTypeId.equalsIgnoreCase("2")) {
                    rbCollection.setChecked(true);
                    tvTitle.setText("New Collection Order");
                } else if (orderTypeId.equalsIgnoreCase("3")) {
                    rbDelivery.setChecked(true);
                    tvTitle.setText("New Delivery Order");
                } else if (orderTypeId.equalsIgnoreCase("5")) {
                    rbWaiting.setChecked(true);
                    tvTitle.setText("New Waiting Order");
                } else {
                    rgOrderType.setVisibility(View.VISIBLE);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void searchPostcode(String postcode) {
        try {
            if (!myApp.isConnected(getActivity())) {
                ToastUtils.makeSnackToast(getActivity(), "No internet connection");
                return;
            }
            progressBarDialog.show();
            progressBarDialog.getWindow().setDimAmount(0.4f);
            AndroidNetworking.get(ApiEndPoints.postcode + postcode)
                    .build()
                    .getAsObject(Postcode.class, new ParsedRequestListener<Postcode>() {
                        @Override
                        public void onResponse(Postcode response) {
                            try {
                                progressBarDialog.dismiss();
                                searchedPostcode = response;
                                etCity.setText(searchedPostcode.post_town);
                                etStreet.setText(searchedPostcode.street);
                                CommonFunctions.hideKeyboard(getActivity(), etPostcode);
                                calculateDistance(searchedPostcode.latitude, searchedPostcode.longitude);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressBarDialog.dismiss();
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                }
                                if (!myApp.isConnected(getActivity())) {
                                    ToastUtils.makeSnackToast(getActivity(), "No internet connection");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void calculateDistance(String latitude, String longitude) {
        try {
            if (!Validators.isNullOrEmpty(findlatitude.value) && !Validators.isNullOrEmpty(findLongitude.value) && !Validators.isNullOrEmpty(latitude) && !Validators.isNullOrEmpty(longitude)) {
                Location locationRestaurant = new Location("Restaurant Location");
                locationRestaurant.setLongitude(Double.parseDouble(findLongitude.value));
                locationRestaurant.setLatitude(Double.parseDouble(findlatitude.value));

                Location locationUser = new Location("User Location");
                locationUser.setLongitude(Double.parseDouble(longitude));
                locationUser.setLatitude(Double.parseDouble(latitude));

                float d = locationRestaurant.distanceTo(locationUser) * 0.000621371f;
                distance = Float.parseFloat(MyApp.df.format(d));
                tvDistance.setVisibility(View.VISIBLE);
                tvDistance.setText(distance + " Miles Away");
            }
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private void fetchCustomers() {
        try {
            new CustomersDbOperations().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, customers);
            /*if (MyApp.getInstance().isConnected(getActivity()) && "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode())) {
                fetchOnlineCustomers();
            } else {
                new CustomersDbOperations().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, customers);
            }*/
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchOnlineCustomers() {
        try {
            LogUtils.e("Fethcing customers");
            AndroidNetworking.get(ApiEndPoints.customers)
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsObjectList(Customer.class, new ParsedRequestListener<List<Customer>>() {

                        @Override
                        public void onResponse(List<Customer> response) {
                            try {
                                LogUtils.e("Customer response: " + response.size());
                                //  customerAutoSuggestAdapter.updateData(response);
                                new CustomersDbOperations().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (ArrayList<Customer>) response);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                }
                                new CustomersDbOperations().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, customers);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createOrderOffline() {
        try {
            CommonFunctions.hideKeyboard(getActivity(), etPostcode);
            Order order = new Order();
            Customer customer;
            if (selectedCustomer != null) {
                customer = selectedCustomer;
            } else {
                customer = new Customer();
            }


            //1->true , 0->false
            if (signupForNewsletter.isChecked())
                customer.news_letter = true;
            else
                customer.news_letter = false;


            customer.name = etName.getText().toString();
            customer.mobile = etMobile.getText().toString();
            customer.email = etEmail.getText().toString();
            customer.house_no = etHouseNo.getText().toString();
            if (rbDelivery.isChecked()) {
                customer.distance = MyApp.df.format(distance);
                customer.house_no = etHouseNo.getText().toString();
                customer.postcode = etPostcode.getText().toString();
                customer.street = etStreet.getText().toString();
                customer.city = etCity.getText().toString();
                if (searchedPostcode != null)
                    customer.state = searchedPostcode.dependent_locality;
                customer.country = "United Kingdom";
            }
            //Add By SP
            if (MyApp.getInstance().myPreferences.getRemoteDeviceEnableStatus()) {
                order.print_id = 1;
            } else {
                order.print_id = 0;
            }
            //Toast.makeText(getActivity(), "print_id:"+order.print_id, Toast.LENGTH_SHORT).show();
            order.customer_id = customer.id;
            order.customer = customer;
            order.updater_id = MyApp.getInstance().myPreferences.getLoggedInUser().id;
            order.order_status_id = "1";
            order.order_status = "Taking Order";
            order.order_type_id = selectedOrderType.id;
            order.order_items = new ArrayList<>();
            order.device_id = MyApp.getInstance().myPreferences.getRegisteredDevice().id;
            order.created_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
            order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
            order.delivery_date = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
            new Thread(() -> {
                // Update Customer
                selectedCustomer = customer;
                if (customer._id > 0) {
                    appDatabase.customerDao().update(customer);
                } else {
                    customer._id = (int) appDatabase.customerDao().insert(customer);
                }
                order._customer_id = customer._id;
                order.customer_name = customer.name;
                long tsLong = System.currentTimeMillis() / 1000;
                order.unique_id = tsLong + MyApp.getInstance().myPreferences.getBusinessId() + MyApp.getInstance().myPreferences.getRegisteredDevice().id;
                // Save Order
                order._id = (int) MyApp.getInstance().appDatabase.orderDao().insert(order);
                String userPrefix = myApp.myPreferences.getLoggedInUser().preffix;
                if(!Validators.isNullOrEmpty(userPrefix)){
                    String prefix = userPrefix+order._id;
                    order.display_order_id = prefix;
                    myApp.appDatabase.orderDao().updateDisplayOrderId(order._id,prefix);
                }
                // removing creating order API
                //if (MyApp.getInstance().isConnected(getActivity()) && "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode())) {
                //    createOrderOnline(order);
                //  } else {
                dialogDismissListener.onDialogDismiss(order);
                dismiss();
                //  }

            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createOrderOnline(Order order) {

        try {
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    progressBarDialog.show();
                });
            }
            myApp.shallWeRefreshOrders = false;
            AndroidNetworking.post(ApiEndPoints.orders)
                    .addApplicationJsonBody(order)
                    .addQueryParameter("print", myApp.myPreferences.getRemoteDeviceEnableStatus() ? "1" : "")
                    .build()
                    .getAsObject(Order.class, new ParsedRequestListener<Order>() {
                        @Override
                        public void onResponse(Order response) {
                            try {
                                response.customer._id = selectedCustomer._id;
                                response._id = order._id;
                                response._customer_id = selectedCustomer._id;
                                new UpdateOrderWithOnline(response).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        progressBarDialog.dismiss();
                                        dialogDismissListener.onDialogDismiss(order);
                                        dismiss();
                                    });
                                }
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void getOfflineCustomer() {
        new Thread(() -> {
            try {
                if (!customers.isEmpty()) {
                    customers.clear();
                }
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        customers.addAll(appDatabase.customerDao().listNoNull());
                        LogUtils.e("New order getOfflineCustomer " + customers.size());
                        customerAutoSuggestAdapter = new CustomerAutoSuggestAdapter(getActivity(), customers);
                        etName.setAdapter(customerAutoSuggestAdapter);
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    private class CustomersDbOperations extends AsyncTask<ArrayList<Customer>, Void, String> {

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected String doInBackground(ArrayList<Customer>... lists) {
            try {
                LogUtils.e("Customers Saving in BG ");
                for (Customer customer : lists[0]) {
                    Customer dbCustomer = appDatabase.customerDao().view(customer.id);
                    if (dbCustomer == null) {
                        appDatabase.customerDao().insert(customer);
                    } else {
                        appDatabase.customerDao().update(customer);
                    }
                }
                if (getActivity() != null)
                    getActivity().runOnUiThread(() -> {
                        customers.clear();
                        customers.addAll(appDatabase.customerDao().listNoNull());
                    });

                if (callLogs != null) {
                    if (callLogs.customer != null) {
                        selectedCustomer = appDatabase.customerDao().view(callLogs.customer._id);
                    } else if (!Validators.isNullOrEmpty(callLogs.customer_id)) {
                        selectedCustomer = appDatabase.customerDao().view(callLogs.customer_id);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return "Executed";
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                LogUtils.e("Customers Saved in BG ");
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        progressBarDialog.dismiss();
                        if (callLogs != null && callLogs.customer != null) {
                            displayCustomerDetails(true);
                        } else {
                            displayCustomerDetails(false);
                        }
                        customerAutoSuggestAdapter.updateData(customers);
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class UpdateOrderWithOnline extends AsyncTask<String, String, String> {
        Order onlineorder;

        public UpdateOrderWithOnline(Order onlineorder) {
            this.onlineorder = onlineorder;
        }

        @Override
        protected String doInBackground(String... strings) {
            appDatabase.customerDao().update(onlineorder.customer);
            appDatabase.orderDao().insert(onlineorder);
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                myApp.shallWeRefreshOrders = true;
                dialogDismissListener.onDialogDismiss(onlineorder);
                dismiss();
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        progressBarDialog.dismiss();
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}
