package com.ubsidi.epos_2021.fragment;


import android.bluetooth.BluetoothDevice;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.Spinner;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.chip.Chip;
import com.google.android.material.textfield.MaterialAutoCompleteTextView;
import com.google.gson.Gson;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.CustomerAutoSuggestAdapter;
import com.ubsidi.epos_2021.adapters.ReservationDepositAdapter;
import com.ubsidi.epos_2021.adapters.ReservationTypeAdapter;
import com.ubsidi.epos_2021.adapters.ReservationsMiniAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.MoneyTextWatcher;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.comman.bluetoothprinter.BluetoothPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinterV3Mix;
import com.ubsidi.epos_2021.comman.printer.WifiPrinter;
import com.ubsidi.epos_2021.comman.printer.ZoneRichPrinter;
import com.ubsidi.epos_2021.daos.relations.ReservationWithCustomer;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.CallLogs;
import com.ubsidi.epos_2021.models.Customer;
import com.ubsidi.epos_2021.models.DepositType;
import com.ubsidi.epos_2021.models.Printer;
import com.ubsidi.epos_2021.models.Reservation;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.Table;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;
import com.wdullaer.materialdatetimepicker.date.DatePickerDialog;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;

public class NewReservationFragment extends BaseFragment {

    private Chip chipBack;
    private Spinner spDiposit;
    private ImageView ivMinus, ivPlus;
    private EditText etName, etMobileNumber, etEmailAddress, etSelectDate, etSelectTime, etAssignTable, etDepositAmount, etSpecialInstruction;
    private MaterialButton btnCancel, btnSavePrint, btnSave;
    private MaterialAutoCompleteTextView etSearchCustomer;
    private TextView tvQuantity, tvToayDate, tvErrorMessage;
    private RecyclerView rvReservationList;
    private Calendar myCalendar = Calendar.getInstance();
    private Date reservationDate;
    private ArrayList<DepositType> reservationDepositList = new ArrayList<>();
    private DepositType depositType;
    private ReservationDepositAdapter reservationDepositAdapter;
    private int quantity = 1;
    private Customer selectedCustomer;
    private ArrayList<Customer> customers = new ArrayList<>();
    private CustomerAutoSuggestAdapter customerAutoSuggestAdapter;
    private AlertDialog progressBarDialog;
    private Table table;
    private ZoneRichPrinter zoneRichPrinter;
    private WifiPrinter wifiPrinter;
    private SunmiPrinter sunmiPrinter;
    private SunmiPrinterV3Mix sunmiPrinterV3Mix;
    public BluetoothPrinter bluetoothPrinter;
    private Printer defaultPrinter;
    private int headerAlignment = 0;
    private SiteSetting ticketHeaderSetting;
    private SiteSetting footerASetting;
    private SiteSetting footerBSetting;
    private ReservationsMiniAdapter reservationsMiniAdapter;
    private ArrayList<Reservation> reservationsToday = new ArrayList<>();
    private boolean openAutoNext = false;
    private CallLogs callLogs;
    private ImageView ivDeposit;

    private Reservation reservation;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_new_reservation, container, false);
    }

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getArguments() != null) {
            reservation = new Gson().fromJson(getArguments().getString("reservation"), Reservation.class);
            callLogs = new Gson().fromJson(getArguments().getString("calllogs"), CallLogs.class);
        }
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initView(view);
            setListeners();
            fetchCustomers();
            updateView();
            fetchTodayReservations(CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"), CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initView(View view) {
        try {
            loadSettings();
            defaultPrinter = myPreferences.getDefaultPrinter();
            progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
            zoneRichPrinter = new ZoneRichPrinter(getActivity());
            zoneRichPrinter = myApp.connectZonerich(zoneRichPrinter, defaultPrinter);
            wifiPrinter = WifiPrinter.getInstance();
            bluetoothPrinter = new BluetoothPrinter(getActivity());
            sunmiPrinter = new SunmiPrinter(getActivity());
            if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                sunmiPrinterV3Mix = new SunmiPrinterV3Mix(requireActivity());
            }
            chipBack = view.findViewById(R.id.chipBack);
            spDiposit = view.findViewById(R.id.spDiposit);
            ivDeposit = view.findViewById(R.id.ivDeposit);
            rvReservationList = view.findViewById(R.id.rvReservationList);
            tvToayDate = view.findViewById(R.id.tvTodayDate);
            etSpecialInstruction = view.findViewById(R.id.etSpecialInstruction);
            etDepositAmount = view.findViewById(R.id.etDepositAmount);
            etAssignTable = view.findViewById(R.id.etAssignTable);
            ivPlus = view.findViewById(R.id.ivPlus);
            tvQuantity = view.findViewById(R.id.tvQuantity);
            ivMinus = view.findViewById(R.id.ivMinus);
            etSelectTime = view.findViewById(R.id.etSelectTime);
            etSelectDate = view.findViewById(R.id.etSelectDate);
            etEmailAddress = view.findViewById(R.id.etEmailAddress);
            etMobileNumber = view.findViewById(R.id.etContectNumber);
            etName = view.findViewById(R.id.etName);
            etSearchCustomer = view.findViewById(R.id.etSearchCustomer);
            btnSave = view.findViewById(R.id.btnSave);
            btnSavePrint = view.findViewById(R.id.btnSavePrint);
            btnCancel = view.findViewById(R.id.btnCancel);
            tvErrorMessage = view.findViewById(R.id.tvErrorMessage);
            etSearchCustomer.setThreshold(3);
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy", Locale.US);
                tvToayDate.setText("on " + sdf.format(myCalendar.getTime()));
            } catch (Exception e) {
                e.printStackTrace();
            }

            getOfflineCustomer();

            reservationsMiniAdapter = new ReservationsMiniAdapter(reservationsToday, (position, tag, data) -> {

            });
            rvReservationList.setAdapter(reservationsMiniAdapter);
            rvReservationList.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));

            reservationDepositList.clear();
            reservationDepositList.addAll(myPreferences.getDepositTypes());
            reservationDepositAdapter = new ReservationDepositAdapter(getActivity(), android.R.layout.simple_list_item_1, reservationDepositList);
            spDiposit.setAdapter(reservationDepositAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getOfflineCustomer() {
        new Thread(() -> {
            try {
                if (!customers.isEmpty()) {
                    customers.clear();
                }

                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        customers.addAll(appDatabase.customerDao().listNoNull());
                        LogUtils.e("Reservation getOfflineCustomer " + customers.size());
                        customerAutoSuggestAdapter = new CustomerAutoSuggestAdapter(getActivity(), customers);
                        etSearchCustomer.setAdapter(customerAutoSuggestAdapter);
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }


    int depositIndex = 0;

    private void updateView() {
        try {
            if (reservation != null) {
                selectedCustomer = reservation.customer;
                reservationDate = CommonFunctions.convertToDate(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT);
                etSelectTime.setText(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT, "HH:mm"));
                etSelectDate.setText(CommonFunctions.formatUnknownDateTime(reservation.reservation_date_time, Constants.PHP_DATE_TIME_FORMAT, "yyyy-MM-dd"));
                tvQuantity.setText(reservation.diners + "");
                quantity = reservation.diners;
                etAssignTable.setText(reservation.table_number);
                etSpecialInstruction.setText(reservation.special_instruction);
                etDepositAmount.setText(MyApp.df.format(reservation.deposit_amount));
                depositIndex = 0;
                for (DepositType type : reservationDepositList) {
                    if (type.id.equalsIgnoreCase(reservation.deposit_type_id)) {
                        if (spDiposit.getCount() > 0)
                            spDiposit.setSelection(depositIndex);
                        depositType = type;
                        break;
                    }
                    depositIndex++;
                }
                if (!Validators.isNullOrEmpty(reservation.table_id)) {
                    table = new Table();
                    table.id = reservation.table_id;
                    table.number = reservation.table_number;
                }
                int customerIndex = 0;
                for (Customer customer : customers) {
                    if (!Validators.isNullOrEmpty(customer.id) && customer.id.equalsIgnoreCase(reservation.customer.id)) {
                        try {
                            etSearchCustomer.setSelection(customerIndex);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    customerIndex++;
                }
            }
            if (callLogs != null) {
                if (callLogs.customer != null)
                    selectedCustomer = callLogs.customer;
                else {
                    etMobileNumber.setText(callLogs.number);
                }
            }
            if (selectedCustomer != null) {
                etName.setText(selectedCustomer.name);
                etMobileNumber.setText(selectedCustomer.mobile);
                etEmailAddress.setText(selectedCustomer.email);

                if (callLogs != null && callLogs.customer != null) {
                    CommonFunctions.hideKeyboard(getActivity(), etSearchCustomer);
                    etSearchCustomer.clearFocus();
                    etName.clearFocus();
                    LogUtils.e("Clear focus");
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }


    }


    private void setListeners() {
        try {
            etDepositAmount.addTextChangedListener(new MoneyTextWatcher(etDepositAmount));

            chipBack.setOnClickListener(v -> goBack());

            btnCancel.setOnClickListener(v -> goBack());

            btnSave.setOnClickListener(v -> {
                if (isValid()) addReservation(false);
            });

            btnSavePrint.setOnClickListener(v -> {
                if (isValid()) addReservation(true);
            });

            etSearchCustomer.setOnItemClickListener((adapterView, view, i, l) -> {
                try {
                    Object object = adapterView.getItemAtPosition(i);
                    if (object instanceof Customer) {
                        selectedCustomer = (Customer) adapterView.getItemAtPosition(i);
                        if (selectedCustomer != null) {
                            etName.setText(selectedCustomer.name);
                            etMobileNumber.setText(selectedCustomer.mobile);
                            etEmailAddress.setText(selectedCustomer.email);
                            new Thread(() -> {
                                if (selectedCustomer._id == 0 && !Validators.isNullOrEmpty(selectedCustomer.id)) {
                                    selectedCustomer._id = (int) appDatabase.customerDao().insert(selectedCustomer);
                                }
                            }).start();
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

            });

            DatePickerDialog.OnDateSetListener datePicker = new DatePickerDialog.OnDateSetListener() {
                @Override
                public void onDateSet(DatePickerDialog view, int year, int month, int dayOfMonth) {
                    try {
                        myCalendar.set(Calendar.YEAR, year);
                        myCalendar.set(Calendar.MONTH, month);
                        myCalendar.set(Calendar.DAY_OF_MONTH, dayOfMonth);
                        reservationDate = myCalendar.getTime();
                        tvToayDate.setText("on " + CommonFunctions.convertMsToDesiredFormat(myCalendar.getTimeInMillis(), "dd/MM/yyyy"));
                        fetchTodayReservations(CommonFunctions.convertMsToDesiredFormat(myCalendar.getTimeInMillis(), "yyyy-MM-dd"), CommonFunctions.convertMsToDesiredFormat(myCalendar.getTimeInMillis(), "yyyy-MM-dd"));
                        updateLabel();
                        if (openAutoNext) {
                            etSelectTime.performClick();
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };

            etSelectDate.setOnClickListener(v -> {
                try {
                    if (reservationDate != null)
                        myCalendar.setTime(reservationDate);
                    DatePickerDialog datePickerDialog = DatePickerDialog.newInstance(datePicker, myCalendar
                                    .get(Calendar.YEAR), myCalendar.get(Calendar.MONTH),
                            myCalendar.get(Calendar.DAY_OF_MONTH));
                    // datePickerDialog.setMinDate(myCalendar);
                    datePickerDialog.setThemeDark(false);
                    datePickerDialog.showYearPickerFirst(false);

                    datePickerDialog.setOnCancelListener(dialogInterface -> {
                    });

                    datePickerDialog.show(getActivity().getFragmentManager(), "DatePickerDialog");
                } catch (Exception e) {
                    e.printStackTrace();
                }

            });

            etSelectTime.setOnClickListener(v -> {
                try {
                    if (reservationDate == null) {
                        openAutoNext = true;
                        etSelectDate.performClick();
                    } else {
                        openAutoNext = false;
                        ReservationTimeSelectionFragment reservationTimeSelectionFragment = getInstanceReservationTimeSelection(etSelectTime.getText().toString());
                        reservationTimeSelectionFragment.show(getChildFragmentManager(), "time_picker");
                        reservationTimeSelectionFragment.setDialogDismissListener(o -> {
                            if (o instanceof String) {
                                etSelectTime.setText((String) o);
                            }
                        });
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });


            ivDeposit.setOnClickListener(view -> spDiposit.performClick());
            spDiposit.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
                @Override
                public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                    depositType = reservationDepositAdapter.getItem(position);
                }

                @Override
                public void onNothingSelected(AdapterView<?> parent) {

                }
            });

            ivPlus.setOnClickListener(view -> {
                quantity++;
                tvQuantity.setText("" + quantity);
            });

            ivMinus.setOnClickListener(view -> {
                if (quantity > 1) {
                    quantity--;
                    tvQuantity.setText("" + quantity);
                }
            });

            etAssignTable.setOnClickListener(v -> {
                try {
                    AssignTableDialogFragment assignTableDialogFragment = new AssignTableDialogFragment();
                    assignTableDialogFragment.show(getChildFragmentManager(), "assign_table");
                    assignTableDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof Table) {
                            table = (Table) o;
                            etAssignTable.setText(table.number);
                        }
                    });
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public ReservationTimeSelectionFragment getInstanceReservationTimeSelection(String selectedTimeSlot) {
        ReservationTimeSelectionFragment reservationTimeSelectionFragment = new ReservationTimeSelectionFragment();
        Bundle bundle = new Bundle();
        bundle.putString("selected_time", selectedTimeSlot);
        reservationTimeSelectionFragment.setArguments(bundle);
        return reservationTimeSelectionFragment;
    }

    private boolean isValid() {
        if (Validators.isNullOrEmpty(etName.getText().toString())) {
            ToastUtils.makeSnackToast(getActivity(), "Please enter name");
            return false;
        }
        if (Validators.isNullOrEmpty(etMobileNumber.getText().toString())) {
            ToastUtils.makeSnackToast(getActivity(), "Please enter contact number");
            return false;
        }
        if (Validators.isNullOrEmpty(etSelectDate.getText().toString())) {
            ToastUtils.makeSnackToast(getActivity(), "Please select reservation date");
            return false;
        }
        if (Validators.isNullOrEmpty(etSelectDate.getText().toString())) {
            ToastUtils.makeSnackToast(getActivity(), "Please select reservation date");
            return false;
        }
        if (Validators.isNullOrEmpty(etSelectTime.getText().toString())) {
            ToastUtils.makeSnackToast(getActivity(), "Please select reservation time");
            return false;
        }
        return true;
    }

    private void loadSettings() {
        try {
            SiteSetting ticketHeaderTypeSetting = myApp.findSetting("ticket_header_type");
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("right")) {
                headerAlignment = 2;
            }
            if (ticketHeaderTypeSetting != null && ticketHeaderTypeSetting.value.equalsIgnoreCase("center")) {
                headerAlignment = 1;
            }
            ticketHeaderSetting = myApp.findSetting("ticket_header");

            footerASetting = myApp.findSetting("footer_a");
            footerBSetting = myApp.findSetting("footer_b");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void updateLabel() {
        try {
            String myFormat = "yyyy-MM-dd"; //In which you need put here
            SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.US);

            etSelectDate.setText(sdf.format(myCalendar.getTime()));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchTodayReservations(String fromDate, String toDate) {
        try {
            tvErrorMessage.setVisibility(View.GONE);
            new DatedReservationsAsync(fromDate, toDate).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class DatedReservationsAsync extends AsyncTask<List<Reservation>, String, String> {
        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        String fromDate, toDate;

        public DatedReservationsAsync(String fromDate, String toDate) {
            this.fromDate = fromDate;
            this.toDate = toDate;
        }

        @Override
        protected String doInBackground(List<Reservation>... lists) {

            try {
                reservationsToday.clear();
                ArrayList<ReservationWithCustomer> reservationWithCustomers = new ArrayList<>();
                if (Validators.isNullOrEmpty(fromDate)) {
                    reservationWithCustomers.addAll(appDatabase.reservationDao().listWithCustomer());
                } else {
                    reservationWithCustomers.addAll(appDatabase.reservationDao().historyListWithCustomer(fromDate, toDate));
                }
                for (ReservationWithCustomer reservationWithCustomer : reservationWithCustomers) {
                    Reservation reservation = reservationWithCustomer.reservation;
                    reservation.customer = reservationWithCustomer.customer;
                    reservationsToday.add(reservation);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        try {
                            reservationsMiniAdapter.notifyDataSetChanged();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void fetchCustomers() {
        try {
            if (MyApp.getInstance().isConnected(getActivity()) && "auto".equalsIgnoreCase(myApp.myPreferences.getOrderSyncMode())) {
                fetchOnlineCustomers();
            } else {
                new CustomersSaveAndGet().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, customers);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchOnlineCustomers() {
        try {
            if (!myApp.isConnected(getActivity())) {
                new CustomersSaveAndGet().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new ArrayList<>());
                return;
            }
            AndroidNetworking.get(ApiEndPoints.customers)
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsObjectList(Customer.class, new ParsedRequestListener<List<Customer>>() {

                        @Override
                        public void onResponse(List<Customer> response) {
                            try {
                                //  customerAutoSuggestAdapter.updateData(response);
                                new CustomersSaveAndGet().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (ArrayList<Customer>) response);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                new CustomersSaveAndGet().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, customers);
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void addReservation(boolean print) {
        try {
            btnSave.setEnabled(false);
            btnSavePrint.setEnabled(false);
            if (reservation == null) {
                reservation = new Reservation();
            } else {
                new Thread(() -> {
                    reservation.id = appDatabase.reservationDao().view(reservation._id).id;
                }).start();
            }

            if (selectedCustomer == null) {
                reservation.customer = new Customer();
            } else {
                reservation.customer = selectedCustomer;
                reservation.customer_id = selectedCustomer.id;
                reservation._customer_id = selectedCustomer._id;
            }
            reservation.customer.name = etName.getText().toString();
            reservation.customer.mobile = etMobileNumber.getText().toString();
            reservation.telephone = reservation.customer.mobile;
            reservation.updater_id = myPreferences.getLoggedInUser().id;
            reservation.reservation_status_id = "1";
            reservation.reservation_status = "Confirm";

            if (!etEmailAddress.getText().toString().equalsIgnoreCase(""))
                reservation.customer.email = etEmailAddress.getText().toString();

            reservation.customer_name = reservation.customer.name;
            reservation.diners = quantity;
            if (!Validators.isNullOrEmpty(etDepositAmount.getText().toString()))
                reservation.deposit_amount = Float.parseFloat(etDepositAmount.getText().toString().replaceAll("[£,]", ""));

            reservation.special_instruction = etSpecialInstruction.getText().toString();

            if (table != null) {
                reservation.table_number = table.number;
                reservation.table_id = table.id;
            } else {
                reservation.table_number = null;
                reservation.table_id = null;
            }

            if (depositType != null) {
                reservation.deposit_type_id = depositType.id;
                reservation.deposit_type = depositType.type;
            }

            reservation.reservation_date_time = etSelectDate.getText().toString() + " " + etSelectTime.getText().toString() + ":00";
            reservation.uploadable = true;
            if (Validators.isNullOrEmpty(reservation.created_at))
                reservation.created_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU_SHORT);

            new SaveReservation(() -> {
                try {
                    if (myApp.isConnected(getActivity())) {
                        uploadReservation(reservation, print);
                    } else {
                        if (print && getActivity() != null) {
                            getActivity().runOnUiThread(() -> {
                                if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                                    if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h") || defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                                        if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                                            zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                                            zoneRichPrinter.printReservation(myApp.businessLogo, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                        } else {
                                            try {
                                                if (bluetoothPrinter != null) {
                                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                                    if (device != null) {
                                                        bluetoothPrinter.printReservation(myApp.businessLogo, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "");
                                                    } else {
                                                        ToastUtils.makeSnackToast(getActivity(), "No bluetooth device found.");
                                                    }
                                                }
                                            } catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    } else if (defaultPrinter.printer_model_name.toLowerCase().contains("sunmi") || defaultPrinter.printer_model_name.toLowerCase().contains("t2")) {
                                        if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                                            sunmiPrinterV3Mix.printReservation(myApp.businessLogo, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                        }else {
                                            sunmiPrinter.printReservation(myApp.businessLogo, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                        }
                                    } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                                        if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                                            myApp.iMinPrinterUtils.printReservation(reservation, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", myApp.tiffintomLogoSmall);
                                        } else {
                                            if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                                                wifiPrinter.connect(defaultPrinter.ip);
                                                CommonFunctions.functionThatDelay(200);
                                                wifiPrinter.printReservation(myApp.businessLogo, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                            } else {
                                                try {
                                                    if (bluetoothPrinter != null) {
                                                        BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                                        if (device != null) {
                                                            bluetoothPrinter.printReservation(myApp.businessLogo, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "");
                                                        } else {
                                                            ToastUtils.makeSnackToast(getActivity(), "No bluetooth device found.");
                                                        }
                                                    }
                                                } catch (Exception e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                        }

                                    }
                                } else {
                                    ToastUtils.makeLongToast(getActivity(), "No printer model found");
                                }

                            });
                        }
                        if (getActivity() != null) goBack();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, reservation);
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }

    }

    private void uploadReservation(Reservation reservation, boolean print) {

        try {
            String url = ApiEndPoints.reservations;
            if (!Validators.isNullOrEmpty(reservation.id)) {
                url = url + reservation.id;
            } else {
                LogUtils.e("ID not found");
                //            return;
            }
            LogUtils.e("Uploading Reservation::" + new Gson().toJson(reservation));
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    progressBarDialog.show();
                });
            }
            AndroidNetworking.post(url)
                    .addApplicationJsonBody(reservation)
                    .build()
                    .getAsObject(Reservation.class, new ParsedRequestListener<Reservation>() {
                        @Override
                        public void onResponse(Reservation response) {
                            try {
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        progressBarDialog.dismiss();
                                    });
                                }
                                reservation.id = response.id;
                                reservation.uploadable = false;
                                reservation.customer_id = response.customer_id;
                                reservation.customer.id = response.customer.id;
                                new SaveReservation(() -> {
                                    if (print && getActivity() != null) {
                                        getActivity().runOnUiThread(() -> {
                                            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                                                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                                                    zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                                                    zoneRichPrinter.printReservation(myApp.businessLogo, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("sunmi") || defaultPrinter.printer_model_name.toLowerCase().contains("t2")) {
                                                    if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                                                        sunmiPrinterV3Mix.printReservation(myApp.businessLogo, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                                    }else {
                                                        sunmiPrinter.printReservation(myApp.businessLogo, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                                    }
                                                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                                                    if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                                                        myApp.iMinPrinterUtils.printReservation(reservation, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", myApp.tiffintomLogoSmall);
                                                    } else {
                                                        if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                                                            wifiPrinter.connect(defaultPrinter.ip);
                                                            CommonFunctions.functionThatDelay(200);
                                                            wifiPrinter.printReservation(myApp.businessLogo, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                                        } else {
                                                            try {
                                                                if (bluetoothPrinter != null) {
                                                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                                                    if (device != null) {
                                                                        bluetoothPrinter.printReservation(myApp.businessLogo, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "");
                                                                    } else {
                                                                        ToastUtils.makeLongToast(getActivity(), "No bluetooth device found.");
                                                                    }
                                                                }
                                                            } catch (Exception e) {
                                                                e.printStackTrace();
                                                            }

                                                        }
                                                    }
                                                }
                                            } else {
                                                ToastUtils.makeLongToast(getActivity(), "No printer model found");
                                            }

                                        });
                                    }
                                    if (getActivity() != null) goBack();
                                    return null;
                                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, reservation);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }


                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                LogUtils.e("Error in uploading reservation");
                                anError.printStackTrace();
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> {
                                        progressBarDialog.dismiss();
                                    });
                                }
                                if (anError.getErrorCode() == 400) {
                                    if (anError.getErrorAsObject(ApiError.class).getCode().equalsIgnoreCase("404")) {
                                        new Thread(() -> {
                                            reservation.id = null;
                                            reservation.uploadable = true;
                                            myApp.appDatabase.reservationDao().update(reservation);
                                            if (print && getActivity() != null) {
                                                getActivity().runOnUiThread(() -> {
                                                    if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                                                        if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                                                            zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                                                            zoneRichPrinter.printReservation(myApp.businessLogo, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                                        } else if (defaultPrinter.printer_model_name.toLowerCase().contains("sunmi") || defaultPrinter.printer_model_name.toLowerCase().contains("t2")) {
                                                            if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                                                                sunmiPrinterV3Mix.printReservation(myApp.businessLogo, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                                            }else {
                                                                sunmiPrinter.printReservation(myApp.businessLogo, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                                            }
                                                        } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                                                            if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                                                                myApp.iMinPrinterUtils.printReservation(reservation, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", myApp.tiffintomLogoSmall);
                                                            } else {
                                                                if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                                                                    wifiPrinter.connect(defaultPrinter.ip);
                                                                    CommonFunctions.functionThatDelay(200);
                                                                    wifiPrinter.printReservation(myApp.businessLogo, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                                                } else {
                                                                    try {
                                                                        if (bluetoothPrinter != null) {
                                                                            BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                                                            if (device != null) {
                                                                                bluetoothPrinter.printReservation(myApp.businessLogo, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "");
                                                                            } else {
                                                                                ToastUtils.makeLongToast(getActivity(), "No bluetooth device found.");
                                                                            }
                                                                        }
                                                                    } catch (Exception e) {
                                                                        e.printStackTrace();
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    } else {
                                                        ToastUtils.makeLongToast(getActivity(), "No printer model found");
                                                    }
                                                    goBack();
                                                });
                                            } else {
                                                goBack();
                                            }
                                        }).start();
                                    }
                                } else {
                                    new Thread(() -> {
                                        reservation.id = null;
                                        reservation.uploadable = true;
                                        myApp.appDatabase.reservationDao().update(reservation);
                                        if (print && getActivity() != null) {
                                            getActivity().runOnUiThread(() -> {
                                                if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                                                    if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                                                        zoneRichPrinter.connectPrinter(defaultPrinter.ip);
                                                        zoneRichPrinter.printReservation(myApp.businessLogo, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                                    } else if (defaultPrinter.printer_model_name.toLowerCase().contains("sunmi") || defaultPrinter.printer_model_name.toLowerCase().contains("t2")) {
                                                        if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))){
                                                            sunmiPrinterV3Mix.printReservation(myApp.businessLogo, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                                        }else {
                                                            sunmiPrinter.printReservation(myApp.businessLogo, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                                        }
                                                    } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                                                        if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                                                            myApp.iMinPrinterUtils.printReservation(reservation, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", myApp.tiffintomLogoSmall);
                                                        } else {
                                                            if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                                                                wifiPrinter.connect(defaultPrinter.ip);
                                                                CommonFunctions.functionThatDelay(200);
                                                                wifiPrinter.printReservation(myApp.businessLogo, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "", myPreferences);
                                                            } else {
                                                                try {
                                                                    if (bluetoothPrinter != null) {
                                                                        BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                                                        if (device != null) {
                                                                            bluetoothPrinter.printReservation(myApp.businessLogo, "Reservation", ticketHeaderSetting != null ? ticketHeaderSetting.value : "", headerAlignment, reservation, footerASetting != null ? footerASetting.value : "", footerBSetting != null ? footerBSetting.value : "");
                                                                        } else {
                                                                            ToastUtils.makeLongToast(getActivity(), "No bluetooth device found.");
                                                                        }
                                                                    }
                                                                } catch (Exception e) {
                                                                    e.printStackTrace();
                                                                }

                                                            }
                                                        }
                                                    }
                                                } else {
                                                    ToastUtils.makeLongToast(getActivity(), "No printer model found");
                                                }
                                                goBack();
                                            });
                                        } else {
                                            goBack();
                                        }
                                    }).start();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }

                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void goBack() {
        if (getActivity() != null) {
            getActivity().getSupportFragmentManager().popBackStack();
        }
    }

    private class CustomersSaveAndGet extends AsyncTask<ArrayList<Customer>, Void, String> {

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected String doInBackground(ArrayList<Customer>... lists) {
            try {
                for (Customer customer : lists[0]) {
                    Customer dbCustomer = appDatabase.customerDao().view(customer.id);
                    if (dbCustomer == null) {
                        appDatabase.customerDao().insert(customer);
                    } else {
                        appDatabase.customerDao().update(customer);
                    }
                }
                if (getActivity() != null)
                    getActivity().runOnUiThread(() -> {
                        customers.clear();
                        customers.addAll(appDatabase.customerDao().listNoNull());
                    });
            } catch (Exception e) {
                e.printStackTrace();
            }

            return "Executed";
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                if (getActivity() != null) {
                    getActivity().runOnUiThread(() -> {
                        progressBarDialog.dismiss();
                        customerAutoSuggestAdapter.updateData(customers);
                    });
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }


    private class SaveReservation extends AsyncTask<Reservation, Void, String> {

        Callable<Void> nextThing;

        public SaveReservation(Callable<Void> nextThing) {
            this.nextThing = nextThing;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected String doInBackground(Reservation... reservations) {
            try {
                Reservation reservationTemp = reservations[0];

                if (reservationTemp._customer_id == 0) {
                    reservationTemp._customer_id = (int) appDatabase.customerDao().insert(reservationTemp.customer);
                } else {
                    appDatabase.customerDao().update(reservationTemp.customer);
                }

                if (reservationTemp._id > 0) {
                    appDatabase.reservationDao().insert(reservationTemp);
                } else {
                    reservationTemp._id = (int) appDatabase.reservationDao().insert(reservationTemp);
                }

                reservation = appDatabase.reservationDao().view(reservationTemp._id);
                reservation.customer = appDatabase.customerDao().view(reservationTemp._customer_id);
                LogUtils.e("Saving Reservation: " + new Gson().toJson(reservation));
            } catch (Exception e) {
                e.printStackTrace();
            }
            return "Executed";
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                if (nextThing != null) {
                    try {
                        nextThing.call();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        myApp.isReservationOpen = true;
    }

    @Override
    public void onDestroy() {
        myApp.isReservationOpen = false;
        super.onDestroy();
    }
}