package com.ubsidi.epos_2021.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;

import com.google.android.material.button.MaterialButton;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.models.OrderItem;
import com.ubsidi.epos_2021.models.OrderItemAddon;
import com.ubsidi.epos_2021.models.OrderItemIngredient;

public class OrderItemViewDialogFragment extends DialogFragment {

    private OrderItem orderItem;

    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private DialogDismissListener dialogDismissListener;
    private TextView tvItemName, tvSubAddonName, tvPrice, tvQty;
    private MaterialButton btnConfirm;

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_order_item_view, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            if (getArguments() != null) {
                orderItem = new Gson().fromJson(getArguments().getString("order_item"), OrderItem.class);
            }
            initView(view);
            setListener();
            updateViews();
        } catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
    }

    private void initView(View view) {
        try {
            tvItemName = view.findViewById(R.id.tvItemName);
            tvSubAddonName = view.findViewById(R.id.tvSubAddons);
            tvQty = view.findViewById(R.id.tvQty);
            tvPrice = view.findViewById(R.id.tvPrice);
            btnConfirm = view.findViewById(R.id.btnConfirm);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListener() {
        try {
            btnConfirm.setOnClickListener(v -> {
                dismiss();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateViews() {
        try {
            if (orderItem != null) {

                tvItemName.setText(orderItem.product_name);
                tvQty.setText(orderItem.quantity + "");
                tvPrice.setText(MyApp.currencySymbol + MyApp.df.format(orderItem.price));

                StringBuilder selectedProductAddons = new StringBuilder();
                if (orderItem.order_item_addons != null && orderItem.order_item_addons.size() > 0) {
                    for (OrderItemAddon orderItemAddon : orderItem.order_item_addons) {
                        if (selectedProductAddons.length() > 0) {
                            selectedProductAddons.append("\n");
                        }
                        selectedProductAddons.append(orderItemAddon.addon_name).append(": ").append(MyApp.currencySymbol).append(MyApp.df.format(orderItemAddon.price));

                    }
                }
                if (orderItem.order_item_ingredients != null && orderItem.order_item_ingredients.size() > 0) {
                    for (OrderItemIngredient orderItemIngredient : orderItem.order_item_ingredients) {
                        if (selectedProductAddons.length() > 0) {
                            selectedProductAddons.append("\n");
                        }
                        if (orderItemIngredient.with) {
                            selectedProductAddons.append("Extra ");
                            selectedProductAddons.append(orderItemIngredient.quantity).append(" ");
                        }
                        if (orderItemIngredient.without) {
                            selectedProductAddons.append("No ");
                        }
                        selectedProductAddons.append(orderItemIngredient.ingredient_name).append(": ").append(MyApp.currencySymbol).append(MyApp.df.format(orderItemIngredient.total));
                    }
                }
                if (!Validators.isNullOrEmpty(orderItem.special_instruction)) {
                    if (selectedProductAddons.length() > 0) {
                        selectedProductAddons.append("\n");
                    }
                    selectedProductAddons.append("Instruction").append(": ").append(orderItem.special_instruction);
                }

                tvSubAddonName.setText(selectedProductAddons.toString());
                if (selectedProductAddons.length() > 0) {
                    tvSubAddonName.setVisibility(View.VISIBLE);
                } else {
                    tvSubAddonName.setVisibility(View.GONE);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}