package com.ubsidi.epos_2021.fragment;

import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.card.MaterialCardView;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.CallLogs;
import com.ubsidi.epos_2021.models.OrderType;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.ArrayList;
import java.util.List;

public class OrderTypeSelectionDialogFragment extends DialogFragment {

    private MaterialCardView cvWaiting, cvCollection, cvDelivery, cvBar, cvReservation;
    private TextView tvWaiting, tvCollection, tvDelivery, tvBar, tvReservation;
    private DialogDismissListener dialogDismissListener;

    private CallLogs callLogs;
    private MyApp myApp = MyApp.getInstance();

    private ArrayList<OrderType> orderTypeList = new ArrayList<>();

    @Override
    public int getTheme() {
        return super.getTheme();
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        getDialog().getWindow().setBackgroundDrawable(new ColorDrawable(android.graphics.Color.TRANSPARENT));
    }


    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_order_type_dialog, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        try {
            if (getArguments() != null) {
                callLogs = new Gson().fromJson(getArguments().getString("calllogs"), CallLogs.class);
            }
            initViews(view);
            setUpOrderTypes();
            fetchOrderType();
            setListeners();
        } catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
    }

    private void setUpOrderTypes() {
        //1 = Dine In, 2= Collection, 3 = Delivery, 4 = Bar, 5= Waiting, 6 Web Order
        try {
            cvBar.setVisibility(View.GONE);

            SiteSetting collectionSetting = myApp.findSetting("is_collection");
            SiteSetting waitingSetting = myApp.findSetting("is_waiting");
            SiteSetting deliverySetting = myApp.findSetting("is_delivery");
            SiteSetting reservationSetting = myApp.findSetting("is_reservation");

            if (collectionSetting != null && (collectionSetting.value.equals("true") || collectionSetting.value.equals("1")) && (MyApp.userPermission != null && MyApp.userPermission.collection.actions.list)) {
                cvCollection.setVisibility(View.VISIBLE);
            } else {
                cvCollection.setVisibility(View.GONE);
            }
            if (deliverySetting != null && (deliverySetting.value.equals("true") || deliverySetting.value.equals("1")) && (MyApp.userPermission != null && MyApp.userPermission.delivery.actions.list)) {
                cvDelivery.setVisibility(View.VISIBLE);
            } else {
                cvDelivery.setVisibility(View.GONE);
            }
            if (waitingSetting != null && (waitingSetting.value.equals("true") || waitingSetting.value.equals("1")) && (MyApp.userPermission != null && MyApp.userPermission.waiting.actions.list)) {
                cvWaiting.setVisibility(View.VISIBLE);
            } else {
                cvWaiting.setVisibility(View.GONE);
            }

            if (callLogs != null && reservationSetting != null && (reservationSetting.value.equals("true") || reservationSetting.value.equals("1")) && MyApp.userPermission != null && MyApp.userPermission.reservation.actions.list) {
                cvReservation.setVisibility(View.VISIBLE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void setListeners() {
        try {
            cvCollection.setOnClickListener(v -> dismissDialog("2"));
            cvDelivery.setOnClickListener(v -> dismissDialog("3"));
            cvWaiting.setOnClickListener(v -> dismissDialog("5"));
            cvReservation.setOnClickListener(v -> {
                if (dialogDismissListener != null) {
                    dialogDismissListener.onDialogDismiss(callLogs);
                    dismiss();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void dismissDialog(String id) {
        try {
            if (dialogDismissListener != null) {
                dialogDismissListener.onDialogDismiss(id);
                dismiss();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        cvWaiting = view.findViewById(R.id.cvWaiting);
        cvCollection = view.findViewById(R.id.cvCollection);
        cvDelivery = view.findViewById(R.id.cvDelivery);
        cvBar = view.findViewById(R.id.cvBar);
        cvReservation = view.findViewById(R.id.cvReservation);

        tvWaiting = view.findViewById(R.id.tvWaiting);
        tvCollection = view.findViewById(R.id.tvCollection);
        tvDelivery = view.findViewById(R.id.tvDelivery);
        tvBar = view.findViewById(R.id.tvBar);
        tvReservation = view.findViewById(R.id.tvReservation);
    }

    private void fetchOrderType() {
        try {
            new Thread(() -> AndroidNetworking.get(ApiEndPoints.order_types)
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsObjectList(OrderType.class, new ParsedRequestListener<List<OrderType>>() {

                        @Override
                        public void onResponse(List<OrderType> response) {
                            try {
                                orderTypeList.clear();
                                orderTypeList.addAll(response);

                                for (int i = 0; i < orderTypeList.size(); i++) {
                                    Log.d("Order Type", "id: " + orderTypeList.get(i).id);
                                    Log.d("Order Type", "type: " + orderTypeList.get(i).type);
                                    Log.d("Order Type", "top color: " + orderTypeList.get(i).top_color);
                                    Log.d("Order Type", "bottom color: " + orderTypeList.get(i).bottom_color);

                                    if (response.get(i).type.equalsIgnoreCase("Waiting")) {
                                        cvWaiting.setCardBackgroundColor(Color.parseColor(response.get(i).top_color));
                                        tvWaiting.setTextColor(Color.parseColor(response.get(i).bottom_color));
                                    } else if (response.get(i).type.equalsIgnoreCase("Collection")) {
                                        cvCollection.setCardBackgroundColor(Color.parseColor(response.get(i).top_color));
                                        tvCollection.setTextColor(Color.parseColor(response.get(i).bottom_color));
                                    } else if (response.get(i).type.equalsIgnoreCase("Delivery")) {
                                        cvDelivery.setCardBackgroundColor(Color.parseColor(response.get(i).top_color));
                                        tvDelivery.setTextColor(Color.parseColor(response.get(i).bottom_color));
                                    } else if (response.get(i).type.equalsIgnoreCase("Bar")) {
                                        cvBar.setBackgroundColor(Color.parseColor(response.get(i).top_color));
                                        tvBar.setTextColor(Color.parseColor(response.get(i).bottom_color));
                                    } else if (response.get(i).type.equalsIgnoreCase("Dine In")) {
                                        cvReservation.setBackgroundColor(Color.parseColor(response.get(i).top_color));
                                        tvReservation.setTextColor(Color.parseColor(response.get(i).bottom_color));
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    })).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
