package com.ubsidi.epos_2021.fragment;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.fragment.app.FragmentTransaction;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.ViewPager;

import com.google.android.material.button.MaterialButton;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.OrderTypesAdapter;
import com.ubsidi.epos_2021.adapters.ViewpagerTabAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.models.OrderType;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.online.fragments.OnlineOrdersFragment;
import com.ubsidi.epos_2021.online.models.Counts;
import com.ubsidi.epos_2021.utils.Constants;

import java.util.ArrayList;

public class OrdersAllFragment extends BaseFragment {

    private RecyclerView rvOrderTypes;
    private ViewPager vpOrders;
    private ViewpagerTabAdapter viewpagerAdapter;
    private ArrayList<OrderType> orderTypes = new ArrayList<>();
    private OrderTypesAdapter orderTypesAdapter;
    private MaterialButton btnRefresh, btnNukeOrders;
    private String orderTypeId;
    private Chip chipBack;
    private LinearLayout llOrderHistory;
    private boolean fromTheme2;

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getArguments() != null) {
            orderTypeId = getArguments().getString("order_type_id");
            fromTheme2 = getArguments().getBoolean("from_theme2", false);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_all_orders, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);

            setUpOrderTypes();
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {

        try {
            btnRefresh = view.findViewById(R.id.btnRefresh);
            rvOrderTypes = view.findViewById(R.id.rvOrderTypes);
            vpOrders = view.findViewById(R.id.vpOrders);
            btnNukeOrders = view.findViewById(R.id.btnNukeOrders);
            chipBack = view.findViewById(R.id.chipBack);
            LinearLayout llTitle = view.findViewById(R.id.llTitle);
            llOrderHistory = view.findViewById(R.id.llOrderHistory);

            if (fromTheme2) {
                llTitle.setVisibility(View.GONE);
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
                params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                rvOrderTypes.setLayoutParams(params);
                if (MyApp.userPermission != null && MyApp.userPermission.order_history.actions.list) {
                    llOrderHistory.setVisibility(View.VISIBLE);
                } else {
                    llOrderHistory.setVisibility(View.GONE);
                }
            } else {
                llTitle.setVisibility(View.VISIBLE);
                llOrderHistory.setVisibility(View.GONE);
            }


            rvOrderTypes.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.HORIZONTAL, false));
            orderTypesAdapter = new OrderTypesAdapter(orderTypes, (position, data) -> {
                OrderType selectedItem = (OrderType) data;
                handleMenuClick(position, selectedItem.id);
            }, (position, data) -> {
                OrderType orderType = (OrderType) data;
                if (!Validators.isNullOrEmpty(orderType.id) && !orderType.id.equalsIgnoreCase("6")) {
                    if(viewpagerAdapter.getItem(vpOrders.getCurrentItem()) instanceof EposOrdersFragment){
                        EposOrdersFragment fragment = (EposOrdersFragment)viewpagerAdapter.getItem(vpOrders.getCurrentItem());
                        if(fragment!=null){
                            orderType.isSelected = !orderType.isSelected;
                            fragment.showPaidOrders = !fragment.showPaidOrders;
                            fragment.refreshOrder();
                        }
                    }
                }
            });
            MyApp.openedOrderTypeId = orderTypesAdapter.selectedOrderTypeId;
            rvOrderTypes.setAdapter(orderTypesAdapter);
            viewpagerAdapter = new ViewpagerTabAdapter(getChildFragmentManager(), FragmentPagerAdapter.BEHAVIOR_RESUME_ONLY_CURRENT_FRAGMENT);
            vpOrders.setOffscreenPageLimit(1);
            vpOrders.setAdapter(viewpagerAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleMenuClick(int position, String id) {
        try {
            orderTypesAdapter.selectedOrderTypeId = id;
            MyApp.openedOrderTypeId = id;
            orderTypesAdapter.notifyDataSetChanged();
            vpOrders.setCurrentItem(position);
            myApp.notifyCart(getActivity(), new Intent(Constants.EPOS_ORDER_TYPE_CLICK).putExtra("order_type_id", id));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            btnRefresh.setOnClickListener(view -> {
                myApp.notifyCart(getActivity(), new Intent().setAction(Constants.EPOS_ORDER_UPDATE).putExtra("result", true));
            });
            chipBack.setOnClickListener(v -> {
                getActivity().onBackPressed();
            });
            vpOrders.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
                @Override
                public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

                }

                @Override
                public void onPageSelected(int position) {
                    for (int i=0; i<orderTypes.size();i++){
                        orderTypes.get(i).isSelected = false;
                    }
                    if(viewpagerAdapter.getItem(vpOrders.getCurrentItem()) instanceof EposOrdersFragment){
                        EposOrdersFragment fragment = (EposOrdersFragment)viewpagerAdapter.getItem(vpOrders.getCurrentItem());
                        fragment.showPaidOrders = false;
                    }
                    // on page scroll change floor tables
                    OrderType selectedOrderType = orderTypes.get(position);
                    orderTypesAdapter.selectedOrderTypeId = selectedOrderType.id;
                    orderTypesAdapter.notifyDataSetChanged();
                    MyApp.openedOrderTypeId = orderTypesAdapter.selectedOrderTypeId;
                    rvOrderTypes.scrollToPosition(position);
                    if (selectedOrderType.id.equalsIgnoreCase("6")) {
                        btnRefresh.setVisibility(View.GONE);
                    } else {
                        btnRefresh.setVisibility(View.VISIBLE);
                    }
                    btnRefresh.setVisibility(View.GONE);
                }

                @Override
                public void onPageScrollStateChanged(int state) {

                }
            });

            btnNukeOrders.setOnClickListener(view -> {
                new Thread(() -> {
                    appDatabase.orderDao().nukeOrders();
                    appDatabase.orderDao().resetPrimaryKey();

                }).start();
            });
            llOrderHistory.setOnClickListener(view -> {
                FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
                ft.replace(R.id.nav_host_fragment, getInstanceEposOrdersHistory(orderTypeId, false), "all_orders");
                ft.addToBackStack("let_go_back");
                ft.commit();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public EposOrdersHistoryFragment getInstanceEposOrdersHistory(String typeId, boolean isArchived) {
        Bundle bundle = new Bundle();
        EposOrdersHistoryFragment fragment = new EposOrdersHistoryFragment();
        bundle.putString("order_type_id", typeId);
        bundle.putBoolean("is_archived", isArchived);
        fragment.setArguments(bundle);
        return fragment;
    }

    private void setUpOrderTypes() {

        //1 = Dine In, 2= Collection, 3 = Delivery, 4 = Bar, 5= Waiting, 6 Web Order
        try {
            orderTypes.clear();
            SiteSetting collectionSetting = myApp.findSetting("is_collection");
            SiteSetting deliverySetting = myApp.findSetting("is_delivery");
            SiteSetting waitingSetting = myApp.findSetting("is_waiting");

            if (collectionSetting != null && (collectionSetting.value.equals("true") || collectionSetting.value.equals("1")) && (MyApp.userPermission != null && MyApp.userPermission.collection.actions.list)) {
                orderTypes.add(new OrderType("2", "Collection"));
            }
            if (deliverySetting != null && (deliverySetting.value.equals("true") || deliverySetting.value.equals("1")) && (MyApp.userPermission != null && MyApp.userPermission.delivery.actions.list)) {
                orderTypes.add(new OrderType("3", "Delivery"));
            }
            if (waitingSetting != null && (waitingSetting.value.equals("true") || waitingSetting.value.equals("1")) && (MyApp.userPermission != null && MyApp.userPermission.waiting.actions.list)) {
                orderTypes.add(new OrderType("5", "Waiting"));
            }

            SiteSetting webSetting = myApp.findSetting("is_weborder");
            if (webSetting != null && (webSetting.value.equalsIgnoreCase("true") || webSetting.value.equalsIgnoreCase("1")) && (MyApp.userPermission != null && MyApp.userPermission.web_orders.actions.list)) {
                orderTypes.add(new OrderType("6", "Online Orders"));
            }

            if (orderTypes.size() > 0) {
                orderTypes.add(0, new OrderType("0", "All Orders"));
            }
            viewpagerAdapter.clearFragments();
            viewpagerAdapter.notifyDataSetChanged();

            for (OrderType orderType : orderTypes) {
                if (!Validators.isNullOrEmpty(orderType.id) && orderType.id.equalsIgnoreCase("6")) {
                    viewpagerAdapter.addFragment(getInstanceOnlineOrders(fromTheme2), "Online Orders");
                } else {
                    viewpagerAdapter.addFragment(getInstance(orderType.id, fromTheme2), orderType.type);
                }
            }

            // Set first floor item selected;
            if (orderTypes.size() > 0) {
                if (!Validators.isNullOrEmpty(orderTypeId)) {
                    int index = -1;
                    int i = 0;
                    for (OrderType orderType : orderTypes) {
                        if (orderType.id.equalsIgnoreCase(orderTypeId)) {
                            index = i;
                            break;
                        }
                        i++;
                    }
                    if (index > -1) {
                        handleMenuClick(index, orderTypeId);
                    }
                } else
                    orderTypesAdapter.selectedOrderTypeId = orderTypes.get(0).id;
            }

            orderTypesAdapter.notifyDataSetChanged();
            viewpagerAdapter.notifyDataSetChanged();

            fetchEposOrdersCount();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EposOrdersFragment getInstance(String typeId, boolean fromTheme2) {
        Bundle bundle = new Bundle();
        EposOrdersFragment fragment = new EposOrdersFragment();
        bundle.putString("order_type_id", typeId);
        bundle.putBoolean("from_theme2", fromTheme2);
        fragment.setArguments(bundle);
        return fragment;
    }

    BroadcastReceiver onlineOrdersNotificationReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getBooleanExtra("refresh", false)) {
                    Counts allCounts = new Gson().fromJson(intent.getStringExtra("counts"), Counts.class);
                    setOnlineOrderCounts(allCounts);
                }
            } catch (JsonSyntaxException e) {
                e.printStackTrace();
            }
        }
    };

    BroadcastReceiver eposOrderUpdateReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                fetchEposOrdersCount();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    BroadcastReceiver eposOrderCountUpdateReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                fetchEposOrdersCount();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private void fetchEposOrdersCount() {
        try {
            new Thread(() -> {
                try {
                    for (OrderType orderType : orderTypes) {
                        if (!orderType.id.equalsIgnoreCase("0") && !orderType.id.equalsIgnoreCase("6")) {
                            orderType.count = appDatabase.orderDao().activeOrdersCount(orderType.id);
                        } else if (orderType.id.equalsIgnoreCase("0")) {
                            orderType.count = appDatabase.orderDao().activeOrdersCount();
                        }
                    }
                    if (getActivity() != null) {
                        getActivity().runOnUiThread(() -> {
                            orderTypesAdapter.notifyDataSetChanged();
                        });
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setOnlineOrderCounts(Counts allCounts) {
        try {
            if (allCounts == null) return;
            for (OrderType menuItem : orderTypes) {
                if (menuItem.id.equalsIgnoreCase("6")) {
                    menuItem.count = allCounts.pending_orders;
                }
            }

            orderTypesAdapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    @Override
    public void onResume() {
        super.onResume();
        try {
            if (getActivity() != null) {
                LocalBroadcastManager.getInstance(getActivity()).registerReceiver(onlineOrdersNotificationReceiver, new IntentFilter(Constants.NOTIFICATION));
                LocalBroadcastManager.getInstance(getActivity()).registerReceiver(eposOrderUpdateReceiver, new IntentFilter(Constants.EPOS_ORDER_UPDATE));
                LocalBroadcastManager.getInstance(getActivity()).registerReceiver(eposOrderCountUpdateReceiver, new IntentFilter(Constants.EPOS_ORDER_COUNT_UPDATE));
                if (orderTypesAdapter != null) {
                    myApp.stopOrderSound();
                    // To update order history count
                    if (!orderTypes.isEmpty()) {
                        for (OrderType orderType : orderTypes) {
                            if (!orderType.id.equalsIgnoreCase("0") && !orderType.id.equalsIgnoreCase("6")) {
                                orderType.count = appDatabase.orderDao().activeOrdersCount(orderType.id);
                            } else if (orderType.id.equalsIgnoreCase("0")) {
                                orderType.count = appDatabase.orderDao().activeOrdersCount();
                            }
                        }
                        orderTypesAdapter.notifyDataSetChanged();
                    }
                    //setOnlineOrderCounts(null);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        try {
            if (onlineOrdersNotificationReceiver != null && getActivity() != null) {
                LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(onlineOrdersNotificationReceiver);
            }
            if (getActivity() != null && eposOrderUpdateReceiver != null) {
                LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(eposOrderUpdateReceiver);
            }
            if (getActivity() != null && eposOrderCountUpdateReceiver != null) {
                LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(eposOrderCountUpdateReceiver);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OnlineOrdersFragment getInstanceOnlineOrders(boolean fromTheme2) {
        OnlineOrdersFragment onlineOrdersFragment = new OnlineOrdersFragment();
        Bundle bundle = new Bundle();
        bundle.putBoolean("from_theme2", fromTheme2);
        onlineOrdersFragment.setArguments(bundle);
        return onlineOrdersFragment;
    }
}