package com.ubsidi.epos_2021.fragment;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.DialogFragment;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.multidex.BuildConfig;

import com.google.android.material.button.MaterialButton;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.online.interfaces.DialogDismissListener;
import com.ubsidi.epos_2021.services.SingleOrderUploaderService;
import com.ubsidi.epos_2021.utils.Constants;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;

/**
 * Created by Amrish on 11-11-2020.
 */
public class OrdersBulkActionPerformDialogFragment extends DialogFragment {
    @Override
    public int getTheme() {
        return R.style.MyDialog;
    }

    @Override
    public void onStart() {
        super.onStart();
        getDialog().setCancelable(false);
        getDialog().getWindow().setLayout(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    }

    private String title, info;
    private int type; //0 neutral, 1 success,2 reject
    private MaterialButton btnConfirm;
    private TextView tvInfo;
    private DialogDismissListener dialogDismissListener;
    private String action;
    private ArrayList<Integer> orderIds = new ArrayList<>();

    public void setDialogDismissListener(DialogDismissListener dialogDismissListener) {
        this.dialogDismissListener = dialogDismissListener;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.dialog_bulk_action_perform, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            title = getArguments().getString("title");
            action = getArguments().getString("action");
            orderIds = getArguments().getIntegerArrayList("orderIds");
            initViews(view);
            setListeners();
            performAction();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            btnConfirm = view.findViewById(R.id.btnConfirm);
            tvInfo = view.findViewById(R.id.tvInfo);
            TextView tvTitle = view.findViewById(R.id.tvTitle);

            if (Validators.isNullOrEmpty(title)) {
                tvTitle.setVisibility(View.GONE);
            } else
                tvTitle.setText(title);
            if (Validators.isNullOrEmpty(info)) {
                tvInfo.setVisibility(View.GONE);
            } else
                tvInfo.setText(info);
            if (type == 2) {
                tvTitle.setTextColor(ContextCompat.getColor(getActivity(), R.color.dialog_title_reject));
            } else if (type == 1) {
                tvTitle.setTextColor(ContextCompat.getColor(getActivity(), R.color.dialog_title_accept));
            }

            btnConfirm.setVisibility(View.GONE);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    private void performAction() {
        try {
            if (action.equalsIgnoreCase("complete_orders")) {
                new CompleteOrdersAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    class CompleteOrdersAsync extends AsyncTask<String, String, String> {

        @Override
        protected String doInBackground(String... strings) {
            MyApp.getInstance().appDatabase.orderDao().updateOrderStatusInBulk(orderIds, "5");
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            getActivity().startService(new Intent(getActivity(), SingleOrderUploaderService.class).putExtra("_order_id", orderIds.get(0)).putExtra("position", 0));
        }
    }

    private void setListeners() {
        try {
            btnConfirm.setOnClickListener(view -> {
                if (dialogDismissListener != null)
                    dialogDismissListener.onDialogDismiss("confirm");
                dismiss();
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    BroadcastReceiver orderUpdateReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                int position = intent.getIntExtra("position", -1);
                if (action.equalsIgnoreCase("complete_orders")) {
                    tvInfo.setText(String.format("Completing orders %d of %d", position + 2, orderIds.size()));
                } else {
                    tvInfo.setText(String.format("Changing orders %d of %d", position + 2, orderIds.size()));
                }
                if (orderIds.size() > 0) {
                    if (position == orderIds.size() - 1) {
                        if (dialogDismissListener != null) dialogDismissListener.onDialogDismiss(null);
                        dismiss();
                    } else {
                        getActivity().startService(new Intent(getActivity(), SingleOrderUploaderService.class).putExtra("forcefully", true).putExtra("_order_id", orderIds.get(position + 1)).putExtra("position", position + 1));
                    }
                } else {
                    if (dialogDismissListener != null) dialogDismissListener.onDialogDismiss(null);
                    dismiss();
                }
                if (BuildConfig.DEBUG) {
                    if (intent.getStringExtra("message") != null) {
                        String message = "\n" + intent.getStringExtra("message");
                        tvInfo.append(message);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    public void onResume() {
        super.onResume();
        if (orderUpdateReceiver != null)
            LocalBroadcastManager.getInstance(getActivity()).registerReceiver(orderUpdateReceiver, new IntentFilter(
                    Constants.EPOS_ORDER_UPDATE));
    }

    @Override
    public void onDismiss(@NonNull @NotNull DialogInterface dialog) {
        super.onDismiss(dialog);
        if (orderUpdateReceiver != null) {
            LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(orderUpdateReceiver);
        }
    }

}
