package com.ubsidi.epos_2021.fragment;

import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.chip.Chip;
import com.google.gson.Gson;
import com.ubsidi.R;
import com.ubsidi.epos_2021.activities.NewOrderActivity;
import com.ubsidi.epos_2021.adapters.ParkCallAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.CallLogs;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.ArrayList;
import java.util.List;

public class ParkCallFragment extends BaseFragment {

    private ArrayList<CallLogs> callList = new ArrayList<>();
    private ParkCallAdapter parkCallAdapter;
    private AlertDialog progressBarDialog;
    private Chip chipBack;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_park_call, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initView(view);
            setListeners();
            fetchCallLogs();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        chipBack.setOnClickListener(view -> getActivity().onBackPressed());
    }

    private void initView(View view) {
        try {
            progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
            RecyclerView rvParkCall = view.findViewById(R.id.rvParkCall);
            chipBack = view.findViewById(R.id.chipBack);

            rvParkCall.setLayoutManager(new LinearLayoutManager(getActivity(), RecyclerView.VERTICAL, false));

            parkCallAdapter = new ParkCallAdapter(callList, (position, data) -> {
                changeStatusCallerid((CallLogs) data);
            });

            rvParkCall.setAdapter(parkCallAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fetchCallLogs() {
        try {
            progressBarDialog.show();
            AndroidNetworking.get(ApiEndPoints.calllogs)
                    .addQueryParameter("status", "parked")
                    .addQueryParameter("nopaginate", "1")
                    .build()
                    .getAsObjectList(CallLogs.class, new ParsedRequestListener<List<CallLogs>>() {
                        @Override
                        public void onResponse(List<CallLogs> response) {
                            try {
                                Log.e("response", "" + response.toString());
                                progressBarDialog.dismiss();
                                callList.clear();
                                new CallLogAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, response);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                progressBarDialog.dismiss();
                                callList.clear();
                                new CallLogAsync().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeStatusCallerid(CallLogs callLogs) {
        try {
            progressBarDialog.show();

            String url = ApiEndPoints.calllogs;
            if (!Validators.isNullOrEmpty(callLogs.id)) {
                url = url + callLogs.id;
            }
            if (callLogs._id > 0) {
                new Thread(() -> {
                    callLogs.uploadable = true;
                    appDatabase.calllogDao().update(callLogs);
                }).start();
            }
            if (callLogs.status.equalsIgnoreCase("accepted")) {
                OrderTypeSelectionDialogFragment orderTypeSelectionDialog = myApp.getInstanceOrderTypeSelection(callLogs);
                orderTypeSelectionDialog.show(getChildFragmentManager(), "order_type");
                orderTypeSelectionDialog.setDialogDismissListener(o -> {
                    try {
                        if (o instanceof String) {
                            String orderTypeId = (String) o;
                            NewOrderDialogFragment newOrderDialogFragment = myApp.getInstanceNewOrder(callLogs, orderTypeId);
                            newOrderDialogFragment.show(getChildFragmentManager(), "new_order");
                            newOrderDialogFragment.setDialogDismissListener(o1 -> {
                                if (o1 instanceof Order) {
                                    startActivity(new Intent(getActivity(), NewOrderActivity.class).putExtra("order", new Gson().toJson(o1)).putExtra("fetch_delivery_charge", ((Order) o1).order_type_id.equalsIgnoreCase("3")));
                                } else if (o1 instanceof CallLogs) {
                                    changeFragment(myApp.getInstanceNewReservation((CallLogs) o1));
                                }
                            });
                        } else if (o instanceof CallLogs) {
                            changeFragment(myApp.getInstanceNewReservation((CallLogs) o));
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }

            AndroidNetworking.post(url)
                    .addApplicationJsonBody(callLogs)
                    .build()
                    .getAsObject(CallLogs.class, new ParsedRequestListener<CallLogs>() {
                        @Override
                        public void onResponse(CallLogs response) {
                            progressBarDialog.dismiss();
                            fetchCallLogs();
                        }

                        @Override
                        public void onError(ANError anError) {
                            try {
                                anError.printStackTrace();
                                progressBarDialog.dismiss();
                                fetchCallLogs();
                                if (anError.getErrorCode() == 400) {
                                    ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                    ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                                } else {
                                    anError.printStackTrace();
                                    ToastUtils.makeSnackToast(getActivity(), "Something went wrong!");
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeFragment(Fragment instance) {
        try {
            FragmentManager manager = getActivity().getSupportFragmentManager();
            FragmentTransaction transaction = manager.beginTransaction();
            transaction.replace(R.id.nav_host_fragment, instance);
            transaction.addToBackStack("can_go_back");
            transaction.commitAllowingStateLoss();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class CallLogAsync extends AsyncTask<List<CallLogs>, String, String> {

        @Override
        protected String doInBackground(List<CallLogs>... lists) {
            try {
                callList.addAll(myApp.appDatabase.calllogDao().getParkedCalls());
                for (CallLogs callLogs : callList) {
                    callLogs.customer = appDatabase.customerDao().view(callLogs.customer_id);
                }
                if (lists.length > 0) {
                    callList.addAll(lists[0]);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            try {
                parkCallAdapter.notifyDataSetChanged();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}