package com.ubsidi.epos_2021.fragment;

import static com.ubsidi.epos_2021.utils.Constants.EXTERNAL_CARD_READER_PAYMENT;
import static com.ubsidi.epos_2021.utils.Constants.EXTERNAL_MOTO_PAYMENT;
import static com.ubsidi.epos_2021.utils.Constants.TAPTOPAY;

import android.Manifest;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.androidnetworking.interfaces.ParsedRequestListener;
import com.google.android.material.button.MaterialButton;
import com.google.gson.Gson;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.Stripe;
import com.stripe.android.core.exception.StripeException;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.stripeterminal.Terminal;
import com.stripe.stripeterminal.external.models.Reader;
import com.ubsidi.BuildConfig;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.MoneyTextWatcher;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.comman.bluetoothprinter.BluetoothPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinterV3Mix;
import com.ubsidi.epos_2021.comman.printer.WifiPrinter;
import com.ubsidi.epos_2021.comman.printer.ZoneRichPrinter;
import com.ubsidi.epos_2021.interfaces.DialogDismissDataListener;
import com.ubsidi.epos_2021.merchant.fragments.StripeBluetoothCardReaderPaymentFragment;
import com.ubsidi.epos_2021.merchant.fragments.StripeInternetCardReaderPaymentFragment;
import com.ubsidi.epos_2021.models.Admin;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.models.BusinessCardReader;
import com.ubsidi.epos_2021.models.OrderExternalPayment;
import com.ubsidi.epos_2021.models.Printer;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.models.Table;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.util.HashMap;

import io.mpos.accessories.AccessoryFamily;
import io.mpos.accessories.parameters.AccessoryParameters;
import io.mpos.provider.ProviderMode;
import io.mpos.transactions.Currency;
import io.mpos.transactions.Transaction;
import io.mpos.transactions.parameters.TransactionParameters;
import io.mpos.ui.shared.MposUi;

public class PaymentCardReaderFragment extends BaseFragment {
    private String selectedConnectivity = "";
    private MposUi mposUi;
    private EditText etAmount, etTip;
    private MaterialButton btnCancel, btnPaynow;
    private float tipAmount = 0, amount = 0;
    private ZoneRichPrinter zoneRichPrinter;
    private SunmiPrinter sunmiPrinter;
    private SunmiPrinterV3Mix sunmiPrinterV3Mix;
    private WifiPrinter wifiPrinter;
    public BluetoothPrinter bluetoothPrinter;
    private Admin loggedInAdmin = myPreferences.getLoggedInAdmin();
    private Business selectedBusiness = loggedInAdmin.selected_business;

    private String header = "", resAddress = "";
    long lastClickTime = 0;
    final long MIN_CLICK_INTERVAL = 2500; //in millis
    private AlertDialog progressBarDialog;
    private Printer defaultPrinter;
    private TextView tvTip, txt_battery_level;
    private LinearLayout linear_battery_level;
    private int headerAlignment = 0;
    private SiteSetting headerAlignmentSetting;
    SiteSetting footerASetting = myApp.findSetting("footer_a");
    SiteSetting footerBSetting = myApp.findSetting("footer_b");
    SiteSetting ticketHeader = myApp.findSetting("ticket_header");
    SiteSetting address = myApp.findSetting("address");

    private BusinessCardReader selectedCardReader;
    private String stripe_mode, stripe_private_key, stripe_public_key;
    private Stripe stripe;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_payment_card_reader, container, false);
    }

    @Override
    public void onViewCreated(@NonNull @NotNull View view, @Nullable @org.jetbrains.annotations.Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            setListeners();
            setCardReader();
            setBatteryLevel();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void setBatteryLevel() {
        try {
            if (Terminal.isInitialized()) {
                Reader connectedReader = Terminal.getInstance().getConnectedReader();
                if (connectedReader != null) {
                    if (linear_battery_level != null && txt_battery_level != null) {
                        linear_battery_level.setVisibility(View.VISIBLE);
                        txt_battery_level.setText("Battery Level:- " + (connectedReader.getBatteryLevel() * 100f) + "%");
                    }
                } else {
                    if (linear_battery_level != null) {
                        linear_battery_level.setVisibility(View.GONE);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeFragment(Fragment fragment) {
        try {
            FragmentManager manager = getChildFragmentManager();
            FragmentTransaction transaction = manager.beginTransaction();
            transaction.replace(R.id.flCardReader, fragment);
            transaction.commit();
            getActivity().invalidateOptionsMenu();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
            defaultPrinter = myPreferences.getDefaultPrinter();
            zoneRichPrinter = new ZoneRichPrinter(getActivity());
            zoneRichPrinter = myApp.connectZonerich(zoneRichPrinter, defaultPrinter);
            wifiPrinter = WifiPrinter.getInstance();
            bluetoothPrinter = new BluetoothPrinter(getActivity());
            sunmiPrinter = new SunmiPrinter(getActivity());
            if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                sunmiPrinterV3Mix = new SunmiPrinterV3Mix(requireActivity());
            }
            btnPaynow = view.findViewById(R.id.btnPaynow);
            btnCancel = view.findViewById(R.id.btnCancel);
            etTip = view.findViewById(R.id.etTip);
            tvTip = view.findViewById(R.id.tvTip);
            etAmount = view.findViewById(R.id.etAmount);

            linear_battery_level = view.findViewById(R.id.linear_battery_level);
            txt_battery_level = view.findViewById(R.id.txt_battery_level);
            selectedCardReader = MyApp.getInstance().myPreferences.getDefaultCardReader();
            headerAlignmentSetting = myApp.findSetting("ticket_header_type");
            if (headerAlignmentSetting != null && headerAlignmentSetting.value.equalsIgnoreCase("right")) {
                headerAlignment = 2;
            }
            if (headerAlignmentSetting != null && headerAlignmentSetting.value.equalsIgnoreCase("center")) {
                headerAlignment = 1;
            }
            if (!selectedBusiness.tip) {
                // Hide tip layout
                tvTip.setVisibility(View.GONE);
                etTip.setVisibility(View.GONE);
            }

            btnPaynow.setEnabled(isValid());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initMpos() {
        try {
            if (selectedBusiness.stripe_mode.equalsIgnoreCase("live")) {
                mposUi = MposUi.initialize(getActivity(), ProviderMode.LIVE,
                        selectedCardReader.merchant_key, selectedCardReader.merchant_secret);
            } else {
                mposUi = MposUi.initialize(getActivity(), ProviderMode.MOCK,
                        selectedCardReader.merchant_key, selectedCardReader.merchant_secret);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    float totalAmount = 0;

    private void setUpMposTerminal() {
        try {
            if (selectedBusiness.card_readers != null && selectedBusiness.card_readers.size() == 1) {
                selectedCardReader = selectedBusiness.card_readers.get(0);
            }
            if (selectedCardReader != null) {

                if (selectedCardReader.connectivity.toLowerCase().equalsIgnoreCase("internet") || selectedCardReader.connectivity.toLowerCase().equalsIgnoreCase("stripebluetooth") || selectedCardReader.connectivity.toLowerCase().equalsIgnoreCase("posbluetooth") || selectedCardReader.connectivity.equalsIgnoreCase(TAPTOPAY)) {
                    //stripe_mode = selectedBusiness.stripe_mode;
                    stripe_mode = ApiEndPoints.ubsidiBuild ? "live" : "test";

                    if (!Validators.isNullOrEmpty(selectedBusiness.s_account_id) && selectedBusiness.connect_service && !Validators.isNullOrEmpty(BuildConfig.connect_stripe_public_key)) {
                        //stripe_private_key = selectedBusiness.connect_stripe_private_key;
                        stripe_private_key = BuildConfig.connect_stripe_private_key;
                        //stripe_public_key = selectedBusiness.connect_stripe_public_key;
                        stripe_public_key = BuildConfig.connect_stripe_public_key;
                    } else {
                        if (stripe_mode.equalsIgnoreCase("live")) {
                            //stripe_private_key = selectedBusiness.stripe_private_key_live;
                            stripe_private_key = BuildConfig.stripe_private_key_live;
                            //stripe_public_key = selectedBusiness.stripe_public_key_live;
                            stripe_public_key = BuildConfig.stripe_public_key_live;
                        } else {
                            //stripe_private_key = selectedBusiness.stripe_private_key_test;
                            stripe_private_key = BuildConfig.stripe_private_key_test;
                            //stripe_public_key = selectedBusiness.stripe_public_key_test;
                            stripe_public_key = BuildConfig.stripe_public_key_test;
                        }
                    }
                    PaymentConfiguration.init(getActivity(), stripe_public_key);
                    stripe = new Stripe(getActivity(), stripe_public_key);
                    openStripeReaders(selectedCardReader);
                } else {
                    initMpos();
                    AccessoryParameters accessoryParameters;
                    if (!Validators.isNullOrEmpty(selectedCardReader.ip)) {
                        accessoryParameters = new AccessoryParameters.Builder(AccessoryFamily.MIURA_MPI)
                                .tcp(selectedCardReader.ip, Integer.parseInt(selectedCardReader.port))
                                .build();
                    } else {
                        accessoryParameters = new AccessoryParameters.Builder(AccessoryFamily.MIURA_MPI)
                                .bluetooth()
                                .build();

                    }
                    mposUi.getConfiguration().setTerminalParameters(accessoryParameters);
                    if (selectedBusiness != null) {
                        String descriptor = selectedBusiness.statement_descriptor;
                        if (!Validators.isNullOrEmpty(selectedBusiness.s_account_id) && selectedBusiness.connect_service) {
                            descriptor = selectedBusiness.statement_descriptor;
                        }
                        if (!Validators.isNullOrEmpty(selectedBusiness.s_account_id) && selectedBusiness.connect_service) {
                            calculateApplicationFee();
                        } else {
                            TransactionParameters transactionParameters = new TransactionParameters.Builder()
                                    .charge(new BigDecimal("" + totalAmount), Currency.GBP)
                                    .statementDescriptor(descriptor)
                                    .subject(selectedBusiness.statement_description)
                                    .autoCapture(true)
                                    .build();

                            Intent intent = mposUi.createTransactionIntent(transactionParameters);
                            startActivityForResult(intent, Constants.PAYMENT_MPOS_CARDREADER);
                        }
                    } else {
                        ToastUtils.makeSnackToast(getActivity(), "Merchant credentials not found");
                    }
                }

            } else {
                setCardReader();
            }
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private void setCardReader() {
        try {
            SelectCardReaderFragment selectCardReaderDialogFragment = new SelectCardReaderFragment();
            changeFragment(selectCardReaderDialogFragment);
            selectCardReaderDialogFragment.setDialogDismissListener(o -> {
                if (o instanceof BusinessCardReader) {
                    selectedCardReader = (BusinessCardReader) o;
                    btnPaynow.setEnabled(isValid());
                    myPreferences.saveDefaultCardReader(selectedCardReader);
                } else {
                    getActivity().onBackPressed();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openStripeReaders(BusinessCardReader selectedCardReader) {
        try {
            if (selectedCardReader.s_location_id == null) {
                selectedCardReader.s_location_id = selectedBusiness.s_location_id;
            }
            selectedConnectivity = "";
            if (selectedCardReader.connectivity.toLowerCase().equalsIgnoreCase("internet")) {
                selectedConnectivity = selectedCardReader.connectivity;
                //    String url = ApiEndPoints.CARD_READER_PAYMENT + "?s_location_id=" + selectedCardReader.s_location_id + "&s_terminal_id=" + selectedCardReader.s_terminal_id + "&amount=" + (totalAmount * 100) + "&business_id=" + selectedBusiness.id;
                //    startActivityForResult(new Intent(getActivity(), InternetCardReaderPaymentActivity.class).putExtra("url", url), Constants.PAYMENT_WEBVIEW_CARDREADER);
                askForPermission("internet");
            } else if (selectedCardReader.connectivity.toLowerCase().toLowerCase().equalsIgnoreCase("stripebluetooth") || selectedCardReader.connectivity.toLowerCase().toLowerCase().equalsIgnoreCase("posbluetooth") || selectedCardReader.connectivity.equalsIgnoreCase(TAPTOPAY)) {
                selectedConnectivity = selectedCardReader.connectivity;
                askForPermission("bluetooth");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void askForPermission(String discoverymethod) {
        try {
            final int locationPermission = ActivityCompat.checkSelfPermission(getActivity(), Manifest.permission.ACCESS_FINE_LOCATION);

           /* if (locationPermission == PackageManager.PERMISSION_GRANTED) {
                if (verifyGpsEnabled()) {
                    if (discoverymethod.equalsIgnoreCase("bluetooth")) {
                        showStripeBluetoothReaderDialog();
                    } else {
                        showStripeInternetReaderDialog();
                    }
                }
            } else {
                // If we don't have them yet, request them before doing anything else
                final String[] permissions = {Manifest.permission.ACCESS_FINE_LOCATION};
                requestPermissions(permissions, Constants.PERMISSION_CODE_LOCATION);
            }*/
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
                final int scanPermission = ActivityCompat.checkSelfPermission(getActivity(), Manifest.permission.BLUETOOTH_SCAN);
                final int connectPermission = ActivityCompat.checkSelfPermission(getActivity(), Manifest.permission.BLUETOOTH_CONNECT);
                if (locationPermission == PackageManager.PERMISSION_GRANTED && scanPermission == PackageManager.PERMISSION_GRANTED && connectPermission == PackageManager.PERMISSION_GRANTED) {
                    if (verifyGpsEnabled()) {
                        if (discoverymethod.equals("bluetooth")) {
                            showStripeBluetoothReaderDialog();
                        } else {
                            showStripeInternetReaderDialog();
                        }

                    }
                } else {
                    // If we don't have them yet, request them before doing anything else
                    final String[] permissions = {Manifest.permission.ACCESS_FINE_LOCATION, Manifest.permission.BLUETOOTH_CONNECT, Manifest.permission.BLUETOOTH_SCAN, Manifest.permission.BLUETOOTH_ADMIN};
                    requestPermissions(permissions, Constants.PERMISSION_CODE_LOCATION);
                }
            } else {
                if (locationPermission == PackageManager.PERMISSION_GRANTED) {
                    if (verifyGpsEnabled()) {
                        if (discoverymethod.equals("bluetooth")) {
                            showStripeBluetoothReaderDialog();
                        } else {
                            showStripeInternetReaderDialog();
                        }

                    }
                } else {
                    // If we don't have them yet, request them before doing anything else
                    final String[] permissions = {Manifest.permission.ACCESS_FINE_LOCATION};
                    requestPermissions(permissions, Constants.PERMISSION_CODE_LOCATION);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public StripeBluetoothCardReaderPaymentFragment getInstanceStripeBluetoothCardR(BusinessCardReader cardReader, float amount, boolean isTapToPay) {
        StripeBluetoothCardReaderPaymentFragment rejectReasonDialog = new StripeBluetoothCardReaderPaymentFragment();
        Bundle bundle = new Bundle();
        bundle.putString("card_reader", new Gson().toJson(cardReader));
        bundle.putFloat("amount", amount);
        bundle.putBoolean(TAPTOPAY, isTapToPay);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    private void showStripeBluetoothReaderDialog() {
        try {
            StripeBluetoothCardReaderPaymentFragment stripeBluetoothCardReaderPaymentFragment = getInstanceStripeBluetoothCardR(selectedCardReader, totalAmount,
            !Validators.isNullOrEmpty(selectedConnectivity) && selectedConnectivity.equalsIgnoreCase(TAPTOPAY));
            stripeBluetoothCardReaderPaymentFragment.show(getChildFragmentManager(), "card_reader");
            stripeBluetoothCardReaderPaymentFragment.setCancelable(false);
            stripeBluetoothCardReaderPaymentFragment.setDialogDismissListener(new DialogDismissDataListener() {
                @Override
                public void onDialogDismiss(Object o, String cardName, String number) {
                    //etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount));
                    //etTip.addTextChangedListener(new MoneyTextWatcher(etTip));
                    resetBox();
                    if (o instanceof com.stripe.stripeterminal.external.models.PaymentIntent) {
                        retrivePaymentIntentAndPrintWithId(((com.stripe.stripeterminal.external.models.PaymentIntent) o).getClientSecret(), cardName, number);
                    } else if (o instanceof String) {
                        myApp.startPaymentFailedSound();
                        ToastUtils.makeSnackToast(getActivity(), (String) o);
                    } else {
                        myApp.startPaymentFailedSound();
                        ToastUtils.makeSnackToast(getActivity(), "Transaction was declined, aborted, or failed");

                    }
                }

                @Override
                public void onDialogDismissPaymentFailed() {
                    setBatteryLevel();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public StripeInternetCardReaderPaymentFragment getInstanceStripeInternetCardR(BusinessCardReader cardReader, float amount) {
        StripeInternetCardReaderPaymentFragment rejectReasonDialog = new StripeInternetCardReaderPaymentFragment();
        Bundle bundle = new Bundle();
        bundle.putString("card_reader", new Gson().toJson(cardReader));
        bundle.putFloat("amount", amount);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }

    private void showStripeInternetReaderDialog() {
        try {
            StripeInternetCardReaderPaymentFragment stripeInternetCardReaderPaymentFragment = getInstanceStripeInternetCardR(selectedCardReader, totalAmount);
            stripeInternetCardReaderPaymentFragment.show(getChildFragmentManager(), "card_reader");
            stripeInternetCardReaderPaymentFragment.setCancelable(false);
            stripeInternetCardReaderPaymentFragment.setDialogDismissListener(new DialogDismissDataListener() {
                @Override
                public void onDialogDismiss(Object o, String cardName, String number) {
                    //etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount));
                    //etTip.addTextChangedListener(new MoneyTextWatcher(etTip));
                    resetBox();
                    if (o instanceof com.stripe.stripeterminal.external.models.PaymentIntent) {
                        retrivePaymentIntentAndPrintWithId(((com.stripe.stripeterminal.external.models.PaymentIntent) o).getClientSecret(), cardName, number);
                    } else if (o instanceof String) {
                        myApp.startPaymentFailedSound();
                        ToastUtils.makeSnackToast(getActivity(), (String) o);
                    } else {
                        myApp.startPaymentFailedSound();
                        ToastUtils.makeSnackToast(getActivity(), "Transaction was declined, aborted, or failed");

                    }
                }

                @Override
                public void onDialogDismissPaymentFailed() {
                    setBatteryLevel();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isGpsEnabled(Context context) {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.KITKAT) {
            String providers = Settings.Secure.getString(context.getContentResolver(),
                    Settings.Secure.LOCATION_PROVIDERS_ALLOWED);
            if (TextUtils.isEmpty(providers)) {
                return false;
            }
            return providers.contains(LocationManager.GPS_PROVIDER);
        } else {
            final int locationMode;
            try {
                locationMode = Settings.Secure.getInt(context.getContentResolver(),
                        Settings.Secure.LOCATION_MODE);
            } catch (Settings.SettingNotFoundException e) {
                e.printStackTrace();
                return false;
            }
            switch (locationMode) {

                case Settings.Secure.LOCATION_MODE_HIGH_ACCURACY:
                case Settings.Secure.LOCATION_MODE_SENSORS_ONLY:
                    return true;
                case Settings.Secure.LOCATION_MODE_BATTERY_SAVING:
                case Settings.Secure.LOCATION_MODE_OFF:
                default:
                    return false;
            }
        }
    }

    private boolean verifyGpsEnabled() {
        if (isGpsEnabled(getActivity())) {
            LogUtils.e("RETURNING TRUE");
            return true;
        }
        final LocationManager locationManager = (LocationManager) getActivity().getSystemService(Context.LOCATION_SERVICE);

        boolean gpsEnabled = false;
        if (locationManager == null) {
            ToastUtils.makeToast(getActivity(), "Location manager null");
        }
        try {
            gpsEnabled = locationManager != null &&
                    locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER);
        } catch (Exception exception) {
            ToastUtils.makeLongToast(getActivity(), exception.getMessage());
            exception.printStackTrace();
        }

        if (!gpsEnabled) {
            // notify user
            new AlertDialog.Builder(new ContextThemeWrapper(getActivity(), R.style.Theme_MaterialComponents_DayNight_DarkActionBar))
                    .setMessage("Please enable location services")
                    .setCancelable(false)
                    .setPositiveButton("Open location settings", (dialog, which) -> {
                        startActivity(new Intent(Settings.ACTION_LOCATION_SOURCE_SETTINGS));
                    })
                    .create()
                    .show();
        }

        return gpsEnabled;
    }

    private HashMap<String, String> generateFeeParams() {
        HashMap<String, String> params = new HashMap<>();

        params.put("amount", MyApp.df.format(totalAmount * 100));
        params.put("currency", "GBP");
        params.put("transaction_type", !selectedBusiness.connect_service ? "merchant" : "connect");
        params.put("business_id", selectedBusiness.id);
        return params;
    }

    private void calculateApplicationFee() {
        if (getActivity() != null) {
            getActivity().runOnUiThread(() -> {
                progressBarDialog.show();
                if (etAmount.length() > 0) {
                    etAmount.getText().clear();
                }

            });
        }
        AndroidNetworking.post(ApiEndPoints.APPLICATION_FEE)
                .addBodyParameter(generateFeeParams())
                .build()
                .getAsJSONObject(new JSONObjectRequestListener() {
                    @Override
                    public void onResponse(JSONObject response) {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> progressBarDialog.dismiss());
                        }
                        try {
                            if (response.has("payment_intent_id")) {
                                String paymentSecret = response.getString("payment_intent_id");
                                Intent intent = mposUi.createTransactionIntent(paymentSecret);
                                startActivityForResult(intent, Constants.PAYMENT_MPOS_CARDREADER);
                            } else if (response.has("fee")) {
                                float fee = Float.parseFloat(response.getString("fee"));
                                TransactionParameters transactionParameters = new TransactionParameters.Builder()
                                        .charge(new BigDecimal("" + totalAmount), Currency.GBP)
                                        .statementDescriptor(selectedBusiness.connect_service ? selectedBusiness.statement_descriptor : selectedBusiness.statement_descriptor)
                                        .applicationFee(new BigDecimal(fee))
                                        .subject(selectedBusiness.statement_description)
                                        .autoCapture(true)
                                        .build();

                                Intent intent = mposUi.createTransactionIntent(transactionParameters);
                                startActivityForResult(intent, Constants.PAYMENT_MPOS_CARDREADER);
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                            ToastUtils.makeSnackToast(getActivity(), "Something went wrong!");
                        }

                    }

                    @Override
                    public void onError(ANError anError) {
                        try {
                            anError.printStackTrace();
                            LogUtils.e("MOTO PAYMENT ERROR");
                            LogUtils.e(anError.getErrorBody());
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressBarDialog.dismiss());
                            }
                            if (anError.getErrorCode() == 400) {
                                ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                ToastUtils.makeSnackToast(getActivity(), apiError.getMessage());
                            } else {
                                ToastUtils.makeSnackToast(getActivity(), "Unknown Error");
                            }


                            if (!CommonFunctions.isConnected(getActivity()))
                                myApp.noInternet(getActivity());
                        } catch (Exception e) {
                            e.printStackTrace();
                        }


                    }
                });
    }

    private void setListeners() {
        try {
            etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount));
            etAmount.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence s, int start, int count, int after) {

                }

                @Override
                public void onTextChanged(CharSequence s, int start, int before, int count) {

                }

                @Override
                public void afterTextChanged(Editable s) {
                    btnPaynow.setEnabled(isValid());
                }
            });
            etTip.addTextChangedListener(new MoneyTextWatcher(etTip));

            btnPaynow.setOnClickListener(view -> {

                if (etTip.getText().toString().equalsIgnoreCase("")) {
                    amount = Float.parseFloat(etAmount.getText().toString().replace(",", ""));
                    totalAmount = amount;
                    //totalAmount = Float.parseFloat(etAmount.getText().toString().replace(",", ""));
                } else {
                    amount = Float.parseFloat(etAmount.getText().toString().replace(",", ""));
                    tipAmount = Float.parseFloat(etTip.getText().toString().replace(",", ""));
                    totalAmount = (amount + tipAmount);
                    //totalAmount = (Float.parseFloat(etAmount.getText().toString().replace(",", "")) + Float.parseFloat(etTip.getText().toString().replace(",", "")));
                }
                if (selectedCardReader == null) {
                    ToastUtils.makeSnackToast(getActivity(), "Please select reader");
                    return;
                }
                if (totalAmount > 0) {
                    long currentTime = SystemClock.elapsedRealtime();
                    if (currentTime - lastClickTime > MIN_CLICK_INTERVAL) {
                        lastClickTime = currentTime;
                        setUpMposTerminal();
                    }
                } else {
                    ToastUtils.makeSnackToast(getActivity(), "Amount should be greater than zero");
                }
            });
            btnCancel.setOnClickListener(view -> {
                if (etAmount.length() > 0) {
                    etAmount.getText().clear();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private boolean isValid() {
        return (!Validators.isNullOrEmpty(etAmount.getText().toString())) && selectedCardReader != null;
    }

    /**
     * Receive the result of our permissions check, and initialize if we can
     */
    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        // If we receive a response to our permission check, initialize
        if (requestCode == Constants.PERMISSION_CODE_LOCATION && verifyGpsEnabled()) {
            if (selectedCardReader.connectivity.toLowerCase().equalsIgnoreCase("internet")) {
                //    String url = ApiEndPoints.CARD_READER_PAYMENT + "?s_location_id=" + selectedCardReader.s_location_id + "&s_terminal_id=" + selectedCardReader.s_terminal_id + "&amount=" + (totalAmount * 100) + "&business_id=" + selectedBusiness.id;
                //    startActivityForResult(new Intent(getActivity(), InternetCardReaderPaymentActivity.class).putExtra("url", url), Constants.PAYMENT_WEBVIEW_CARDREADER);
                showStripeInternetReaderDialog();
            } else if (selectedCardReader.connectivity.toLowerCase().toLowerCase().equalsIgnoreCase("stripebluetooth") || selectedCardReader.connectivity.equalsIgnoreCase("posbluetooth") || selectedCardReader.connectivity.equalsIgnoreCase(TAPTOPAY)) {
                showStripeBluetoothReaderDialog();
            }
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        try {
            if (requestCode == Constants.PAYMENT_MPOS_CARDREADER) {
                boolean paymentSuccess = false;
                if (resultCode == MposUi.RESULT_CODE_APPROVED) {
                    paymentSuccess = true;
                    myApp.startPaymentSuccessSound();
                    ToastUtils.makeSnackToast(getActivity(), "Payment Approved");
                } else {
                    myApp.startPaymentFailedSound();
                    ToastUtils.makeSnackToast(getActivity(), "Transaction was declined, aborted, or failed");
                }
                //  etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount));

                try {
                    Transaction transaction = MposUi.getInitializedInstance().getTransaction();
                    if (transaction != null && paymentSuccess) {
                        createCardReaderPrint(transaction, paymentSuccess);
                    } else {
                        ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Failed response", "Transaction Cancelled", 2, "OKAY", null);
                        confirmationDialogFragment.show(getChildFragmentManager(), "dialog");
                    }

                } catch (Exception e) {
                    ToastUtils.makeLongToast(getActivity(), e.toString());
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Failed response", "Transaction Cancelled", 2, "OKAY", null);
                    confirmationDialogFragment.show(getChildFragmentManager(), "dialog");
                    e.printStackTrace();
                }
                resetBox();
            }
            if (requestCode == Constants.PAYMENT_WEBVIEW_CARDREADER) {
                if (data != null) {
                    //    etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount));
                    //     etTip.addTextChangedListener(new MoneyTextWatcher(etTip));

                    String status = data.getStringExtra("status");
                    if (Validators.isNullOrEmpty(status) || status.equalsIgnoreCase("0")) {
                        myApp.startPaymentFailedSound();
                        ToastUtils.makeSnackToast(getActivity(), "Transaction was declined, aborted, or failed");
                        return;
                    }

                    if (getActivity() != null) {
                        getActivity().runOnUiThread(() -> {
                            if (progressBarDialog == null)
                                progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
                            progressBarDialog.show();
                        });
                    }
                    String paymentIntentId = data.getStringExtra("payment_intent_id");
                    String client_secret = data.getStringExtra("client_secret");
                    retrivePaymentIntentAndPrint(client_secret);
                    resetBox();
                } else {

                    myApp.startPaymentFailedSound();
                    ToastUtils.makeSnackToast(getActivity(), "Transaction was declined, aborted, or failed");

                    resetBox();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void resetBox() {
        try {
            Thread.sleep(300);
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    etAmount.setText("0.00");
                    etTip.setText("0.00");
                    // etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount)); creating trouble
                    //  etTip.addTextChangedListener(new MoneyTextWatcher(etTip)); creating trouble
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void retrivePaymentIntentAndPrint(String clientSecret) {
        try {
            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                if (progressBarDialog == null) {
                    progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
                }
                progressBarDialog.show();
            });
            stripe.retrievePaymentIntent(clientSecret, new ApiResultCallback<PaymentIntent>() {
                @Override
                public void onSuccess(@NotNull PaymentIntent paymentIntent) {
                    try {
                        //com.stripe.Stripe.apiKey = stripe_private_key;
                        new Thread(() -> {
                            try {
                                //PaymentMethod paymentMethod = PaymentMethod.retrieve(paymentIntent.getPaymentMethodId());
                                PaymentMethod paymentMethod = paymentIntent.getPaymentMethod();
                                boolean paymentSuccess = paymentIntent.getStatus().toString().contains("succeeded");
                                ToastUtils.makeSnackToast(getActivity(), paymentSuccess ? "Payment Approved" : "Payment Declined");
                                if (paymentSuccess) myApp.startPaymentSuccessSound();
                                else myApp.startPaymentFailedSound();
                                if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                    printUsingPaymentIntent("Customer Copy", paymentIntent, paymentMethod.card != null ? paymentMethod.card.brand.getDisplayName() : "", paymentMethod.card != null ? paymentMethod.card.last4 : "", paymentSuccess);
                                });

                            } catch (Exception e) {
                                e.printStackTrace();
                                boolean paymentSuccess = paymentIntent.getStatus().toString().contains("succeeded");
                                ToastUtils.makeSnackToast(getActivity(), paymentSuccess ? "Payment Approved" : "Payment Declined");
                                if (paymentSuccess) myApp.startPaymentSuccessSound();
                                else myApp.startPaymentFailedSound();
                                if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                    printUsingPaymentIntent("Customer Copy", paymentIntent, "", "", paymentSuccess);
                                });
                            }
                            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                if (progressBarDialog == null) {
                                    progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
                                }
                                progressBarDialog.dismiss();
                            });
                        }).start();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                }

                @Override
                public void onError(@NotNull Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void retrivePaymentIntentAndPrintWithId(String clientSecret, String cardName, String number) {
        try {
            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                if (progressBarDialog == null) {
                    progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
                }
                progressBarDialog.show();
            });
            stripe.retrievePaymentIntent(clientSecret, new ApiResultCallback<PaymentIntent>() {
                @Override
                public void onSuccess(@NotNull PaymentIntent paymentIntent) {
                    try {
                        //com.stripe.Stripe.apiKey = stripe_private_key;
                        new Thread(() -> {
                            try {
                                boolean paymentSuccess = paymentIntent.getStatus().toString().contains("succeeded");
                                ToastUtils.makeSnackToast(getActivity(), paymentSuccess ? "Payment Approved" : "Payment Declined");
                                if (paymentSuccess) myApp.startPaymentSuccessSound();
                                else myApp.startPaymentFailedSound();
                                if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                    printUsingPaymentIntent("Customer Copy", paymentIntent, cardName != null ? cardName : "", number != null ? number : "", paymentSuccess);
                                });
                            } catch (Exception e) {
                                e.printStackTrace();
                                boolean paymentSuccess = paymentIntent.getStatus().toString().contains("succeeded");
                                ToastUtils.makeSnackToast(getActivity(), paymentSuccess ? "Payment Approved" : "Payment Declined");
                                if (paymentSuccess) myApp.startPaymentSuccessSound();
                                else myApp.startPaymentFailedSound();
                                if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                    printUsingPaymentIntent("Customer Copy", paymentIntent, "", "", paymentSuccess);
                                });
                            }
                            if (getActivity() != null) getActivity().runOnUiThread(() -> {
                                if (progressBarDialog == null) {
                                    progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
                                }
                                progressBarDialog.dismiss();
                            });
                        }).start();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                }

                @Override
                public void onError(@NotNull Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    String payment_type;
    String actualAmount;
    String tip_amount;
    String printTotal;
    String card;
    String account;
    String stripe_id;
    String entry_mode;
    String status;
    String please;
    String date_final;
    String main_content;
    String footerA;
    String footerB;

    /**
     * Print for Bluetooth BBPOS Card reader & Internet Cardreader
     */
    private void printUsingPaymentIntent(String title, PaymentIntent paymentIntent, String cardBrand, String cardNumber, boolean paymentSuccess) {

        try {
            new Thread(() -> addExternalPayment(paymentSuccess)).start();
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    if (progressBarDialog == null) {
                        progressBarDialog = CommonFunctions.customProgressDialog(getActivity());
                    }
                    progressBarDialog.dismiss();
                });
            }

            String payment_type = "PIN";
            if (ticketHeader != null) header = ticketHeader.value;
            if (address != null) resAddress = address.value;

            actualAmount = "£" + MyApp.df.format(amount);
            tip_amount = "Tip £" + MyApp.df.format(tipAmount);

            printTotal = "£" + MyApp.df.format(totalAmount);

            card = "Card                    " + cardBrand;
            account = "Account      " + cardNumber;
            stripe_id = "TID  " + paymentIntent.getId();
            entry_mode = "Entry Mode         " + payment_type;
            status = "Status            " + (paymentSuccess ? "Approved" : "Declined");
            please = "Please Retain Receipt\nFor Your Record";

            date_final = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy hh:mm:ss a");

            main_content = card + "\n" + account + "\n" + stripe_id + "\n" + entry_mode + "\n" + status + "\n";

            footerA = "";
            footerB = "";

            if (footerASetting != null) {
                footerA = footerASetting.value;
            }
            if (footerBSetting != null)
                footerB = footerBSetting.value;

            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                    printZonrich("Merchant Copy");
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("t2") || defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                    printSunmi("Merchant Copy");
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                        printCardReaderIMin("Merchant Copy");
                    } else {
                        if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                            printWifi("Merchant Copy");
                        } else {
                            try {
                                if (bluetoothPrinter != null) {
                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                    if (device != null) {
                                        printBT("Merchant Copy");
                                    } else {
                                        ToastUtils.makeSnackToast(getActivity(), "No bluetooth device found.");
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            } else {
                ToastUtils.makeLongToast(getActivity(), "No printer model found");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * MUIRA Cardreader payment print
     *
     * @param transaction
     * @param paymentSuccess
     */
    private void createCardReaderPrint(Transaction transaction, boolean paymentSuccess) {
        try {
            new Thread(() -> addExternalPayment(paymentSuccess)).start();
            payment_type = "" + transaction.getPaymentDetails().getCustomerVerification().name();
            if (payment_type.equals("PIN")) {
                payment_type = "EMV";
            } else {
                payment_type = "Contactless";
            }

            if (ticketHeader != null) header = ticketHeader.value;
            if (address != null) resAddress = address.value;

            actualAmount = "£" + MyApp.df.format(amount);
            tip_amount = "Tip £" + MyApp.df.format(tipAmount);

            printTotal = "£" + MyApp.df.format(totalAmount);

            card = "Card                    " + transaction.getPaymentDetails().getScheme().name();
            account = "Account      " + transaction.getPaymentDetails().getMaskedAccountNumber();
            stripe_id = "TID  " + transaction.getIdentifier();
            entry_mode = "Entry Mode         " + payment_type;
            status = "Status            " + (paymentSuccess ? "Approved" : "Declined");
            please = "Please Retain Receipt\nFor Your Record";

            date_final = CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy hh:mm:ss a");

            main_content = card + "\n" + account + "\n" + stripe_id + "\n" + entry_mode + "\n" + status + "\n";
            footerA = "";
            footerB = "";

            if (footerASetting != null) footerA = footerASetting.value;

            if (footerBSetting != null) footerB = footerBSetting.value;

            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                    printZonrich("Merchant Copy");
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("t2") || defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                    printSunmi("Merchant Copy");
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                        printCardReaderIMin("Merchant Copy");
                    } else {
                        if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                            printWifi("Merchant Copy");
                        } else {
                            try {
                                if (bluetoothPrinter != null) {
                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                    if (device != null) {
                                        printBT("Merchant Copy");
                                    } else {
                                        ToastUtils.makeSnackToast(getActivity(), "No bluetooth device found.");
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            } else {
                ToastUtils.makeLongToast(getActivity(), "No printer model found");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printCardReaderIMin(String title) {
        try {
            myApp.iMinPrinterUtils.printCardReaderReceipt(myApp.tiffintomLogoSmall, "", title, selectedBusiness.header_a, selectedBusiness.header_b, "", actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b);

            if (title.toLowerCase().contains("merchant")) {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Is Customer Copy required?", null, 0, "Confirm", "Cancel");
                confirmationDialogFragment.show(getChildFragmentManager(), "printer");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        if (((String) o).equalsIgnoreCase("confirm")) {
                            printCardReaderIMin("Customer Copy");
                        }
                    }
                });

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printZonrich(String title) {
        try {
            zoneRichPrinter.connectPrinter(defaultPrinter.ip);
            CommonFunctions.functionThatDelay(200);
            // comment and change by arbaz as need to change header and footer
            //zoneRichPrinter.printCardReaderReceipt(myApp.businessLogo,"", title, header, headerAlignment, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, footerA, footerB, myApp.myPreferences);
            if (title.toLowerCase().contains("merchant")) {
                if (selectedBusiness.auto_merchant_print != null && (selectedBusiness.auto_merchant_print.equalsIgnoreCase("true") || selectedBusiness.auto_merchant_print.equalsIgnoreCase("1"))) {
                    zoneRichPrinter.printCardReaderReceipt(myApp.businessLogo, "", title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, myApp.myPreferences);
                    printCustomerZoneRich(title);
                } else {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Is Merchant Copy required?", null, 0, "Confirm", "Cancel");
                    confirmationDialogFragment.show(getChildFragmentManager(), "printer");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                zoneRichPrinter.printCardReaderReceipt(myApp.businessLogo, "", title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, myApp.myPreferences);
                                printCustomerZoneRich(title);
                            } else {
                                printCustomerZoneRich(title);
                            }
                        }
                    });
                }
            } else {
                zoneRichPrinter.printCardReaderReceipt(myApp.businessLogo, "", title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, myApp.myPreferences);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void printCustomerZoneRich(String title) {
        if (title.toLowerCase().contains("merchant")) {
            if (selectedBusiness.auto_customer_print != null && (selectedBusiness.auto_customer_print.equalsIgnoreCase("true") || selectedBusiness.auto_customer_print.equalsIgnoreCase("1"))) {
                printZonrich("Customer Copy");
            } else {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Customer copy required?", null, 0, "Okay", "Cancel");
                confirmationDialogFragment.show(getChildFragmentManager(), "confirm");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                        printZonrich("Customer Copy");
                    }
                });
            }
        }
    }

    private void printSunmi(String title) {
        try {
            //sunmiPrinter.printCardReaderReceipt(myApp.businessLogo, "",title, header, headerAlignment, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, footerA, footerB, myPreferences);
            if (title.toLowerCase().contains("merchant")) {
                if (selectedBusiness.auto_merchant_print != null && (selectedBusiness.auto_merchant_print.equalsIgnoreCase("true") || selectedBusiness.auto_merchant_print.equalsIgnoreCase("1"))) {
                    if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                        sunmiPrinterV3Mix.printCardReaderReceipt(myApp.businessLogo, "", title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, myPreferences);
                    }else {
                        sunmiPrinter.printCardReaderReceipt(myApp.businessLogo, "", title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, myPreferences);
                    }
                    printCustomerSunmi(title);
                } else {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Is Merchant Copy required?", null, 0, "Confirm", "Cancel");
                    confirmationDialogFragment.show(getChildFragmentManager(), "printer");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String) {
                            if (((String) o).equalsIgnoreCase("confirm")) {
                                if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                                    sunmiPrinterV3Mix.printCardReaderReceipt(myApp.businessLogo, "", title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, myPreferences);
                                }else {
                                    sunmiPrinter.printCardReaderReceipt(myApp.businessLogo, "", title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, myPreferences);
                                }
                                printCustomerSunmi(title);
                            } else {
                                printCustomerSunmi(title);
                            }
                        }
                    });
                }
            } else {
                if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                    sunmiPrinterV3Mix.printCardReaderReceipt(myApp.businessLogo, "", title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, myPreferences);
                }else {
                    sunmiPrinter.printCardReaderReceipt(myApp.businessLogo, "", title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, myPreferences);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void printCustomerSunmi(String title) {
        if (title.toLowerCase().contains("merchant")) {
            if (selectedBusiness.auto_customer_print != null && (selectedBusiness.auto_customer_print.equalsIgnoreCase("true") || selectedBusiness.auto_customer_print.equalsIgnoreCase("1"))) {
                printSunmi("Customer Copy");
            } else {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Is Customer Copy required?", null, 0, "Confirm", "Cancel");
                confirmationDialogFragment.show(getChildFragmentManager(), "printer");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        if (((String) o).equalsIgnoreCase("confirm")) {
                            printSunmi("Customer Copy");
                        }
                    }
                });
            }
        }
    }

    private void printWifi(String title) {
        try {
            wifiPrinter.connect(defaultPrinter.ip);
            CommonFunctions.functionThatDelay(200);
            //fiPrinter.printCardReaderReceipt(myApp.businessLogo,"", title, header, headerAlignment, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, footerA, footerB, true, myPreferences);
            //wifiPrinter.printCardReaderReceipt(myApp.businessLogo,"", title, header, headerAlignment, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, footerA, footerB, true, myPreferences);
            wifiPrinter.printCardReaderReceipt(myApp.businessLogo, "", title, selectedBusiness.header_a, headerAlignment, selectedBusiness.header_b, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, true, myPreferences);

            if (title.toLowerCase().contains("merchant")) {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Is Customer Copy required?", null, 0, "Confirm", "Cancel");
                confirmationDialogFragment.show(getChildFragmentManager(), "printer");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        if (((String) o).equalsIgnoreCase("confirm")) {
                            printWifi("Customer Copy");
                        }
                    }
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void printBT(String title) {
        try {
            CommonFunctions.functionThatDelay(200);
            //bluetoothPrinter.printCardReaderReceipt(myApp.businessLogo, title, header, headerAlignment, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, footerA, footerB, true);
            bluetoothPrinter.printCardReaderReceipt(myApp.businessLogo, title, selectedBusiness.header_a, selectedBusiness.header_b, headerAlignment, actualAmount, tipAmount > 0 ? tip_amount : null, printTotal, main_content, please, date_final, selectedBusiness.footer_a, selectedBusiness.footer_b, true);
            if (title.toLowerCase().contains("merchant")) {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Is Customer Copy required?", null, 0, "Confirm", "Cancel");
                confirmationDialogFragment.show(getChildFragmentManager(), "printer");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        if (((String) o).equalsIgnoreCase("confirm")) {
                            printBT("Customer Copy");
                        }
                    }
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    public void onPause() {
        CommonFunctions.hideKeyboard(getActivity(), etAmount);
        super.onPause();
    }

    @Override
    public void onStop() {
        CommonFunctions.hideKeyboard(getActivity(), etAmount);
        super.onStop();
    }

    private void addExternalPayment(boolean paymentSuccess) {
        OrderExternalPayment orderExternalPayment = new OrderExternalPayment();
        orderExternalPayment.payment_method_name = "External Card Reader Payment";
        orderExternalPayment.payment_method_id = EXTERNAL_CARD_READER_PAYMENT;
        orderExternalPayment.amount = totalAmount;
        orderExternalPayment.updater_id = myPreferences.getLoggedInUser().id;
        orderExternalPayment.payment_status = paymentSuccess ? Constants.APPROVED : Constants.DECLINED;
        appDatabase.orderExternalPaymentDao().insert(orderExternalPayment);
        if(paymentSuccess){
            callExternalPaymentApi(orderExternalPayment);
        }
    }

    private void callExternalPaymentApi(OrderExternalPayment orderExternalPayment){
        AndroidNetworking.post(ApiEndPoints.external_payment)
                .addBodyParameter(orderExternalPayment)
                .build()
                .getAsJSONObject(new JSONObjectRequestListener() {
                    @Override
                    public void onResponse(JSONObject response) {

                    }

                    @Override
                    public void onError(ANError anError) {}
                });
    }
}