package com.ubsidi.epos_2021.fragment;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.button.MaterialButton;
import com.google.android.material.chip.Chip;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.activities.UploadOrdersActivity;
import com.ubsidi.epos_2021.adapters.MenuAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.interfaces.FragmentChangeListener;
import com.ubsidi.epos_2021.merchant.fragments.MerchantDashboardFragment;
import com.ubsidi.epos_2021.merchant.fragments.MerchantTransactionsFragment;
import com.ubsidi.epos_2021.merchant.fragments.PaymentLinkFragment;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.models.ExclusionModel;
import com.ubsidi.epos_2021.models.MerchantUserPermission;
import com.ubsidi.epos_2021.online.fragments.EnterPasswordDialogFragment;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.ArrayList;
import java.util.Objects;


public class PaymentFragment extends BaseFragment {
    private Chip chipBack;
    private RecyclerView rvPayments;
    private MaterialButton btnPayment;
    private ArrayList<ExclusionModel> paymentList = new ArrayList<>();
    private MenuAdapter menuAdapter;
    private int merchantRole = 0;
    private Business selectedBusiness = myPreferences.getLoggedInAdmin().selected_business;
    private MerchantUserPermission permission;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_payment, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initView(view);
            setUpPayments();
            btnPayment.setOnClickListener(view1 -> {
                try {
                    FragmentTransaction ft = getActivity().getSupportFragmentManager().beginTransaction();
                    ft.replace(R.id.nav_host_fragment, new PaymentLinkFragment(), "payment_sms");
                    ft.addToBackStack("can_go_back");
                    ft.commit();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            chipBack.setOnClickListener(v -> getActivity().onBackPressed());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MerchantDashboardFragment getInstanceMerchantDashboard(FragmentChangeListener changeListener) {
        MerchantDashboardFragment dashboardFragment = new MerchantDashboardFragment();
        dashboardFragment.changeListener = changeListener;
        return dashboardFragment;
    }

    private void initView(View view) {
        try {
            merchantRole = myPreferences.getMerchantRole();
            btnPayment = view.findViewById(R.id.btnPayment);
            rvPayments = view.findViewById(R.id.rvPayments);
            chipBack = view.findViewById(R.id.chipBack);

            menuAdapter = new MenuAdapter(paymentList, true, true, (position, data) -> {
                try {
                    ExclusionModel exclusionModel = (ExclusionModel) data;

                    if (exclusionModel.id.equalsIgnoreCase("overview")) {
                        changeFragment(getInstanceMerchantDashboard(id -> {
                            if (id.equalsIgnoreCase("transactions")) {
                                menuAdapter.checkedId = "transactions";
                                menuAdapter.notifyDataSetChanged();
                                changeFragment(getInstanceMerchantTransactions("normal"));
                            }
                            if (id.equalsIgnoreCase("statements")) {
                                menuAdapter.checkedId = "statements";
                                menuAdapter.notifyDataSetChanged();
                                changeFragment(new MerchantStatementFragment());
                            }

                        }));
                    }else if (exclusionModel.id.equalsIgnoreCase("qr_code")) {
                        changeFragment(new QRCodeFragment());
                    } else if (exclusionModel.id.equalsIgnoreCase("payment_link")) {
                        changeFragment(new PaymentLinkFragment());
                    } else if (exclusionModel.id.equalsIgnoreCase("moto_payment")) {
                        changeFragment(new PaymentMotoFragment());
                    } else if (exclusionModel.id.equalsIgnoreCase("card_reader_payment")) {
                        //   turnOnOffDeviceBluetooth();
                        changeFragment(new PaymentCardReaderFragment());
                    } else if (exclusionModel.id.equalsIgnoreCase("report")) {
                        changeFragment(new ReportListFragment());
                    } else if (exclusionModel.id.equalsIgnoreCase("transactions")) {
                        changeFragment(getInstanceMerchantTransactions("normal"));
                    } else if (exclusionModel.id.equalsIgnoreCase("refunded_transactions")) {
                        changeFragment(getInstanceMerchantTransactions("refunded"));
                    } else if (exclusionModel.id.equalsIgnoreCase("archived_transactions")) {
                        changeFragment(getInstanceMerchantTransactions("archived"));
                    } else if (exclusionModel.id.equalsIgnoreCase("statements")) {
                        changeFragment(new MerchantStatementFragment());
                    } else if (exclusionModel.id.equalsIgnoreCase("logout")) {
                        askForLogout();
                    } else if (exclusionModel.id.equalsIgnoreCase("login")) {
                        passwordFragment();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }

            });

            rvPayments.setLayoutManager(new LinearLayoutManager(getActivity(), LinearLayoutManager.VERTICAL, false));
            rvPayments.setAdapter(menuAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void turnOnOffDeviceBluetooth() {
        try {
            BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            if (bluetoothAdapter.isEnabled()) {
                bluetoothAdapter.disable();
                // ToastUtils.makeToast(getActivity(), "BLUETOOTH TURNED OFF.");
            }
            new Handler(Objects.requireNonNull(Looper.myLooper()))
                    .postDelayed(() -> {
                        if (!bluetoothAdapter.isEnabled()) {
                            bluetoothAdapter.enable();
                            //   ToastUtils.makeToast(getActivity(), "BLUETOOTH TURNED ON.");
                        }
                    }, 1000);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean ordersUploaded = false;

    private void uploadOrders() {
        ToastUtils.makeSnackToast(getActivity(), "Please wait, Report will generate after orders uploading");
        startActivityForResult(new Intent(getActivity(), UploadOrdersActivity.class).putExtra("finish", true), Constants.CODE_REFRESH);
    }

    private void askForLogout() {
        try {
            ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Logout", "Are you sure you want to logout?", 0, "Confirm", "Cancel");
            confirmationDialogFragment.show(getChildFragmentManager(), "logout");
            confirmationDialogFragment.setDialogDismissListener(o -> {
                if (o instanceof String) {
                    if (((String) o).equalsIgnoreCase("confirm")) {
                        myPreferences.saveMerchantRole(0);
                        setUpPayments();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void passwordFragment() {
        try {
            EnterPasswordDialogFragment enterPasswordDialogFragment = myApp.getInstanceEnterPassword(null, "Enter password", "Please enter password to login");
            enterPasswordDialogFragment.show(getChildFragmentManager(), "password");
            enterPasswordDialogFragment.setDialogDismissListener(o -> {
                try {
                    if (o instanceof String) {
                        String password = (String) o;
                        if (password.equals(selectedBusiness.admin_password)) {
                            myPreferences.saveMerchantRole(2);
                            merchantRole = 2;
                            setUpPayments();
                            ToastUtils.makeSnackToast(getActivity(), "Login successful");
                        } else if (password.equals(selectedBusiness.supervisor_password)) {
                            myPreferences.saveMerchantRole(1);
                            merchantRole = 1;
                            setUpPayments();
                            ToastUtils.makeSnackToast(getActivity(), "Login successful");
                        } else {
                            ToastUtils.makeSnackToast(getActivity(), "Invalid password");
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void setUpPayments() {
        try {
            merchantRole = myPreferences.getMerchantRole();
            if (merchantRole == 1) {
                permission = selectedBusiness.supervisor_permissions;
            } else if (merchantRole == 2) {
                permission = selectedBusiness.admin_permissions;
            } else {
                permission = null;
            }
            paymentList.clear();

            ExclusionModel exclusionModel = new ExclusionModel();
            if (selectedBusiness.merchant_service) {
                if (merchantRole > 0 || (MyApp.userPermission.payment_overview != null && MyApp.userPermission.payment_overview.actions.list)) { // Firebase crash handled
                    exclusionModel.id = "overview";
                    exclusionModel.name = "Overview";
                    exclusionModel.isCheckable = true;
                    exclusionModel.isChecked = true;
                    paymentList.add(exclusionModel);
                }

                exclusionModel = new ExclusionModel();
                exclusionModel.id = "payment_link";
                exclusionModel.name = "Payment Link";
                exclusionModel.isCheckable = true;
                exclusionModel.isChecked = true;
                paymentList.add(exclusionModel);

                exclusionModel = new ExclusionModel();
                exclusionModel.id = "qr_code";
                exclusionModel.name = "QR CODE";
                exclusionModel.isCheckable = true;
                exclusionModel.isChecked = true;
                paymentList.add(exclusionModel);

                if (merchantRole == 0 || (permission != null && permission.moto_service)) {
                    exclusionModel = new ExclusionModel();
                    exclusionModel.id = "moto_payment";
                    exclusionModel.name = "Moto payment";
                    exclusionModel.isCheckable = true;
                    paymentList.add(exclusionModel);
                }
                if (merchantRole == 0 || (permission != null && permission.payworks)) {
                    exclusionModel = new ExclusionModel();
                    exclusionModel.id = "card_reader_payment";
                    exclusionModel.name = "Card reader payment";
                    exclusionModel.isCheckable = true;
                    paymentList.add(exclusionModel);
                }

                if ((permission != null && permission.archive_list)) {
                    exclusionModel = new ExclusionModel();
                    exclusionModel.id = "archived_transactions";
                    exclusionModel.name = "Archived Transactions";
                    exclusionModel.isCheckable = true;
                    paymentList.add(exclusionModel);
                }

                if ((permission != null && permission.refund_list)) {
                    exclusionModel = new ExclusionModel();
                    exclusionModel.id = "refunded_transactions";
                    exclusionModel.name = "Refunded transactions";
                    exclusionModel.isCheckable = true;
                    paymentList.add(exclusionModel);
                }
                if (merchantRole > 0 || MyApp.userPermission.transaction_list.actions.list) {
                    exclusionModel = new ExclusionModel();
                    exclusionModel.id = "transactions";
                    exclusionModel.name = "Transactions";
                    exclusionModel.isCheckable = true;
                    paymentList.add(exclusionModel);
                }

                if (permission != null && permission.statement) {
                    exclusionModel = new ExclusionModel();
                    exclusionModel.id = "statements";
                    exclusionModel.name = "Statements";
                    exclusionModel.isCheckable = true;
                    paymentList.add(exclusionModel);
                }
            }

            exclusionModel = new ExclusionModel();
            exclusionModel.id = "report";
            exclusionModel.name = "Report";
            exclusionModel.isCheckable = true;
            paymentList.add(exclusionModel);

            if (selectedBusiness.merchant_service) {
                if (myPreferences.getMerchantRole() == 0) {
                    exclusionModel = new ExclusionModel();
                    exclusionModel.id = "login";
                    exclusionModel.name = "Login";
                    exclusionModel.isCheckable = false;
                    paymentList.add(exclusionModel);
                } else {
                    exclusionModel = new ExclusionModel();
                    exclusionModel.id = "logout";
                    exclusionModel.name = "Logout";
                    exclusionModel.isCheckable = false;
                    paymentList.add(exclusionModel);
                }
            }
            if (selectedBusiness.merchant_service) {
                if (merchantRole > 0 || (MyApp.userPermission.payment_overview != null && MyApp.userPermission.payment_overview.actions.list)) { // Firebase crash handled
                    menuAdapter.checkedId = "overview";
                    menuAdapter.notifyDataSetChanged();

                    changeFragment(getInstanceMerchantDashboard(id -> {
                        if (id.equalsIgnoreCase("transactions")) {
                            menuAdapter.checkedId = "transactions";
                            menuAdapter.notifyDataSetChanged();
                            changeFragment(getInstanceMerchantTransactions("normal"));
                        }
                        if (id.equalsIgnoreCase("statements")) {
                            menuAdapter.checkedId = "statements";
                            menuAdapter.notifyDataSetChanged();
                            changeFragment(new MerchantStatementFragment());
                        }
                    }));
                } else {
                    menuAdapter.checkedId = paymentList.get(0).id;
                    menuAdapter.notifyDataSetChanged();

                    if (menuAdapter.checkedId.equalsIgnoreCase("moto_payment")) {
                        changeFragment(new PaymentMotoFragment());
                    } else if (menuAdapter.checkedId.equalsIgnoreCase("card_reader_payment")) {
                        changeFragment(new PaymentCardReaderFragment());
                    } else if (menuAdapter.checkedId.equalsIgnoreCase("payment_link")) {
                        changeFragment(new PaymentLinkFragment());
                    }
                }
            } else {
                menuAdapter.checkedId = "report";
                changeFragment(new ReportListFragment());
            }
            menuAdapter.notifyDataSetChanged();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void changeFragment(Fragment fragment) {
        try {
            FragmentManager manager = getChildFragmentManager();
            FragmentTransaction transaction = manager.beginTransaction();
            transaction.replace(R.id.nav_payment_fragment, fragment);
            transaction.addToBackStack("can_go_back");
            transaction.commit();
            getActivity().invalidateOptionsMenu();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable @org.jetbrains.annotations.Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        try {
            if (requestCode == Constants.CODE_REFRESH) {
                if (resultCode == Activity.RESULT_OK) {
                    ordersUploaded = true;
                    changeFragment(new ReportListFragment());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MerchantTransactionsFragment getInstanceMerchantTransactions(String type) {
        MerchantTransactionsFragment fragment = new MerchantTransactionsFragment();
        Bundle bundle = new Bundle();
        bundle.putString("type", type);
        fragment.setArguments(bundle);
        return fragment;
    }
}