package com.ubsidi.epos_2021.fragment;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.button.MaterialButton;
import com.google.gson.Gson;
import com.ubsidi.R;
import com.ubsidi.epos_2021.Links;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.adapters.PaymentMethodSelectionAdapter;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.daos.relations.OrderWithItems;
import com.ubsidi.epos_2021.merchant.fragments.PaymentLinkFragment;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.models.Discount;
import com.ubsidi.epos_2021.models.Order;
import com.ubsidi.epos_2021.models.OrderSplit;
import com.ubsidi.epos_2021.models.PaymentMethod;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.ToastUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class PaymentMethodSelectionFragment extends BaseFragment {

    private RecyclerView rvPaymentMethods;
    private View overlay;
    private LinearLayout llDiscount, llGratuity, llServiceCharge, llDelivery, llMainLayout, llCustomerInfo;
    private TextView tvGratuity, tvServiceCharge, tvDelivery, tvSubtotal, tvDiscount, tvGrandTotal, tvBalance, tvcustomer_detail, tvcustomer_contact;
    private MaterialButton btnPay;
    private LinearLayout llExpand, llGrandTotal;
    private ImageView ivExpand;

    private Float paidAmount, orderTotal, remainingBalance;
    private Order order;
    private PaymentMethodSelectionAdapter paymentAdapter;
    private ArrayList<PaymentMethod> paymentMethods = new ArrayList<>();
    private ArrayList<Object> objects = new ArrayList<>();
    public Business selectedBusiness;
    String order_id, order_split_id;
    int _order_id, _order_split_id;

    private PaymentMethod paymentMethod;
    private TextView tvGratuityText, tvServiceChargeText, tvDiscountText;
    private float cartGrandTotal = 0, cartSubTotal = 0, cartDiscount = 0, cartGratuity = 0, cartServiceCharge = 0;
    private boolean serviceChargeAutoMode = true, serviceChargeEnabled = false, serviceChargeVisible = false, discountEnabled = true, autoDiscountApplied = false;
    private SiteSetting serviceChargeSetting;
    private SiteSetting serviceChargeTypeSetting;
    private String selectedMethodId;

    @Override
    protected void manageIntents() {
        super.manageIntents();
        if (getArguments() != null) {
            _order_id = getArguments().getInt("_order_id");
            order_id = getArguments().getString("order_id");
            order_split_id = getArguments().getString("order_split_id");
            _order_split_id = getArguments().getInt("_order_split_id");
            paidAmount = getArguments().getFloat("paid_amount", 0);
            orderTotal = getArguments().getFloat("order_total");
        }
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (myPreferences.getLoggedInAdmin() != null)
            selectedBusiness = myPreferences.getLoggedInAdmin().selected_business;

        return inflater.inflate(R.layout.fragment_order_review_payment_selection, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            if (savedInstanceState != null) return;
            initViews(view);
            setListeners();
            fetchOffline();
            myApp.notifyCart(getActivity(), new Intent(Constants.FRAGMENT_CHANGE).putExtra("can_edit", true));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initViews(View view) {
        try {
            llMainLayout = view.findViewById(R.id.llMainLayout);
            llCustomerInfo = view.findViewById(R.id.llCustomerInfo);
            llDelivery = view.findViewById(R.id.ll_Delivery);
            llGratuity = view.findViewById(R.id.ll_Gratuity);
            llServiceCharge = view.findViewById(R.id.ll_ServiceCharge);
            llDiscount = view.findViewById(R.id.ll_Discount);
            llGrandTotal = view.findViewById(R.id.llGrandTotal);
            llExpand = view.findViewById(R.id.llExpandable);
            ivExpand = view.findViewById(R.id.ivExpand);
            tvSubtotal = view.findViewById(R.id.tvSubtotal);
            tvDelivery = view.findViewById(R.id.tvDelivery);
            tvGratuity = view.findViewById(R.id.tvGratuity);
            tvcustomer_detail = view.findViewById(R.id.tvcustomer_detail);
            tvcustomer_contact = view.findViewById(R.id.tvcustomer_contact);
            tvServiceCharge = view.findViewById(R.id.tvServiceFee);
            tvDiscount = view.findViewById(R.id.tvDiscount);
            tvGrandTotal = view.findViewById(R.id.tvGrandTotal);
            tvBalance = view.findViewById(R.id.tvBalance);
            btnPay = view.findViewById(R.id.btnPay);
            rvPaymentMethods = view.findViewById(R.id.rvPaymentMethods);
            tvDiscountText = view.findViewById(R.id.tvDiscountText);
            tvServiceChargeText = view.findViewById(R.id.tvServiceText);
            tvGratuityText = view.findViewById(R.id.tvGratuityText);
            overlay = view.findViewById(R.id.overlay);
            SiteSetting serviceChargeEnableSetting = myApp.findSetting("is_service_charge");
            serviceChargeSetting = myApp.findSetting("service_charge");
            SiteSetting serviceChargeOptionSetting = myApp.findSetting("service_charge_type_option");
            serviceChargeTypeSetting = myApp.findSetting("service_charge_type");

            if (serviceChargeEnableSetting != null && (serviceChargeEnableSetting.value.equalsIgnoreCase("true") || serviceChargeEnableSetting.value.equalsIgnoreCase("1"))) {
                serviceChargeEnabled = true;
                serviceChargeVisible = true;
            }
            if (serviceChargeEnabled && serviceChargeOptionSetting != null && serviceChargeOptionSetting.value.equalsIgnoreCase("manual")) {
                serviceChargeAutoMode = false;
            }
            btnPay.setEnabled(false);
            llExpand.setVisibility(View.GONE);

            setAdapters();

            setUpPaymentMethods();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setAdapters() {
        try {
            paymentAdapter = new PaymentMethodSelectionAdapter(objects, (position, data) -> {
                try {
                    if (data instanceof PaymentMethod) {
                        PaymentMethod method = (PaymentMethod) data;
                        // handleFragments(paymentMethod);
                        paymentMethod = method;
                        btnPay.setEnabled(remainingBalance > 0);
                        selectedMethodId = paymentMethod.id;
                        btnPay.performClick();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            rvPaymentMethods.setLayoutManager(new LinearLayoutManager(getActivity(), LinearLayoutManager.VERTICAL, false));
            rvPaymentMethods.setAdapter(paymentAdapter);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateViews() {
        try {
            cartSubTotal = order.sub_total;
            cartDiscount = order.discount;
            cartGratuity = order.gratuity;
            cartGrandTotal = ((cartSubTotal + cartGratuity + cartServiceCharge + order.delivery_charge) - cartDiscount);
            cartServiceCharge = order.service_charge;
            tvSubtotal.setText(MyApp.currencySymbol + MyApp.df.format(cartSubTotal));
            tvGrandTotal.setText(MyApp.currencySymbol + MyApp.df.format(cartGrandTotal));

            if (order.discount > 0) {
                llDiscount.setVisibility(View.VISIBLE);
                tvDiscount.setText(MyApp.currencySymbol + MyApp.df.format(order.discount));
                tvDiscountText.setClickable(false);
                //            if (autoDiscountApplied) {
                //                tvDiscountText.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
                //
                //            } else {
                //                tvDiscountText.setClickable(true);
                //                tvDiscountText.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_baseline_green_close_18, 0, 0, 0);
                //            }
            } else {
                llDiscount.setVisibility(View.GONE);
            }
            if (order.gratuity > 0) {
                llGratuity.setVisibility(View.VISIBLE);
                tvGratuity.setText(MyApp.currencySymbol + MyApp.df.format(order.gratuity));
                tvGratuityText.setClickable(false);
                //            tvGratuityText.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_baseline_green_close_18, 0, 0, 0);
            } else {
                llGratuity.setVisibility(View.GONE);
            }
            if (order.service_charge > 0) {
                llServiceCharge.setVisibility(View.VISIBLE);
                tvServiceCharge.setText(MyApp.currencySymbol + MyApp.df.format(order.service_charge));
                tvServiceChargeText.setClickable(false);
                //            if (serviceChargeAutoMode) {
                //                tvServiceChargeText.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
                //            } else {
                //                tvServiceChargeText.setClickable(true);
                //                tvServiceChargeText.setCompoundDrawablesWithIntrinsicBounds(R.drawable.ic_baseline_green_close_18, 0, 0, 0);
                //            }
            } else {
                llServiceCharge.setVisibility(View.GONE);
            }
            if (order.delivery_charge > 0) {
                llDelivery.setVisibility(View.VISIBLE);
                tvDelivery.setText(MyApp.currencySymbol + MyApp.df.format(order.delivery_charge));

                String customer_address = order.customer.house_no + " ," + order.customer.street + " ," + order.customer.country;
                tvcustomer_detail.setText("" + customer_address);

                String customer_contact = order.customer.name + " (" + order.customer.mobile + ")";
                tvcustomer_contact.setText("" + customer_contact);

                llCustomerInfo.setVisibility(View.VISIBLE);

            } else {
                llDelivery.setVisibility(View.GONE);
                llCustomerInfo.setVisibility(View.GONE);
            }

            if (Float.parseFloat(MyApp.df.format(orderTotal - order.total_paid)) == 0) {
                btnPay.setEnabled(false);
            }
            tvBalance.setText("Balance Remaining: " + MyApp.currencySymbol + MyApp.df.format(remainingBalance));
            btnPay.setEnabled(paymentMethod != null && remainingBalance > 0);

            // Disable views if payment done already by person
            if (remainingBalance > 0) {
                overlay.setVisibility(View.GONE);
            } else {
                overlay.setVisibility(View.VISIBLE);
            }

            paymentAdapter.selectedMethod = selectedMethodId;
            paymentAdapter.notifyDataSetChanged();
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    private void setUpPaymentMethods() {
        try {
            paymentMethods.clear();
            objects.clear();
            List<String> ids = new ArrayList<>();
            if (myApp.isConnected(getActivity())) {
                ids.add("2");
                if (selectedBusiness.merchant_service) {
                    ids.add("9");
                    ids.add("10");
                }
                new Thread(() -> {
                    try {
                        ArrayList<PaymentMethod> pMethods = new ArrayList<>(appDatabase.paymentMethodDao().list(ids));
                        PaymentMethod cashPaymentMethod = appDatabase.paymentMethodDao().view("1");
                        PaymentMethod chequePaymentMethod = appDatabase.paymentMethodDao().view("3");
                        if (cashPaymentMethod != null && !cashPaymentMethod.disabled)  // firebase crash handled
                            paymentMethods.add(new PaymentMethod("1", "Cash"));
                        if (pMethods.size() > 0) {
                            paymentMethods.add(new PaymentMethod("cc", "Card"));
                        }
                        if (cashPaymentMethod != null && !chequePaymentMethod.disabled)// firebase crash handled
                        {
                            paymentMethods.add(new PaymentMethod("3", "Cheque"));
                        }
                        if (_order_split_id == 0) {
                            //  paymentMethods.add(new PaymentMethod("4", "Payment Link"));
                        }
                        objects.addAll(paymentMethods);
                        getActivity().runOnUiThread(() -> {
                            paymentAdapter.notifyDataSetChanged();
                        });
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }).start();

            } else {
                // Added card option in Manual or no internet mode
                paymentMethods.add(new PaymentMethod("1", "Cash"));
                ids.add("2");
                if (selectedBusiness.merchant_service) {
                    ids.add("9");
                    ids.add("10");
                }
                new Thread(() -> {
                    try {
                        ArrayList<PaymentMethod> pMethods = new ArrayList<>(appDatabase.paymentMethodDao().list(ids));
                        if (pMethods.size() > 0) {
                            paymentMethods.add(new PaymentMethod("cc", "Card"));
                        }
                        objects.addAll(paymentMethods);
                        getActivity().runOnUiThread(() -> {
                            paymentAdapter.notifyDataSetChanged();
                        });
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }).start();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {
        try {
            btnPay.setOnClickListener(v -> {
                if (paymentMethod == null) {
                    ToastUtils.showSnackBar(getActivity(), llMainLayout, "Please select payment method first");
                } else {
                    myApp.notifyCart(getActivity(), new Intent(Constants.FRAGMENT_CHANGE).putExtra("can_edit", false));
                    // 4 = Payment link
                    if (!paymentMethod.id.equalsIgnoreCase("4")) {
                        changeFragment(new AmountSelectionFragment(), paymentMethod);
                    } else {
                        changeFragment(new PaymentLinkFragment(), paymentMethod);
                    }
                }
            });

            tvDiscountText.setOnClickListener(v -> {
                cartDiscount = 0;
                new UpdateOrderAsyncTask(() -> {
                    fetchOffline();
                    ToastUtils.showSnackBar(getActivity(), llMainLayout, "Discount has been removed", "remove");
                    return null;
                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            });
            tvServiceChargeText.setOnClickListener(v -> {
                cartServiceCharge = 0;
                new UpdateOrderAsyncTask(() -> {
                    fetchOffline();
                    ToastUtils.showSnackBar(getActivity(), llMainLayout, "Service charge has been removed", "remove");
                    return null;
                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            });

            tvGratuityText.setOnClickListener(v -> {
                cartGratuity = 0;
                new UpdateOrderAsyncTask(() -> {
                    fetchOffline();
                    ToastUtils.showSnackBar(getActivity(), llMainLayout, "Gratuity has been removed", "remove");
                    return null;
                }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
            });

            llGrandTotal.setOnClickListener(view -> {
                if (llExpand.getVisibility() == View.VISIBLE) {
                    ivExpand.setRotation(90);
                    llExpand.setVisibility(View.GONE);
                } else {
                    ivExpand.setRotation(270);
                    llExpand.setVisibility(View.VISIBLE);
                }

            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private class UpdateOrderAsyncTask extends AsyncTask<Object, Object, Object> {
        Callable<Void> nextMethod;

        public UpdateOrderAsyncTask(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected Object doInBackground(Object... objects) {
            try {
                order.sub_total = myApp.appDatabase.orderDao().getItemSubTotal(order._id);

                cartSubTotal = order.sub_total;
                if (serviceChargeEnabled) {
                    if (serviceChargeAutoMode && !order.is_auto_service_charge_remove) {
                        float serviceChargeValue = Float.parseFloat(serviceChargeSetting.value);
                        if (serviceChargeTypeSetting.value.equalsIgnoreCase("flat")) {
                            cartServiceCharge = serviceChargeValue;
                        } else {
                            if (serviceChargeValue > 0) {
                                cartServiceCharge = cartSubTotal * serviceChargeValue / 100;
                            } else {
                                cartServiceCharge = 0;
                            }
                        }
                    }
                } else {
                    serviceChargeEnabled = false;
                    cartServiceCharge = 0;
                }

                if (discountEnabled) {
                    List<Discount> discounts = appDatabase.discountDao().eligibleDiscounts("%" + myApp.current_day + "%", "%" + order.order_type_id + "%", order.sub_total, CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"), CommonFunctions.getCurrentTimeFormatted("yyyy-MM-dd"));
                    if (discounts.size() > 0) {
                        Discount appliedDiscount = discounts.get(0);
                        autoDiscountApplied = false;
                        if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("flat")) {
                            if (cartSubTotal > 0)
                                cartDiscount = appliedDiscount.discount;
                            else cartDiscount = 0;
                            autoDiscountApplied = true;
                        }
                        if (!Validators.isNullOrEmpty(appliedDiscount.discount_type) && appliedDiscount.discount_type.equalsIgnoreCase("percentage")) {
                            if (cartSubTotal > 0)
                                cartDiscount = cartSubTotal * appliedDiscount.discount / 100;
                            else cartDiscount = 0;
                            autoDiscountApplied = true;
                        }
                    } else {
                        if (autoDiscountApplied) cartDiscount = 0;
                    }
                }

                order.gratuity = cartGratuity;
                order.discount = cartDiscount;
                order.service_charge = cartServiceCharge;
                order.total = ((order.sub_total + order.gratuity + order.service_charge + order.delivery_charge) - order.discount);
                //cartGrandTotal = ((cartSubTotal + cartGratuity + cartServiceCharge + order.delivery_charge) - cartDiscount);
                order.total = cartGrandTotal;
                if (!order.order_status_id.equalsIgnoreCase("5") && !order.order_status_id.equalsIgnoreCase("10")) {
                    order.updated_at = CommonFunctions.convertMsToDesiredFormat(System.currentTimeMillis(), Constants.PHP_DATE_TIME_FORMAT_ZULU);
                }
                appDatabase.orderDao().update(order);
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Object s) {
            super.onPostExecute(s);
            if (nextMethod != null) {
                try {
                    nextMethod.call();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }


    private void fetchOffline() {
        new FetchOrderOfflineAsyncTask(() -> {
            updateViews();
            return null;
        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR);
    }

    private class FetchOrderOfflineAsyncTask extends AsyncTask<Object, Object, Object> {
        Callable<Void> nextMethod;

        public FetchOrderOfflineAsyncTask(Callable<Void> nextMethod) {
            this.nextMethod = nextMethod;
        }

        @Override
        protected Object doInBackground(Object... objects) {
            try {
                OrderWithItems orderWithItems = myApp.appDatabase.orderDao().orderWithItems(_order_id);
                if (orderWithItems != null) {
                    order = orderWithItems.order;
                    if (_order_split_id > 0) {
                        OrderSplit orderSplit = appDatabase.orderSplitDao().view(_order_split_id);
                        orderTotal = orderSplit.total;
                        paidAmount = appDatabase.orderPaymentDao().getSplitTotalPaidAmount(_order_id, _order_split_id);
                    } else {
                        orderTotal = order.total;
                        paidAmount = order.total_paid;
                    }
                    remainingBalance = orderTotal - paidAmount;

                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("1")) {
                        order.order_type = "Dine in";
                    }
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("2")) {
                        order.order_type = "Collection";
                    }
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("3")) {
                        order.order_type = "Delivery";
                    }
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("4")) {
                        order.order_type = "Bar";
                    }
                    if (order.order_type_id != null && order.order_type_id.equalsIgnoreCase("5")) {
                        order.order_type = "Waiting";
                    }
                    Log.e("Order_type", " " + order.order_type);
                    if (serviceChargeVisible) {
                        SiteSetting services_charges = myApp.findSetting("service_charge_order_type");
                        List<String> split_funcation = Links.split_funcation(services_charges.value);
                        for (int i = 0; i < split_funcation.size(); i++) {
                            if (order.order_type.equalsIgnoreCase(split_funcation.get(i).toString())) {
                                serviceChargeEnabled = true;
                                break;
                            } else {
                                serviceChargeEnabled = false;
                            }
                        }

                    }

                    if (order.service_charge == 0) {
                        if (serviceChargeEnabled) {
                            if (serviceChargeAutoMode && !order.is_auto_service_charge_remove) {
                                float serviceChargeValue = Float.parseFloat(serviceChargeSetting.value);
                                if (serviceChargeTypeSetting.value.equalsIgnoreCase("flat")) {
                                    cartServiceCharge = serviceChargeValue;
                                } else {
                                    if (serviceChargeValue > 0) {
                                        cartServiceCharge = cartSubTotal * serviceChargeValue / 100;
                                    } else {
                                        cartServiceCharge = 0;
                                    }
                                }
                            }
                        } else {
                            cartServiceCharge = 0;
                        }
                    } else {
                        cartServiceCharge = order.service_charge;
                    }
                    if (order.split_type != null && order.split_type.equalsIgnoreCase("order_item")) {
                        cartServiceCharge = 0;
                        //  serviceChargeEnabled = false;
                        discountEnabled = false;
                    }

                    order.customer = myApp.appDatabase.customerDao().view(order._customer_id);
                    if (order.customer == null) {
                        order.customer = appDatabase.customerDao().view(order.customer_id);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Object s) {
            super.onPostExecute(s);
            if (order != null)
                if (nextMethod != null) {
                    try {
                        nextMethod.call();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
        }
    }

    private void changeFragment(Fragment fragment, PaymentMethod paymentMethod) {
        try {
            FragmentManager manager = getActivity().getSupportFragmentManager();
            if (getArguments() != null) {
                getArguments().putString("payment_method", new Gson().toJson(paymentMethod));
                fragment.setArguments(getArguments());
            }
            FragmentTransaction transaction = manager.beginTransaction();
            transaction.replace(R.id.flContainer, fragment);
            transaction.addToBackStack("can_go_back");
            transaction.commitAllowingStateLoss();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance(getActivity()).registerReceiver(eposOrderUpdateReceiver, new IntentFilter(Constants.EPOS_ORDER_UPDATE));
    }

    @Override
    public void onStop() {
        super.onStop();
        if (eposOrderUpdateReceiver != null)
            LocalBroadcastManager.getInstance(getActivity()).unregisterReceiver(eposOrderUpdateReceiver);
    }

    BroadcastReceiver eposOrderUpdateReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (intent.getBooleanExtra("refresh", false)) {
                    if (intent.hasExtra("_order_split_id")) {
                        _order_split_id = intent.getIntExtra("_order_split_id", 0);
                        getArguments().putInt("_order_split_id", _order_split_id);
                    }
                    fetchOffline();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
}
