package com.ubsidi.epos_2021.fragment;

import static com.ubsidi.epos_2021.utils.Constants.EXTERNAL_MOTO_PAYMENT;

import android.bluetooth.BluetoothDevice;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;

import com.androidnetworking.AndroidNetworking;
import com.androidnetworking.error.ANError;
import com.androidnetworking.interfaces.JSONObjectRequestListener;
import com.google.android.material.button.MaterialButton;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.PaymentIntentResult;
import com.stripe.android.Stripe;
import com.stripe.android.model.CardParams;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.Token;
/*import com.stripe.exception.StripeException;
import com.stripe.model.Charge;*/
import com.ubsidi.BuildConfig;
import com.ubsidi.R;
import com.ubsidi.epos_2021.MyApp;
import com.ubsidi.epos_2021.base.BaseFragment;
import com.ubsidi.epos_2021.comman.CommonFunctions;
import com.ubsidi.epos_2021.comman.MoneyTextWatcher;
import com.ubsidi.epos_2021.comman.Validators;
import com.ubsidi.epos_2021.comman.bluetoothprinter.BluetoothPrinter;
import com.ubsidi.epos_2021.comman.ccwatchers.CreditCardEditText;
import com.ubsidi.epos_2021.comman.ccwatchers.OtherCardTextWatcher;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinter;
import com.ubsidi.epos_2021.comman.printer.SunmiPrinterV3Mix;
import com.ubsidi.epos_2021.comman.printer.WifiPrinter;
import com.ubsidi.epos_2021.comman.printer.ZoneRichPrinter;
import com.ubsidi.epos_2021.models.ApiError;
import com.ubsidi.epos_2021.models.Business;
import com.ubsidi.epos_2021.models.OrderExternalPayment;
import com.ubsidi.epos_2021.models.Printer;
import com.ubsidi.epos_2021.models.SiteSetting;
import com.ubsidi.epos_2021.network.ApiEndPoints;
import com.ubsidi.epos_2021.utils.Constants;
import com.ubsidi.epos_2021.utils.LogUtils;
import com.ubsidi.epos_2021.utils.ToastUtils;

import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;


public class PaymentMotoFragment extends BaseFragment {
    private ZoneRichPrinter zoneRichPrinter;
    private SunmiPrinter sunmiPrinter;
    private SunmiPrinterV3Mix sunmiPrinterV3Mix;
    private WifiPrinter wifiPrinter;
    protected AlertDialog progressDialog;
    private CreditCardEditText etCardNumber;
    private EditText etCardHolderName, etAmount, etCVV, etExpiryDate, etTip;
    private MaterialButton btnCancel, btnPaynow;
    final long MIN_CLICK_INTERVAL = 25000; //in millis
    long lastClickTime = 0;
    private Stripe stripe;
    private float totalAmount;
    private String description;
    private String descriptor;
    private String stripe_secret_key;
    private Printer defaultPrinter;
    public BluetoothPrinter bluetoothPrinter;
    private Business selectedBusiness;
    private int headerAlignment = 0;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_payment_moto, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            initViews(view);
            setListeners();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private void initViews(View view) {
        try {
            selectedBusiness = myPreferences.getLoggedInAdmin().selected_business;
            defaultPrinter = myPreferences.getDefaultPrinter();
            String stripeMode = selectedBusiness.stripe_mode;

            zoneRichPrinter = new ZoneRichPrinter(getActivity());
            zoneRichPrinter = myApp.connectZonerich(zoneRichPrinter, defaultPrinter);
            wifiPrinter = WifiPrinter.getInstance();
            bluetoothPrinter = new BluetoothPrinter(getActivity());
            sunmiPrinter = new SunmiPrinter(getActivity());
            if (Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                sunmiPrinterV3Mix = new SunmiPrinterV3Mix(requireActivity());
            }
            progressDialog = CommonFunctions.customProgressDialog(getActivity(), "Loading...");
            etTip = view.findViewById(R.id.etTip);
            etCardNumber = view.findViewById(R.id.etCardNumber);
            etCardHolderName = view.findViewById(R.id.etCardHolderName);
            etCVV = view.findViewById(R.id.etCVV);
            etAmount = view.findViewById(R.id.etAmount);
            etExpiryDate = view.findViewById(R.id.etExpiryDate);
            btnPaynow = view.findViewById(R.id.btnPaynow);
            btnCancel = view.findViewById(R.id.btnCancel);
            LinearLayout llTip = view.findViewById(R.id.llTip);

            description = selectedBusiness.statement_description;
            descriptor = selectedBusiness.statement_descriptor;
            String stripe_public_key;
            if (!Validators.isNullOrEmpty(selectedBusiness.s_account_id) && selectedBusiness.connect_service && !Validators.isNullOrEmpty(BuildConfig.connect_stripe_public_key)) {
                stripe = new Stripe(getActivity(), BuildConfig.connect_stripe_public_key);
                stripe_public_key = BuildConfig.connect_stripe_public_key;
                stripe_secret_key = BuildConfig.connect_stripe_private_key;
                descriptor = selectedBusiness.statement_descriptor;
            } else {
                if (stripeMode.equalsIgnoreCase("live")) {
                    stripe = new Stripe(getActivity(), selectedBusiness.stripe_public_key_live);
                    stripe_public_key = selectedBusiness.stripe_public_key_live;
                    stripe_secret_key = selectedBusiness.stripe_private_key_live;
                } else {
                    stripe = new Stripe(getActivity(), selectedBusiness.stripe_public_key_test);
                    stripe_secret_key = selectedBusiness.stripe_private_key_test;
                    stripe_public_key = selectedBusiness.stripe_public_key_test;
                }
            }
            SiteSetting headerAlignmentSetting = myApp.findSetting("ticket_header_type");
            if (headerAlignmentSetting != null && headerAlignmentSetting.value.equalsIgnoreCase("right")) {
                headerAlignment = 2;
            }
            if (headerAlignmentSetting != null && headerAlignmentSetting.value.equalsIgnoreCase("center")) {
                headerAlignment = 1;
            }
            if (selectedBusiness.tip) {
                llTip.setVisibility(View.VISIBLE);
            } else {
                llTip.setVisibility(View.GONE);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setListeners() {

        try {
            etCardNumber.addTextChangedListener(new OtherCardTextWatcher(etCardNumber, null));
            etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount));
            etTip.addTextChangedListener(new MoneyTextWatcher(etTip));

            etExpiryDate.addTextChangedListener(new TextWatcher() {
                int previousLength = 0;
                String previousText = "";

                @Override
                public void beforeTextChanged(CharSequence charSequence, int start, int count, int after) {
                    try {
                        if (!etExpiryDate.getText().toString().equalsIgnoreCase("")) { // Firebase crash handled here
                            previousLength = etExpiryDate.getText().toString().length();
                        }
                        previousText = charSequence.toString();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onTextChanged(CharSequence charSequence, int start, int before, int count) {
                    String current = charSequence.toString();
                    if (charSequence.length() == 1) {
                        int n = Integer.parseInt(current);
                        if (n > 1) {
                            etExpiryDate.setText("0" + current + "/");
                            etExpiryDate.setSelection(current.length() + 2);
                        } else {
                            if (current.length() == 2 && start == 1) {
                                etExpiryDate.setText(current + "/");
                                etExpiryDate.setSelection(current.length() + 1);
                            } else if (current.length() == 2 && before == 1) {
                                current = current.substring(0, 1);
                                etExpiryDate.setText(current);
                                etExpiryDate.setSelection(current.length());
                            }
                        }
                    } else {
                        if (charSequence.length() == 2) {
                            int n = Integer.parseInt(current);
                            if (n > 12) {
                                etExpiryDate.setText(previousText);
                                etExpiryDate.setSelection(etExpiryDate.getText().toString().length());
                                return;
                            }
                        }
                        if (current.length() == 2 && start == 1) {
                            etExpiryDate.setText(current + "/");
                            etExpiryDate.setSelection(current.length() + 1);
                        } else if (current.length() == 2 && before == 1) {
                            current = current.substring(0, 1);
                            etExpiryDate.setText(current);
                            etExpiryDate.setSelection(current.length());
                        }
                    }
                    if (etExpiryDate.getText().toString().length() == 5) {
                        etCVV.requestFocus();
                    }
                }

                @Override
                public void afterTextChanged(Editable s) {

                }
            });

            btnPaynow.setOnClickListener(v -> {
                if (isValid()) {
                    if (etTip.getText().toString().equalsIgnoreCase("")) {
                        totalAmount = Float.parseFloat(etAmount.getText().toString().replace(",", ""));
                    } else {
                        totalAmount = (Float.parseFloat(etAmount.getText().toString().replace(",", "")) + Float.parseFloat(etTip.getText().toString().replace(",", "")));
                    }

                    long currentTime = SystemClock.elapsedRealtime();
                    if (currentTime - lastClickTime > MIN_CLICK_INTERVAL) {
                        lastClickTime = currentTime;
                        createStripeCall();
                    } else {
                        LogUtils.e("Button blocked");
                    }
                }

            });

            btnCancel.setOnClickListener(view -> {
                if (etAmount.length() > 0) {
                    etAmount.getText().clear();
                }
                if (etCardNumber.length() > 0) {
                    etCardNumber.getText().clear();
                }
                if (etCardHolderName.length() > 0) {
                    etCardHolderName.getText().clear();
                }
                if (etExpiryDate.length() > 0) {
                    etExpiryDate.getText().clear();
                }
                if (etCVV.length() > 0) {
                    etCVV.getText().clear();
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    CardParams cardParams;

    private boolean isValid() {
        if (Validators.isNullOrEmpty(etCardNumber.getText().toString())) {
            ToastUtils.makeSnackToast(getActivity(), "Please enter card number");
            return false;
        }

        if (Validators.isNullOrEmpty(etExpiryDate.getText().toString())) {
            ToastUtils.makeSnackToast(getActivity(), "Please enter card expiry");
            return false;
        }
        if (Validators.isNullOrEmpty(etCVV.getText().toString())) {
            ToastUtils.makeSnackToast(getActivity(), "Please enter card cvv");
            return false;
        }
        if (Validators.isNullOrEmpty(etAmount.getText().toString())) {
            ToastUtils.makeSnackToast(getActivity(), "Please enter amount");
            return false;
        }
        String exp = etExpiryDate.getText().toString();
        String[] data = exp.split("/");
        if (!isNumberChar(data[0])) {
            ToastUtils.makeSnackToast(getActivity(), "Invalid expiry month");
            return false;
        }
        if (data.length == 1) {
            ToastUtils.makeSnackToast(getActivity(), "Please enter expiry year");
            return false;
        }
        if (data.length > 1 && !isNumberChar(data[1])) {
            ToastUtils.makeSnackToast(getActivity(), "Invalid expiry year");
            return false;
        }
        if (Validators.isNullOrEmpty(etCVV.getText().toString())) {
            ToastUtils.makeSnackToast(getActivity(), "Please enter card cvv");
            return false;
        }

        cardParams = new CardParams(etCardNumber.getText().toString().replace(" ", ""), Integer.parseInt(data[0]), Integer.parseInt(data[1]), etCVV.getText().toString());

        return true;
    }

    private boolean isNumberChar(String string) {
        return string.matches(".*\\d.*");
    }

    private void createStripeCall() {
        LogUtils.e("PAYMENT", "create stripe call");
        if (getActivity() != null) {
            getActivity().runOnUiThread(() -> {
                progressDialog.show();
            });
        }

        PaymentMethodCreateParams params = PaymentMethodCreateParams.createCard(cardParams);
        if (cardParams == null) {
            ToastUtils.makeSnackToast(getActivity(), "Invalid Details");
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.dismiss());
            }
            return;
        }
        // Configure the SDK with your Stripe publishable key so that it can make requests to the Stripe API
        if (selectedBusiness.s_account_id != null && selectedBusiness.connect_service) {
            createPaymentMethod(params);
        } else {
            createCardToken(cardParams);
        }
    }

    String paymentMethodId;

    private void createPaymentMethod(PaymentMethodCreateParams params) {
        try {
            LogUtils.e("PAYMENT", "create payment method");
            stripe.createPaymentMethod(params, new ApiResultCallback<PaymentMethod>() {
                @Override
                public void onSuccess(@NonNull PaymentMethod result) {
                    try {
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> progressDialog.dismiss());
                        }
                        paymentMethodId = result.id;
                        createPaymentIntent();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onError(@NonNull Exception e) {
                    // Display the error to the user
                    try {
                        e.printStackTrace();
                        LogUtils.e(e.getMessage());
                        LogUtils.e("PAYMENT", "create payment method error");
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> {
                                progressDialog.dismiss();
                                ToastUtils.makeToast(getActivity(), e.getMessage());
                            });
                        }
                    } catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createCardToken(CardParams cardParams) {
        try {
            LogUtils.e("PAYMENT", "create card token");
            // Configure the SDK with your Stripe publishable key so that it can make requests to the Stripe API
            /*stripe.createCardToken(cardParams, new ApiResultCallback<Token>() {
                @Override
                public void onSuccess(@NotNull Token token) {

                    com.stripe.Stripe.apiKey = "" + stripe_secret_key;
                    Map<String, Object> params = new HashMap<String, Object>();
                    Map<String, Object> params1 = new HashMap<String, Object>();
                    DecimalFormat doubleFormat = new DecimalFormat("#.##");
                    doubleFormat.setMinimumFractionDigits(0);
                    String price = doubleFormat.format((totalAmount) * 100);
                    params.put("amount", "" + price);
                    params.put("currency", "gbp");
                    params.put("capture", true);
                    params.put("source", token.getId());
                    params.put("description", description);
                    params.put("statement_descriptor", Validators.isNullOrEmpty(descriptor) ? "UBSIDI" : descriptor);
                    params1.put("limit", "3");
                    new Thread(() -> {
                        try {
                            Charge charge = Charge.create(params);
                            Charge.list(params1);
                            manageChargeResponse(charge);
                        } catch (StripeException e) {
                            e.printStackTrace();
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> {
                                    progressDialog.dismiss();
                                    myApp.startPaymentFailedSound();
                                    updateUI();
                                });
                            }
                        }

                    }).start();
                }

                @Override
                public void onError(@NotNull Exception e) {
                    try {
                        e.printStackTrace();
                        LogUtils.e("PAYMENT", "create card token error");
                        if (getActivity() != null) {
                            getActivity().runOnUiThread(() -> {
                                progressDialog.dismiss();
                                updateUI();
                                AnimatedConfirmationDialogFragment confirmationDialogFragment = getInstanceAnimatedConfirmation("Error", "Payment declined", 2, "Okay", null);
                                confirmationDialogFragment.show(getChildFragmentManager(), "action");
                            });
                        }
                    } catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });*/
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    boolean autoConfirm = false;

    private HashMap<String, String> generatePaymentIntentParams() {
        HashMap<String, String> params = new HashMap<>();

        params.put("amount", MyApp.df.format(totalAmount * 100));
        params.put("currency", "GBP");
        params.put("transaction_type", !selectedBusiness.connect_service ? "merchant" : "connect");
        params.put("stripe_secrete_key", stripe_secret_key);
        params.put("business_id", selectedBusiness.id);
        params.put("payment_method_id", paymentMethodId);
        params.put("auto_confirm", autoConfirm ? "1" : "0");

        return params;
    }

    private void createPaymentIntent() {
        try {
            LogUtils.e("PAYMENT", "create payment intent");
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    progressDialog.show();
                    updateUI();
                });
            }
            AndroidNetworking.post(ApiEndPoints.PAYMENT_INTENT)
                    .addBodyParameter(generatePaymentIntentParams())
                    .build()
                    .getAsJSONObject(new JSONObjectRequestListener() {
                        @Override
                        public void onResponse(JSONObject response) {
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            try {
                                if (response.has("payment_intent")) {
                                    JSONObject paymentIntent = response.getJSONObject("payment_intent");
                                    String paymentSecret = paymentIntent.getString("client_secret");
                                    if (!autoConfirm)
                                        performStripePayment(paymentSecret);
                                    else {
                                        if (getActivity() != null) {
                                            getActivity().runOnUiThread(() -> progressDialog.show());
                                        }
                                        LogUtils.e("PAYMENT", "retriving payment intent");
                                        stripe.retrievePaymentIntent(paymentSecret, new ApiResultCallback<PaymentIntent>() {
                                            @Override
                                            public void onSuccess(@NotNull PaymentIntent paymentIntent) {
                                                if (getActivity() != null) {
                                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                                }
                                                createMotoPrint(paymentIntent);
                                            }

                                            @Override
                                            public void onError(@NotNull Exception e) {
                                                e.printStackTrace();
                                                LogUtils.e("PAYMENT", "retrive payment intent error");
                                                if (getActivity() != null) {
                                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                                }
                                            }
                                        });
                                    }
                                }
                            } catch (JSONException e) {
                                e.printStackTrace();
                                LogUtils.e("PAYMENT", "create payment intent json exception");
                                if (getActivity() != null) {
                                    getActivity().runOnUiThread(() -> progressDialog.dismiss());
                                }
                                ToastUtils.makeToast(getActivity(), "Something went wrong!");
                            }

                        }

                        @Override
                        public void onError(ANError anError) {
                            anError.printStackTrace();
                            LogUtils.e("MOTO PAYMENT ERROR");
                            LogUtils.e("PAYMENT", "create payment intent error");
                            if (getActivity() != null) {
                                getActivity().runOnUiThread(() -> progressDialog.dismiss());
                            }
                            if (anError.getErrorCode() == 400) {
                                ApiError apiError = anError.getErrorAsObject(ApiError.class);
                                ToastUtils.makeToast(getActivity(), apiError.getMessage());
                            } else {
                                ToastUtils.makeToast(getActivity(), "Unknown Error");
                            }


                            if (!CommonFunctions.isConnected(getActivity()))
                                myApp.noInternet(getActivity());
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void performStripePayment(String paymentIntentSecret) {
        try {
            LogUtils.e("PAYMENT", "perform stripe payment");
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> progressDialog.show());
            }
            ConfirmPaymentIntentParams confirmParams = ConfirmPaymentIntentParams
                    .createWithPaymentMethodId(paymentMethodId, paymentIntentSecret);
//        stripe = new Stripe(getContext(), stripe_public_key);
            stripe.confirmPayment(this, confirmParams);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (data != null) {
            stripe.onPaymentResult(requestCode, data, new PaymentResultCallback(this));
        }
    }

    private final class PaymentResultCallback
            implements ApiResultCallback<PaymentIntentResult> {

        @NonNull
        private final WeakReference<PaymentMotoFragment> activityRef;

        PaymentResultCallback(PaymentMotoFragment activity) {
            activityRef = new WeakReference<>(activity);
            final PaymentMotoFragment a = activityRef.get();
            if (activity.getActivity() != null && !activity.getActivity().isFinishing())
                a.progressDialog.show();
        }


        @Override
        public void onSuccess(@NonNull PaymentIntentResult result) {
            try {
                final PaymentMotoFragment activity = activityRef.get();
                if (activity == null) {
                    return;
                }
                if (activity.getActivity() != null && !activity.getActivity().isFinishing())
                    activity.progressDialog.dismiss();
                PaymentIntent paymentIntent = result.getIntent();
                activity.createMotoPrint(paymentIntent);
                activity.myApp.startPaymentSuccessSound();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void onError(@NonNull Exception e) {
            try {
                final PaymentMotoFragment activity = activityRef.get();
                if (activity == null) {
                    return;
                }
                e.printStackTrace();
                if (activity.getActivity() != null && !activity.getActivity().isFinishing())
                    activity.progressDialog.dismiss();
                // Payment request failed – allow retrying using the same payment method
                activity.myApp.startPaymentFailedSound();
                ToastUtils.makeToast(activity.getActivity(), "Payment request failed");
            } catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }


    private void updateUI() {
        try {
            Thread.sleep(300);
            if (getActivity() != null) {
                getActivity().runOnUiThread(() -> {
                    progressDialog.dismiss();
                    etCardNumber.setText("");
                    etCardHolderName.setText("");
                    etAmount.setText("");
                    etCVV.setText("");
                    //   etAmount.addTextChangedListener(new MoneyTextWatcher(etAmount)); creating trouble
                    etExpiryDate.setText("");
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    String title;
    String header = "", resAddress = "";
    String amount;
    String card_____;
    String account__;
    String stripe_id;
    String entry_mod;
    String status___;
    String please;
    String date_final;
    String footerA;
    String footerB;
    String main_content;
    String print_amount, print_card = "", print_card_number = "", print_stripe_id, print_payment_mode, print_status;

    /*private void manageChargeResponse(Charge charge) {
        try {
            String transactionId = charge.getId();
            if (getActivity() != null)
                progressDialog.dismiss();

            print_stripe_id = transactionId;
            print_amount = MyApp.df.format(totalAmount);

            if (charge.getPaymentMethodDetails() != null)
                print_card = charge.getPaymentMethodDetails().getCard().getBrand().toString();

            if (charge.getPaymentMethodDetails() != null && charge.getPaymentMethodDetails().getCard() != null)
                print_card_number = charge.getPaymentMethodDetails().getCard().getLast4().toString();

            print_payment_mode = "MOTO";
            if (charge.getStatus().equalsIgnoreCase("Succeeded")) {
                // Payment completed successfully
                ToastUtils.makeSnackToast(getActivity(), "Payment successful");
                myApp.startPaymentSuccessSound();
                print_status = "Approved";
                addExternalPayment(Constants.APPROVED);
            } else if (charge.getStatus().equalsIgnoreCase("RequiresPaymentMethod")) {
                // Payment failed
                print_status = "Failed";
                myApp.startPaymentFailedSound();
                ToastUtils.makeSnackToast(getActivity(), "Card authentication failed, Please retry");
                addExternalPayment(Constants.DECLINED);
            } else if (charge.getStatus().equalsIgnoreCase("Canceled")) {
                print_status = "Declined";
                myApp.startPaymentFailedSound();
                ToastUtils.makeSnackToast(getActivity(), "Payment declined");
                addExternalPayment(Constants.DECLINED);
            }

            title = "" + "Customer Copy" + "\n";

            SiteSetting ticketHeader = myApp.findSetting("ticket_header");
            SiteSetting address = myApp.findSetting("address");

            if (ticketHeader != null) header = ticketHeader.value;
            if (address != null) resAddress = address.value;

            amount = "£" + print_amount + "\n";

            card_____ = "Card       :" + print_card;
            account__ = "Account    :" + print_card_number;
            stripe_id = "TID        :" + print_stripe_id;
            entry_mod = "Entry Mode :" + print_payment_mode;
            status___ = "Status     :" + print_status;

            please = "Please Retain Receipt\nFor Your Record\n";
            date_final = "" + CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy hh:mm:ss a") + "\n";
            footerA = "";
            footerB = "";
            SiteSetting footerASetting = myApp.findSetting("footer_a");
            SiteSetting footerBSetting = myApp.findSetting("footer_b");

            if (footerASetting != null) footerA = footerASetting.value;

            if (footerBSetting != null) footerB = footerBSetting.value;

            main_content = card_____ + "\n" + account__ + "\n" + stripe_id + "\n" + entry_mod + "\n" + status___ + "\n";
            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                    printZonrich("Merchant Copy");
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("t2") || defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                    printSunmi("Merchant Copy");
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                        printIMin("Merchant Copy");
                    } else {
                        if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                            printWIfi("Merchant Copy");
                        } else {
                            try {
                                if (bluetoothPrinter != null) {
                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                    if (device != null) {
                                        printBT("Merchant Copy");
                                    } else {
                                        ToastUtils.makeSnackToast(getActivity(), "No bluetooth device found.");
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            } else {
                ToastUtils.makeLongToast(getActivity(), "No printer model found");
            }
            updateUI();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }*/

    private void createMotoPrint(PaymentIntent paymentIntent) {
        try {
            if (getActivity() != null && !getActivity().isFinishing())
                progressDialog.dismiss();
            PaymentIntent.Status paymentIntentStatus = paymentIntent.getStatus();
            print_stripe_id = paymentIntent.getId();
            print_amount = MyApp.df.format(totalAmount);

            if (paymentIntent.getPaymentMethod() != null && paymentIntent.getPaymentMethod().card != null)
                print_card = paymentIntent.getPaymentMethod().card.brand.getDisplayName();

            if (paymentIntent.getPaymentMethod() != null && paymentIntent.getPaymentMethod().card != null)
                print_card_number = paymentIntent.getPaymentMethod().card.last4;

            print_payment_mode = "MOTO";
            if (paymentIntentStatus == null) {
                print_status = "Declined";
                ToastUtils.makeToast(getActivity(), "Payment declined");
                myApp.startPaymentFailedSound();
                addExternalPayment(Constants.DECLINED);
            } else if (paymentIntentStatus == PaymentIntent.Status.Succeeded) {
                // Payment completed successfully
                ToastUtils.makeToast(getActivity(), "Payment successful");
                myApp.startPaymentSuccessSound();
                print_status = "Approved";
                addExternalPayment(Constants.APPROVED);
            } else if (paymentIntentStatus == PaymentIntent.Status.RequiresPaymentMethod) {
                // Payment failed
                print_status = "Failed";
                myApp.startPaymentFailedSound();
                ToastUtils.makeToast(getActivity(), "Card authentication failed, Please retry");
                addExternalPayment(Constants.DECLINED);
            } else if (paymentIntentStatus == StripeIntent.Status.Canceled) {
                print_status = "Declined";
                ToastUtils.makeToast(getActivity(), "Payment declined");
                myApp.startPaymentFailedSound();
                addExternalPayment(Constants.DECLINED);
            } else {
                print_status = "Declined";
                ToastUtils.makeToast(getActivity(), "Payment declined");
                myApp.startPaymentFailedSound();
                addExternalPayment(Constants.DECLINED);
            }

            title = "" + "Customer Copy" + "\n";

            SiteSetting ticketHeader = myApp.findSetting("ticket_header");
            SiteSetting address = myApp.findSetting("address");

            if (ticketHeader != null) header = ticketHeader.value;
            if (address != null) resAddress = address.value;

            amount = "£" + print_amount + "\n";

            card_____ = "Card       :" + print_card;
            account__ = "Account    :" + print_card_number;
            stripe_id = "TID        :" + print_stripe_id;
            entry_mod = "Entry Mode :" + print_payment_mode;
            status___ = "Status     :" + print_status;

            please = "Please Retain Receipt\nFor Your Record\n";
            date_final = "" + CommonFunctions.getCurrentTimeFormatted("dd-MM-yyyy hh:mm:ss a") + "\n";
            footerA = "";
            footerB = "";
            SiteSetting footerASetting = myApp.findSetting("footer_a");
            SiteSetting footerBSetting = myApp.findSetting("footer_b");

            if (footerASetting != null) footerA = footerASetting.value;

            if (footerBSetting != null) footerB = footerBSetting.value;

            main_content = card_____ + "\n" + account__ + "\n" + stripe_id + "\n" + entry_mod + "\n" + status___ + "\n";
            if (defaultPrinter != null && defaultPrinter.printer_model_name != null) {
                if (defaultPrinter.printer_model_name.toLowerCase().contains("88 h")) {
                    printZonrich("Merchant Copy");
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("t2") || defaultPrinter.printer_model_name.toLowerCase().contains("sunmi")) {
                    printSunmi("Merchant Copy");
                } else if (defaultPrinter.printer_model_name.toLowerCase().contains("pos-80") || defaultPrinter.printer_model_name.toLowerCase().contains("pos 80") || defaultPrinter.printer_model_name.toLowerCase().contains("yoke4") || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP80) || defaultPrinter.printer_model_name.toLowerCase().contains(Constants.KP_80)) {
                    if (defaultPrinter.printer_model_name.toLowerCase().contains("yoke4")) {
                        printIMin("Merchant Copy");
                    } else {
                        if (defaultPrinter.ip != null && !defaultPrinter.ip.equalsIgnoreCase("")) {
                            printWIfi("Merchant Copy");
                        } else {
                            try {
                                if (bluetoothPrinter != null) {
                                    BluetoothDevice device = bluetoothPrinter.getConnectedPrinter();
                                    if (device != null) {
                                        printBT("Merchant Copy");
                                    } else {
                                        ToastUtils.makeSnackToast(getActivity(), "No bluetooth device found.");
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            } else {
                ToastUtils.makeLongToast(getActivity(), "No printer model found");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printIMin(String title) {
        try {
            title = title + "\n";
            String finalTitle = title;
            myApp.iMinPrinterUtils.printMotoReceipt(myApp.tiffintomLogoSmall, finalTitle, header, "", "", amount, main_content, date_final, please, footerA, footerB);
            if (finalTitle.toLowerCase().contains("merchant")) {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Is Customer Copy required?", null, 0, "Confirm", "Cancel");
                confirmationDialogFragment.setCancelable(false);
                confirmationDialogFragment.show(requireActivity().getSupportFragmentManager(), "printer");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String) {
                        if (((String) o).equalsIgnoreCase("confirm")) {
                            printIMin("Customer Copy");
                        }
                    }
                });

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public void printZonrich(String title) {
        try {
            title = title + "\n";
            //if (getActivity() != null) {
            String finalTitle = title;
            //getActivity().runOnUiThread(() -> {
            zoneRichPrinter.connectPrinter(defaultPrinter.ip);
            CommonFunctions.functionThatDelay(200);
            if (finalTitle.toLowerCase().contains("merchant")) {
                if (selectedBusiness.auto_merchant_print != null && (selectedBusiness.auto_merchant_print.equalsIgnoreCase("true") || selectedBusiness.auto_merchant_print.equalsIgnoreCase("1"))) {
                    zoneRichPrinter.printMotoReceipt(myApp.businessLogo, finalTitle, header, headerAlignment, amount, main_content, date_final, please, footerA, footerB, myApp.myPreferences);
                    printCustomerZoneRich(finalTitle);
                } else {
                    ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Merchant copy required?", null, 0, "Okay", "Cancel");
                    confirmationDialogFragment.show(getChildFragmentManager(), "confirm");
                    confirmationDialogFragment.setDialogDismissListener(o -> {
                        if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                            zoneRichPrinter.printMotoReceipt(myApp.businessLogo, finalTitle, header, headerAlignment, amount, main_content, date_final, please, footerA, footerB, myApp.myPreferences);
                            printCustomerZoneRich(finalTitle);
                        } else {
                            printCustomerZoneRich(finalTitle);
                        }
                    });
                }
            } else {
                zoneRichPrinter.printMotoReceipt(myApp.businessLogo, finalTitle, header, headerAlignment, amount, main_content, date_final, please, footerA, footerB, myApp.myPreferences);
            }
            //});

            //}
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void printCustomerZoneRich(String title) {
        if (title.toLowerCase().contains("merchant")) {
            if (selectedBusiness.auto_customer_print != null && (selectedBusiness.auto_customer_print.equalsIgnoreCase("true") || selectedBusiness.auto_customer_print.equalsIgnoreCase("1"))) {
                printZonrich("Customer Copy");
            } else {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Customer copy required?", null, 0, "Okay", "Cancel");
                confirmationDialogFragment.show(getChildFragmentManager(), "confirm");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                        printZonrich("Customer Copy");
                    }
                });
            }
        }
    }

    public void printWIfi(String title) {
        try {
            wifiPrinter.connect(defaultPrinter.ip);
            wifiPrinter.printMotoReceipt(myApp.businessLogo, title, header, headerAlignment, amount, main_content, date_final, please, footerA, footerB, true, myPreferences);
            if (title.toLowerCase().contains("merchant")) {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Customer copy required?", null, 0, "Okay", "Cancel");
                confirmationDialogFragment.show(getChildFragmentManager(), "confirm");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                        printWIfi("Customer Copy");
                    }
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printBT(String title) {
        try {
            bluetoothPrinter.printMotoReceipt(myApp.businessLogo, title, header, headerAlignment, amount, main_content, date_final, please, footerA, footerB, true);
            if (title.toLowerCase().contains("merchant")) {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Customer copy required?", null, 0, "Okay", "Cancel");
                confirmationDialogFragment.show(getChildFragmentManager(), "confirm");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                        printBT("Customer Copy");
                    }
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printSunmi(String title) {
        try {
            if (getActivity() != null) {

                getActivity().runOnUiThread(() -> {
                    if (title.toLowerCase().contains("merchant")) {
                        if (selectedBusiness.auto_merchant_print != null && (selectedBusiness.auto_merchant_print.equalsIgnoreCase("true") || selectedBusiness.auto_merchant_print.equalsIgnoreCase("1"))) {
                            if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                                sunmiPrinterV3Mix.printMotoReceipt(myApp.businessLogo, title, header, headerAlignment, amount, main_content, date_final, please, footerA, footerB, myPreferences);
                            }else {
                                sunmiPrinter.printMotoReceipt(myApp.businessLogo, title, header, headerAlignment, amount, main_content, date_final, please, footerA, footerB, myPreferences);
                            }
                            merchantCopySunmi(title);
                        } else {
                            ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Merchant copy required?", null, 0, "Okay", "Cancel");
                            confirmationDialogFragment.show(getChildFragmentManager(), "confirm");
                            confirmationDialogFragment.setDialogDismissListener(o -> {
                                if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                                    if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                                        sunmiPrinterV3Mix.printMotoReceipt(myApp.businessLogo, title, header, headerAlignment, amount, main_content, date_final, please, footerA, footerB, myPreferences);
                                    }else {
                                        sunmiPrinter.printMotoReceipt(myApp.businessLogo, title, header, headerAlignment, amount, main_content, date_final, please, footerA, footerB, myPreferences);
                                    }
                                    merchantCopySunmi(title);
                                } else {
                                    merchantCopySunmi(title);
                                }
                            });
                        }
                    } else {
                        if(Build.MODEL.equalsIgnoreCase(getString(R.string.v3_mix))) {
                            sunmiPrinterV3Mix.printMotoReceipt(myApp.businessLogo, title, header, headerAlignment, amount, main_content, date_final, please, footerA, footerB, myPreferences);
                        }else {
                            sunmiPrinter.printMotoReceipt(myApp.businessLogo, title, header, headerAlignment, amount, main_content, date_final, please, footerA, footerB, myPreferences);
                        }
                    }
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void merchantCopySunmi(String title) {
        if (title.toLowerCase().contains("merchant")) {
            if (selectedBusiness.auto_customer_print != null && (selectedBusiness.auto_customer_print.equalsIgnoreCase("true") || selectedBusiness.auto_customer_print.equalsIgnoreCase("1"))) {
                printSunmi("Customer Copy");
            } else {
                ConfirmationDialogFragment confirmationDialogFragment = myApp.getInstanceConfirmationDialog("Customer copy required?", null, 0, "Okay", "Cancel");
                confirmationDialogFragment.show(getChildFragmentManager(), "confirm");
                confirmationDialogFragment.setDialogDismissListener(o -> {
                    if (o instanceof String && ((String) o).equalsIgnoreCase("confirm")) {
                        printSunmi("Customer Copy");
                    }
                });
            }
        }
    }

    private void addExternalPayment(String status){
        OrderExternalPayment orderExternalPayment = new OrderExternalPayment();
        orderExternalPayment.payment_method_name = "External Moto Payment";
        orderExternalPayment.payment_method_id = EXTERNAL_MOTO_PAYMENT;
        orderExternalPayment.amount = Float.parseFloat(print_amount);
        orderExternalPayment.updater_id = myPreferences.getLoggedInUser().id;
        orderExternalPayment.payment_status =status;
        appDatabase.orderExternalPaymentDao().insert(orderExternalPayment);
        if(Objects.equals(status, Constants.APPROVED)){
            callExternalPaymentApi(orderExternalPayment);
        }
    }

    private void callExternalPaymentApi(OrderExternalPayment orderExternalPayment){
        AndroidNetworking.post(ApiEndPoints.external_payment)
                .addBodyParameter(orderExternalPayment)
                .build()
                .getAsJSONObject(new JSONObjectRequestListener() {
                    @Override
                    public void onResponse(JSONObject response) {}

                    @Override
                    public void onError(ANError anError) {}
                });
    }

    public AnimatedConfirmationDialogFragment getInstanceAnimatedConfirmation(String title, String info, int type, String positiveButton, String negativeButton) {
        AnimatedConfirmationDialogFragment rejectReasonDialog = new AnimatedConfirmationDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putString("title", title);
        bundle.putString("info", info);
        bundle.putString("positive_button", positiveButton);
        bundle.putString("negative_button", negativeButton);
        bundle.putInt("type", type);
        rejectReasonDialog.setArguments(bundle);
        return rejectReasonDialog;
    }
}